/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.io.ByteSource;
import org.apache.hive.druid.com.google.common.io.FileWriteMode;
import org.apache.hive.druid.com.google.common.io.Files;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.data.input.MapBasedInputRow;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.FileUtils;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.segment.CloserRule;
import org.apache.hive.druid.org.apache.druid.segment.IndexIO;
import org.apache.hive.druid.org.apache.druid.segment.IndexMerger;
import org.apache.hive.druid.org.apache.druid.segment.IndexMergerTestBase;
import org.apache.hive.druid.org.apache.druid.segment.IndexSpec;
import org.apache.hive.druid.org.apache.druid.segment.QueryableIndex;
import org.apache.hive.druid.org.apache.druid.segment.QueryableIndexIndexableAdapter;
import org.apache.hive.druid.org.apache.druid.segment.TestHelper;
import org.apache.hive.druid.org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.hive.druid.org.apache.druid.segment.data.CompressionFactory;
import org.apache.hive.druid.org.apache.druid.segment.data.CompressionStrategy;
import org.apache.hive.druid.org.apache.druid.segment.data.ConciseBitmapSerdeFactory;
import org.apache.hive.druid.org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.hive.druid.org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.hive.druid.org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.hive.druid.org.apache.druid.segment.writeout.TmpFileSegmentWriteOutMediumFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IndexMergerV9CompatibilityTest {
    private static final long TIMESTAMP = DateTimes.of((String)"2014-01-01").getMillis();
    private static final AggregatorFactory[] DEFAULT_AGG_FACTORIES = new AggregatorFactory[]{new CountAggregatorFactory("count")};
    private static final IndexSpec INDEX_SPEC = IndexMergerTestBase.makeIndexSpec((BitmapSerdeFactory)new ConciseBitmapSerdeFactory(), CompressionStrategy.LZ4, CompressionStrategy.LZ4, CompressionFactory.LongEncodingStrategy.LONGS);
    private static final List<String> DIMS = ImmutableList.of((Object)"dim0", (Object)"dim1");
    private final Collection<InputRow> events;
    @Rule
    public final CloserRule closer = new CloserRule(false);
    private final IndexMerger indexMerger;
    private final IndexIO indexIO;
    IncrementalIndex toPersist;
    File tmpDir;
    File persistTmpDir;

    @Parameterized.Parameters
    public static Collection<?> constructorFeeder() {
        return ImmutableList.of((Object)new Object[]{TmpFileSegmentWriteOutMediumFactory.instance()}, (Object)new Object[]{OffHeapMemorySegmentWriteOutMediumFactory.instance()});
    }

    public IndexMergerV9CompatibilityTest(SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) {
        this.indexMerger = TestHelper.getTestIndexMergerV9(segmentWriteOutMediumFactory);
        this.indexIO = TestHelper.getTestIndexIO();
        this.events = new ArrayList<InputRow>();
        ImmutableMap map1 = ImmutableMap.of((Object)DIMS.get(0), (Object)ImmutableList.of((Object)"dim00", (Object)"dim01"), (Object)DIMS.get(1), (Object)"dim10");
        List<Object> nullList = Collections.singletonList(null);
        ImmutableMap map2 = ImmutableMap.of((Object)DIMS.get(0), nullList, (Object)DIMS.get(1), (Object)"dim10");
        ImmutableMap map3 = ImmutableMap.of((Object)DIMS.get(0), (Object)ImmutableList.of((Object)"dim00", (Object)"dim01"));
        ImmutableMap map4 = ImmutableMap.of();
        ImmutableMap map5 = ImmutableMap.of((Object)DIMS.get(1), (Object)"dim10");
        HashMap<String, Object> map6 = new HashMap<String, Object>();
        map6.put(DIMS.get(1), null);
        int i = 0;
        for (Map map : Arrays.asList(map1, map2, map3, map4, map5, map6)) {
            this.events.add((InputRow)new MapBasedInputRow(TIMESTAMP + (long)i++, DIMS, map));
        }
    }

    @Before
    public void setUp() throws IOException {
        String[] files;
        this.toPersist = new IncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withMinTimestamp(-4611686018427387904L).withMetrics(DEFAULT_AGG_FACTORIES).build()).setMaxRowCount(1000000).buildOnheap();
        this.toPersist.getMetadata().put("key", (Object)"value");
        for (InputRow event : this.events) {
            this.toPersist.add(event);
        }
        this.tmpDir = FileUtils.createTempDir();
        this.persistTmpDir = new File(this.tmpDir, "persistDir");
        org.apache.commons.io.FileUtils.forceMkdir((File)this.persistTmpDir);
        for (final String file : files = new String[]{"00000.smoosh", "meta.smoosh", "version.bin"}) {
            new ByteSource(){

                public InputStream openStream() {
                    return IndexMergerV9CompatibilityTest.class.getResourceAsStream("/v8SegmentPersistDir/" + file);
                }
            }.copyTo(Files.asByteSink((File)new File(this.persistTmpDir, file), (FileWriteMode[])new FileWriteMode[0]));
        }
    }

    @After
    public void tearDown() throws IOException {
        FileUtils.deleteDirectory((File)this.tmpDir);
    }

    @Test
    public void testPersistWithSegmentMetadata() throws IOException {
        File outDir = FileUtils.createTempDir();
        QueryableIndex index = null;
        try {
            outDir = FileUtils.createTempDir();
            index = this.indexIO.loadIndex(this.indexMerger.persist(this.toPersist, outDir, INDEX_SPEC, null));
            Assert.assertEquals((Object)"value", (Object)index.getMetadata().get("key"));
        }
        finally {
            if (index != null) {
                index.close();
            }
            if (outDir != null) {
                FileUtils.deleteDirectory((File)outDir);
            }
        }
    }

    @Test
    public void testSimpleReprocess() throws IOException {
        QueryableIndexIndexableAdapter adapter = new QueryableIndexIndexableAdapter(this.closer.closeLater(this.indexIO.loadIndex(this.persistTmpDir)));
        Assert.assertEquals((long)this.events.size(), (long)adapter.getNumRows());
        this.reprocessAndValidate(this.persistTmpDir, new File(this.tmpDir, "reprocessed"));
    }

    private File reprocessAndValidate(File inDir, File tmpDir) throws IOException {
        File outDir = this.indexMerger.convert(inDir, tmpDir, INDEX_SPEC);
        this.indexIO.validateTwoSegments(this.persistTmpDir, outDir);
        return outDir;
    }

    @Test
    public void testIdempotentReprocess() throws IOException {
        QueryableIndexIndexableAdapter adapter = new QueryableIndexIndexableAdapter(this.closer.closeLater(this.indexIO.loadIndex(this.persistTmpDir)));
        Assert.assertEquals((long)this.events.size(), (long)adapter.getNumRows());
        File tmpDir1 = new File(this.tmpDir, "reprocessed1");
        this.reprocessAndValidate(this.persistTmpDir, tmpDir1);
        File tmpDir2 = new File(this.tmpDir, "reprocessed2");
        QueryableIndexIndexableAdapter adapter2 = new QueryableIndexIndexableAdapter(this.closer.closeLater(this.indexIO.loadIndex(tmpDir1)));
        Assert.assertEquals((long)this.events.size(), (long)adapter2.getNumRows());
        this.reprocessAndValidate(tmpDir1, tmpDir2);
        File tmpDir3 = new File(this.tmpDir, "reprocessed3");
        QueryableIndexIndexableAdapter adapter3 = new QueryableIndexIndexableAdapter(this.closer.closeLater(this.indexIO.loadIndex(tmpDir2)));
        Assert.assertEquals((long)this.events.size(), (long)adapter3.getNumRows());
        this.reprocessAndValidate(tmpDir2, tmpDir3);
    }
}

