/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.org.apache.druid.collections.CloseableStupidPool;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.java.util.common.Pair;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.hive.druid.org.apache.druid.query.Druids;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.QueryPlus;
import org.apache.hive.druid.org.apache.druid.query.QueryRunner;
import org.apache.hive.druid.org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.org.apache.druid.query.Result;
import org.apache.hive.druid.org.apache.druid.query.TestQueryRunners;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.DoubleMaxAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.DoubleMinAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.PostAggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.SimpleDoubleAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.post.ArithmeticPostAggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.post.ConstantPostAggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.hive.druid.org.apache.druid.query.filter.AndDimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.DimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.NotDimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.OrDimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.hive.druid.org.apache.druid.query.search.SearchHit;
import org.apache.hive.druid.org.apache.druid.query.search.SearchQuery;
import org.apache.hive.druid.org.apache.druid.query.search.SearchResultValue;
import org.apache.hive.druid.org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.hive.druid.org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.hive.druid.org.apache.druid.query.timeboundary.TimeBoundaryQuery;
import org.apache.hive.druid.org.apache.druid.query.timeboundary.TimeBoundaryResultValue;
import org.apache.hive.druid.org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.hive.druid.org.apache.druid.query.timeseries.TimeseriesResultValue;
import org.apache.hive.druid.org.apache.druid.query.topn.TopNQuery;
import org.apache.hive.druid.org.apache.druid.query.topn.TopNQueryBuilder;
import org.apache.hive.druid.org.apache.druid.query.topn.TopNResultValue;
import org.apache.hive.druid.org.apache.druid.segment.QueryableIndex;
import org.apache.hive.druid.org.apache.druid.segment.QueryableIndexSegment;
import org.apache.hive.druid.org.apache.druid.segment.SchemalessIndexTest;
import org.apache.hive.druid.org.apache.druid.segment.Segment;
import org.apache.hive.druid.org.apache.druid.segment.TestHelper;
import org.apache.hive.druid.org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.hive.druid.org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class AppendTest {
    private static final AggregatorFactory[] METRIC_AGGS = new AggregatorFactory[]{new DoubleSumAggregatorFactory("index", "index"), new CountAggregatorFactory("count"), new HyperUniquesAggregatorFactory("quality_uniques", "quality")};
    private static final AggregatorFactory[] METRIC_AGGS_NO_UNIQ = new AggregatorFactory[]{new DoubleSumAggregatorFactory("index", "index"), new CountAggregatorFactory("count")};
    final String dataSource = "testing";
    final Granularity ALL_GRAN = Granularities.ALL;
    final String marketDimension = "market";
    final String qualityDimension = "quality";
    final String placementDimension = "placement";
    final String placementishDimension = "placementish";
    final String indexMetric = "index";
    final CountAggregatorFactory rowsCount = new CountAggregatorFactory("rows");
    final DoubleSumAggregatorFactory indexDoubleSum = new DoubleSumAggregatorFactory("index", "index");
    final HyperUniquesAggregatorFactory uniques = new HyperUniquesAggregatorFactory("uniques", "quality_uniques");
    final ConstantPostAggregator constant = new ConstantPostAggregator("const", (Number)1L);
    final FieldAccessPostAggregator rowsPostAgg = new FieldAccessPostAggregator("rows", "rows");
    final FieldAccessPostAggregator indexPostAgg = new FieldAccessPostAggregator("index", "index");
    final ArithmeticPostAggregator addRowsIndexConstant = new ArithmeticPostAggregator("addRowsIndexConstant", "+", (List)Lists.newArrayList((Object[])new PostAggregator[]{this.constant, this.rowsPostAgg, this.indexPostAgg}));
    final List<AggregatorFactory> commonAggregators = Arrays.asList(this.rowsCount, this.indexDoubleSum, this.uniques);
    final QuerySegmentSpec fullOnInterval = new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.of((String)"1970-01-01T00:00:00.000Z/2020-01-01T00:00:00.000Z")));
    private Segment segment;
    private Segment segment2;
    private Segment segment3;

    @Before
    public void setUp() {
        SchemalessIndexTest schemalessIndexTest = new SchemalessIndexTest((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance());
        QueryableIndex appendedIndex = schemalessIndexTest.getAppendedIncrementalIndex(Arrays.asList(new Pair((Object)"append.json.1", (Object)METRIC_AGGS_NO_UNIQ), new Pair((Object)"append.json.2", (Object)METRIC_AGGS)), Arrays.asList(Intervals.of((String)"2011-01-12T00:00:00.000Z/2011-01-16T00:00:00.000Z"), Intervals.of((String)"2011-01-14T22:00:00.000Z/2011-01-16T00:00:00.000Z")));
        this.segment = new QueryableIndexSegment(appendedIndex, null);
        QueryableIndex append2 = schemalessIndexTest.getAppendedIncrementalIndex(Arrays.asList(new Pair((Object)"append.json.3", (Object)METRIC_AGGS_NO_UNIQ), new Pair((Object)"append.json.4", (Object)METRIC_AGGS)), Arrays.asList(Intervals.of((String)"2011-01-12T00:00:00.000Z/2011-01-16T00:00:00.000Z"), Intervals.of((String)"2011-01-13T00:00:00.000Z/2011-01-14T00:00:00.000Z")));
        this.segment2 = new QueryableIndexSegment(append2, null);
        QueryableIndex append3 = schemalessIndexTest.getAppendedIncrementalIndex(Arrays.asList(new Pair((Object)"append.json.5", (Object)METRIC_AGGS), new Pair((Object)"append.json.6", (Object)METRIC_AGGS), new Pair((Object)"append.json.7", (Object)METRIC_AGGS)), Arrays.asList(Intervals.of((String)"2011-01-12T00:00:00.000Z/2011-01-22T00:00:00.000Z"), Intervals.of((String)"2011-01-13T00:00:00.000Z/2011-01-16T00:00:00.000Z"), Intervals.of((String)"2011-01-18T00:00:00.000Z/2011-01-21T00:00:00.000Z")));
        this.segment3 = new QueryableIndexSegment(append3, null);
    }

    @Test
    public void testTimeBoundary() {
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TimeBoundaryResultValue((Object)ImmutableMap.of((Object)"minTime", (Object)DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)"maxTime", (Object)DateTimes.of((String)"2011-01-15T02:00:00.000Z")))));
        TimeBoundaryQuery query = Druids.newTimeBoundaryQueryBuilder().dataSource("testing").build();
        QueryRunner runner = TestQueryRunners.makeTimeBoundaryQueryRunner(this.segment);
        TestHelper.assertExpectedResults(expectedResults, runner.run(QueryPlus.wrap((Query)query)));
    }

    @Test
    public void testTimeBoundary2() {
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TimeBoundaryResultValue((Object)ImmutableMap.of((Object)"minTime", (Object)DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)"maxTime", (Object)DateTimes.of((String)"2011-01-15T00:00:00.000Z")))));
        TimeBoundaryQuery query = Druids.newTimeBoundaryQueryBuilder().dataSource("testing").build();
        QueryRunner runner = TestQueryRunners.makeTimeBoundaryQueryRunner(this.segment2);
        TestHelper.assertExpectedResults(expectedResults, runner.run(QueryPlus.wrap((Query)query)));
    }

    @Test
    public void testTimeSeries() {
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)8L).put((Object)"index", (Object)700.0).put((Object)"addRowsIndexConstant", (Object)709.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)0.0).build())));
        TimeseriesQuery query = this.makeTimeseriesQuery();
        QueryRunner runner = TestQueryRunners.makeTimeSeriesQueryRunner(this.segment);
        TestHelper.assertExpectedResults(expectedResults, runner.run(QueryPlus.wrap((Query)query)));
    }

    @Test
    public void testTimeSeries2() {
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)7L).put((Object)"index", (Object)500.0).put((Object)"addRowsIndexConstant", (Object)508.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)0.0).build())));
        TimeseriesQuery query = this.makeTimeseriesQuery();
        QueryRunner runner = TestQueryRunners.makeTimeSeriesQueryRunner(this.segment2);
        TestHelper.assertExpectedResults(expectedResults, runner.run(QueryPlus.wrap((Query)query)));
    }

    @Test
    public void testFilteredTimeSeries() {
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)5L).put((Object)"index", (Object)500.0).put((Object)"addRowsIndexConstant", (Object)506.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build())));
        TimeseriesQuery query = this.makeFilteredTimeseriesQuery();
        QueryRunner runner = TestQueryRunners.makeTimeSeriesQueryRunner(this.segment);
        TestHelper.assertExpectedResults(expectedResults, runner.run(QueryPlus.wrap((Query)query)));
    }

    @Test
    public void testFilteredTimeSeries2() {
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)4L).put((Object)"index", (Object)400.0).put((Object)"addRowsIndexConstant", (Object)405.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build())));
        TimeseriesQuery query = this.makeFilteredTimeseriesQuery();
        QueryRunner runner = TestQueryRunners.makeTimeSeriesQueryRunner(this.segment2);
        TestHelper.assertExpectedResults(expectedResults, runner.run(QueryPlus.wrap((Query)query)));
    }

    @Test
    public void testTopNSeries() {
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)3L).put((Object)"index", (Object)300.0).put((Object)"addRowsIndexConstant", (Object)304.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build(), QueryRunnerTestHelper.orderedMap("market", null, "rows", 3L, "index", 200.0, "addRowsIndexConstant", 204.0, "uniques", 0.0, "maxIndex", 100.0, "minIndex", 0.0), ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"rows", (Object)2L).put((Object)"index", (Object)200.0).put((Object)"addRowsIndexConstant", (Object)203.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build()))));
        TopNQuery query = this.makeTopNQuery();
        try (CloseableStupidPool<ByteBuffer> pool = TestQueryRunners.createDefaultNonBlockingPool();){
            QueryRunner runner = TestQueryRunners.makeTopNQueryRunner(this.segment, pool);
            TestHelper.assertExpectedResults(expectedResults, runner.run(QueryPlus.wrap((Query)query)));
        }
    }

    @Test
    public void testTopNSeries2() {
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"rows", (Object)3L).put((Object)"index", (Object)300.0).put((Object)"addRowsIndexConstant", (Object)304.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build(), QueryRunnerTestHelper.orderedMap("market", null, "rows", 3L, "index", 100.0, "addRowsIndexConstant", 104.0, "uniques", 0.0, "maxIndex", 100.0, "minIndex", 0.0), ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build()))));
        TopNQuery query = this.makeTopNQuery();
        try (CloseableStupidPool<ByteBuffer> pool = TestQueryRunners.createDefaultNonBlockingPool();){
            QueryRunner runner = TestQueryRunners.makeTopNQueryRunner(this.segment2, pool);
            TestHelper.assertExpectedResults(expectedResults, runner.run(QueryPlus.wrap((Query)query)));
        }
    }

    @Test
    public void testFilteredTopNSeries() {
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Collections.singletonList(ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build()))));
        TopNQuery query = this.makeFilteredTopNQuery();
        try (CloseableStupidPool<ByteBuffer> pool = TestQueryRunners.createDefaultNonBlockingPool();){
            QueryRunner runner = TestQueryRunners.makeTopNQueryRunner(this.segment, pool);
            TestHelper.assertExpectedResults(expectedResults, runner.run(QueryPlus.wrap((Query)query)));
        }
    }

    @Test
    public void testFilteredTopNSeries2() {
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(new ArrayList())));
        TopNQuery query = this.makeFilteredTopNQuery();
        try (CloseableStupidPool<ByteBuffer> pool = TestQueryRunners.createDefaultNonBlockingPool();){
            QueryRunner runner = TestQueryRunners.makeTopNQueryRunner(this.segment2, pool);
            TestHelper.assertExpectedResults(expectedResults, runner.run(QueryPlus.wrap((Query)query)));
        }
    }

    @Test
    public void testSearch() {
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new SearchResultValue(Arrays.asList(new SearchHit("placementish", "a"), new SearchHit("quality", "automotive"), new SearchHit("placement", "mezzanine"), new SearchHit("market", "total_market")))));
        SearchQuery query = this.makeSearchQuery();
        QueryRunner runner = TestQueryRunners.makeSearchQueryRunner(this.segment);
        TestHelper.assertExpectedResults(expectedResults, runner.run(QueryPlus.wrap((Query)query)));
    }

    @Test
    public void testSearchWithOverlap() {
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new SearchResultValue(Arrays.asList(new SearchHit("placementish", "a"), new SearchHit("placement", "mezzanine"), new SearchHit("market", "total_market")))));
        SearchQuery query = this.makeSearchQuery();
        QueryRunner runner = TestQueryRunners.makeSearchQueryRunner(this.segment2);
        TestHelper.assertExpectedResults(expectedResults, runner.run(QueryPlus.wrap((Query)query)));
    }

    @Test
    public void testFilteredSearch() {
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new SearchResultValue(Arrays.asList(new SearchHit("placement", "mezzanine"), new SearchHit("market", "total_market")))));
        SearchQuery query = this.makeFilteredSearchQuery();
        QueryRunner runner = TestQueryRunners.makeSearchQueryRunner(this.segment);
        TestHelper.assertExpectedResults(expectedResults, runner.run(QueryPlus.wrap((Query)query)));
    }

    @Test
    public void testFilteredSearch2() {
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new SearchResultValue(Arrays.asList(new SearchHit("placementish", "a"), new SearchHit("placement", "mezzanine"), new SearchHit("market", "total_market")))));
        SearchQuery query = this.makeFilteredSearchQuery();
        QueryRunner runner = TestQueryRunners.makeSearchQueryRunner(this.segment2);
        TestHelper.assertExpectedResults(expectedResults, runner.run(QueryPlus.wrap((Query)query)));
    }

    @Test
    public void testRowFiltering() {
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)5L).put((Object)"index", (Object)500.0).put((Object)"addRowsIndexConstant", (Object)506.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build())));
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(this.ALL_GRAN).intervals(this.fullOnInterval).filters("market", "breakstuff").aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(new PostAggregator[]{this.addRowsIndexConstant}).build();
        QueryRunner runner = TestQueryRunners.makeTimeSeriesQueryRunner(this.segment3);
        TestHelper.assertExpectedResults(expectedResults, runner.run(QueryPlus.wrap((Query)query)));
    }

    private TimeseriesQuery makeTimeseriesQuery() {
        return Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(this.ALL_GRAN).intervals(this.fullOnInterval).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(new PostAggregator[]{this.addRowsIndexConstant}).build();
    }

    private TimeseriesQuery makeFilteredTimeseriesQuery() {
        return Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(this.ALL_GRAN).intervals(this.fullOnInterval).filters((DimFilter)new OrDimFilter(new DimFilter[]{new SelectorDimFilter("market", "spot", null), new SelectorDimFilter("market", "total_market", null)})).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(new PostAggregator[]{this.addRowsIndexConstant}).build();
    }

    private TopNQuery makeTopNQuery() {
        return new TopNQueryBuilder().dataSource("testing").granularity(this.ALL_GRAN).dimension("market").metric("index").threshold(3).intervals(this.fullOnInterval).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(new PostAggregator[]{this.addRowsIndexConstant}).build();
    }

    private TopNQuery makeFilteredTopNQuery() {
        return new TopNQueryBuilder().dataSource("testing").granularity(this.ALL_GRAN).dimension("market").metric("index").threshold(3).filters((DimFilter)new AndDimFilter(new DimFilter[]{new SelectorDimFilter("market", "spot", null), new SelectorDimFilter("placement", "preferred", null)})).intervals(this.fullOnInterval).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(new PostAggregator[]{this.addRowsIndexConstant}).build();
    }

    private SearchQuery makeSearchQuery() {
        return Druids.newSearchQueryBuilder().dataSource("testing").granularity(this.ALL_GRAN).intervals(this.fullOnInterval).query("a").build();
    }

    private SearchQuery makeFilteredSearchQuery() {
        return Druids.newSearchQueryBuilder().dataSource("testing").filters((DimFilter)new NotDimFilter((DimFilter)new SelectorDimFilter("market", "spot", null))).granularity(this.ALL_GRAN).intervals(this.fullOnInterval).query("a").build();
    }
}

