/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.topn;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.org.apache.druid.query.topn.AlphaNumericTopNMetricSpec;
import org.apache.hive.druid.org.apache.druid.query.topn.TopNMetricSpec;
import org.apache.hive.druid.org.apache.druid.segment.TestHelper;
import org.junit.Assert;
import org.junit.Test;

public class AlphaNumericTopNMetricSpecTest {
    @Test
    public void testComparator() {
        Comparator comparator = AlphaNumericTopNMetricSpec.COMPARATOR;
        Assert.assertEquals((long)0L, (long)comparator.compare("", ""));
        Assert.assertEquals((long)0L, (long)comparator.compare("abc", "abc"));
        Assert.assertEquals((long)0L, (long)comparator.compare("123", "123"));
        Assert.assertEquals((long)0L, (long)comparator.compare("abc123", "abc123"));
        Assert.assertTrue((comparator.compare("", "abc") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare("abc", "") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare("123", "abc") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare("abc", "123") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare("2", "11") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare("a2", "a11") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare("02", "11") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare("02", "002") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare("1.3", "1.5") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare("1.3", "1.15") < 0 ? 1 : 0) != 0);
        ArrayList sorted = Lists.newArrayList((Object[])new String[]{"1-5", "11-15", "16-20", "21-25", "26-30", "6-10", "Other"});
        Collections.sort(sorted, comparator);
        Assert.assertEquals((Object)ImmutableList.of((Object)"1-5", (Object)"6-10", (Object)"11-15", (Object)"16-20", (Object)"21-25", (Object)"26-30", (Object)"Other"), (Object)sorted);
        ArrayList sortedFixedDecimal = Lists.newArrayList((Object[])new String[]{"Other", "[0.00-0.05)", "[0.05-0.10)", "[0.10-0.50)", "[0.50-1.00)", "[1.00-5.00)", "[5.00-10.00)", "[10.00-20.00)"});
        Collections.sort(sortedFixedDecimal, comparator);
        Assert.assertEquals((Object)ImmutableList.of((Object)"[0.00-0.05)", (Object)"[0.05-0.10)", (Object)"[0.10-0.50)", (Object)"[0.50-1.00)", (Object)"[1.00-5.00)", (Object)"[5.00-10.00)", (Object)"[10.00-20.00)", (Object)"Other"), (Object)sortedFixedDecimal);
    }

    @Test
    public void testSerdeAlphaNumericTopNMetricSpec() throws IOException {
        AlphaNumericTopNMetricSpec expectedMetricSpec = new AlphaNumericTopNMetricSpec(null);
        AlphaNumericTopNMetricSpec expectedMetricSpec1 = new AlphaNumericTopNMetricSpec("test");
        String jsonSpec = "{\n    \"type\": \"alphaNumeric\"\n}";
        String jsonSpec1 = "{\n    \"type\": \"alphaNumeric\",\n    \"previousStop\": \"test\"\n}";
        ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
        TopNMetricSpec actualMetricSpec = (TopNMetricSpec)jsonMapper.readValue(jsonMapper.writeValueAsString(jsonMapper.readValue(jsonSpec, TopNMetricSpec.class)), TopNMetricSpec.class);
        TopNMetricSpec actualMetricSpec1 = (TopNMetricSpec)jsonMapper.readValue(jsonMapper.writeValueAsString(jsonMapper.readValue(jsonSpec1, TopNMetricSpec.class)), TopNMetricSpec.class);
        Assert.assertEquals((Object)expectedMetricSpec, (Object)actualMetricSpec);
        Assert.assertEquals((Object)expectedMetricSpec1, (Object)actualMetricSpec1);
    }
}

