/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.timeseries;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.primitives.Doubles;
import org.apache.hive.druid.org.apache.druid.common.config.NullHandling;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.hive.druid.org.apache.druid.query.Druids;
import org.apache.hive.druid.org.apache.druid.query.FinalizeResultsQueryRunner;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.QueryPlus;
import org.apache.hive.druid.org.apache.druid.query.QueryRunner;
import org.apache.hive.druid.org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.org.apache.druid.query.QueryToolChest;
import org.apache.hive.druid.org.apache.druid.query.Result;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.DoubleMaxAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.DoubleMinAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.FilteredAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.PostAggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.first.DoubleFirstAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.last.DoubleLastAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.hive.druid.org.apache.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.extraction.MapLookupExtractor;
import org.apache.hive.druid.org.apache.druid.query.filter.AndDimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.BoundDimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.DimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.InDimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.NotDimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.OrDimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.RegexDimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.hive.druid.org.apache.druid.query.lookup.LookupExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.lookup.LookupExtractor;
import org.apache.hive.druid.org.apache.druid.query.ordering.StringComparators;
import org.apache.hive.druid.org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.hive.druid.org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.hive.druid.org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.hive.druid.org.apache.druid.query.timeseries.TimeseriesQueryEngine;
import org.apache.hive.druid.org.apache.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.hive.druid.org.apache.druid.query.timeseries.TimeseriesQueryRunnerFactory;
import org.apache.hive.druid.org.apache.druid.query.timeseries.TimeseriesResultValue;
import org.apache.hive.druid.org.apache.druid.segment.TestHelper;
import org.apache.hive.druid.org.apache.druid.segment.VirtualColumn;
import org.apache.hive.druid.org.apache.druid.segment.column.ValueType;
import org.apache.hive.druid.org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.hive.druid.org.apache.druid.testing.InitializedNullHandlingTest;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TimeseriesQueryRunnerTest
extends InitializedNullHandlingTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    protected final QueryRunner runner;
    protected final boolean descending;
    protected final boolean vectorize;
    private final List<AggregatorFactory> aggregatorFactoryList;

    @Parameterized.Parameters(name="{0}:descending={1},vectorize={2}")
    public static Iterable<Object[]> constructorFeeder() {
        Iterable<Object[]> baseConstructors = QueryRunnerTestHelper.cartesian(QueryRunnerTestHelper.makeQueryRunners(new TimeseriesQueryRunnerFactory(new TimeseriesQueryQueryToolChest(QueryRunnerTestHelper.noopIntervalChunkingQueryRunnerDecorator()), new TimeseriesQueryEngine(), QueryRunnerTestHelper.NOOP_QUERYWATCHER)), Arrays.asList(false, true), Arrays.asList(false, true), Arrays.asList(QueryRunnerTestHelper.COMMON_DOUBLE_AGGREGATORS, QueryRunnerTestHelper.COMMON_FLOAT_AGGREGATORS));
        return StreamSupport.stream(baseConstructors.spliterator(), false).filter(constructor -> {
            boolean canVectorize = QueryRunnerTestHelper.isTestRunnerVectorizable((QueryRunner)constructor[0]) && (Boolean)constructor[1] == false;
            boolean vectorize = (Boolean)constructor[2];
            return !vectorize || canVectorize;
        }).collect(Collectors.toList());
    }

    private <T> void assertExpectedResults(Iterable<Result<T>> expectedResults, Iterable<Result<T>> results) {
        if (this.descending) {
            expectedResults = TestHelper.revert(expectedResults);
        }
        TestHelper.assertExpectedResults(expectedResults, results);
    }

    public TimeseriesQueryRunnerTest(QueryRunner runner, boolean descending, boolean vectorize, List<AggregatorFactory> aggregatorFactoryList) {
        this.runner = runner;
        this.descending = descending;
        this.vectorize = vectorize;
        this.aggregatorFactoryList = aggregatorFactoryList;
    }

    @Test
    public void testEmptyTimeseries() {
        this.cannotVectorize();
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).intervals(QueryRunnerTestHelper.EMPTY_INTERVAL).aggregators(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.INDEX_DOUBLE_SUM, new DoubleFirstAggregatorFactory("first", "index"))).descending(this.descending).context(this.makeContext()).build();
        HashMap<String, Number> resultMap = new HashMap<String, Number>();
        resultMap.put("rows", 0L);
        resultMap.put("index", NullHandling.defaultDoubleValue());
        resultMap.put("first", NullHandling.defaultDoubleValue());
        ImmutableList expectedResults = ImmutableList.of((Object)new Result(DateTimes.of((String)"2020-04-02"), (Object)new TimeseriesResultValue(resultMap)));
        List actualResults = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        TestHelper.assertExpectedResults(expectedResults, actualResults);
    }

    @Test
    public void testFullOnTimeseries() {
        Granularity gran = Granularities.DAY;
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(gran).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.INDEX_DOUBLE_SUM, QueryRunnerTestHelper.QUALITY_UNIQUES}).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        String[] expectedIndex = this.descending ? QueryRunnerTestHelper.EXPECTED_FULL_ON_INDEX_VALUES_DESC : QueryRunnerTestHelper.EXPECTED_FULL_ON_INDEX_VALUES;
        DateTime expectedLast = this.descending ? QueryRunnerTestHelper.EARLIEST : QueryRunnerTestHelper.LAST;
        int count = 0;
        Result lastResult = null;
        for (Result result : results) {
            DateTime current = result.getTimestamp();
            Assert.assertFalse((String)StringUtils.format((String)"Timestamp[%s] > expectedLast[%s]", (Object[])new Object[]{current, expectedLast}), (boolean)(this.descending ? current.isBefore((ReadableInstant)expectedLast) : current.isAfter((ReadableInstant)expectedLast)));
            TimeseriesResultValue value = (TimeseriesResultValue)result.getValue();
            Assert.assertEquals((String)result.toString(), (long)(QueryRunnerTestHelper.SKIPPED_DAY.equals((Object)current) ? 0L : 13L), (long)value.getLongMetric("rows"));
            if (!QueryRunnerTestHelper.SKIPPED_DAY.equals((Object)current)) {
                Assert.assertEquals((String)result.toString(), (double)Doubles.tryParse((String)expectedIndex[count]), (double)value.getDoubleMetric("index"), (double)(value.getDoubleMetric("index") * 1.0E-6));
                Assert.assertEquals((String)result.toString(), (double)(new Double(expectedIndex[count]) + 13.0 + 1.0), (double)value.getDoubleMetric("addRowsIndexConstant"), (double)(value.getDoubleMetric("addRowsIndexConstant") * 1.0E-6));
                Assert.assertEquals((double)value.getDoubleMetric("uniques"), (double)9.0, (double)0.02);
            } else if (NullHandling.replaceWithDefault()) {
                Assert.assertEquals((String)result.toString(), (double)0.0, (double)value.getDoubleMetric("index"), (double)(value.getDoubleMetric("index") * 1.0E-6));
                Assert.assertEquals((String)result.toString(), (double)(new Double(expectedIndex[count]) + 1.0), (double)value.getDoubleMetric("addRowsIndexConstant"), (double)(value.getDoubleMetric("addRowsIndexConstant") * 1.0E-6));
                Assert.assertEquals((double)0.0, (double)value.getDoubleMetric("uniques"), (double)0.02);
            } else {
                Assert.assertNull((String)result.toString(), (Object)value.getDoubleMetric("index"));
                Assert.assertNull((String)result.toString(), (Object)value.getDoubleMetric("addRowsIndexConstant"));
                Assert.assertEquals((double)value.getDoubleMetric("uniques"), (double)0.0, (double)0.02);
            }
            lastResult = result;
            ++count;
        }
        Assert.assertEquals((String)lastResult.toString(), (Object)expectedLast, (Object)lastResult.getTimestamp());
    }

    @Test
    public void testTimeseriesNoAggregators() {
        Granularity gran = Granularities.DAY;
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(gran).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).descending(this.descending).context(this.makeContext()).build();
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        DateTime expectedLast = this.descending ? QueryRunnerTestHelper.EARLIEST : QueryRunnerTestHelper.LAST;
        Result lastResult = null;
        for (Result result : results) {
            DateTime current = result.getTimestamp();
            Assert.assertFalse((String)StringUtils.format((String)"Timestamp[%s] > expectedLast[%s]", (Object[])new Object[]{current, expectedLast}), (boolean)(this.descending ? current.isBefore((ReadableInstant)expectedLast) : current.isAfter((ReadableInstant)expectedLast)));
            Assert.assertEquals((Object)ImmutableMap.of(), (Object)((TimeseriesResultValue)result.getValue()).getBaseObject());
            lastResult = result;
        }
        Assert.assertEquals((String)lastResult.toString(), (Object)expectedLast, (Object)lastResult.getTimestamp());
    }

    @Test
    public void testFullOnTimeseriesMaxMin() {
        this.cannotVectorize();
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(Granularities.ALL).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators(Arrays.asList(new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index"))).descending(this.descending).context(this.makeContext()).build();
        DateTime expectedEarliest = DateTimes.of((String)"2011-01-12");
        DateTime expectedLast = DateTimes.of((String)"2011-04-15");
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        Result result = (Result)results.iterator().next();
        Assert.assertEquals((Object)expectedEarliest, (Object)result.getTimestamp());
        Assert.assertFalse((String)StringUtils.format((String)"Timestamp[%s] > expectedLast[%s]", (Object[])new Object[]{result.getTimestamp(), expectedLast}), (boolean)result.getTimestamp().isAfter((ReadableInstant)expectedLast));
        TimeseriesResultValue value = (TimeseriesResultValue)result.getValue();
        Assert.assertEquals((String)result.toString(), (double)1870.061029, (double)value.getDoubleMetric("maxIndex"), (double)0.0018700610289999998);
        Assert.assertEquals((String)result.toString(), (double)59.021022, (double)value.getDoubleMetric("minIndex"), (double)5.9021021999999996E-5);
    }

    @Test
    public void testFullOnTimeseriesWithFilter() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters("market", "upfront").intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.QUALITY_UNIQUES)).descending(this.descending).context(this.makeContext()).build();
        Assert.assertEquals((Object)new SelectorDimFilter("market", "upfront", null), (Object)query.getDimensionsFilter());
        DateTime expectedLast = this.descending ? QueryRunnerTestHelper.EARLIEST : QueryRunnerTestHelper.LAST;
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        for (Result result : results) {
            DateTime current = result.getTimestamp();
            Assert.assertFalse((String)StringUtils.format((String)"Timestamp[%s] > expectedLast[%s]", (Object[])new Object[]{current, expectedLast}), (boolean)(this.descending ? current.isBefore((ReadableInstant)expectedLast) : current.isAfter((ReadableInstant)expectedLast)));
            TimeseriesResultValue value = (TimeseriesResultValue)result.getValue();
            Assert.assertEquals((String)result.toString(), (long)(QueryRunnerTestHelper.SKIPPED_DAY.equals((Object)result.getTimestamp()) ? 0L : 2L), (long)value.getLongMetric("rows"));
            Assert.assertEquals((String)result.toString(), (double)(QueryRunnerTestHelper.SKIPPED_DAY.equals((Object)result.getTimestamp()) ? 0.0 : 2.0), (double)value.getDoubleMetric("uniques"), (double)0.01);
        }
    }

    @Test
    public void testTimeseries() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index"), QueryRunnerTestHelper.QUALITY_UNIQUES)).descending(this.descending).context(this.makeContext()).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)6619L, (Object)"uniques", (Object)9.019833517963864))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)5827L, (Object)"uniques", (Object)9.019833517963864))));
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesGrandTotal() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.INDEX_LONG_SUM, QueryRunnerTestHelper.QUALITY_UNIQUES)).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context((Map)ImmutableMap.of((Object)"grandTotal", (Object)true)).build();
        ArrayList expectedResults = new ArrayList();
        expectedResults.add(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"index", (Object)6619L, (Object)"uniques", (Object)9.019833517963864, (Object)"addRowsIndexConstant", (Object)6633.0))));
        expectedResults.add(new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"index", (Object)5827L, (Object)"uniques", (Object)9.019833517963864, (Object)"addRowsIndexConstant", (Object)5841.0))));
        if (this.descending) {
            Collections.reverse(expectedResults);
        }
        expectedResults.add(new Result(null, (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)26L, (Object)"index", (Object)12446L, (Object)"uniques", (Object)9.019833517963864, (Object)"addRowsIndexConstant", (Object)12473.0))));
        TimeseriesQueryQueryToolChest toolChest = new TimeseriesQueryQueryToolChest(QueryRunnerTestHelper.noopIntervalChunkingQueryRunnerDecorator());
        FinalizeResultsQueryRunner finalRunner = new FinalizeResultsQueryRunner(toolChest.mergeResults(this.runner), (QueryToolChest)toolChest);
        List results = finalRunner.run(QueryPlus.wrap((Query)query)).toList();
        TestHelper.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesIntervalOutOfRanges() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).intervals(QueryRunnerTestHelper.EMPTY_INTERVAL).aggregators(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.INDEX_LONG_SUM)).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context((Map)ImmutableMap.of((Object)"skipEmptyBuckets", (Object)false)).build();
        ArrayList expectedResults = new ArrayList();
        expectedResults.add(new Result(((Interval)QueryRunnerTestHelper.EMPTY_INTERVAL.getIntervals().get(0)).getStart(), (Object)new TimeseriesResultValue(TestHelper.createExpectedMap("rows", 0L, "index", NullHandling.defaultLongValue(), "addRowsIndexConstant", NullHandling.sqlCompatible() ? null : Double.valueOf(1.0)))));
        TimeseriesQueryQueryToolChest toolChest = new TimeseriesQueryQueryToolChest(QueryRunnerTestHelper.noopIntervalChunkingQueryRunnerDecorator());
        FinalizeResultsQueryRunner finalRunner = new FinalizeResultsQueryRunner(toolChest.mergeResults(this.runner), (QueryToolChest)toolChest);
        List results = finalRunner.run(QueryPlus.wrap((Query)query)).toList();
        TestHelper.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithVirtualColumn() {
        this.cannotVectorize();
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "expr"), QueryRunnerTestHelper.QUALITY_UNIQUES)).descending(this.descending).virtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("expr", "index", ValueType.FLOAT, TestExprMacroTable.INSTANCE)}).context(this.makeContext()).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)6619L, (Object)"uniques", (Object)9.019833517963864))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)5827L, (Object)"uniques", (Object)9.019833517963864))));
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithTimeZone() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").intervals("2011-03-31T00:00:00-07:00/2011-04-02T00:00:00-07:00").aggregators(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index"))).granularity((Granularity)new PeriodGranularity(new Period((Object)"P1D"), null, DateTimes.inferTzFromString((String)"America/Los_Angeles"))).descending(this.descending).context(this.makeContext()).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-03-31", DateTimes.inferTzFromString((String)"America/Los_Angeles")), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)6619L))), new Result(new DateTime((Object)"2011-04-01T", DateTimes.inferTzFromString((String)"America/Los_Angeles")), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)5827L))));
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithVaryingGran() {
        TimeseriesQuery query1 = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).intervals(Collections.singletonList(Intervals.of((String)"2011-04-02T00:00:00.000Z/2011-04-03T00:00:00.000Z"))).aggregators(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index"), QueryRunnerTestHelper.QUALITY_UNIQUES)).descending(this.descending).context(this.makeContext()).build();
        List expectedResults1 = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)5827L, (Object)"uniques", (Object)9.019833517963864))));
        List results1 = this.runner.run(QueryPlus.wrap((Query)query1)).toList();
        this.assertExpectedResults(expectedResults1, results1);
        TimeseriesQuery query2 = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity("DAY").intervals(Collections.singletonList(Intervals.of((String)"2011-04-02T00:00:00.000Z/2011-04-03T00:00:00.000Z"))).aggregators(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index"), QueryRunnerTestHelper.QUALITY_UNIQUES)).context(this.makeContext()).build();
        List expectedResults2 = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)5827L, (Object)"uniques", (Object)9.019833517963864))));
        List results2 = this.runner.run(QueryPlus.wrap((Query)query2)).toList();
        this.assertExpectedResults(expectedResults2, results2);
    }

    @Test
    public void testTimeseriesGranularityNotAlignedOnSegmentBoundariesWithFilter() {
        TimeseriesQuery query1 = Druids.newTimeseriesQueryBuilder().dataSource("testing").filters("market", "spot", new String[]{"upfront", "total_market"}).granularity((Granularity)new PeriodGranularity(new Period((Object)"P7D"), null, DateTimes.inferTzFromString((String)"America/Los_Angeles"))).intervals(Collections.singletonList(Intervals.of((String)"2011-01-12T00:00:00.000-08:00/2011-01-20T00:00:00.000-08:00"))).aggregators(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index"))).descending(this.descending).context(this.makeContext()).build();
        List expectedResults1 = Arrays.asList(new Result(new DateTime((Object)"2011-01-06T00:00:00.000-08:00", DateTimes.inferTzFromString((String)"America/Los_Angeles")), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)6071L))), new Result(new DateTime((Object)"2011-01-13T00:00:00.000-08:00", DateTimes.inferTzFromString((String)"America/Los_Angeles")), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)91L, (Object)"idx", (Object)33382L))));
        List results1 = this.runner.run(QueryPlus.wrap((Query)query1)).toList();
        this.assertExpectedResults(expectedResults1, results1);
    }

    @Test
    public void testTimeseriesQueryZeroFilling() {
        TimeseriesQuery query1 = Druids.newTimeseriesQueryBuilder().dataSource("testing").filters("market", "spot", new String[]{"upfront", "total_market"}).granularity(Granularities.HOUR).intervals(Collections.singletonList(Intervals.of((String)"2011-04-14T00:00:00.000Z/2011-05-01T00:00:00.000Z"))).aggregators(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index"))).descending(this.descending).context(this.makeContext()).build();
        ArrayList<Result> lotsOfZeroes = new ArrayList<Result>();
        Iterable iterable = Granularities.HOUR.getIterable(new Interval((ReadableInstant)DateTimes.of((String)"2011-04-14T01"), (ReadableInstant)DateTimes.of((String)"2011-04-15")));
        HashMap<String, Long> noRowsResult = new HashMap<String, Long>();
        noRowsResult.put("rows", 0L);
        noRowsResult.put("idx", NullHandling.defaultLongValue());
        for (Interval interval : iterable) {
            lotsOfZeroes.add(new Result(interval.getStart(), (Object)new TimeseriesResultValue(noRowsResult)));
        }
        ArrayList expectedResults1 = Lists.newArrayList((Iterable)Iterables.concat(Collections.singletonList(new Result(DateTimes.of((String)"2011-04-14T00"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)4907L)))), lotsOfZeroes, Collections.singletonList(new Result(DateTimes.of((String)"2011-04-15T00"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)4717L))))));
        List results1 = this.runner.run(QueryPlus.wrap((Query)query1)).toList();
        this.assertExpectedResults(expectedResults1, results1);
    }

    @Test
    public void testTimeseriesQueryGranularityNotAlignedWithRollupGranularity() {
        TimeseriesQuery query1 = Druids.newTimeseriesQueryBuilder().dataSource("testing").filters("market", "spot", new String[]{"upfront", "total_market"}).granularity((Granularity)new PeriodGranularity(new Period((Object)"PT1H"), DateTimes.utc((long)60000L), DateTimeZone.UTC)).intervals(Collections.singletonList(Intervals.of((String)"2011-04-15T00:00:00.000Z/2012"))).aggregators(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index"))).descending(this.descending).context(this.makeContext()).build();
        List expectedResults1 = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-14T23:01Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)4717L))));
        List results1 = this.runner.run(QueryPlus.wrap((Query)query1)).toList();
        this.assertExpectedResults(expectedResults1, results1);
    }

    @Test
    public void testTimeseriesWithVaryingGranWithFilter() {
        TimeseriesQuery query1 = Druids.newTimeseriesQueryBuilder().dataSource("testing").filters("market", "spot", new String[]{"upfront", "total_market"}).granularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).intervals(Collections.singletonList(Intervals.of((String)"2011-04-02T00:00:00.000Z/2011-04-03T00:00:00.000Z"))).aggregators(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index"), QueryRunnerTestHelper.QUALITY_UNIQUES)).descending(this.descending).context(this.makeContext()).build();
        List expectedResults1 = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)5827L, (Object)"uniques", (Object)9.019833517963864))));
        List results1 = this.runner.run(QueryPlus.wrap((Query)query1)).toList();
        this.assertExpectedResults(expectedResults1, results1);
        TimeseriesQuery query2 = Druids.newTimeseriesQueryBuilder().dataSource("testing").filters("market", "spot", new String[]{"upfront", "total_market"}).granularity("DAY").intervals(Collections.singletonList(Intervals.of((String)"2011-04-02T00:00:00.000Z/2011-04-03T00:00:00.000Z"))).aggregators(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index"), QueryRunnerTestHelper.QUALITY_UNIQUES)).context(this.makeContext()).build();
        List expectedResults2 = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)5827L, (Object)"uniques", (Object)9.019833517963864))));
        List results2 = this.runner.run(QueryPlus.wrap((Query)query2)).toList();
        this.assertExpectedResults(expectedResults2, results2);
    }

    @Test
    public void testTimeseriesQueryBeyondTimeRangeOfData() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.of((String)"2015-01-01/2015-01-10")))).aggregators(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index"))).descending(this.descending).context(this.makeContext()).build();
        List expectedResults = Collections.emptyList();
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithOrFilter() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters("market", "spot", new String[]{"upfront", "total_market"}).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.INDEX_LONG_SUM, QueryRunnerTestHelper.QUALITY_UNIQUES}).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"index", (Object)6619L, (Object)"addRowsIndexConstant", (Object)6633.0, (Object)"uniques", (Object)9.019833517963864))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"index", (Object)5827L, (Object)"addRowsIndexConstant", (Object)5841.0, (Object)"uniques", (Object)9.019833517963864))));
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithRegexFilter() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters((DimFilter)new RegexDimFilter("market", "^.p.*$", null)).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.INDEX_LONG_SUM, QueryRunnerTestHelper.QUALITY_UNIQUES}).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)11L, (Object)"index", (Object)3783L, (Object)"addRowsIndexConstant", (Object)3795.0, (Object)"uniques", (Object)9.019833517963864))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)11L, (Object)"index", (Object)3313L, (Object)"addRowsIndexConstant", (Object)3325.0, (Object)"uniques", (Object)9.019833517963864))));
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithFilter1() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters("market", "spot").intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.INDEX_LONG_SUM, QueryRunnerTestHelper.QUALITY_UNIQUES}).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)9L, (Object)"index", (Object)1102L, (Object)"addRowsIndexConstant", (Object)1112.0, (Object)"uniques", (Object)9.019833517963864))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)9L, (Object)"index", (Object)1120L, (Object)"addRowsIndexConstant", (Object)1130.0, (Object)"uniques", (Object)9.019833517963864))));
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithFilter2() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters("market", "upfront").intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.INDEX_LONG_SUM, QueryRunnerTestHelper.QUALITY_UNIQUES}).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)2681L, (Object)"addRowsIndexConstant", (Object)2684.0, (Object)"uniques", (Object)2.000977198748901))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)2193L, (Object)"addRowsIndexConstant", (Object)2196.0, (Object)"uniques", (Object)2.000977198748901))));
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithFilter3() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters("market", "total_market").intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.INDEX_LONG_SUM, QueryRunnerTestHelper.QUALITY_UNIQUES}).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)2836L, (Object)"addRowsIndexConstant", (Object)2839.0, (Object)"uniques", (Object)2.000977198748901))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)2514L, (Object)"addRowsIndexConstant", (Object)2517.0, (Object)"uniques", (Object)2.000977198748901))));
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithMultiDimFilterAndOr() {
        AndDimFilter andDimFilter = new AndDimFilter(new DimFilter[]{new SelectorDimFilter("market", "spot", null), new OrDimFilter("quality", "automotive", new String[]{"business"})});
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters((DimFilter)andDimFilter).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)254.4554443359375, (Object)"addRowsIndexConstant", (Object)257.4554443359375, (Object)"uniques", (Object)2.000977198748901))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)260.4129638671875, (Object)"addRowsIndexConstant", (Object)263.4129638671875, (Object)"uniques", (Object)2.000977198748901))));
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithMultiDimFilter() {
        AndDimFilter andDimFilter = new AndDimFilter(new DimFilter[]{new SelectorDimFilter("market", "spot", null), new SelectorDimFilter("quality", "automotive", null)});
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters((DimFilter)andDimFilter).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)1L, (Object)"index", (Object)new Float(135.885094).doubleValue(), (Object)"addRowsIndexConstant", (Object)new Float(137.885094).doubleValue(), (Object)"uniques", (Object)1.0002442201269182))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)1L, (Object)"index", (Object)new Float(147.425935).doubleValue(), (Object)"addRowsIndexConstant", (Object)new Float(149.425935).doubleValue(), (Object)"uniques", (Object)1.0002442201269182))));
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithOtherMultiDimFilter() {
        AndDimFilter andDimFilter = new AndDimFilter(new DimFilter[]{new SelectorDimFilter("market", "spot", null), new SelectorDimFilter("quality", "business", null)});
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters((DimFilter)andDimFilter).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(QueryRunnerTestHelper.COMMON_DOUBLE_AGGREGATORS).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)1L, (Object)"index", (Object)new Float(118.57034).doubleValue(), (Object)"addRowsIndexConstant", (Object)new Float(120.57034).doubleValue(), (Object)"uniques", (Object)1.0002442201269182))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)1L, (Object)"index", (Object)new Float(112.987027).doubleValue(), (Object)"addRowsIndexConstant", (Object)new Float(114.987027).doubleValue(), (Object)"uniques", (Object)1.0002442201269182))));
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithNonExistentFilterInOr() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters("market", "spot", new String[]{"upfront", "total_market", "billyblank"}).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.INDEX_LONG_SUM, QueryRunnerTestHelper.QUALITY_UNIQUES}).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"index", (Object)6619L, (Object)"addRowsIndexConstant", (Object)6633.0, (Object)"uniques", (Object)9.019833517963864))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"index", (Object)5827L, (Object)"addRowsIndexConstant", (Object)5841.0, (Object)"uniques", (Object)9.019833517963864))));
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithInFilter() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters((DimFilter)new InDimFilter("market", Arrays.asList("spot", "upfront", "total_market", "billyblank"), null)).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.INDEX_LONG_SUM, QueryRunnerTestHelper.QUALITY_UNIQUES}).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"index", (Object)6619L, (Object)"addRowsIndexConstant", (Object)6633.0, (Object)"uniques", (Object)9.019833517963864))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"index", (Object)5827L, (Object)"addRowsIndexConstant", (Object)5841.0, (Object)"uniques", (Object)9.019833517963864))));
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithNonExistentFilterAndMultiDimAndOr() {
        AndDimFilter andDimFilter = new AndDimFilter(new DimFilter[]{new SelectorDimFilter("market", "spot", null), new OrDimFilter("quality", "automotive", new String[]{"business", "billyblank"})});
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters((DimFilter)andDimFilter).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)254.4554443359375, (Object)"addRowsIndexConstant", (Object)257.4554443359375, (Object)"uniques", (Object)2.000977198748901))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)260.4129638671875, (Object)"addRowsIndexConstant", (Object)263.4129638671875, (Object)"uniques", (Object)2.000977198748901))));
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithFilterOnNonExistentDimension() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters("bobby", "billy").intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        HashMap<String, Number> resultMap = new HashMap<String, Number>();
        resultMap.put("rows", 0L);
        resultMap.put("index", NullHandling.defaultDoubleValue());
        resultMap.put("addRowsIndexConstant", NullHandling.replaceWithDefault() ? Double.valueOf(1.0) : null);
        resultMap.put("uniques", 0.0);
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue(resultMap)), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue(resultMap)));
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithFilterOnNonExistentDimensionSkipBuckets() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters("bobby", "billy").intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).context((Map)ImmutableMap.of((Object)"skipEmptyBuckets", (Object)"true")).descending(this.descending).context(this.makeContext((Map<String, Object>)ImmutableMap.of((Object)"skipEmptyBuckets", (Object)"true"))).build();
        List expectedResults = Collections.emptyList();
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithNullFilterOnNonExistentDimension() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters("bobby", null).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"index", (Object)6626.151596069336, (Object)"addRowsIndexConstant", (Object)6640.151596069336, (Object)"uniques", (Object)9.019833517963864))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"index", (Object)5833.2095947265625, (Object)"addRowsIndexConstant", (Object)5847.2095947265625, (Object)"uniques", (Object)9.019833517963864))));
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithInvertedFilterOnNonExistentDimension() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters((DimFilter)new NotDimFilter((DimFilter)new SelectorDimFilter("bobby", "sally", null))).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"index", (Object)6626.151596069336, (Object)"addRowsIndexConstant", (Object)6640.151596069336, (Object)"uniques", (Object)9.019833517963864))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"index", (Object)5833.2095947265625, (Object)"addRowsIndexConstant", (Object)5847.2095947265625, (Object)"uniques", (Object)9.019833517963864))));
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithNonExistentFilter() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters("market", "billy").intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        HashMap<String, Number> resultMap = new HashMap<String, Number>();
        resultMap.put("rows", 0L);
        resultMap.put("index", NullHandling.defaultDoubleValue());
        resultMap.put("addRowsIndexConstant", NullHandling.replaceWithDefault() ? Double.valueOf(1.0) : null);
        resultMap.put("uniques", 0.0);
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue(resultMap)), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue(resultMap)));
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithNonExistentFilterAndMultiDim() {
        AndDimFilter andDimFilter = new AndDimFilter(new DimFilter[]{new SelectorDimFilter("market", "billy", null), new SelectorDimFilter("quality", "business", null)});
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters((DimFilter)andDimFilter).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        HashMap<String, Number> resultMap = new HashMap<String, Number>();
        resultMap.put("rows", 0L);
        resultMap.put("index", NullHandling.defaultDoubleValue());
        resultMap.put("addRowsIndexConstant", NullHandling.replaceWithDefault() ? Double.valueOf(1.0) : null);
        resultMap.put("uniques", 0.0);
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue(resultMap)), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue(resultMap)));
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithMultiValueFilteringJavascriptAggregator() {
        this.cannotVectorize();
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators((List)ImmutableList.of((Object)QueryRunnerTestHelper.INDEX_DOUBLE_SUM, (Object)QueryRunnerTestHelper.JS_INDEX_SUM_IF_PLACEMENTISH_A, (Object)QueryRunnerTestHelper.JS_PLACEMENTISH_COUNT)).descending(this.descending).context(this.makeContext()).build();
        ImmutableList expectedResults = ImmutableList.of((Object)new Result(((Interval)QueryRunnerTestHelper.FIRST_TO_THIRD.getIntervals().get(0)).getStart(), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"index", (Object)12459.361190795898, (Object)"nindex", (Object)283.31103515625, (Object)"pishcount", (Object)52.0))));
        List actualResults = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults((Iterable)expectedResults, actualResults);
    }

    @Test
    public void testTimeseriesWithMultiValueFilteringJavascriptAggregatorAndAlsoRegularFilters() {
        this.cannotVectorize();
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).filters("placementish", "a").intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators((List)ImmutableList.of((Object)QueryRunnerTestHelper.INDEX_DOUBLE_SUM, (Object)QueryRunnerTestHelper.JS_INDEX_SUM_IF_PLACEMENTISH_A, (Object)QueryRunnerTestHelper.JS_PLACEMENTISH_COUNT)).descending(this.descending).context(this.makeContext()).build();
        ImmutableList expectedResults = ImmutableList.of((Object)new Result(((Interval)QueryRunnerTestHelper.FIRST_TO_THIRD.getIntervals().get(0)).getStart(), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"index", (Object)283.31103515625, (Object)"nindex", (Object)283.31103515625, (Object)"pishcount", (Object)4.0))));
        List actualResults = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults((Iterable)expectedResults, actualResults);
    }

    @Test
    public void testTimeseriesWithFirstLastAggregator() {
        this.cannotVectorize();
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.MONTH_GRAN).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators((List)ImmutableList.of((Object)new DoubleFirstAggregatorFactory("first", "index"), (Object)new DoubleLastAggregatorFactory("last", "index"))).descending(this.descending).context(this.makeContext()).build();
        ImmutableList expectedAscendingResults = ImmutableList.of((Object)new Result(DateTimes.of((String)"2011-01-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"first", (Object)new Float(100.0).doubleValue(), (Object)"last", (Object)new Float(943.497198).doubleValue()))), (Object)new Result(DateTimes.of((String)"2011-02-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"first", (Object)new Float(132.123776).doubleValue(), (Object)"last", (Object)new Float(1101.91827).doubleValue()))), (Object)new Result(DateTimes.of((String)"2011-03-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"first", (Object)new Float(153.059937).doubleValue(), (Object)"last", (Object)new Float(1063.201156).doubleValue()))), (Object)new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"first", (Object)new Float(135.885094).doubleValue(), (Object)"last", (Object)new Float(780.271977).doubleValue()))));
        ImmutableList expectedDescendingResults = ImmutableList.of((Object)new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"first", (Object)new Float(1234.247546).doubleValue(), (Object)"last", (Object)new Float(106.7937).doubleValue()))), (Object)new Result(DateTimes.of((String)"2011-03-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"first", (Object)new Float(1004.940887).doubleValue(), (Object)"last", (Object)new Float(151.752485).doubleValue()))), (Object)new Result(DateTimes.of((String)"2011-02-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"first", (Object)new Float(913.561076).doubleValue(), (Object)"last", (Object)new Float(122.258195).doubleValue()))), (Object)new Result(DateTimes.of((String)"2011-01-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"first", (Object)new Float(800.0).doubleValue(), (Object)"last", (Object)new Float(133.740047).doubleValue()))));
        List actualResults = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        if (this.descending) {
            TestHelper.assertExpectedResults(expectedDescendingResults, actualResults);
        } else {
            TestHelper.assertExpectedResults(expectedAscendingResults, actualResults);
        }
    }

    @Test
    public void testTimeseriesWithMultiValueDimFilter1() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters("placementish", "preferred").intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        TimeseriesQuery query1 = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        List expectedResults = this.runner.run(QueryPlus.wrap((Query)query1)).toList();
        List actualResults = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        TestHelper.assertExpectedResults(expectedResults, actualResults);
    }

    @Test
    public void testTimeseriesWithMultiValueDimFilter2() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters("placementish", "a").intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        TimeseriesQuery query1 = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters("quality", "automotive").intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        List expectedResults = this.runner.run(QueryPlus.wrap((Query)query1)).toList();
        List actualResults = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        TestHelper.assertExpectedResults(expectedResults, actualResults);
    }

    @Test
    public void testTimeseriesWithMultiValueDimFilterAndOr1() {
        AndDimFilter andDimFilter = new AndDimFilter(new DimFilter[]{new SelectorDimFilter("market", "spot", null), new SelectorDimFilter("placementish", "a", null)});
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters((DimFilter)andDimFilter).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        AndDimFilter andDimFilter2 = new AndDimFilter(new DimFilter[]{new SelectorDimFilter("market", "spot", null), new SelectorDimFilter("quality", "automotive", null)});
        TimeseriesQuery query2 = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters((DimFilter)andDimFilter2).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        List expectedResults = this.runner.run(QueryPlus.wrap((Query)query2)).toList();
        List actualResults = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        TestHelper.assertExpectedResults(expectedResults, actualResults);
    }

    @Test
    public void testTimeseriesWithMultiValueDimFilterAndOr2() {
        AndDimFilter andDimFilter = new AndDimFilter(new DimFilter[]{new SelectorDimFilter("market", "spot", null), new OrDimFilter("placementish", "a", new String[]{"b"})});
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters((DimFilter)andDimFilter).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        AndDimFilter andDimFilter2 = new AndDimFilter(new DimFilter[]{new SelectorDimFilter("market", "spot", null), new OrDimFilter("quality", "automotive", new String[]{"business"})});
        TimeseriesQuery query2 = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters((DimFilter)andDimFilter2).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        List expectedResults = this.runner.run(QueryPlus.wrap((Query)query2)).toList();
        List actualResults = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        TestHelper.assertExpectedResults(expectedResults, actualResults);
    }

    @Test
    public void testTimeSeriesWithFilteredAgg() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.aggregatorFactoryList, Collections.singletonList(new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("filteredAgg"), (DimFilter)new SelectorDimFilter("market", "spot", null)))))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        List actualResults = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"filteredAgg", (Object)18L, (Object)"addRowsIndexConstant", (Object)12486.361190795898, (Object)"index", (Object)12459.361190795898, (Object)"uniques", (Object)9.019833517963864, (Object)"rows", (Object)26L))));
        this.assertExpectedResults(expectedResults, actualResults);
    }

    @Test
    public void testTimeSeriesWithFilteredAggDimensionNotPresentNotNullValue() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.aggregatorFactoryList, Collections.singletonList(new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("filteredAgg"), (DimFilter)new SelectorDimFilter("abraKaDabra", "Lol", null)))))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        List actualResults = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"filteredAgg", (Object)0L, (Object)"addRowsIndexConstant", (Object)12486.361190795898, (Object)"index", (Object)12459.361190795898, (Object)"uniques", (Object)9.019833517963864, (Object)"rows", (Object)26L))));
        this.assertExpectedResults(expectedResults, actualResults);
    }

    @Test
    public void testTimeSeriesWithFilteredAggDimensionNotPresentNullValue() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.aggregatorFactoryList, Collections.singletonList(new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("filteredAgg"), (DimFilter)new SelectorDimFilter("abraKaDabra", null, null)))))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        List actualResults = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"filteredAgg", (Object)26L, (Object)"addRowsIndexConstant", (Object)12486.361190795898, (Object)"index", (Object)12459.361190795898, (Object)"uniques", (Object)9.019833517963864, (Object)"rows", (Object)26L))));
        this.assertExpectedResults(expectedResults, actualResults);
    }

    @Test
    public void testTimeSeriesWithFilteredAggValueNotPresent() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.aggregatorFactoryList, Collections.singletonList(new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("filteredAgg"), (DimFilter)new NotDimFilter((DimFilter)new SelectorDimFilter("market", "LolLol", null))))))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        List actualResults = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"filteredAgg", (Object)26L, (Object)"addRowsIndexConstant", (Object)12486.361190795898, (Object)"index", (Object)12459.361190795898, (Object)"uniques", (Object)9.019833517963864, (Object)"rows", (Object)26L))));
        this.assertExpectedResults(expectedResults, actualResults);
    }

    @Test
    public void testTimeSeriesWithFilteredAggInvertedNullValue() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.aggregatorFactoryList, Collections.singletonList(new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("filteredAgg"), (DimFilter)new NotDimFilter((DimFilter)new SelectorDimFilter("market", null, null))))))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        List actualResults = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"filteredAgg", (Object)26L, (Object)"addRowsIndexConstant", (Object)12486.361190795898, (Object)"index", (Object)12459.361190795898, (Object)"uniques", (Object)9.019833517963864, (Object)"rows", (Object)26L))));
        this.assertExpectedResults(expectedResults, actualResults);
    }

    @Test
    public void testTimeseriesWithTimeColumn() {
        this.cannotVectorize();
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.JS_COUNT_IF_TIME_GREATER_THAN, QueryRunnerTestHelper.TIME_LONG_SUM}).granularity(QueryRunnerTestHelper.ALL_GRAN).descending(this.descending).context(this.makeContext()).build();
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)26L, (Object)"ntimestamps", (Object)13.0, (Object)"sumtime", (Object)33843139200000L))));
        List actualResults = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, actualResults);
    }

    @Test
    public void testTimeseriesWithBoundFilter1() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters((DimFilter)new AndDimFilter(Arrays.asList(new BoundDimFilter("market", "spa", "spot", Boolean.valueOf(true), null, null, null, StringComparators.LEXICOGRAPHIC), new BoundDimFilter("market", "spot", "spotify", null, Boolean.valueOf(true), null, null, StringComparators.LEXICOGRAPHIC), new BoundDimFilter("market", "SPOT", "spot", null, null, null, null, StringComparators.LEXICOGRAPHIC)))).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.INDEX_LONG_SUM, QueryRunnerTestHelper.QUALITY_UNIQUES}).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).context(this.makeContext()).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)9L, (Object)"index", (Object)1102L, (Object)"addRowsIndexConstant", (Object)1112.0, (Object)"uniques", (Object)9.019833517963864))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)9L, (Object)"index", (Object)1120L, (Object)"addRowsIndexConstant", (Object)1130.0, (Object)"uniques", (Object)9.019833517963864))));
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        TestHelper.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeSeriesWithSelectionFilterLookupExtractionFn() {
        HashMap<String, String> extractionMap = new HashMap<String, String>();
        extractionMap.put("spot", "upfront");
        MapLookupExtractor mapLookupExtractor = new MapLookupExtractor(extractionMap, false);
        LookupExtractionFn lookupExtractionFn = new LookupExtractionFn((LookupExtractor)mapLookupExtractor, true, null, Boolean.valueOf(true), Boolean.valueOf(true));
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters((DimFilter)new SelectorDimFilter("market", "upfront", (ExtractionFn)lookupExtractionFn)).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.INDEX_LONG_SUM, QueryRunnerTestHelper.QUALITY_UNIQUES}).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).context(this.makeContext()).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)11L, (Object)"index", (Object)3783L, (Object)"addRowsIndexConstant", (Object)3795.0, (Object)"uniques", (Object)9.019833517963864))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)11L, (Object)"index", (Object)3313L, (Object)"addRowsIndexConstant", (Object)3325.0, (Object)"uniques", (Object)9.019833517963864))));
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        TestHelper.assertExpectedResults(expectedResults, results);
        TimeseriesQueryQueryToolChest toolChest = new TimeseriesQueryQueryToolChest(QueryRunnerTestHelper.noopIntervalChunkingQueryRunnerDecorator());
        QueryRunner optimizedRunner = toolChest.postMergeQueryDecoration(toolChest.mergeResults(toolChest.preMergeQueryDecoration(this.runner)));
        List results2 = new FinalizeResultsQueryRunner(optimizedRunner, (QueryToolChest)toolChest).run(QueryPlus.wrap((Query)query)).toList();
        TestHelper.assertExpectedResults(expectedResults, results2);
    }

    @Test
    public void testTimeseriesWithLimit() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.QUALITY_UNIQUES)).descending(this.descending).limit(10).context(this.makeContext()).build();
        TimeseriesQueryQueryToolChest toolChest = new TimeseriesQueryQueryToolChest(QueryRunnerTestHelper.noopIntervalChunkingQueryRunnerDecorator());
        FinalizeResultsQueryRunner finalRunner = new FinalizeResultsQueryRunner(toolChest.mergeResults(this.runner), (QueryToolChest)toolChest);
        List list = finalRunner.run(QueryPlus.wrap((Query)query)).toList();
        Assert.assertEquals((long)10L, (long)list.size());
    }

    private Map<String, Object> makeContext() {
        return this.makeContext((Map<String, Object>)ImmutableMap.of());
    }

    private Map<String, Object> makeContext(Map<String, Object> myContext) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("vectorize", this.vectorize ? "force" : "false");
        context.put("vectorSize", 16);
        context.putAll(myContext);
        return context;
    }

    private void cannotVectorize() {
        if (this.vectorize) {
            this.expectedException.expect(RuntimeException.class);
            this.expectedException.expectMessage("Cannot vectorize!");
        }
    }
}

