/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.timeseries;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.data.input.MapBasedInputRow;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.org.apache.druid.query.Druids;
import org.apache.hive.druid.org.apache.druid.query.FinalizeResultsQueryRunner;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.QueryPlus;
import org.apache.hive.druid.org.apache.druid.query.QueryRunner;
import org.apache.hive.druid.org.apache.druid.query.QueryRunnerFactory;
import org.apache.hive.druid.org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.org.apache.druid.query.Result;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.hive.druid.org.apache.druid.query.timeseries.TimeseriesQueryEngine;
import org.apache.hive.druid.org.apache.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.hive.druid.org.apache.druid.query.timeseries.TimeseriesQueryRunnerFactory;
import org.apache.hive.druid.org.apache.druid.query.timeseries.TimeseriesResultValue;
import org.apache.hive.druid.org.apache.druid.segment.IncrementalIndexSegment;
import org.apache.hive.druid.org.apache.druid.segment.Segment;
import org.apache.hive.druid.org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.hive.druid.org.apache.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.hive.druid.org.apache.druid.timeline.SegmentId;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TimeseriesQueryRunnerBonusTest {
    private final boolean descending;

    @Parameterized.Parameters(name="descending={0}")
    public static Iterable<Object[]> constructorFeeder() {
        return QueryRunnerTestHelper.transformToConstructionFeeder(Arrays.asList(false, true));
    }

    public TimeseriesQueryRunnerBonusTest(boolean descending) {
        this.descending = descending;
    }

    @Test
    public void testOneRowAtATime() throws Exception {
        OnheapIncrementalIndex oneRowIndex = new IncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withMinTimestamp(DateTimes.of((String)"2012-01-01T00:00:00Z").getMillis()).build()).setMaxRowCount(1000).buildOnheap();
        oneRowIndex.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2012-01-01T00:00:00Z").getMillis(), (List)ImmutableList.of((Object)"dim1"), (Map)ImmutableMap.of((Object)"dim1", (Object)"x")));
        List<Result<TimeseriesResultValue>> results = this.runTimeseriesCount((IncrementalIndex)oneRowIndex);
        Assert.assertEquals((String)"index size", (long)1L, (long)oneRowIndex.size());
        Assert.assertEquals((String)"result size", (long)1L, (long)results.size());
        Assert.assertEquals((String)"result timestamp", (Object)DateTimes.of((String)"2012-01-01T00:00:00Z"), (Object)results.get(0).getTimestamp());
        Assert.assertEquals((String)"result count metric", (long)1L, (long)((TimeseriesResultValue)results.get(0).getValue()).getLongMetric("rows"));
        oneRowIndex.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2012-01-01T00:00:00Z").getMillis(), (List)ImmutableList.of((Object)"dim1"), (Map)ImmutableMap.of((Object)"dim1", (Object)"y")));
        results = this.runTimeseriesCount((IncrementalIndex)oneRowIndex);
        Assert.assertEquals((String)"index size", (long)2L, (long)oneRowIndex.size());
        Assert.assertEquals((String)"result size", (long)1L, (long)results.size());
        Assert.assertEquals((String)"result timestamp", (Object)DateTimes.of((String)"2012-01-01T00:00:00Z"), (Object)results.get(0).getTimestamp());
        Assert.assertEquals((String)"result count metric", (long)2L, (long)((TimeseriesResultValue)results.get(0).getValue()).getLongMetric("rows"));
    }

    private List<Result<TimeseriesResultValue>> runTimeseriesCount(IncrementalIndex index) {
        TimeseriesQueryRunnerFactory factory = new TimeseriesQueryRunnerFactory(new TimeseriesQueryQueryToolChest(QueryRunnerTestHelper.noopIntervalChunkingQueryRunnerDecorator()), new TimeseriesQueryEngine(), QueryRunnerTestHelper.NOOP_QUERYWATCHER);
        QueryRunner runner = TimeseriesQueryRunnerBonusTest.makeQueryRunner(factory, (Segment)new IncrementalIndexSegment(index, SegmentId.dummy((String)"ds")));
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("xxx").granularity(Granularities.ALL).intervals((List)ImmutableList.of((Object)Intervals.of((String)"2012-01-01T00:00:00Z/P1D"))).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("rows")}).descending(this.descending).build();
        return runner.run(QueryPlus.wrap((Query)query)).toList();
    }

    private static <T> QueryRunner<T> makeQueryRunner(QueryRunnerFactory<T, Query<T>> factory, Segment adapter) {
        return new FinalizeResultsQueryRunner(factory.createRunner(adapter), factory.getToolchest());
    }
}

