/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.timeseries;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.org.apache.druid.query.CacheStrategy;
import org.apache.hive.druid.org.apache.druid.query.DataSource;
import org.apache.hive.druid.org.apache.druid.query.Druids;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.org.apache.druid.query.Result;
import org.apache.hive.druid.org.apache.druid.query.TableDataSource;
import org.apache.hive.druid.org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.SerializablePairLongString;
import org.apache.hive.druid.org.apache.druid.query.aggregation.last.StringLastAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.post.ArithmeticPostAggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.post.ConstantPostAggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.hive.druid.org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.hive.druid.org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.hive.druid.org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.hive.druid.org.apache.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.hive.druid.org.apache.druid.query.timeseries.TimeseriesResultValue;
import org.apache.hive.druid.org.apache.druid.segment.TestHelper;
import org.apache.hive.druid.org.apache.druid.segment.VirtualColumns;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TimeseriesQueryQueryToolChestTest {
    private static final TimeseriesQueryQueryToolChest TOOL_CHEST = new TimeseriesQueryQueryToolChest(null);
    private final boolean descending;

    @Parameterized.Parameters(name="descending={0}")
    public static Iterable<Object[]> constructorFeeder() {
        return QueryRunnerTestHelper.transformToConstructionFeeder(Arrays.asList(false, true));
    }

    public TimeseriesQueryQueryToolChestTest(boolean descending) {
        this.descending = descending;
    }

    @Test
    public void testCacheStrategy() throws Exception {
        CacheStrategy strategy = TOOL_CHEST.getCacheStrategy(new TimeseriesQuery((DataSource)new TableDataSource("dummy"), (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2015-01-01/2015-01-02"))), this.descending, VirtualColumns.EMPTY, null, Granularities.ALL, (List)ImmutableList.of((Object)new CountAggregatorFactory("metric1"), (Object)new LongSumAggregatorFactory("metric0", "metric0"), (Object)new StringLastAggregatorFactory("complexMetric", "test", null)), (List)ImmutableList.of((Object)new ConstantPostAggregator("post", (Number)10)), 0, null));
        Result result1 = new Result(DateTimes.utc((long)123L), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric1", (Object)2, (Object)"metric0", (Object)3, (Object)"complexMetric", (Object)new SerializablePairLongString(Long.valueOf(123L), "val1"))));
        Object preparedValue = strategy.prepareForSegmentLevelCache().apply((Object)result1);
        ObjectMapper objectMapper = TestHelper.makeJsonMapper();
        Object fromCacheValue = objectMapper.readValue(objectMapper.writeValueAsBytes(preparedValue), strategy.getCacheObjectClazz());
        Result fromCacheResult = (Result)strategy.pullFromSegmentLevelCache().apply(fromCacheValue);
        Assert.assertEquals((Object)result1, (Object)fromCacheResult);
        Result result2 = new Result(DateTimes.utc((long)123L), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric1", (Object)2, (Object)"metric0", (Object)3, (Object)"complexMetric", (Object)"val1", (Object)"post", (Object)10)));
        Object preparedResultLevelCacheValue = strategy.prepareForCache(true).apply((Object)result2);
        Object fromResultLevelCacheValue = objectMapper.readValue(objectMapper.writeValueAsBytes(preparedResultLevelCacheValue), strategy.getCacheObjectClazz());
        Result fromResultLevelCacheRes = (Result)strategy.pullFromCache(true).apply(fromResultLevelCacheValue);
        Assert.assertEquals((Object)result2, (Object)fromResultLevelCacheRes);
        Result result3 = new Result(null, (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric1", (Object)2, (Object)"metric0", (Object)3, (Object)"complexMetric", (Object)"val1", (Object)"post", (Object)10)));
        preparedResultLevelCacheValue = strategy.prepareForCache(true).apply((Object)result3);
        fromResultLevelCacheValue = objectMapper.readValue(objectMapper.writeValueAsBytes(preparedResultLevelCacheValue), strategy.getCacheObjectClazz());
        fromResultLevelCacheRes = (Result)strategy.pullFromCache(true).apply(fromResultLevelCacheValue);
        Assert.assertEquals((Object)result3, (Object)fromResultLevelCacheRes);
    }

    @Test
    public void testCacheKey() {
        TimeseriesQuery query1 = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2015-01-01/2015-01-02").descending(this.descending).granularity(Granularities.ALL).aggregators((List)ImmutableList.of((Object)new CountAggregatorFactory("metric1"), (Object)new LongSumAggregatorFactory("metric0", "metric0"))).build();
        TimeseriesQuery query2 = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2015-01-01/2015-01-02").descending(this.descending).granularity(Granularities.ALL).aggregators((List)ImmutableList.of((Object)new LongSumAggregatorFactory("metric0", "metric0"), (Object)new CountAggregatorFactory("metric1"))).build();
        Assert.assertFalse((boolean)Arrays.equals(TOOL_CHEST.getCacheStrategy(query1).computeCacheKey((Query)query1), TOOL_CHEST.getCacheStrategy(query2).computeCacheKey((Query)query2)));
    }

    @Test
    public void testResultLevelCacheKey() {
        TimeseriesQuery query1 = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2015-01-01/2015-01-02").descending(this.descending).granularity(Granularities.ALL).aggregators((List)ImmutableList.of((Object)new LongSumAggregatorFactory("metric0", "metric0"), (Object)new CountAggregatorFactory("metric1"))).postAggregators((List)ImmutableList.of((Object)new ArithmeticPostAggregator("post", "+", (List)ImmutableList.of((Object)new FieldAccessPostAggregator(null, "metric1"), (Object)new FieldAccessPostAggregator(null, "metric0"))))).build();
        TimeseriesQuery query2 = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2015-01-01/2015-01-02").descending(this.descending).granularity(Granularities.ALL).aggregators((List)ImmutableList.of((Object)new LongSumAggregatorFactory("metric0", "metric0"), (Object)new CountAggregatorFactory("metric1"))).postAggregators((List)ImmutableList.of((Object)new ArithmeticPostAggregator("post", "/", (List)ImmutableList.of((Object)new FieldAccessPostAggregator(null, "metric1"), (Object)new FieldAccessPostAggregator(null, "metric0"))))).build();
        Assert.assertTrue((boolean)Arrays.equals(TOOL_CHEST.getCacheStrategy(query1).computeCacheKey((Query)query1), TOOL_CHEST.getCacheStrategy(query2).computeCacheKey((Query)query2)));
        Assert.assertFalse((boolean)Arrays.equals(TOOL_CHEST.getCacheStrategy(query1).computeResultLevelCacheKey((Query)query1), TOOL_CHEST.getCacheStrategy(query2).computeResultLevelCacheKey((Query)query2)));
    }

    @Test
    public void testResultLevelCacheKeyWithGrandTotal() {
        TimeseriesQuery query1 = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2015-01-01/2015-01-02").descending(this.descending).granularity(Granularities.ALL).aggregators((List)ImmutableList.of((Object)new LongSumAggregatorFactory("metric0", "metric0"), (Object)new CountAggregatorFactory("metric1"))).postAggregators((List)ImmutableList.of((Object)new ArithmeticPostAggregator("post", "+", (List)ImmutableList.of((Object)new FieldAccessPostAggregator(null, "metric1"), (Object)new FieldAccessPostAggregator(null, "metric0"))))).context((Map)ImmutableMap.of((Object)"grandTotal", (Object)true)).build();
        TimeseriesQuery query2 = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2015-01-01/2015-01-02").descending(this.descending).granularity(Granularities.ALL).aggregators((List)ImmutableList.of((Object)new LongSumAggregatorFactory("metric0", "metric0"), (Object)new CountAggregatorFactory("metric1"))).postAggregators((List)ImmutableList.of((Object)new ArithmeticPostAggregator("post", "/", (List)ImmutableList.of((Object)new FieldAccessPostAggregator(null, "metric1"), (Object)new FieldAccessPostAggregator(null, "metric0"))))).context((Map)ImmutableMap.of((Object)"grandTotal", (Object)true)).build();
        Assert.assertTrue((boolean)Arrays.equals(TOOL_CHEST.getCacheStrategy(query1).computeCacheKey((Query)query1), TOOL_CHEST.getCacheStrategy(query2).computeCacheKey((Query)query2)));
        Assert.assertFalse((boolean)Arrays.equals(TOOL_CHEST.getCacheStrategy(query1).computeResultLevelCacheKey((Query)query1), TOOL_CHEST.getCacheStrategy(query2).computeResultLevelCacheKey((Query)query2)));
    }
}

