/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.timeseries;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.org.apache.druid.query.DataSource;
import org.apache.hive.druid.org.apache.druid.query.Druids;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.QueryPlus;
import org.apache.hive.druid.org.apache.druid.query.QueryRunner;
import org.apache.hive.druid.org.apache.druid.query.QueryRunnerFactory;
import org.apache.hive.druid.org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.org.apache.druid.query.Result;
import org.apache.hive.druid.org.apache.druid.query.TableDataSource;
import org.apache.hive.druid.org.apache.druid.query.UnionDataSource;
import org.apache.hive.druid.org.apache.druid.query.UnionQueryRunner;
import org.apache.hive.druid.org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.context.ResponseContext;
import org.apache.hive.druid.org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.hive.druid.org.apache.druid.query.timeseries.TimeseriesQueryEngine;
import org.apache.hive.druid.org.apache.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.hive.druid.org.apache.druid.query.timeseries.TimeseriesQueryRunnerFactory;
import org.apache.hive.druid.org.apache.druid.query.timeseries.TimeseriesResultValue;
import org.apache.hive.druid.org.apache.druid.segment.TestHelper;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TimeSeriesUnionQueryRunnerTest {
    private final QueryRunner runner;
    private final boolean descending;

    public TimeSeriesUnionQueryRunnerTest(QueryRunner runner, boolean descending) {
        this.runner = runner;
        this.descending = descending;
    }

    @Parameterized.Parameters(name="{0}:descending={1}")
    public static Iterable<Object[]> constructorFeeder() {
        return QueryRunnerTestHelper.cartesian(QueryRunnerTestHelper.makeUnionQueryRunners((QueryRunnerFactory)new TimeseriesQueryRunnerFactory(new TimeseriesQueryQueryToolChest(QueryRunnerTestHelper.noopIntervalChunkingQueryRunnerDecorator()), new TimeseriesQueryEngine(), QueryRunnerTestHelper.NOOP_QUERYWATCHER)), Arrays.asList(false, true));
    }

    private <T> void assertExpectedResults(Iterable<Result<T>> expectedResults, Iterable<Result<T>> results) {
        if (this.descending) {
            expectedResults = TestHelper.revert(expectedResults);
        }
        TestHelper.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testUnionTimeseries() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource((DataSource)QueryRunnerTestHelper.UNION_DATA_SOURCE).granularity(QueryRunnerTestHelper.DAY_GRAN).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index"), QueryRunnerTestHelper.QUALITY_UNIQUES)).descending(this.descending).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)52L, (Object)"idx", (Object)26476L, (Object)"uniques", (Object)9.019833517963864))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)52L, (Object)"idx", (Object)23308L, (Object)"uniques", (Object)9.019833517963864))));
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testUnionResultMerging() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource((DataSource)new UnionDataSource((List)Lists.newArrayList((Object[])new TableDataSource[]{new TableDataSource("ds1"), new TableDataSource("ds2")}))).granularity(QueryRunnerTestHelper.DAY_GRAN).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index"))).descending(this.descending).build();
        TimeseriesQueryQueryToolChest toolChest = new TimeseriesQueryQueryToolChest(QueryRunnerTestHelper.noopIntervalChunkingQueryRunnerDecorator());
        final ArrayList ds1 = Lists.newArrayList((Object[])new Result[]{new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)1L, (Object)"idx", (Object)2L))), new Result(DateTimes.of((String)"2011-04-03"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)3L, (Object)"idx", (Object)4L)))});
        final ArrayList ds2 = Lists.newArrayList((Object[])new Result[]{new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)5L, (Object)"idx", (Object)6L))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)7L, (Object)"idx", (Object)8L))), new Result(DateTimes.of((String)"2011-04-04"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)9L, (Object)"idx", (Object)10L)))});
        QueryRunner mergingrunner = toolChest.mergeResults((QueryRunner)new UnionQueryRunner((QueryRunner)new QueryRunner<Result<TimeseriesResultValue>>(){

            public Sequence<Result<TimeseriesResultValue>> run(QueryPlus<Result<TimeseriesResultValue>> queryPlus, ResponseContext responseContext) {
                if (queryPlus.getQuery().getDataSource().equals(new TableDataSource("ds1"))) {
                    return Sequences.simple((Iterable)(TimeSeriesUnionQueryRunnerTest.this.descending ? Lists.reverse((List)ds1) : ds1));
                }
                return Sequences.simple((Iterable)(TimeSeriesUnionQueryRunnerTest.this.descending ? Lists.reverse((List)ds2) : ds2));
            }
        }));
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)5L, (Object)"idx", (Object)6L))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)8L, (Object)"idx", (Object)10L))), new Result(DateTimes.of((String)"2011-04-03"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)3L, (Object)"idx", (Object)4L))), new Result(DateTimes.of((String)"2011-04-04"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)9L, (Object)"idx", (Object)10L))));
        List results = mergingrunner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }
}

