/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.spec;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Accumulator;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Yielder;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.YieldingAccumulator;
import org.apache.hive.druid.org.apache.druid.query.Druids;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.QueryPlus;
import org.apache.hive.druid.org.apache.druid.query.QueryRunner;
import org.apache.hive.druid.org.apache.druid.query.Result;
import org.apache.hive.druid.org.apache.druid.query.SegmentDescriptor;
import org.apache.hive.druid.org.apache.druid.query.aggregation.CountAggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.context.ResponseContext;
import org.apache.hive.druid.org.apache.druid.query.spec.SpecificSegmentQueryRunner;
import org.apache.hive.druid.org.apache.druid.query.spec.SpecificSegmentSpec;
import org.apache.hive.druid.org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.hive.druid.org.apache.druid.query.timeseries.TimeseriesResultBuilder;
import org.apache.hive.druid.org.apache.druid.query.timeseries.TimeseriesResultValue;
import org.apache.hive.druid.org.apache.druid.segment.SegmentMissingException;
import org.junit.Assert;
import org.junit.Test;

public class SpecificSegmentQueryRunnerTest {
    @Test
    public void testRetry() throws Exception {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        SegmentDescriptor descriptor = new SegmentDescriptor(Intervals.of((String)"2012-01-01T00:00:00Z/P1D"), "version", 0);
        SpecificSegmentQueryRunner queryRunner = new SpecificSegmentQueryRunner(new QueryRunner(){

            public Sequence run(QueryPlus queryPlus, ResponseContext responseContext) {
                return new Sequence(){

                    public Object accumulate(Object initValue, Accumulator accumulator) {
                        throw new SegmentMissingException("FAILSAUCE", new Object[0]);
                    }

                    public Yielder<Object> toYielder(Object initValue, YieldingAccumulator accumulator) {
                        throw new SegmentMissingException("FAILSAUCE", new Object[0]);
                    }
                };
            }
        }, new SpecificSegmentSpec(descriptor));
        ResponseContext responseContext = ResponseContext.createEmpty();
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("foo").granularity(Granularities.ALL).intervals((List)ImmutableList.of((Object)Intervals.of((String)"2012-01-01T00:00:00Z/P1D"))).aggregators((List)ImmutableList.of((Object)new CountAggregatorFactory("rows"))).build();
        Sequence results = queryRunner.run(QueryPlus.wrap((Query)query), responseContext);
        results.toList();
        this.validate((ObjectMapper)mapper, descriptor, responseContext);
        responseContext = ResponseContext.createEmpty();
        results = queryRunner.run(QueryPlus.wrap((Query)query), responseContext);
        results.toYielder(null, new YieldingAccumulator(){
            final List lists = new ArrayList();

            public Object accumulate(Object accumulated, Object in) {
                this.lists.add(in);
                return in;
            }
        });
        this.validate((ObjectMapper)mapper, descriptor, responseContext);
    }

    @Test
    public void testRetry2() throws Exception {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        SegmentDescriptor descriptor = new SegmentDescriptor(Intervals.of((String)"2012-01-01T00:00:00Z/P1D"), "version", 0);
        TimeseriesResultBuilder builder = new TimeseriesResultBuilder(DateTimes.of((String)"2012-01-01T00:00:00Z"));
        CountAggregator rows = new CountAggregator();
        rows.aggregate();
        builder.addMetric("rows", rows.get());
        final Result value = builder.build();
        SpecificSegmentQueryRunner queryRunner = new SpecificSegmentQueryRunner(new QueryRunner(){

            public Sequence run(QueryPlus queryPlus, ResponseContext responseContext) {
                return Sequences.withEffect((Sequence)Sequences.simple(Collections.singletonList(value)), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        throw new SegmentMissingException("FAILSAUCE", new Object[0]);
                    }
                }, (Executor)Execs.directExecutor());
            }
        }, new SpecificSegmentSpec(descriptor));
        ResponseContext responseContext = ResponseContext.createEmpty();
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("foo").granularity(Granularities.ALL).intervals((List)ImmutableList.of((Object)Intervals.of((String)"2012-01-01T00:00:00Z/P1D"))).aggregators((List)ImmutableList.of((Object)new CountAggregatorFactory("rows"))).build();
        Sequence results = queryRunner.run(QueryPlus.wrap((Query)query), responseContext);
        List res = results.toList();
        Assert.assertEquals((long)1L, (long)res.size());
        Result theVal = (Result)res.get(0);
        Assert.assertTrue((1L == ((TimeseriesResultValue)theVal.getValue()).getLongMetric("rows") ? 1 : 0) != 0);
        this.validate((ObjectMapper)mapper, descriptor, responseContext);
    }

    private void validate(ObjectMapper mapper, SegmentDescriptor descriptor, ResponseContext responseContext) throws IOException {
        Object missingSegments = responseContext.get((ResponseContext.BaseKey)ResponseContext.Key.MISSING_SEGMENTS);
        Assert.assertTrue((missingSegments != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(missingSegments instanceof List));
        Object segmentDesc = ((List)missingSegments).get(0);
        Assert.assertTrue((boolean)(segmentDesc instanceof SegmentDescriptor));
        SegmentDescriptor newDesc = (SegmentDescriptor)mapper.readValue(mapper.writeValueAsString(segmentDesc), SegmentDescriptor.class);
        Assert.assertEquals((Object)descriptor, (Object)newDesc);
    }
}

