/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.select;

import org.apache.hive.druid.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.query.select.SelectQuery;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class SelectQueryTest {
    private static final String SOME_QUERY_THAT_IS_DOOMED_TO_FAIL = "{\n   \"queryType\": \"select\",\n   \"dataSource\": \"wikipedia\",\n   \"descending\": \"false\",\n   \"dimensions\":[],\n   \"metrics\":[],\n   \"granularity\": \"all\",\n   \"intervals\": [\n     \"2013-01-01/2013-01-02\"\n   ],\n   \"pagingSpec\":{\"pagingIdentifiers\": {}, \"threshold\":5}\n }";
    private final ObjectMapper objectMapper = new DefaultObjectMapper();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testSerde() throws Exception {
        String exceptionMessage = StringUtils.format((String)"Cannot construct instance of `org.apache.druid.query.select.SelectQuery`, problem: %s", (Object[])new Object[]{"The 'select' query has been removed, use 'scan' instead. See https://druid.apache.org/docs/latest/querying/select-query.html for more details."});
        this.expectedException.expect(JsonMappingException.class);
        this.expectedException.expectMessage(exceptionMessage);
        this.objectMapper.readValue(SOME_QUERY_THAT_IS_DOOMED_TO_FAIL, SelectQuery.class);
    }
}

