/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.search;

import java.io.IOException;
import org.apache.hive.druid.org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.org.apache.druid.query.ordering.StringComparators;
import org.apache.hive.druid.org.apache.druid.query.search.SearchHit;
import org.apache.hive.druid.org.apache.druid.query.search.SearchSortSpec;
import org.junit.Assert;
import org.junit.Test;

public class SearchSortSpecTest {
    @Test
    public void testLexicographicComparator() {
        SearchHit hit1 = new SearchHit("test", "apple");
        SearchHit hit2 = new SearchHit("test", "banana");
        SearchHit hit3 = new SearchHit("test", "banana");
        SearchSortSpec spec = new SearchSortSpec(StringComparators.LEXICOGRAPHIC);
        Assert.assertTrue((spec.getComparator().compare(hit2, hit3) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((spec.getComparator().compare(hit2, hit1) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((spec.getComparator().compare(hit1, hit3) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAlphanumericComparator() {
        SearchSortSpec spec = new SearchSortSpec(StringComparators.ALPHANUMERIC);
        SearchHit hit1 = new SearchHit("test", "a100");
        SearchHit hit2 = new SearchHit("test", "a9");
        SearchHit hit3 = new SearchHit("test", "b0");
        Assert.assertTrue((spec.getComparator().compare(hit1, hit2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((spec.getComparator().compare(hit3, hit1) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((spec.getComparator().compare(hit3, hit2) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNumericComparator() {
        SearchSortSpec spec = new SearchSortSpec(StringComparators.NUMERIC);
        SearchHit hit1 = new SearchHit("test", "1001001.12412");
        SearchHit hit2 = new SearchHit("test", "-1421");
        SearchHit hit3 = new SearchHit("test", "not-numeric-at-all");
        SearchHit hit4 = new SearchHit("best", "1001001.12412");
        Assert.assertTrue((spec.getComparator().compare(hit1, hit2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((spec.getComparator().compare(hit3, hit1) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((spec.getComparator().compare(hit3, hit2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((spec.getComparator().compare(hit1, hit4) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testStrlenComparator() {
        SearchSortSpec spec = new SearchSortSpec(StringComparators.LEXICOGRAPHIC);
        SearchHit hit1 = new SearchHit("test", "apple");
        SearchHit hit2 = new SearchHit("test", "banana");
        SearchHit hit3 = new SearchHit("test", "orange");
        Assert.assertTrue((spec.getComparator().compare(hit1, hit2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((spec.getComparator().compare(hit3, hit1) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((spec.getComparator().compare(hit3, hit2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((spec.getComparator().compare(hit1, hit1) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSerde() throws IOException {
        DefaultObjectMapper jsonMapper = new DefaultObjectMapper();
        SearchSortSpec spec = new SearchSortSpec(StringComparators.ALPHANUMERIC);
        String expectJsonSpec = "{\"type\":{\"type\":\"alphanumeric\"}}";
        String jsonSpec = jsonMapper.writeValueAsString((Object)spec);
        Assert.assertEquals((Object)expectJsonSpec, (Object)jsonSpec);
        Assert.assertEquals((Object)spec, (Object)jsonMapper.readValue(jsonSpec, SearchSortSpec.class));
        String expectJsonSpec2 = "{\"type\":\"alphanumeric\"}";
        Assert.assertEquals((Object)spec, (Object)jsonMapper.readValue(expectJsonSpec2, SearchSortSpec.class));
    }
}

