/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.search;

import java.io.IOException;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.org.apache.druid.query.Druids;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.dimension.LegacyDimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.search.SearchQuery;
import org.junit.Assert;
import org.junit.Test;

public class SearchQueryTest {
    private static final ObjectMapper JSON_MAPPER = new DefaultObjectMapper();

    @Test
    public void testQuerySerialization() throws IOException {
        SearchQuery query = Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).query("a").build();
        String json = JSON_MAPPER.writeValueAsString((Object)query);
        Query serdeQuery = (Query)JSON_MAPPER.readValue(json, Query.class);
        Assert.assertEquals((Object)query, (Object)serdeQuery);
    }

    @Test
    public void testEquals() {
        SearchQuery query1 = Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).dimensions((DimensionSpec)new DefaultDimensionSpec("quality", "quality")).query("a").build();
        SearchQuery query2 = Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).dimensions((DimensionSpec)new DefaultDimensionSpec("quality", "quality")).query("a").build();
        Assert.assertEquals((Object)query1, (Object)query2);
    }

    @Test
    public void testSerDe() throws IOException {
        SearchQuery query = Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).dimensions((DimensionSpec)new LegacyDimensionSpec((Object)"quality")).query("a").build();
        String json = "{\"queryType\":\"search\",\"dataSource\":{\"type\":\"table\",\"name\":\"testing\"},\"filter\":null,\"granularity\":{\"type\":\"all\"},\"limit\":1000,\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"1970-01-01T00:00:00.000Z/2020-01-01T00:00:00.000Z\"]},\"searchDimensions\":[\"quality\"],\"query\":{\"type\":\"insensitive_contains\",\"value\":\"a\"},\"sort\":{\"type\":\"lexicographic\"},\"context\":null}";
        Query serdeQuery = (Query)JSON_MAPPER.readValue("{\"queryType\":\"search\",\"dataSource\":{\"type\":\"table\",\"name\":\"testing\"},\"filter\":null,\"granularity\":{\"type\":\"all\"},\"limit\":1000,\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"1970-01-01T00:00:00.000Z/2020-01-01T00:00:00.000Z\"]},\"searchDimensions\":[\"quality\"],\"query\":{\"type\":\"insensitive_contains\",\"value\":\"a\"},\"sort\":{\"type\":\"lexicographic\"},\"context\":null}", Query.class);
        Assert.assertEquals((Object)query.toString(), (Object)serdeQuery.toString());
        Assert.assertEquals((Object)query, (Object)serdeQuery);
        String json2 = "{\"queryType\":\"search\",\"dataSource\":{\"type\":\"table\",\"name\":\"testing\"},\"filter\":null,\"granularity\":{\"type\":\"all\"},\"limit\":1000,\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"1970-01-01T00:00:00.000Z/2020-01-01T00:00:00.000Z\"]},\"searchDimensions\":[\"quality\"],\"query\":{\"type\":\"insensitive_contains\",\"value\":\"a\"},\"sort\":{\"type\":\"lexicographic\"},\"context\":null}";
        Query serdeQuery2 = (Query)JSON_MAPPER.readValue("{\"queryType\":\"search\",\"dataSource\":{\"type\":\"table\",\"name\":\"testing\"},\"filter\":null,\"granularity\":{\"type\":\"all\"},\"limit\":1000,\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"1970-01-01T00:00:00.000Z/2020-01-01T00:00:00.000Z\"]},\"searchDimensions\":[\"quality\"],\"query\":{\"type\":\"insensitive_contains\",\"value\":\"a\"},\"sort\":{\"type\":\"lexicographic\"},\"context\":null}", Query.class);
        Assert.assertEquals((Object)query.toString(), (Object)serdeQuery2.toString());
        Assert.assertEquals((Object)query, (Object)serdeQuery2);
    }
}

