/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.base.Suppliers;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.common.config.NullHandling;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.data.input.MapBasedInputRow;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.org.apache.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.org.apache.druid.js.JavaScriptConfig;
import org.apache.hive.druid.org.apache.druid.query.Druids;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.QueryPlus;
import org.apache.hive.druid.org.apache.druid.query.QueryRunner;
import org.apache.hive.druid.org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.org.apache.druid.query.Result;
import org.apache.hive.druid.org.apache.druid.query.context.ResponseContext;
import org.apache.hive.druid.org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.dimension.ExtractionDimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.extraction.JavaScriptExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.extraction.MapLookupExtractor;
import org.apache.hive.druid.org.apache.druid.query.extraction.TimeFormatExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.filter.AndDimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.DimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.ExtractionDimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.OrDimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.hive.druid.org.apache.druid.query.lookup.LookupExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.lookup.LookupExtractor;
import org.apache.hive.druid.org.apache.druid.query.ordering.StringComparators;
import org.apache.hive.druid.org.apache.druid.query.search.FragmentSearchQuerySpec;
import org.apache.hive.druid.org.apache.druid.query.search.SearchHit;
import org.apache.hive.druid.org.apache.druid.query.search.SearchQuery;
import org.apache.hive.druid.org.apache.druid.query.search.SearchQueryConfig;
import org.apache.hive.druid.org.apache.druid.query.search.SearchQueryQueryToolChest;
import org.apache.hive.druid.org.apache.druid.query.search.SearchQueryRunnerFactory;
import org.apache.hive.druid.org.apache.druid.query.search.SearchQuerySpec;
import org.apache.hive.druid.org.apache.druid.query.search.SearchResultValue;
import org.apache.hive.druid.org.apache.druid.query.search.SearchSortSpec;
import org.apache.hive.druid.org.apache.druid.query.search.SearchStrategySelector;
import org.apache.hive.druid.org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.hive.druid.org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.hive.druid.org.apache.druid.segment.QueryableIndexSegment;
import org.apache.hive.druid.org.apache.druid.segment.Segment;
import org.apache.hive.druid.org.apache.druid.segment.TestHelper;
import org.apache.hive.druid.org.apache.druid.segment.TestIndex;
import org.apache.hive.druid.org.apache.druid.segment.column.ValueType;
import org.apache.hive.druid.org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.hive.druid.org.apache.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.hive.druid.org.apache.druid.testing.InitializedNullHandlingTest;
import org.apache.hive.druid.org.apache.druid.timeline.SegmentId;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SearchQueryRunnerTest
extends InitializedNullHandlingTest {
    private static final Logger LOG = new Logger(SearchQueryRunnerTest.class);
    private static final SearchQueryConfig CONFIG = new SearchQueryConfig();
    private static final SearchQueryQueryToolChest TOOL_CHEST = new SearchQueryQueryToolChest(CONFIG, QueryRunnerTestHelper.noopIntervalChunkingQueryRunnerDecorator());
    private static final SearchStrategySelector SELECTOR = new SearchStrategySelector(Suppliers.ofInstance((Object)CONFIG));
    private final QueryRunner runner;
    private final QueryRunner decoratedRunner;

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> constructorFeeder() {
        return QueryRunnerTestHelper.transformToConstructionFeeder(QueryRunnerTestHelper.makeQueryRunners(new SearchQueryRunnerFactory(SELECTOR, TOOL_CHEST, QueryRunnerTestHelper.NOOP_QUERYWATCHER)));
    }

    public SearchQueryRunnerTest(QueryRunner runner) {
        this.runner = runner;
        this.decoratedRunner = TOOL_CHEST.postMergeQueryDecoration(TOOL_CHEST.mergeResults(TOOL_CHEST.preMergeQueryDecoration(runner)));
    }

    @Test
    public void testSearchHitSerDe() throws Exception {
        for (SearchHit hit : Arrays.asList(new SearchHit("dim1", "val1"), new SearchHit("dim2", "val2", Integer.valueOf(3)))) {
            SearchHit read = (SearchHit)TestHelper.makeJsonMapper().readValue(TestHelper.makeJsonMapper().writeValueAsString((Object)hit), SearchHit.class);
            Assert.assertEquals((Object)hit, (Object)read);
            if (hit.getCount() == null) {
                Assert.assertNull((Object)read.getCount());
                continue;
            }
            Assert.assertEquals((Object)hit.getCount(), (Object)read.getCount());
        }
    }

    @Test
    public void testSearch() {
        SearchQuery searchQuery = Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).query("a").build();
        ArrayList<SearchHit> expectedHits = new ArrayList<SearchHit>();
        expectedHits.add(new SearchHit("quality", "automotive", Integer.valueOf(93)));
        expectedHits.add(new SearchHit("quality", "mezzanine", Integer.valueOf(279)));
        expectedHits.add(new SearchHit("quality", "travel", Integer.valueOf(93)));
        expectedHits.add(new SearchHit("quality", "health", Integer.valueOf(93)));
        expectedHits.add(new SearchHit("quality", "entertainment", Integer.valueOf(93)));
        expectedHits.add(new SearchHit("market", "total_market", Integer.valueOf(186)));
        expectedHits.add(new SearchHit("placementish", "a", Integer.valueOf(93)));
        expectedHits.add(new SearchHit("partial_null_column", "value", Integer.valueOf(186)));
        this.checkSearchQuery((Query)searchQuery, expectedHits);
    }

    @Test
    public void testSearchWithCardinality() {
        SearchQuery searchQuery = Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).query("a").build();
        QueryRunner mergedRunner = TOOL_CHEST.mergeResults((QueryRunner)new QueryRunner<Result<SearchResultValue>>(){

            public Sequence<Result<SearchResultValue>> run(QueryPlus<Result<SearchResultValue>> queryPlus, ResponseContext responseContext) {
                QueryPlus queryPlus1 = queryPlus.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.of((String)"2011-01-12/2011-02-28"))));
                QueryPlus queryPlus2 = queryPlus.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.of((String)"2011-03-01/2011-04-15"))));
                return Sequences.concat((Sequence[])new Sequence[]{SearchQueryRunnerTest.this.runner.run(queryPlus1, responseContext), SearchQueryRunnerTest.this.runner.run(queryPlus2, responseContext)});
            }
        });
        ArrayList<SearchHit> expectedHits = new ArrayList<SearchHit>();
        expectedHits.add(new SearchHit("quality", "automotive", Integer.valueOf(91)));
        expectedHits.add(new SearchHit("quality", "mezzanine", Integer.valueOf(273)));
        expectedHits.add(new SearchHit("quality", "travel", Integer.valueOf(91)));
        expectedHits.add(new SearchHit("quality", "health", Integer.valueOf(91)));
        expectedHits.add(new SearchHit("quality", "entertainment", Integer.valueOf(91)));
        expectedHits.add(new SearchHit("market", "total_market", Integer.valueOf(182)));
        expectedHits.add(new SearchHit("placementish", "a", Integer.valueOf(91)));
        expectedHits.add(new SearchHit("partial_null_column", "value", Integer.valueOf(182)));
        this.checkSearchQuery((Query)searchQuery, mergedRunner, expectedHits);
    }

    @Test
    public void testSearchSameValueInMultiDims() {
        SearchQuery searchQuery = Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).dimensions(Arrays.asList("placement", "placementish")).query("e").build();
        ArrayList<SearchHit> expectedHits = new ArrayList<SearchHit>();
        expectedHits.add(new SearchHit("placement", "preferred", Integer.valueOf(1209)));
        expectedHits.add(new SearchHit("placementish", "e", Integer.valueOf(93)));
        expectedHits.add(new SearchHit("placementish", "preferred", Integer.valueOf(1209)));
        this.checkSearchQuery((Query)searchQuery, expectedHits);
    }

    @Test
    public void testSearchSameValueInMultiDims2() {
        SearchQuery searchQuery = Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).dimensions(Arrays.asList("placement", "placementish")).sortSpec(new SearchSortSpec(StringComparators.STRLEN)).query("e").build();
        ArrayList<SearchHit> expectedHits = new ArrayList<SearchHit>();
        expectedHits.add(new SearchHit("placementish", "e", Integer.valueOf(93)));
        expectedHits.add(new SearchHit("placement", "preferred", Integer.valueOf(1209)));
        expectedHits.add(new SearchHit("placementish", "preferred", Integer.valueOf(1209)));
        this.checkSearchQuery((Query)searchQuery, expectedHits);
    }

    @Test
    public void testFragmentSearch() {
        SearchQuery searchQuery = Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).query((SearchQuerySpec)new FragmentSearchQuerySpec(Arrays.asList("auto", "ve"))).build();
        ArrayList<SearchHit> expectedHits = new ArrayList<SearchHit>();
        expectedHits.add(new SearchHit("quality", "automotive", Integer.valueOf(93)));
        this.checkSearchQuery((Query)searchQuery, expectedHits);
    }

    @Test
    public void testSearchWithDimensionQuality() {
        ArrayList<SearchHit> expectedHits = new ArrayList<SearchHit>();
        expectedHits.add(new SearchHit("quality", "automotive", Integer.valueOf(93)));
        expectedHits.add(new SearchHit("quality", "mezzanine", Integer.valueOf(279)));
        expectedHits.add(new SearchHit("quality", "travel", Integer.valueOf(93)));
        expectedHits.add(new SearchHit("quality", "health", Integer.valueOf(93)));
        expectedHits.add(new SearchHit("quality", "entertainment", Integer.valueOf(93)));
        this.checkSearchQuery((Query)Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimensions("quality").intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).query("a").build(), expectedHits);
    }

    @Test
    public void testSearchWithDimensionProvider() {
        ArrayList<SearchHit> expectedHits = new ArrayList<SearchHit>();
        expectedHits.add(new SearchHit("market", "total_market", Integer.valueOf(186)));
        this.checkSearchQuery((Query)Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimensions("market").intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).query("a").build(), expectedHits);
    }

    @Test
    public void testSearchWithDimensionsQualityAndProvider() {
        ArrayList<SearchHit> expectedHits = new ArrayList<SearchHit>();
        expectedHits.add(new SearchHit("quality", "automotive", Integer.valueOf(93)));
        expectedHits.add(new SearchHit("quality", "mezzanine", Integer.valueOf(279)));
        expectedHits.add(new SearchHit("quality", "travel", Integer.valueOf(93)));
        expectedHits.add(new SearchHit("quality", "health", Integer.valueOf(93)));
        expectedHits.add(new SearchHit("quality", "entertainment", Integer.valueOf(93)));
        expectedHits.add(new SearchHit("market", "total_market", Integer.valueOf(186)));
        this.checkSearchQuery((Query)Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimensions(Arrays.asList("quality", "market")).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).query("a").build(), expectedHits);
    }

    @Test
    public void testSearchWithDimensionsPlacementAndProvider() {
        ArrayList<SearchHit> expectedHits = new ArrayList<SearchHit>();
        expectedHits.add(new SearchHit("market", "total_market", Integer.valueOf(186)));
        this.checkSearchQuery((Query)Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimensions(Arrays.asList("placementish", "market")).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).query("mark").build(), expectedHits);
    }

    @Test
    public void testSearchWithExtractionFilter1() {
        String automotiveSnowman = "automotive\u2603";
        ArrayList<SearchHit> expectedHits = new ArrayList<SearchHit>();
        expectedHits.add(new SearchHit("quality", "automotive\u2603", Integer.valueOf(93)));
        LookupExtractionFn lookupExtractionFn = new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)ImmutableMap.of((Object)"automotive", (Object)"automotive\u2603"), false), true, null, Boolean.valueOf(true), Boolean.valueOf(true));
        SearchQuery query = Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).filters((DimFilter)new ExtractionDimFilter("quality", "automotive\u2603", (ExtractionFn)lookupExtractionFn, null)).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).dimensions((DimensionSpec)new ExtractionDimensionSpec("quality", null, (ExtractionFn)lookupExtractionFn)).query("\u2603").build();
        this.checkSearchQuery((Query)query, expectedHits);
    }

    @Test
    public void testSearchWithSingleFilter1() {
        ArrayList<SearchHit> expectedHits = new ArrayList<SearchHit>();
        expectedHits.add(new SearchHit("quality", "mezzanine", Integer.valueOf(93)));
        this.checkSearchQuery((Query)Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).filters((DimFilter)new AndDimFilter(Arrays.asList(new SelectorDimFilter("market", "total_market", null), new SelectorDimFilter("quality", "mezzanine", null)))).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).dimensions("quality").query("a").build(), expectedHits);
    }

    @Test
    public void testSearchWithSingleFilter2() {
        ArrayList<SearchHit> expectedHits = new ArrayList<SearchHit>();
        expectedHits.add(new SearchHit("market", "total_market", Integer.valueOf(186)));
        this.checkSearchQuery((Query)Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).filters("market", "total_market").intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).dimensions("market").query("a").build(), expectedHits);
    }

    @Test
    public void testSearchMultiAndFilter() {
        ArrayList<SearchHit> expectedHits = new ArrayList<SearchHit>();
        expectedHits.add(new SearchHit("quality", "automotive", Integer.valueOf(93)));
        AndDimFilter filter = new AndDimFilter(new DimFilter[]{new SelectorDimFilter("market", "spot", null), new SelectorDimFilter("quality", "automotive", null)});
        this.checkSearchQuery((Query)Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).filters((DimFilter)filter).dimensions("quality").intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).query("a").build(), expectedHits);
    }

    @Test
    public void testSearchWithMultiOrFilter() {
        ArrayList<SearchHit> expectedHits = new ArrayList<SearchHit>();
        expectedHits.add(new SearchHit("quality", "automotive", Integer.valueOf(93)));
        OrDimFilter filter = new OrDimFilter(new DimFilter[]{new SelectorDimFilter("quality", "total_market", null), new SelectorDimFilter("quality", "automotive", null)});
        this.checkSearchQuery((Query)Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimensions("quality").filters((DimFilter)filter).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).query("a").build(), expectedHits);
    }

    @Test
    public void testSearchWithEmptyResults() {
        ArrayList<SearchHit> expectedHits = new ArrayList<SearchHit>();
        this.checkSearchQuery((Query)Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).query("abcd123").build(), expectedHits);
    }

    @Test
    public void testSearchWithFilterEmptyResults() {
        ArrayList<SearchHit> expectedHits = new ArrayList<SearchHit>();
        AndDimFilter filter = new AndDimFilter(new DimFilter[]{new SelectorDimFilter("market", "total_market", null), new SelectorDimFilter("quality", "automotive", null)});
        this.checkSearchQuery((Query)Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).filters((DimFilter)filter).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).query("a").build(), expectedHits);
    }

    @Test
    public void testSearchNonExistingDimension() {
        ArrayList<SearchHit> expectedHits = new ArrayList<SearchHit>();
        this.checkSearchQuery((Query)Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).dimensions("does_not_exist").query("a").build(), expectedHits);
    }

    @Test
    public void testSearchAll() {
        ArrayList<SearchHit> expectedHits = new ArrayList<SearchHit>();
        expectedHits.add(new SearchHit("market", "spot", Integer.valueOf(837)));
        expectedHits.add(new SearchHit("market", "total_market", Integer.valueOf(186)));
        expectedHits.add(new SearchHit("market", "upfront", Integer.valueOf(186)));
        this.checkSearchQuery((Query)Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).dimensions("market").query("").build(), expectedHits);
        this.checkSearchQuery((Query)Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).dimensions("market").build(), expectedHits);
    }

    @Test
    public void testSearchWithNumericSort() {
        SearchQuery searchQuery = Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).query("a").sortSpec(new SearchSortSpec(StringComparators.NUMERIC)).build();
        ArrayList<SearchHit> expectedHits = new ArrayList<SearchHit>();
        expectedHits.add(new SearchHit("placementish", "a", Integer.valueOf(93)));
        expectedHits.add(new SearchHit("quality", "automotive", Integer.valueOf(93)));
        expectedHits.add(new SearchHit("quality", "entertainment", Integer.valueOf(93)));
        expectedHits.add(new SearchHit("quality", "health", Integer.valueOf(93)));
        expectedHits.add(new SearchHit("quality", "mezzanine", Integer.valueOf(279)));
        expectedHits.add(new SearchHit("market", "total_market", Integer.valueOf(186)));
        expectedHits.add(new SearchHit("quality", "travel", Integer.valueOf(93)));
        expectedHits.add(new SearchHit("partial_null_column", "value", Integer.valueOf(186)));
        this.checkSearchQuery((Query)searchQuery, expectedHits);
    }

    @Test
    public void testSearchOnTime() {
        SearchQuery searchQuery = Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).query("Friday").dimensions((DimensionSpec)new ExtractionDimensionSpec("__time", "__time2", (ExtractionFn)new TimeFormatExtractionFn("EEEE", null, null, null, false))).build();
        ArrayList<SearchHit> expectedHits = new ArrayList<SearchHit>();
        expectedHits.add(new SearchHit("__time2", "Friday", Integer.valueOf(169)));
        this.checkSearchQuery((Query)searchQuery, expectedHits);
    }

    @Test
    public void testSearchOnLongColumn() {
        SearchQuery searchQuery = Druids.newSearchQueryBuilder().dimensions((DimensionSpec)new DefaultDimensionSpec("__time", "__time", ValueType.LONG)).dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).query("1297123200000").build();
        ArrayList<SearchHit> expectedHits = new ArrayList<SearchHit>();
        expectedHits.add(new SearchHit("__time", "1297123200000", Integer.valueOf(13)));
        this.checkSearchQuery((Query)searchQuery, expectedHits);
    }

    @Test
    public void testSearchOnLongColumnWithExFn() {
        String jsFn = "function(str) { return 'super-' + str; }";
        JavaScriptExtractionFn jsExtractionFn = new JavaScriptExtractionFn(jsFn, false, JavaScriptConfig.getEnabledInstance());
        SearchQuery searchQuery = Druids.newSearchQueryBuilder().dimensions((DimensionSpec)new ExtractionDimensionSpec("__time", "__time", (ExtractionFn)jsExtractionFn)).dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).query("1297123200000").build();
        ArrayList<SearchHit> expectedHits = new ArrayList<SearchHit>();
        expectedHits.add(new SearchHit("__time", "super-1297123200000", Integer.valueOf(13)));
        this.checkSearchQuery((Query)searchQuery, expectedHits);
    }

    @Test
    public void testSearchOnFloatColumn() {
        SearchQuery searchQuery = Druids.newSearchQueryBuilder().dimensions((DimensionSpec)new DefaultDimensionSpec("index", "index", ValueType.DOUBLE)).dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).query("100.7").build();
        ArrayList<SearchHit> expectedHits = new ArrayList<SearchHit>();
        expectedHits.add(new SearchHit("index", "100.706057", Integer.valueOf(1)));
        expectedHits.add(new SearchHit("index", "100.775597", Integer.valueOf(1)));
        this.checkSearchQuery((Query)searchQuery, expectedHits);
    }

    @Test
    public void testSearchOnFloatColumnWithExFn() {
        String jsFn = "function(str) { return 'super-' + str; }";
        JavaScriptExtractionFn jsExtractionFn = new JavaScriptExtractionFn(jsFn, false, JavaScriptConfig.getEnabledInstance());
        SearchQuery searchQuery = Druids.newSearchQueryBuilder().dimensions((DimensionSpec)new ExtractionDimensionSpec("index", "index", (ExtractionFn)jsExtractionFn)).dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).query("100.7").build();
        ArrayList<SearchHit> expectedHits = new ArrayList<SearchHit>();
        expectedHits.add(new SearchHit("index", "super-100.706057", Integer.valueOf(1)));
        expectedHits.add(new SearchHit("index", "super-100.775597", Integer.valueOf(1)));
        this.checkSearchQuery((Query)searchQuery, expectedHits);
    }

    @Test
    public void testSearchWithNullValueInDimension() throws Exception {
        OnheapIncrementalIndex index = new IncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withMinTimestamp(DateTimes.of((String)"2011-01-12T00:00:00.000Z").getMillis()).build()).setMaxRowCount(10).buildOnheap();
        index.add((InputRow)new MapBasedInputRow(1481871600000L, Arrays.asList("name", "host"), (Map)ImmutableMap.of((Object)"name", (Object)"name1", (Object)"host", (Object)"host")));
        index.add((InputRow)new MapBasedInputRow(1481871670000L, Arrays.asList("name", "table"), (Map)ImmutableMap.of((Object)"name", (Object)"name2", (Object)"table", (Object)"table")));
        SearchQuery searchQuery = Druids.newSearchQueryBuilder().dimensions((DimensionSpec)new DefaultDimensionSpec("table", "table")).dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).context((Map)ImmutableMap.of((Object)"searchStrategy", (Object)"cursorOnly")).build();
        SearchQueryRunnerFactory factory = new SearchQueryRunnerFactory(SELECTOR, TOOL_CHEST, QueryRunnerTestHelper.NOOP_QUERYWATCHER);
        QueryRunner runner = factory.createRunner((Segment)new QueryableIndexSegment(TestIndex.persistRealtimeAndLoadMMapped((IncrementalIndex)index), SegmentId.dummy((String)"asdf")));
        ArrayList<SearchHit> expectedHits = new ArrayList<SearchHit>();
        expectedHits.add(new SearchHit("table", "table", Integer.valueOf(1)));
        expectedHits.add(new SearchHit("table", NullHandling.defaultStringValue(), Integer.valueOf(1)));
        this.checkSearchQuery((Query)searchQuery, runner, expectedHits);
    }

    @Test
    public void testSearchWithNotExistedDimension() {
        SearchQuery searchQuery = Druids.newSearchQueryBuilder().dimensions((DimensionSpec)new DefaultDimensionSpec("asdf", "asdf")).dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).build();
        ArrayList<SearchHit> noHit = new ArrayList<SearchHit>();
        this.checkSearchQuery((Query)searchQuery, noHit);
    }

    private void checkSearchQuery(Query searchQuery, List<SearchHit> expectedResults) {
        this.checkSearchQuery(searchQuery, this.runner, expectedResults);
        this.checkSearchQuery(searchQuery, this.decoratedRunner, expectedResults);
    }

    private void checkSearchQuery(Query searchQuery, QueryRunner runner, List<SearchHit> expectedResults) {
        List results = runner.run(QueryPlus.wrap((Query)searchQuery)).toList();
        ArrayList<SearchHit> copy = new ArrayList<SearchHit>(expectedResults);
        for (Result result : results) {
            Assert.assertEquals((Object)DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)result.getTimestamp());
            Assert.assertTrue((boolean)(result.getValue() instanceof Iterable));
            Iterable resultValues = (Iterable)result.getValue();
            for (SearchHit resultValue : resultValues) {
                int index = copy.indexOf(resultValue);
                if (index < 0) {
                    this.fail(expectedResults, results, "No result found containing " + resultValue.getDimension() + " and " + resultValue.getValue());
                }
                SearchHit expected = (SearchHit)copy.remove(index);
                if (resultValue.toString().equals(expected.toString())) continue;
                this.fail(expectedResults, results, "Invalid count for " + resultValue + ".. which was expected to be " + expected.getCount());
            }
        }
        if (!copy.isEmpty()) {
            this.fail(expectedResults, results, "Some expected results are not shown: " + copy);
        }
    }

    private void fail(List<SearchHit> expectedResults, Iterable<Result<SearchResultValue>> results, String errorMsg) {
        LOG.info("Expected..", new Object[0]);
        for (SearchHit searchHit : expectedResults) {
            LOG.info(searchHit.toString(), new Object[0]);
        }
        LOG.info("Result..", new Object[0]);
        for (Result result : results) {
            for (SearchHit v : (SearchResultValue)result.getValue()) {
                LOG.info(v.toString(), new Object[0]);
            }
        }
        Assert.fail((String)errorMsg);
    }
}

