/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.search;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.query.DataSource;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.QueryConfig;
import org.apache.hive.druid.org.apache.druid.query.QueryContexts;
import org.apache.hive.druid.org.apache.druid.query.TableDataSource;
import org.apache.hive.druid.org.apache.druid.query.TestQuery;
import org.apache.hive.druid.org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.hive.druid.org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.hive.druid.org.apache.druid.segment.TestHelper;
import org.junit.Assert;
import org.junit.Test;

public class QueryConfigTest {
    @Test
    public void testSerde() throws IOException {
        ObjectMapper mapper = TestHelper.makeJsonMapper();
        String json = "{\"vectorize\" : \"force\",\"vectorSize\" : 1}";
        QueryConfig config = (QueryConfig)mapper.readValue("{\"vectorize\" : \"force\",\"vectorSize\" : 1}", QueryConfig.class);
        Assert.assertEquals((Object)QueryContexts.Vectorize.FORCE, (Object)config.getVectorize());
        Assert.assertEquals((long)1L, (long)config.getVectorSize());
    }

    @Test
    public void testDefault() {
        QueryConfig config = new QueryConfig();
        Assert.assertEquals((Object)QueryContexts.DEFAULT_VECTORIZE, (Object)config.getVectorize());
        Assert.assertEquals((long)512L, (long)config.getVectorSize());
    }

    @Test
    public void testOverrides() {
        TestQuery query = new TestQuery((DataSource)new TableDataSource("datasource"), (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of()), false, (Map)ImmutableMap.of((Object)"vectorize", (Object)"true", (Object)"vectorSize", (Object)1024));
        QueryConfig config = new QueryConfig().withOverrides((Query)query);
        Assert.assertEquals((Object)QueryContexts.Vectorize.TRUE, (Object)config.getVectorize());
        Assert.assertEquals((long)1024L, (long)config.getVectorSize());
    }
}

