/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.scan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.org.apache.druid.java.util.common.UOE;
import org.apache.hive.druid.org.apache.druid.query.scan.ScanQuery;
import org.apache.hive.druid.org.apache.druid.query.scan.ScanResultValue;

public class ScanQueryTestHelper {
    public static ScanResultValue generateScanResultValue(long timestamp, ScanQuery.ResultFormat resultFormat, int batchSize) {
        String segmentId = "some_segment_id";
        ArrayList<String> columns = new ArrayList<String>(Arrays.asList("__time", "name", "count"));
        ArrayList events = new ArrayList();
        for (int i = 0; i < batchSize; ++i) {
            Cloneable event;
            if (resultFormat.equals((Object)ScanQuery.ResultFormat.RESULT_FORMAT_LIST)) {
                HashMap<String, Object> eventMap = new HashMap<String, Object>();
                eventMap.put("__time", timestamp);
                eventMap.put("name", "Feridun");
                eventMap.put("count", i);
                event = eventMap;
            } else if (resultFormat.equals((Object)ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST)) {
                event = new ArrayList<Serializable>(Arrays.asList(timestamp, "Feridun", i));
            } else {
                throw new UOE("Result format [%s] not supported yet", new Object[]{resultFormat.toString()});
            }
            events.add(event);
        }
        return new ScanResultValue(segmentId, columns, events);
    }

    public static List<Map<String, Object>> getEventsListResultFormat(ScanResultValue scanResultValue) {
        return (List)scanResultValue.getEvents();
    }

    public static List<List<Object>> getEventsCompactedListResultFormat(ScanResultValue scanResultValue) {
        return (List)scanResultValue.getEvents();
    }
}

