/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.scan;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.UOE;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.org.apache.druid.query.DefaultGenericQueryMetricsFactory;
import org.apache.hive.druid.org.apache.druid.query.Druids;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.QueryPlus;
import org.apache.hive.druid.org.apache.druid.query.QueryRunner;
import org.apache.hive.druid.org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.org.apache.druid.query.SegmentDescriptor;
import org.apache.hive.druid.org.apache.druid.query.context.ResponseContext;
import org.apache.hive.druid.org.apache.druid.query.scan.ScanQuery;
import org.apache.hive.druid.org.apache.druid.query.scan.ScanQueryConfig;
import org.apache.hive.druid.org.apache.druid.query.scan.ScanQueryEngine;
import org.apache.hive.druid.org.apache.druid.query.scan.ScanQueryQueryToolChest;
import org.apache.hive.druid.org.apache.druid.query.scan.ScanQueryRunnerFactory;
import org.apache.hive.druid.org.apache.druid.query.scan.ScanQueryTestHelper;
import org.apache.hive.druid.org.apache.druid.query.scan.ScanResultValue;
import org.apache.hive.druid.org.apache.druid.query.spec.LegacySegmentSpec;
import org.apache.hive.druid.org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.hive.druid.org.apache.druid.query.spec.MultipleSpecificSegmentSpec;
import org.apache.hive.druid.org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.hive.druid.org.apache.druid.query.spec.SpecificSegmentSpec;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Enclosed.class)
public class ScanQueryRunnerFactoryTest {
    private static final ScanQueryRunnerFactory FACTORY = new ScanQueryRunnerFactory(new ScanQueryQueryToolChest(new ScanQueryConfig(), DefaultGenericQueryMetricsFactory.instance()), new ScanQueryEngine(), new ScanQueryConfig());

    public static class ScanQueryRunnerFactoryNonParameterizedTest {
        private SegmentDescriptor descriptor = new SegmentDescriptor(new Interval((ReadableInstant)DateTimes.of((String)"2010-01-01"), (ReadableInstant)DateTimes.of((String)"2019-01-01").plusHours(1)), "1", 0);

        @Test
        public void testGetValidIntervalsFromSpec() {
            MultipleSpecificSegmentSpec multiSpecificSpec = new MultipleSpecificSegmentSpec(Collections.singletonList(this.descriptor));
            SpecificSegmentSpec singleSpecificSpec = new SpecificSegmentSpec(this.descriptor);
            List intervals = FACTORY.getIntervalsFromSpecificQuerySpec((QuerySegmentSpec)multiSpecificSpec);
            Assert.assertEquals((long)1L, (long)intervals.size());
            Assert.assertEquals((Object)this.descriptor.getInterval(), intervals.get(0));
            intervals = FACTORY.getIntervalsFromSpecificQuerySpec((QuerySegmentSpec)singleSpecificSpec);
            Assert.assertEquals((long)1L, (long)intervals.size());
            Assert.assertEquals((Object)this.descriptor.getInterval(), intervals.get(0));
        }

        @Test(expected=UOE.class)
        public void testGetSegmentDescriptorsFromInvalidIntervalSpec() {
            MultipleIntervalSegmentSpec multiIntervalSpec = new MultipleIntervalSegmentSpec(Collections.singletonList(new Interval((ReadableInstant)DateTimes.of((String)"2010-01-01"), (ReadableInstant)DateTimes.of((String)"2019-01-01").plusHours(1))));
            FACTORY.getIntervalsFromSpecificQuerySpec((QuerySegmentSpec)multiIntervalSpec);
        }

        @Test(expected=UOE.class)
        public void testGetSegmentDescriptorsFromInvalidLegacySpec() {
            LegacySegmentSpec legacySpec = new LegacySegmentSpec((Object)new Interval((ReadableInstant)DateTimes.of((String)"2010-01-01"), (ReadableInstant)DateTimes.of((String)"2019-01-01").plusHours(1)));
            FACTORY.getIntervalsFromSpecificQuerySpec((QuerySegmentSpec)legacySpec);
        }
    }

    @RunWith(value=Parameterized.class)
    public static class ScanQueryRunnerFactoryParameterizedTest {
        private int numElements;
        private ScanQuery query;
        private ScanQuery.ResultFormat resultFormat;

        public ScanQueryRunnerFactoryParameterizedTest(int numElements, int batchSize, long limit, ScanQuery.ResultFormat resultFormat, ScanQuery.Order order) {
            this.numElements = numElements;
            this.query = Druids.newScanQueryBuilder().batchSize(batchSize).limit(limit).order(order).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).dataSource("some datasource").resultFormat(resultFormat).build();
            this.resultFormat = resultFormat;
        }

        @Parameterized.Parameters(name="{0} {1} {2} {3} {4}")
        public static Iterable<Object[]> constructorFeeder() {
            ImmutableList numsElements = ImmutableList.of((Object)0, (Object)10, (Object)100);
            ImmutableList batchSizes = ImmutableList.of((Object)1, (Object)100);
            ImmutableList limits = ImmutableList.of((Object)3L, (Object)1000L, (Object)Long.MAX_VALUE);
            ImmutableList resultFormats = ImmutableList.of((Object)ScanQuery.ResultFormat.RESULT_FORMAT_LIST, (Object)ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST);
            ImmutableList order = ImmutableList.of((Object)ScanQuery.Order.ASCENDING, (Object)ScanQuery.Order.DESCENDING);
            return QueryRunnerTestHelper.cartesian(new Iterable[]{numsElements, batchSizes, limits, resultFormats, order});
        }

        @Test
        public void testSortAndLimitScanResultValues() {
            block4: {
                ArrayList<ScanResultValue> srvs = new ArrayList<ScanResultValue>(this.numElements);
                ArrayList<Long> expectedEventTimestamps = new ArrayList<Long>();
                for (int i = 0; i < this.numElements; ++i) {
                    long timestamp = DateTimes.of((String)"2015-01-01").plusHours(i).getMillis();
                    expectedEventTimestamps.add(timestamp);
                    srvs.add(ScanQueryTestHelper.generateScanResultValue(timestamp, this.resultFormat, 1));
                }
                expectedEventTimestamps.sort((o1, o2) -> {
                    int retVal = 0;
                    if (o1 > o2) {
                        retVal = 1;
                    } else if (o1 < o2) {
                        retVal = -1;
                    }
                    if (this.query.getOrder().equals((Object)ScanQuery.Order.DESCENDING)) {
                        return retVal * -1;
                    }
                    return retVal;
                });
                Sequence inputSequence = Sequences.simple(srvs);
                try {
                    List output = FACTORY.priorityQueueSortAndLimit(inputSequence, this.query, (List)ImmutableList.of((Object)new Interval((ReadableInstant)DateTimes.of((String)"2010-01-01"), (ReadableInstant)DateTimes.of((String)"2019-01-01").plusHours(1)))).toList();
                    if (this.query.getScanRowsLimit() > Integer.MAX_VALUE) {
                        Assert.fail((String)"Unsupported exception should have been thrown due to high limit");
                    }
                    this.validateSortedOutput(output, expectedEventTimestamps);
                }
                catch (UOE e) {
                    if (this.query.getScanRowsLimit() > Integer.MAX_VALUE) break block4;
                    Assert.fail((String)"Unsupported operation exception should not have been thrown here");
                }
            }
        }

        @Test
        public void testNWayMerge() {
            ArrayList<Long> expectedEventTimestamps = new ArrayList<Long>(this.numElements * 3);
            ArrayList<ScanResultValue> scanResultValues1 = new ArrayList<ScanResultValue>(this.numElements);
            for (int i = 0; i < this.numElements; ++i) {
                long timestamp = DateTimes.of((String)"2015-01-01").plusMinutes(i * 2).getMillis();
                expectedEventTimestamps.add(timestamp);
                scanResultValues1.add(ScanQueryTestHelper.generateScanResultValue(timestamp, this.resultFormat, 1));
            }
            ArrayList<ScanResultValue> scanResultValues2 = new ArrayList<ScanResultValue>(this.numElements);
            for (int i = 0; i < this.numElements; ++i) {
                long timestamp = DateTimes.of((String)"2015-01-01").plusMinutes(i * 2 + 1).getMillis();
                expectedEventTimestamps.add(timestamp);
                scanResultValues2.add(ScanQueryTestHelper.generateScanResultValue(timestamp, this.resultFormat, 1));
            }
            ArrayList<ScanResultValue> scanResultValues3 = new ArrayList<ScanResultValue>(this.numElements);
            for (int i = 0; i < this.numElements; ++i) {
                long timestamp = DateTimes.of((String)"2015-01-02").plusMinutes(i).getMillis();
                expectedEventTimestamps.add(timestamp);
                scanResultValues3.add(ScanQueryTestHelper.generateScanResultValue(timestamp, this.resultFormat, 1));
            }
            if (this.query.getOrder() == ScanQuery.Order.DESCENDING) {
                Collections.reverse(scanResultValues1);
                Collections.reverse(scanResultValues2);
                Collections.reverse(scanResultValues3);
            }
            QueryRunner runnerSegment1Partition1 = (queryPlus, responseContext) -> Sequences.simple((Iterable)scanResultValues1);
            QueryRunner runnerSegment1Partition2 = (queryPlus, responseContext) -> Sequences.simple((Iterable)scanResultValues2);
            QueryRunner runnerSegment2Partition1 = (queryPlus, responseContext) -> Sequences.simple((Iterable)scanResultValues3);
            QueryRunner runnerSegment2Partition2 = (queryPlus, responseContext) -> Sequences.empty();
            ArrayList<List<QueryRunner>> groupedRunners = new ArrayList<List<QueryRunner>>(2);
            if (this.query.getOrder() == ScanQuery.Order.DESCENDING) {
                groupedRunners.add(Arrays.asList(runnerSegment2Partition1, runnerSegment2Partition2));
                groupedRunners.add(Arrays.asList(runnerSegment1Partition1, runnerSegment1Partition2));
            } else {
                groupedRunners.add(Arrays.asList(runnerSegment1Partition1, runnerSegment1Partition2));
                groupedRunners.add(Arrays.asList(runnerSegment2Partition1, runnerSegment2Partition2));
            }
            expectedEventTimestamps.sort((o1, o2) -> {
                int retVal = 0;
                if (o1 > o2) {
                    retVal = 1;
                } else if (o1 < o2) {
                    retVal = -1;
                }
                if (this.query.getOrder().equals((Object)ScanQuery.Order.DESCENDING)) {
                    return retVal * -1;
                }
                return retVal;
            });
            List output = FACTORY.nWayMergeAndLimit(groupedRunners, QueryPlus.wrap((Query)this.query), ResponseContext.createEmpty()).toList();
            this.validateSortedOutput(output, expectedEventTimestamps);
        }

        private void validateSortedOutput(List<ScanResultValue> output, List<Long> expectedEventTimestamps) {
            int i;
            for (ScanResultValue srv : output) {
                if (this.resultFormat.equals((Object)ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST)) {
                    Assert.assertTrue((ScanQueryTestHelper.getEventsCompactedListResultFormat(srv).size() == 1 ? 1 : 0) != 0);
                    continue;
                }
                if (!this.resultFormat.equals((Object)ScanQuery.ResultFormat.RESULT_FORMAT_LIST)) continue;
                Assert.assertTrue((ScanQueryTestHelper.getEventsListResultFormat(srv).size() == 1 ? 1 : 0) != 0);
            }
            Assert.assertTrue(((long)output.size() <= this.query.getScanRowsLimit() ? 1 : 0) != 0);
            for (i = 1; i < output.size(); ++i) {
                if (this.query.getOrder().equals((Object)ScanQuery.Order.DESCENDING)) {
                    Assert.assertTrue((output.get(i).getFirstEventTimestamp(this.resultFormat) < output.get(i - 1).getFirstEventTimestamp(this.resultFormat) ? 1 : 0) != 0);
                    continue;
                }
                Assert.assertTrue((output.get(i).getFirstEventTimestamp(this.resultFormat) > output.get(i - 1).getFirstEventTimestamp(this.resultFormat) ? 1 : 0) != 0);
            }
            for (i = 0; (long)i < this.query.getScanRowsLimit() && i < output.size(); ++i) {
                Assert.assertEquals((long)expectedEventTimestamps.get(i), (long)output.get(i).getFirstEventTimestamp(this.resultFormat));
            }
        }
    }
}

