/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.scan;

import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.org.apache.druid.query.scan.ScanQueryConfig;
import org.junit.Assert;
import org.junit.Test;

public class ScanQueryConfigTest {
    private final ObjectMapper MAPPER = new DefaultObjectMapper();
    private final ImmutableMap<String, String> CONFIG_MAP = ImmutableMap.builder().put((Object)"maxSegmentPartitionsOrderedInMemory", (Object)"1").put((Object)"maxRowsQueuedForOrdering", (Object)"1").put((Object)"legacy", (Object)"true").build();
    private final ImmutableMap<String, String> CONFIG_MAP2 = ImmutableMap.builder().put((Object)"legacy", (Object)"false").put((Object)"maxSegmentPartitionsOrderedInMemory", (Object)"42").build();
    private final ImmutableMap<String, String> CONFIG_MAP_EMPTY = ImmutableMap.builder().build();

    @Test
    public void testSerde() {
        ScanQueryConfig config = (ScanQueryConfig)this.MAPPER.convertValue(this.CONFIG_MAP, ScanQueryConfig.class);
        Assert.assertEquals((long)1L, (long)config.getMaxRowsQueuedForOrdering());
        Assert.assertEquals((long)1L, (long)config.getMaxSegmentPartitionsOrderedInMemory());
        Assert.assertTrue((boolean)config.isLegacy());
        ScanQueryConfig config2 = (ScanQueryConfig)this.MAPPER.convertValue(this.CONFIG_MAP2, ScanQueryConfig.class);
        Assert.assertEquals((long)100000L, (long)config2.getMaxRowsQueuedForOrdering());
        Assert.assertEquals((long)42L, (long)config2.getMaxSegmentPartitionsOrderedInMemory());
        Assert.assertFalse((boolean)config2.isLegacy());
        ScanQueryConfig config3 = (ScanQueryConfig)this.MAPPER.convertValue(this.CONFIG_MAP_EMPTY, ScanQueryConfig.class);
        Assert.assertEquals((long)100000L, (long)config3.getMaxRowsQueuedForOrdering());
        Assert.assertEquals((long)50L, (long)config3.getMaxSegmentPartitionsOrderedInMemory());
        Assert.assertFalse((boolean)config3.isLegacy());
    }
}

