/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.monomorphicprocessing;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hive.druid.org.apache.druid.query.monomorphicprocessing.HotLoopCallee;
import org.apache.hive.druid.org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.org.apache.druid.query.monomorphicprocessing.StringRuntimeShape;
import org.junit.Assert;
import org.junit.Test;

public class StringRuntimeShapeTest {
    @Test
    public void testStringRuntimeShape() {
        String barRuntimeShape = StringRuntimeShape.of((HotLoopCallee)new Bar());
        Assert.assertEquals((Object)"org.apache.hive.druid.org.apache.druid.query.monomorphicprocessing.StringRuntimeShapeTest$Bar {\n  foo: org.apache.druid.query.monomorphicprocessing.StringRuntimeShapeTest$Foo {\n    flag1: true,\n    flag2: false,\n    key: value,\n    empty: org.apache.druid.query.monomorphicprocessing.StringRuntimeShapeTest$Empty,\n    object: java.nio.HeapByteBuffer {order: BIG_ENDIAN},\n    array: [\n      java.util.HashSet,\n      java.util.TreeSet\n    ],\n    emptyArray: []\n  },\n  array: [\n    org.apache.druid.query.monomorphicprocessing.StringRuntimeShapeTest$Foo {\n      flag1: true,\n      flag2: false,\n      key: value,\n      empty: org.apache.druid.query.monomorphicprocessing.StringRuntimeShapeTest$Empty,\n      object: java.nio.HeapByteBuffer {order: BIG_ENDIAN},\n      array: [\n        java.util.HashSet,\n        java.util.TreeSet\n      ],\n      emptyArray: []\n    },\n    org.apache.druid.query.monomorphicprocessing.StringRuntimeShapeTest$Foo {\n      flag1: true,\n      flag2: false,\n      key: value,\n      empty: org.apache.druid.query.monomorphicprocessing.StringRuntimeShapeTest$Empty,\n      object: java.nio.HeapByteBuffer {order: BIG_ENDIAN},\n      array: [\n        java.util.HashSet,\n        java.util.TreeSet\n      ],\n      emptyArray: []\n    }\n  ]\n}", (Object)barRuntimeShape);
    }

    static class Bar
    implements HotLoopCallee {
        Bar() {
        }

        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            inspector.visit("foo", (HotLoopCallee)new Foo());
            inspector.visit("array", (Object[])new Foo[]{new Foo(), new Foo()});
        }
    }

    static class Foo
    implements HotLoopCallee {
        Foo() {
        }

        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            inspector.visit("flag1", true);
            inspector.visit("flag2", false);
            inspector.visit("key", "value");
            inspector.visit("empty", (HotLoopCallee)new Empty());
            inspector.visit("object", (Object)ByteBuffer.allocate(1));
            inspector.visit("array", (Object[])new Set[]{new HashSet(), new TreeSet()});
            inspector.visit("emptyArray", (Object[])new Set[0]);
        }
    }

    static class Empty
    implements HotLoopCallee {
        Empty() {
        }

        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        }
    }
}

