/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.metadata;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.hive.druid.org.apache.druid.query.DataSource;
import org.apache.hive.druid.org.apache.druid.query.LegacyDataSource;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.QueryPlus;
import org.apache.hive.druid.org.apache.druid.query.QueryRunner;
import org.apache.hive.druid.org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.org.apache.druid.query.metadata.SegmentMetadataQueryConfig;
import org.apache.hive.druid.org.apache.druid.query.metadata.SegmentMetadataQueryQueryToolChest;
import org.apache.hive.druid.org.apache.druid.query.metadata.SegmentMetadataQueryRunnerFactory;
import org.apache.hive.druid.org.apache.druid.query.metadata.metadata.ColumnAnalysis;
import org.apache.hive.druid.org.apache.druid.query.metadata.metadata.SegmentAnalysis;
import org.apache.hive.druid.org.apache.druid.query.metadata.metadata.SegmentMetadataQuery;
import org.apache.hive.druid.org.apache.druid.query.spec.LegacySegmentSpec;
import org.apache.hive.druid.org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.hive.druid.org.apache.druid.segment.IncrementalIndexSegment;
import org.apache.hive.druid.org.apache.druid.segment.QueryableIndexSegment;
import org.apache.hive.druid.org.apache.druid.segment.Segment;
import org.apache.hive.druid.org.apache.druid.segment.TestIndex;
import org.apache.hive.druid.org.apache.druid.segment.column.ValueType;
import org.apache.hive.druid.org.apache.druid.timeline.SegmentId;
import org.junit.Assert;
import org.junit.Test;

public class SegmentAnalyzerTest {
    private static final EnumSet<SegmentMetadataQuery.AnalysisType> EMPTY_ANALYSES = EnumSet.noneOf(SegmentMetadataQuery.AnalysisType.class);

    @Test
    public void testIncrementalWorks() {
        this.testIncrementalWorksHelper(null);
        this.testIncrementalWorksHelper(EMPTY_ANALYSES);
    }

    private void testIncrementalWorksHelper(EnumSet<SegmentMetadataQuery.AnalysisType> analyses) {
        List<SegmentAnalysis> results = this.getSegmentAnalysises((Segment)new IncrementalIndexSegment(TestIndex.getIncrementalTestIndex(), SegmentId.dummy((String)"ds")), analyses);
        Assert.assertEquals((long)1L, (long)results.size());
        SegmentAnalysis analysis = results.get(0);
        Assert.assertEquals((Object)SegmentId.dummy((String)"ds").toString(), (Object)analysis.getId());
        Map columns = analysis.getColumns();
        Assert.assertEquals((long)(TestIndex.COLUMNS.length + 3), (long)columns.size());
        for (DimensionSchema schema : TestIndex.DIMENSION_SCHEMAS) {
            String dimension = schema.getName();
            ColumnAnalysis columnAnalysis = (ColumnAnalysis)columns.get(dimension);
            boolean isString = schema.getValueType().name().equals(ValueType.STRING.name());
            Assert.assertEquals((String)dimension, (Object)schema.getValueType().name(), (Object)columnAnalysis.getType());
            Assert.assertEquals((String)dimension, (long)0L, (long)columnAnalysis.getSize());
            if (isString) {
                if (analyses == null) {
                    Assert.assertTrue((String)dimension, (columnAnalysis.getCardinality() > 0 ? 1 : 0) != 0);
                    continue;
                }
                Assert.assertEquals((String)dimension, (long)0L, (long)columnAnalysis.getCardinality().longValue());
                continue;
            }
            Assert.assertNull((String)dimension, (Object)columnAnalysis.getCardinality());
        }
        for (String metric : TestIndex.DOUBLE_METRICS) {
            ColumnAnalysis columnAnalysis = (ColumnAnalysis)columns.get(metric);
            Assert.assertEquals((String)metric, (Object)ValueType.DOUBLE.name(), (Object)columnAnalysis.getType());
            Assert.assertEquals((String)metric, (long)0L, (long)columnAnalysis.getSize());
            Assert.assertNull((String)metric, (Object)columnAnalysis.getCardinality());
        }
        for (String metric : TestIndex.FLOAT_METRICS) {
            ColumnAnalysis columnAnalysis = (ColumnAnalysis)columns.get(metric);
            Assert.assertEquals((String)metric, (Object)ValueType.FLOAT.name(), (Object)columnAnalysis.getType());
            Assert.assertEquals((String)metric, (long)0L, (long)columnAnalysis.getSize());
            Assert.assertNull((String)metric, (Object)columnAnalysis.getCardinality());
        }
    }

    @Test
    public void testMappedWorks() {
        this.testMappedWorksHelper(null);
        this.testMappedWorksHelper(EMPTY_ANALYSES);
    }

    private void testMappedWorksHelper(EnumSet<SegmentMetadataQuery.AnalysisType> analyses) {
        List<SegmentAnalysis> results = this.getSegmentAnalysises((Segment)new QueryableIndexSegment(TestIndex.getMMappedTestIndex(), SegmentId.dummy((String)"test_1")), analyses);
        Assert.assertEquals((long)1L, (long)results.size());
        SegmentAnalysis analysis = results.get(0);
        Assert.assertEquals((Object)SegmentId.dummy((String)"test_1").toString(), (Object)analysis.getId());
        Map columns = analysis.getColumns();
        Assert.assertEquals((long)(TestIndex.COLUMNS.length + 3 - 1), (long)columns.size());
        for (DimensionSchema schema : TestIndex.DIMENSION_SCHEMAS) {
            String dimension = schema.getName();
            ColumnAnalysis columnAnalysis = (ColumnAnalysis)columns.get(dimension);
            if ("null_column".equals(dimension)) {
                Assert.assertNull((Object)columnAnalysis);
                continue;
            }
            boolean isString = schema.getValueType().name().equals(ValueType.STRING.name());
            Assert.assertEquals((String)dimension, (Object)schema.getValueType().name(), (Object)columnAnalysis.getType());
            Assert.assertEquals((String)dimension, (long)0L, (long)columnAnalysis.getSize());
            if (isString) {
                if (analyses == null) {
                    Assert.assertTrue((String)dimension, (columnAnalysis.getCardinality() > 0 ? 1 : 0) != 0);
                    continue;
                }
                Assert.assertEquals((String)dimension, (long)0L, (long)columnAnalysis.getCardinality().longValue());
                continue;
            }
            Assert.assertNull((String)dimension, (Object)columnAnalysis.getCardinality());
        }
        for (String metric : TestIndex.DOUBLE_METRICS) {
            ColumnAnalysis columnAnalysis = (ColumnAnalysis)columns.get(metric);
            Assert.assertEquals((String)metric, (Object)ValueType.DOUBLE.name(), (Object)columnAnalysis.getType());
            Assert.assertEquals((String)metric, (long)0L, (long)columnAnalysis.getSize());
            Assert.assertNull((String)metric, (Object)columnAnalysis.getCardinality());
        }
        for (String metric : TestIndex.FLOAT_METRICS) {
            ColumnAnalysis columnAnalysis = (ColumnAnalysis)columns.get(metric);
            Assert.assertEquals((String)metric, (Object)ValueType.FLOAT.name(), (Object)columnAnalysis.getType());
            Assert.assertEquals((String)metric, (long)0L, (long)columnAnalysis.getSize());
            Assert.assertNull((String)metric, (Object)columnAnalysis.getCardinality());
        }
    }

    private List<SegmentAnalysis> getSegmentAnalysises(Segment index, EnumSet<SegmentMetadataQuery.AnalysisType> analyses) {
        QueryRunner runner = QueryRunnerTestHelper.makeQueryRunner(new SegmentMetadataQueryRunnerFactory(new SegmentMetadataQueryQueryToolChest(new SegmentMetadataQueryConfig()), QueryRunnerTestHelper.NOOP_QUERYWATCHER), index, null);
        SegmentMetadataQuery query = new SegmentMetadataQuery((DataSource)new LegacyDataSource("test"), (QuerySegmentSpec)new LegacySegmentSpec((Object)"2011/2012"), null, null, null, analyses, Boolean.valueOf(false), Boolean.valueOf(false));
        return runner.run(QueryPlus.wrap((Query)query)).toList();
    }
}

