/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.lookup;

import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.hive.druid.org.apache.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.extraction.MapLookupExtractor;
import org.apache.hive.druid.org.apache.druid.query.lookup.LookupExtractor;
import org.apache.hive.druid.org.apache.druid.query.lookup.LookupExtractorFactory;
import org.apache.hive.druid.org.apache.druid.query.lookup.LookupExtractorFactoryContainer;
import org.apache.hive.druid.org.apache.druid.query.lookup.LookupExtractorFactoryContainerProvider;
import org.apache.hive.druid.org.apache.druid.query.lookup.LookupIntrospectHandler;
import org.apache.hive.druid.org.apache.druid.query.lookup.LookupReferencesManager;
import org.apache.hive.druid.org.apache.druid.query.lookup.RegisteredLookupExtractionFn;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class RegisteredLookupExtractionFnTest {
    private static Map<String, String> MAP = ImmutableMap.of((Object)"foo", (Object)"bar", (Object)"bat", (Object)"baz");
    private static final LookupExtractor LOOKUP_EXTRACTOR = new MapLookupExtractor(MAP, true);
    private static final String LOOKUP_NAME = "some lookup";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testSimpleDelegation() {
        LookupExtractorFactoryContainerProvider manager = (LookupExtractorFactoryContainerProvider)EasyMock.createStrictMock(LookupReferencesManager.class);
        this.managerReturnsMap(manager);
        EasyMock.replay((Object[])new Object[]{manager});
        RegisteredLookupExtractionFn fn = new RegisteredLookupExtractionFn(manager, LOOKUP_NAME, true, null, Boolean.valueOf(false), Boolean.valueOf(false));
        EasyMock.verify((Object[])new Object[]{manager});
        Assert.assertEquals((Object)false, (Object)fn.isInjective());
        Assert.assertEquals((Object)ExtractionFn.ExtractionType.MANY_TO_ONE, (Object)fn.getExtractionType());
        for (String orig : Arrays.asList(null, "foo", "bat")) {
            Assert.assertEquals((Object)LOOKUP_EXTRACTOR.apply(orig), (Object)fn.apply(orig));
        }
        Assert.assertEquals((Object)"not in the map", (Object)fn.apply("not in the map"));
    }

    @Test
    public void testInheritInjective() {
        LookupExtractorFactoryContainerProvider manager = (LookupExtractorFactoryContainerProvider)EasyMock.createStrictMock(LookupReferencesManager.class);
        this.managerReturnsMap(manager);
        EasyMock.replay((Object[])new Object[]{manager});
        RegisteredLookupExtractionFn fn = new RegisteredLookupExtractionFn(manager, LOOKUP_NAME, true, null, null, Boolean.valueOf(false));
        EasyMock.verify((Object[])new Object[]{manager});
        Assert.assertNull((Object)fn.isInjective());
        Assert.assertEquals((Object)ExtractionFn.ExtractionType.ONE_TO_ONE, (Object)fn.getExtractionType());
    }

    @Test
    public void testMissingDelegation() {
        LookupExtractorFactoryContainerProvider manager = (LookupExtractorFactoryContainerProvider)EasyMock.createStrictMock(LookupReferencesManager.class);
        EasyMock.expect((Object)manager.get((String)EasyMock.eq((Object)LOOKUP_NAME))).andReturn(null).once();
        EasyMock.replay((Object[])new Object[]{manager});
        this.expectedException.expectMessage("Lookup [some lookup] not found");
        try {
            new RegisteredLookupExtractionFn(manager, LOOKUP_NAME, true, null, Boolean.valueOf(true), Boolean.valueOf(false)).apply("foo");
        }
        catch (Throwable throwable) {
            EasyMock.verify((Object[])new Object[]{manager});
            throw throwable;
        }
        EasyMock.verify((Object[])new Object[]{manager});
    }

    @Test
    public void testNullLookup() {
        this.expectedException.expectMessage("`lookup` required");
        new RegisteredLookupExtractionFn(null, null, true, null, Boolean.valueOf(true), Boolean.valueOf(false));
    }

    @Test
    public void testSerDe() throws Exception {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        LookupExtractorFactoryContainerProvider manager = (LookupExtractorFactoryContainerProvider)EasyMock.createStrictMock(LookupReferencesManager.class);
        this.managerReturnsMap(manager);
        EasyMock.replay((Object[])new Object[]{manager});
        RegisteredLookupExtractionFn fn = new RegisteredLookupExtractionFn(manager, LOOKUP_NAME, true, null, Boolean.valueOf(true), Boolean.valueOf(false));
        EasyMock.verify((Object[])new Object[]{manager});
        Map result = (Map)mapper.readValue(mapper.writeValueAsString((Object)fn), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        Assert.assertEquals((Object)mapper.convertValue((Object)fn, JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT), (Object)result);
        Assert.assertEquals((Object)LOOKUP_NAME, result.get("lookup"));
        Assert.assertEquals((Object)true, result.get("retainMissingValue"));
        Assert.assertEquals((Object)true, result.get("injective"));
        Assert.assertNull(result.get("replaceMissingValueWith"));
        Assert.assertEquals((Object)false, result.get("optimize"));
    }

    @Test
    public void testEquals() {
        LookupExtractorFactoryContainerProvider manager = (LookupExtractorFactoryContainerProvider)EasyMock.createStrictMock(LookupReferencesManager.class);
        this.managerReturnsMap(manager);
        EasyMock.replay((Object[])new Object[]{manager});
        RegisteredLookupExtractionFn fn = new RegisteredLookupExtractionFn(manager, LOOKUP_NAME, false, "something", Boolean.valueOf(true), Boolean.valueOf(false));
        Assert.assertEquals((Object)fn, (Object)new RegisteredLookupExtractionFn(manager, LOOKUP_NAME, false, "something", Boolean.valueOf(true), Boolean.valueOf(false)));
        Assert.assertNotEquals((Object)fn, (Object)new RegisteredLookupExtractionFn(manager, LOOKUP_NAME, true, null, Boolean.valueOf(true), Boolean.valueOf(false)));
        Assert.assertNotEquals((Object)fn, (Object)new RegisteredLookupExtractionFn(manager, LOOKUP_NAME, false, "something else", Boolean.valueOf(true), Boolean.valueOf(false)));
        Assert.assertNotEquals((Object)fn, (Object)new RegisteredLookupExtractionFn(manager, LOOKUP_NAME, false, "something", Boolean.valueOf(false), Boolean.valueOf(false)));
        Assert.assertNotEquals((Object)fn, (Object)new RegisteredLookupExtractionFn(manager, LOOKUP_NAME, false, "something", Boolean.valueOf(true), Boolean.valueOf(true)));
        Assert.assertNotEquals((Object)fn, (Object)new RegisteredLookupExtractionFn(manager, LOOKUP_NAME, false, null, Boolean.valueOf(true), Boolean.valueOf(false)));
        EasyMock.verify((Object[])new Object[]{manager});
    }

    private void managerReturnsMap(LookupExtractorFactoryContainerProvider manager) {
        EasyMock.expect((Object)manager.get((String)EasyMock.eq((Object)LOOKUP_NAME))).andReturn((Object)new LookupExtractorFactoryContainer("v0", new LookupExtractorFactory(){

            public boolean start() {
                return false;
            }

            public boolean replaces(@Nullable LookupExtractorFactory other) {
                return false;
            }

            public boolean close() {
                return false;
            }

            @Nullable
            public LookupIntrospectHandler getIntrospectHandler() {
                return null;
            }

            public LookupExtractor get() {
                return LOOKUP_EXTRACTOR;
            }
        })).anyTimes();
    }
}

