/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.lookup;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.io.Files;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.query.lookup.LookupBean;
import org.apache.hive.druid.org.apache.druid.query.lookup.LookupExtractorFactory;
import org.apache.hive.druid.org.apache.druid.query.lookup.LookupExtractorFactoryContainer;
import org.apache.hive.druid.org.apache.druid.query.lookup.LookupSnapshotTaker;
import org.apache.hive.druid.org.apache.druid.query.lookup.MapLookupExtractorFactory;
import org.apache.hive.druid.org.apache.druid.segment.TestHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class LookupSnapshotTakerTest {
    private static final String TIER1 = "tier1";
    private static final String TIER2 = "tier2";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private final ObjectMapper mapper = TestHelper.makeJsonMapper();
    private LookupSnapshotTaker lookupSnapshotTaker;
    private String basePersistDirectory;

    @Before
    public void setUp() throws IOException {
        this.mapper.registerSubtypes(new Class[]{MapLookupExtractorFactory.class});
        this.basePersistDirectory = this.temporaryFolder.newFolder().getAbsolutePath();
        this.lookupSnapshotTaker = new LookupSnapshotTaker(this.mapper, this.basePersistDirectory);
    }

    @Test
    public void testTakeSnapshotAndPullExisting() {
        LookupBean lookupBean1 = new LookupBean("name1", null, new LookupExtractorFactoryContainer("v1", (LookupExtractorFactory)new MapLookupExtractorFactory((Map)ImmutableMap.of((Object)"key", (Object)"value"), true)));
        LookupBean lookupBean2 = new LookupBean("name2", null, new LookupExtractorFactoryContainer("v1", (LookupExtractorFactory)new MapLookupExtractorFactory((Map)ImmutableMap.of((Object)"key", (Object)"value"), true)));
        List<LookupBean> lookupBeanList1 = Collections.singletonList(lookupBean1);
        this.lookupSnapshotTaker.takeSnapshot(TIER1, lookupBeanList1);
        List<LookupBean> lookupBeanList2 = Collections.singletonList(lookupBean2);
        this.lookupSnapshotTaker.takeSnapshot(TIER2, lookupBeanList2);
        Assert.assertEquals(lookupBeanList1, (Object)this.lookupSnapshotTaker.pullExistingSnapshot(TIER1));
        Assert.assertEquals(lookupBeanList2, (Object)this.lookupSnapshotTaker.pullExistingSnapshot(TIER2));
    }

    @Test
    public void testIOExceptionDuringLookupPersist() throws IOException {
        File directory = this.temporaryFolder.newFolder();
        LookupSnapshotTaker lookupSnapshotTaker = new LookupSnapshotTaker(this.mapper, directory.getAbsolutePath());
        File snapshotFile = lookupSnapshotTaker.getPersistFile(TIER1);
        Assert.assertFalse((boolean)snapshotFile.exists());
        Assert.assertTrue((boolean)snapshotFile.createNewFile());
        Assert.assertTrue((boolean)snapshotFile.setReadOnly());
        Assert.assertTrue((boolean)snapshotFile.getParentFile().setReadOnly());
        LookupBean lookupBean = new LookupBean("name", null, new LookupExtractorFactoryContainer("v1", (LookupExtractorFactory)new MapLookupExtractorFactory((Map)ImmutableMap.of((Object)"key", (Object)"value"), true)));
        List<LookupBean> lookupBeanList = Collections.singletonList(lookupBean);
        this.expectedException.expect(ISE.class);
        this.expectedException.expectMessage("Exception during serialization of lookups");
        lookupSnapshotTaker.takeSnapshot(TIER1, lookupBeanList);
    }

    @Test
    public void tesLookupPullingFromEmptyFile() throws IOException {
        File snapshotFile = this.lookupSnapshotTaker.getPersistFile(TIER1);
        Assert.assertTrue((boolean)snapshotFile.createNewFile());
        Assert.assertEquals((Object)Collections.EMPTY_LIST, (Object)this.lookupSnapshotTaker.pullExistingSnapshot(TIER1));
    }

    @Test(expected=ISE.class)
    public void tesLookupPullingFromCorruptFile() throws IOException {
        File snapshotFile = this.lookupSnapshotTaker.getPersistFile(TIER1);
        Assert.assertTrue((boolean)snapshotFile.createNewFile());
        byte[] bytes = StringUtils.toUtf8((String)"test corrupt file");
        Files.write((byte[])bytes, (File)snapshotFile);
        this.lookupSnapshotTaker.pullExistingSnapshot(TIER1);
    }

    @Test
    public void testLookupPullingFromNonExistingFile() throws IOException {
        File directory = this.temporaryFolder.newFolder();
        LookupSnapshotTaker lookupSnapshotTaker = new LookupSnapshotTaker(this.mapper, directory.getAbsolutePath());
        List actualList = lookupSnapshotTaker.pullExistingSnapshot(TIER1);
        Assert.assertEquals((Object)Collections.EMPTY_LIST, (Object)actualList);
    }
}

