/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.groupby.having;

import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hive.druid.org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.filter.DimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.hive.druid.org.apache.druid.query.groupby.GroupByQuery;
import org.apache.hive.druid.org.apache.druid.query.groupby.ResultRow;
import org.apache.hive.druid.org.apache.druid.query.groupby.having.DimFilterHavingSpec;
import org.apache.hive.druid.org.apache.druid.query.groupby.having.HavingSpec;
import org.apache.hive.druid.org.apache.druid.segment.column.ValueType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.junit.rules.ExpectedException;

public class DimFilterHavingSpecTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testSimple() {
        DimFilterHavingSpec havingSpec = new DimFilterHavingSpec((DimFilter)new SelectorDimFilter("foo", "bar", null), null);
        havingSpec.setQuery(GroupByQuery.builder().setDataSource("dummy").setInterval("1000/3000").setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"foo")}).setGranularity(Granularities.ALL).build());
        Assert.assertTrue((boolean)havingSpec.eval(ResultRow.of((Object[])new Object[]{"bar"})));
        Assert.assertFalse((boolean)havingSpec.eval(ResultRow.of((Object[])new Object[]{"baz"})));
    }

    @Test
    public void testRowSignature() {
        DimFilterHavingSpec havingSpec = new DimFilterHavingSpec((DimFilter)new SelectorDimFilter("foo", "1", null), null);
        havingSpec.setQuery(GroupByQuery.builder().setDataSource("dummy").setInterval("1000/3000").setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("foo", "foo", ValueType.LONG)}).build());
        Assert.assertTrue((boolean)havingSpec.eval(ResultRow.of((Object[])new Object[]{1L})));
        Assert.assertFalse((boolean)havingSpec.eval(ResultRow.of((Object[])new Object[]{2L})));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    @Ignore
    public void testConcurrentUsage() throws Exception {
        ExecutorService exec = Executors.newFixedThreadPool(2);
        DimFilterHavingSpec havingSpec = new DimFilterHavingSpec((DimFilter)new SelectorDimFilter("foo", "1", null), null);
        ArrayList futures = new ArrayList();
        for (int i = 0; i < 2; ++i) {
            ResultRow resultRow = ResultRow.of((Object[])new Object[]{String.valueOf(i)});
            futures.add(exec.submit(() -> {
                havingSpec.setQuery(GroupByQuery.builder().setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"foo")}).build());
                while (!Thread.interrupted()) {
                    havingSpec.eval(row);
                }
            }));
        }
        this.expectedException.expect(ExecutionException.class);
        this.expectedException.expectCause(CoreMatchers.instanceOf(IllegalStateException.class));
        this.expectedException.expectCause(ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"concurrent 'eval' calls not permitted")));
        try {
            for (Future future : futures) {
                future.get();
            }
        }
        finally {
            exec.shutdownNow();
        }
        Assert.assertTrue((boolean)false);
    }

    @Test
    public void testSerde() throws Exception {
        DimFilterHavingSpec havingSpec = new DimFilterHavingSpec((DimFilter)new SelectorDimFilter("foo", "1", null), Boolean.valueOf(false));
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        Assert.assertEquals((Object)havingSpec, (Object)objectMapper.readValue(objectMapper.writeValueAsBytes((Object)havingSpec), HavingSpec.class));
    }
}

