/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.groupby.epinephelinae;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.groupby.epinephelinae.Grouper;

public class IntKeySerde
implements Grouper.KeySerde<Integer> {
    public static final Grouper.KeySerde<Integer> INSTANCE = new IntKeySerde();
    private static final Grouper.BufferComparator KEY_COMPARATOR = new Grouper.BufferComparator(){

        public int compare(ByteBuffer lhsBuffer, ByteBuffer rhsBuffer, int lhsPosition, int rhsPosition) {
            return Ints.compare((int)lhsBuffer.getInt(lhsPosition), (int)rhsBuffer.getInt(rhsPosition));
        }
    };
    private final ByteBuffer buf = ByteBuffer.allocate(4);

    private IntKeySerde() {
    }

    public int keySize() {
        return 4;
    }

    public Class<Integer> keyClazz() {
        return Integer.class;
    }

    public List<String> getDictionary() {
        return ImmutableList.of();
    }

    public ByteBuffer toByteBuffer(Integer key) {
        this.buf.putInt(0, key);
        this.buf.position(0);
        return this.buf;
    }

    public Integer fromByteBuffer(ByteBuffer buffer, int position) {
        return buffer.getInt(position);
    }

    public Grouper.BufferComparator bufferComparator() {
        return KEY_COMPARATOR;
    }

    public Grouper.BufferComparator bufferComparatorWithAggregators(AggregatorFactory[] aggregatorFactories, int[] aggregatorOffsets) {
        return KEY_COMPARATOR;
    }

    public void reset() {
    }
}

