/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.groupby.epinephelinae;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.base.Suppliers;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.org.apache.druid.common.config.NullHandling;
import org.apache.hive.druid.org.apache.druid.data.input.MapBasedRow;
import org.apache.hive.druid.org.apache.druid.data.input.Row;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorAdapters;
import org.apache.hive.druid.org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.groupby.epinephelinae.BufferHashGrouper;
import org.apache.hive.druid.org.apache.druid.query.groupby.epinephelinae.Grouper;
import org.apache.hive.druid.org.apache.druid.query.groupby.epinephelinae.GrouperTestUtil;
import org.apache.hive.druid.org.apache.druid.query.groupby.epinephelinae.TestColumnSelectorFactory;
import org.apache.hive.druid.org.apache.druid.segment.CloserRule;
import org.apache.hive.druid.org.apache.druid.segment.ColumnSelectorFactory;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class BufferHashGrouperTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public CloserRule closerRule = new CloserRule(true);

    @Test
    public void testSimple() {
        TestColumnSelectorFactory columnSelectorFactory = GrouperTestUtil.newColumnSelectorFactory();
        BufferHashGrouper grouper = new BufferHashGrouper(Suppliers.ofInstance((Object)ByteBuffer.allocate(1000)), GrouperTestUtil.intKeySerde(), AggregatorAdapters.factorizeBuffered((ColumnSelectorFactory)columnSelectorFactory, (List)ImmutableList.of((Object)new LongSumAggregatorFactory("valueSum", "value"), (Object)new CountAggregatorFactory("count"))), Integer.MAX_VALUE, 0.0f, 0, true);
        grouper.init();
        columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"value", (Object)10L)));
        grouper.aggregate((Object)12);
        grouper.aggregate((Object)6);
        grouper.aggregate((Object)10);
        grouper.aggregate((Object)6);
        grouper.aggregate((Object)12);
        grouper.aggregate((Object)12);
        ImmutableList expected = ImmutableList.of((Object)new Grouper.Entry((Object)6, new Object[]{20L, 2L}), (Object)new Grouper.Entry((Object)10, new Object[]{10L, 1L}), (Object)new Grouper.Entry((Object)12, new Object[]{30L, 3L}));
        ArrayList unsortedEntries = Lists.newArrayList((Iterator)grouper.iterator(false));
        ArrayList sortedEntries = Lists.newArrayList((Iterator)grouper.iterator(true));
        Assert.assertEquals((Object)expected, (Object)sortedEntries);
        Assert.assertEquals((Object)expected, (Object)Ordering.from((Comparator)new Comparator<Grouper.Entry<Integer>>(){

            @Override
            public int compare(Grouper.Entry<Integer> o1, Grouper.Entry<Integer> o2) {
                return Ints.compare((int)((Integer)o1.getKey()), (int)((Integer)o2.getKey()));
            }
        }).sortedCopy((Iterable)unsortedEntries));
    }

    @Test
    public void testGrowing() {
        int i;
        TestColumnSelectorFactory columnSelectorFactory = GrouperTestUtil.newColumnSelectorFactory();
        BufferHashGrouper<Integer> grouper = this.makeGrouper(columnSelectorFactory, 10000, 2, 0.75f);
        int expectedMaxSize = NullHandling.replaceWithDefault() ? 219 : 210;
        columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"value", (Object)10L)));
        for (i = 0; i < expectedMaxSize; ++i) {
            Assert.assertTrue((String)String.valueOf(i), (boolean)grouper.aggregate((Object)i).isOk());
        }
        Assert.assertFalse((boolean)grouper.aggregate((Object)expectedMaxSize).isOk());
        columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"value", (Object)11L)));
        for (i = 0; i < expectedMaxSize; ++i) {
            Assert.assertTrue((String)String.valueOf(i), (boolean)grouper.aggregate((Object)i).isOk());
        }
        Assert.assertFalse((boolean)grouper.aggregate((Object)expectedMaxSize).isOk());
        ArrayList<Grouper.Entry> expected = new ArrayList<Grouper.Entry>();
        for (int i2 = 0; i2 < expectedMaxSize; ++i2) {
            expected.add(new Grouper.Entry((Object)i2, new Object[]{21L, 2L}));
        }
        Assert.assertEquals(expected, (Object)Lists.newArrayList((Iterator)grouper.iterator(true)));
    }

    @Test
    public void testGrowingOverflowingInteger() {
        if (NullHandling.replaceWithDefault()) {
            TestColumnSelectorFactory columnSelectorFactory = GrouperTestUtil.newColumnSelectorFactory();
            BufferHashGrouper<Integer> grouper = this.makeGrouper(columnSelectorFactory, 1900000000, 2, 0.3f);
            int expectedMaxSize = 15323979;
            columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"value", (Object)10L)));
            for (int i = 0; i < 15323979; ++i) {
                Assert.assertTrue((String)String.valueOf(i), (boolean)grouper.aggregate((Object)i).isOk());
            }
            Assert.assertFalse((boolean)grouper.aggregate((Object)15323979).isOk());
        }
    }

    @Test
    public void testNoGrowing() {
        int i;
        TestColumnSelectorFactory columnSelectorFactory = GrouperTestUtil.newColumnSelectorFactory();
        BufferHashGrouper<Integer> grouper = this.makeGrouper(columnSelectorFactory, 10000, Integer.MAX_VALUE, 0.75f);
        int expectedMaxSize = NullHandling.replaceWithDefault() ? 267 : 258;
        columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"value", (Object)10L)));
        for (i = 0; i < expectedMaxSize; ++i) {
            Assert.assertTrue((String)String.valueOf(i), (boolean)grouper.aggregate((Object)i).isOk());
        }
        Assert.assertFalse((boolean)grouper.aggregate((Object)expectedMaxSize).isOk());
        columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"value", (Object)11L)));
        for (i = 0; i < expectedMaxSize; ++i) {
            Assert.assertTrue((String)String.valueOf(i), (boolean)grouper.aggregate((Object)i).isOk());
        }
        Assert.assertFalse((boolean)grouper.aggregate((Object)expectedMaxSize).isOk());
        ArrayList<Grouper.Entry> expected = new ArrayList<Grouper.Entry>();
        for (int i2 = 0; i2 < expectedMaxSize; ++i2) {
            expected.add(new Grouper.Entry((Object)i2, new Object[]{21L, 2L}));
        }
        Assert.assertEquals(expected, (Object)Lists.newArrayList((Iterator)grouper.iterator(true)));
    }

    private BufferHashGrouper<Integer> makeGrouper(TestColumnSelectorFactory columnSelectorFactory, int bufferSize, int initialBuckets, float maxLoadFactor) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(bufferSize);
        BufferHashGrouper grouper = new BufferHashGrouper(Suppliers.ofInstance((Object)buffer), GrouperTestUtil.intKeySerde(), AggregatorAdapters.factorizeBuffered((ColumnSelectorFactory)columnSelectorFactory, (List)ImmutableList.of((Object)new LongSumAggregatorFactory("valueSum", "value"), (Object)new CountAggregatorFactory("count"))), Integer.MAX_VALUE, maxLoadFactor, initialBuckets, true);
        grouper.init();
        return grouper;
    }
}

