/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.groupby.epinephelinae;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.base.Suppliers;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.org.apache.druid.common.config.NullHandling;
import org.apache.hive.druid.org.apache.druid.data.input.MapBasedRow;
import org.apache.hive.druid.org.apache.druid.data.input.Row;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorAdapters;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.groupby.epinephelinae.BufferArrayGrouper;
import org.apache.hive.druid.org.apache.druid.query.groupby.epinephelinae.Grouper;
import org.apache.hive.druid.org.apache.druid.query.groupby.epinephelinae.GrouperTestUtil;
import org.apache.hive.druid.org.apache.druid.query.groupby.epinephelinae.TestColumnSelectorFactory;
import org.apache.hive.druid.org.apache.druid.segment.ColumnSelectorFactory;
import org.junit.Assert;
import org.junit.Test;

public class BufferArrayGrouperTest {
    @Test
    public void testAggregate() {
        TestColumnSelectorFactory columnSelectorFactory = GrouperTestUtil.newColumnSelectorFactory();
        BufferArrayGrouper grouper = this.newGrouper(columnSelectorFactory, 32768);
        columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"value", (Object)10L)));
        grouper.aggregate(12);
        grouper.aggregate(6);
        grouper.aggregate(10);
        grouper.aggregate(6);
        grouper.aggregate(12);
        grouper.aggregate(6);
        ImmutableList expected = ImmutableList.of((Object)new Grouper.Entry((Object)6, new Object[]{30L, 3L}), (Object)new Grouper.Entry((Object)10, new Object[]{10L, 1L}), (Object)new Grouper.Entry((Object)12, new Object[]{20L, 2L}));
        ArrayList unsortedEntries = Lists.newArrayList((Iterator)grouper.iterator(false));
        Assert.assertEquals((Object)expected, (Object)Ordering.from((o1, o2) -> Ints.compare((int)((Integer)o1.getKey()), (int)((Integer)o2.getKey()))).sortedCopy((Iterable)unsortedEntries));
    }

    private BufferArrayGrouper newGrouper(TestColumnSelectorFactory columnSelectorFactory, int bufferSize) {
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        BufferArrayGrouper grouper = new BufferArrayGrouper(Suppliers.ofInstance((Object)buffer), AggregatorAdapters.factorizeBuffered((ColumnSelectorFactory)columnSelectorFactory, (List)ImmutableList.of((Object)new LongSumAggregatorFactory("valueSum", "value"), (Object)new CountAggregatorFactory("count"))), 1000);
        grouper.init();
        return grouper;
    }

    @Test
    public void testRequiredBufferCapacity() {
        int[] cardinalityArray = new int[]{1, 10, 0x7FFFFFFE};
        AggregatorFactory[] aggregatorFactories = new AggregatorFactory[]{new LongSumAggregatorFactory("sum", "sum")};
        long[] requiredSizes = NullHandling.sqlCompatible() ? new long[]{19L, 101L, 19058917368L} : new long[]{17L, 90L, 16911433721L};
        for (int i = 0; i < cardinalityArray.length; ++i) {
            Assert.assertEquals((long)requiredSizes[i], (long)BufferArrayGrouper.requiredBufferCapacity((int)cardinalityArray[i], (AggregatorFactory[])aggregatorFactories));
        }
    }
}

