/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.groupby;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.UnmodifiableIterator;
import org.apache.hive.druid.org.apache.druid.data.input.MapBasedRow;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.Pair;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.org.apache.druid.java.util.common.io.Closer;
import org.apache.hive.druid.org.apache.druid.query.Druids;
import org.apache.hive.druid.org.apache.druid.query.FinalizeResultsQueryRunner;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.QueryPlus;
import org.apache.hive.druid.org.apache.druid.query.QueryRunner;
import org.apache.hive.druid.org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.org.apache.druid.query.QueryToolChest;
import org.apache.hive.druid.org.apache.druid.query.Result;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.DoubleMaxAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.DoubleMinAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.context.ResponseContext;
import org.apache.hive.druid.org.apache.druid.query.groupby.GroupByQuery;
import org.apache.hive.druid.org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.hive.druid.org.apache.druid.query.groupby.GroupByQueryRunnerFactory;
import org.apache.hive.druid.org.apache.druid.query.groupby.GroupByQueryRunnerTest;
import org.apache.hive.druid.org.apache.druid.query.groupby.ResultRow;
import org.apache.hive.druid.org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.hive.druid.org.apache.druid.query.timeseries.TimeseriesQueryRunnerTest;
import org.apache.hive.druid.org.apache.druid.query.timeseries.TimeseriesResultValue;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class GroupByTimeseriesQueryRunnerTest
extends TimeseriesQueryRunnerTest {
    private static final Closer RESOURCE_CLOSER = Closer.create();

    @AfterClass
    public static void teardown() throws IOException {
        RESOURCE_CLOSER.close();
    }

    @Parameterized.Parameters(name="{0}, vectorize = {1}")
    public static Iterable<Object[]> constructorFeeder() {
        GroupByQueryConfig config = new GroupByQueryConfig();
        config.setMaxIntermediateRows(10000);
        Pair<GroupByQueryRunnerFactory, Closer> factoryAndCloser = GroupByQueryRunnerTest.makeQueryRunnerFactory(config);
        final GroupByQueryRunnerFactory factory = (GroupByQueryRunnerFactory)factoryAndCloser.lhs;
        RESOURCE_CLOSER.register((Closeable)factoryAndCloser.rhs);
        ArrayList<Object[]> constructors = new ArrayList<Object[]>();
        for (final QueryRunner runner : QueryRunnerTestHelper.makeQueryRunners(factory)) {
            QueryRunner modifiedRunner = new QueryRunner(){

                public Sequence run(QueryPlus queryPlus, ResponseContext responseContext) {
                    TimeseriesQuery tsQuery = (TimeseriesQuery)queryPlus.getQuery();
                    QueryRunner newRunner = factory.mergeRunners((ExecutorService)Execs.directExecutor(), (Iterable)ImmutableList.of((Object)runner));
                    QueryToolChest toolChest = factory.getToolchest();
                    newRunner = new FinalizeResultsQueryRunner(toolChest.mergeResults(toolChest.preMergeQueryDecoration(newRunner)), toolChest);
                    final GroupByQuery newQuery = GroupByQuery.builder().setDataSource(tsQuery.getDataSource()).setQuerySegmentSpec(tsQuery.getQuerySegmentSpec()).setGranularity(tsQuery.getGranularity()).setDimFilter(tsQuery.getDimensionsFilter()).setAggregatorSpecs(tsQuery.getAggregatorSpecs()).setPostAggregatorSpecs(tsQuery.getPostAggregatorSpecs()).setVirtualColumns(tsQuery.getVirtualColumns()).setContext(tsQuery.getContext()).build();
                    return Sequences.map((Sequence)newRunner.run(queryPlus.withQuery((Query)newQuery), responseContext), (Function)new Function<ResultRow, Result<TimeseriesResultValue>>(){

                        public Result<TimeseriesResultValue> apply(ResultRow input) {
                            MapBasedRow mapBasedRow = input.toMapBasedRow(newQuery);
                            return new Result(mapBasedRow.getTimestamp(), (Object)new TimeseriesResultValue(mapBasedRow.getEvent()));
                        }
                    });
                }

                public String toString() {
                    return runner.toString();
                }
            };
            UnmodifiableIterator unmodifiableIterator = ImmutableList.of((Object)false, (Object)true).iterator();
            while (unmodifiableIterator.hasNext()) {
                boolean vectorize = (Boolean)unmodifiableIterator.next();
                if (vectorize && !QueryRunnerTestHelper.isTestRunnerVectorizable(runner)) continue;
                constructors.add(new Object[]{modifiedRunner, vectorize});
            }
        }
        return constructors;
    }

    public GroupByTimeseriesQueryRunnerTest(QueryRunner runner, boolean vectorize) {
        super(runner, false, vectorize, QueryRunnerTestHelper.COMMON_DOUBLE_AGGREGATORS);
    }

    @Override
    @Test
    public void testFullOnTimeseriesMaxMin() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(Granularities.ALL).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators(new AggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")}).descending(this.descending).build();
        DateTime expectedEarliest = DateTimes.of((String)"1970-01-01");
        DateTime expectedLast = DateTimes.of((String)"2011-04-15");
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        Result result = (Result)results.iterator().next();
        Assert.assertEquals((Object)expectedEarliest, (Object)result.getTimestamp());
        Assert.assertFalse((String)StringUtils.format((String)"Timestamp[%s] > expectedLast[%s]", (Object[])new Object[]{result.getTimestamp(), expectedLast}), (boolean)result.getTimestamp().isAfter((ReadableInstant)expectedLast));
        TimeseriesResultValue value = (TimeseriesResultValue)result.getValue();
        Assert.assertEquals((String)result.toString(), (double)1870.061029, (double)value.getDoubleMetric("maxIndex"), (double)0.0018700610289999998);
        Assert.assertEquals((String)result.toString(), (double)59.021022, (double)value.getDoubleMetric("minIndex"), (double)5.9021021999999996E-5);
    }

    @Override
    public void testEmptyTimeseries() {
    }

    @Override
    public void testFullOnTimeseries() {
    }

    @Override
    public void testFullOnTimeseriesWithFilter() {
    }

    @Override
    public void testTimeseriesQueryZeroFilling() {
    }

    @Override
    public void testTimeseriesWithNonExistentFilter() {
    }

    @Override
    public void testTimeseriesWithNonExistentFilterAndMultiDim() {
    }

    @Override
    public void testTimeseriesWithFilterOnNonExistentDimension() {
    }
}

