/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.groupby;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.org.apache.druid.query.BaseQuery;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.hive.druid.org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.groupby.GroupByQuery;
import org.apache.hive.druid.org.apache.druid.query.groupby.ResultRow;
import org.apache.hive.druid.org.apache.druid.query.groupby.orderby.DefaultLimitSpec;
import org.apache.hive.druid.org.apache.druid.query.groupby.orderby.LimitSpec;
import org.apache.hive.druid.org.apache.druid.query.groupby.orderby.OrderByColumnSpec;
import org.apache.hive.druid.org.apache.druid.query.ordering.StringComparators;
import org.apache.hive.druid.org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.hive.druid.org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.hive.druid.org.apache.druid.segment.TestHelper;
import org.apache.hive.druid.org.apache.druid.segment.column.ValueType;
import org.junit.Assert;
import org.junit.Test;

public class GroupByQueryTest {
    private static final ObjectMapper JSON_MAPPER = TestHelper.makeJsonMapper();

    @Test
    public void testQuerySerialization() throws IOException {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).setPostAggregatorSpecs((List)ImmutableList.of((Object)new FieldAccessPostAggregator("x", "idx"))).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("alias", OrderByColumnSpec.Direction.ASCENDING, StringComparators.LEXICOGRAPHIC)), Integer.valueOf(100))).build();
        String json = JSON_MAPPER.writeValueAsString((Object)query);
        Query serdeQuery = (Query)JSON_MAPPER.readValue(json, Query.class);
        Assert.assertEquals((Object)query, (Object)serdeQuery);
    }

    @Test
    public void testRowOrderingMixTypes() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("dummy").setGranularity(Granularities.ALL).setInterval("2000/2001").addDimension((DimensionSpec)new DefaultDimensionSpec("foo", "foo", ValueType.LONG)).addDimension((DimensionSpec)new DefaultDimensionSpec("bar", "bar", ValueType.FLOAT)).addDimension((DimensionSpec)new DefaultDimensionSpec("baz", "baz", ValueType.STRING)).build();
        Ordering rowOrdering = query.getRowOrdering(false);
        int compare = rowOrdering.compare((Object)ResultRow.of((Object[])new Object[]{1, Float.valueOf(1.0f), "a"}), (Object)ResultRow.of((Object[])new Object[]{1L, 1.0, "b"}));
        Assert.assertEquals((long)-1L, (long)compare);
    }

    @Test
    public void testSegmentLookUpForNestedQueries() {
        MultipleIntervalSegmentSpec innerQuerySegmentSpec = new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.of((String)"2011-11-07/2011-11-08")));
        MultipleIntervalSegmentSpec outerQuerySegmentSpec = new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.of((String)"2011-11-04/2011-11-08")));
        List<CountAggregatorFactory> aggs = Collections.singletonList(QueryRunnerTestHelper.ROWS_COUNT);
        GroupByQuery innerQuery = GroupByQuery.builder().setDataSource("blah").setInterval((QuerySegmentSpec)innerQuerySegmentSpec).setGranularity(Granularities.DAY).setAggregatorSpecs(aggs).build();
        GroupByQuery query = GroupByQuery.builder().setDataSource((Query)innerQuery).setInterval((QuerySegmentSpec)outerQuerySegmentSpec).setAggregatorSpecs(aggs).setGranularity(Granularities.DAY).build();
        Assert.assertEquals((Object)innerQuerySegmentSpec, (Object)BaseQuery.getQuerySegmentSpecForLookUp((BaseQuery)query));
    }
}

