/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.groupby;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.org.apache.druid.query.FinalizeResultsQueryRunner;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.QueryPlus;
import org.apache.hive.druid.org.apache.druid.query.QueryRunner;
import org.apache.hive.druid.org.apache.druid.query.QueryRunnerFactory;
import org.apache.hive.druid.org.apache.druid.query.QueryToolChest;
import org.apache.hive.druid.org.apache.druid.query.groupby.GroupByQuery;
import org.apache.hive.druid.org.apache.druid.query.groupby.ResultRow;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;

public class GroupByQueryRunnerTestHelper {
    public static <T> Iterable<T> runQuery(QueryRunnerFactory factory, QueryRunner runner, Query<T> query) {
        QueryToolChest toolChest = factory.getToolchest();
        FinalizeResultsQueryRunner theRunner = new FinalizeResultsQueryRunner(toolChest.mergeResults(toolChest.preMergeQueryDecoration(runner)), toolChest);
        Sequence queryResult = theRunner.run(QueryPlus.wrap(query));
        return queryResult.toList();
    }

    public static ResultRow createExpectedRow(GroupByQuery query, String timestamp, Object ... vals) {
        return GroupByQueryRunnerTestHelper.createExpectedRow(query, DateTimes.of((String)timestamp), vals);
    }

    public static ResultRow createExpectedRow(GroupByQuery query, DateTime timestamp, Object ... vals) {
        Preconditions.checkArgument((vals.length % 2 == 0 ? 1 : 0) != 0);
        ResultRow row = ResultRow.create((int)query.getResultRowSizeWithPostAggregators());
        if (query.getResultRowHasTimestamp()) {
            row.set(0, (Object)timestamp.getMillis());
        }
        for (int i = 0; i < vals.length; i += 2) {
            int position = query.getResultRowPositionLookup().getInt((Object)vals[i].toString());
            row.set(position, vals[i + 1]);
        }
        return row;
    }

    public static List<ResultRow> createExpectedRows(GroupByQuery query, String[] columnNames, Object[] ... values) {
        int timeIndex = Arrays.asList(columnNames).indexOf("__time");
        Preconditions.checkArgument((timeIndex >= 0 ? 1 : 0) != 0);
        ArrayList<ResultRow> expected = new ArrayList<ResultRow>();
        for (Object[] value : values) {
            Preconditions.checkArgument((value.length == columnNames.length ? 1 : 0) != 0);
            ResultRow row = ResultRow.create((int)query.getResultRowSizeWithPostAggregators());
            for (int i = 0; i < columnNames.length; ++i) {
                if (i != timeIndex) {
                    int position = query.getResultRowPositionLookup().getInt((Object)columnNames[i]);
                    row.set(position, value[i]);
                    continue;
                }
                if (!query.getResultRowHasTimestamp()) continue;
                row.set(0, (Object)new DateTime(value[i], (Chronology)ISOChronology.getInstanceUTC()).getMillis());
            }
            expected.add(row);
        }
        return expected;
    }
}

