/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.groupby;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Functions;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.base.Suppliers;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.com.google.common.collect.UnmodifiableIterator;
import org.apache.hive.druid.org.apache.druid.collections.CloseableDefaultBlockingPool;
import org.apache.hive.druid.org.apache.druid.collections.CloseableStupidPool;
import org.apache.hive.druid.org.apache.druid.common.config.NullHandling;
import org.apache.hive.druid.org.apache.druid.data.input.Rows;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.IAE;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.java.util.common.Pair;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.DurationGranularity;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.MergeSequence;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.org.apache.druid.java.util.common.io.Closer;
import org.apache.hive.druid.org.apache.druid.js.JavaScriptConfig;
import org.apache.hive.druid.org.apache.druid.query.BySegmentResultValueClass;
import org.apache.hive.druid.org.apache.druid.query.ChainedExecutionQueryRunner;
import org.apache.hive.druid.org.apache.druid.query.DataSource;
import org.apache.hive.druid.org.apache.druid.query.DruidProcessingConfig;
import org.apache.hive.druid.org.apache.druid.query.FinalizeResultsQueryRunner;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.QueryConfig;
import org.apache.hive.druid.org.apache.druid.query.QueryDataSource;
import org.apache.hive.druid.org.apache.druid.query.QueryPlus;
import org.apache.hive.druid.org.apache.druid.query.QueryRunner;
import org.apache.hive.druid.org.apache.druid.query.QueryRunnerFactory;
import org.apache.hive.druid.org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.org.apache.druid.query.QueryToolChest;
import org.apache.hive.druid.org.apache.druid.query.ResourceLimitExceededException;
import org.apache.hive.druid.org.apache.druid.query.Result;
import org.apache.hive.druid.org.apache.druid.query.TestBigDecimalSumAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.DoubleMaxAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.FilteredAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.FloatSumAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.JavaScriptAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.LongMaxAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.PostAggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.cardinality.CardinalityAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.first.LongFirstAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.hyperloglog.HyperUniqueFinalizingPostAggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.last.LongLastAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.post.ArithmeticPostAggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.post.ConstantPostAggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.post.ExpressionPostAggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.hive.druid.org.apache.druid.query.context.ResponseContext;
import org.apache.hive.druid.org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.dimension.ExtractionDimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.dimension.ListFilteredDimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.dimension.RegexFilteredDimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.hive.druid.org.apache.druid.query.extraction.CascadeExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.extraction.DimExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.extraction.JavaScriptExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.extraction.MapLookupExtractor;
import org.apache.hive.druid.org.apache.druid.query.extraction.RegexDimExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.extraction.StringFormatExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.extraction.StrlenExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.extraction.TimeFormatExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.filter.AndDimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.BoundDimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.DimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.ExtractionDimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.InDimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.JavaScriptDimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.OrDimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.RegexDimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.SearchQueryDimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.hive.druid.org.apache.druid.query.groupby.GroupByQuery;
import org.apache.hive.druid.org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.hive.druid.org.apache.druid.query.groupby.GroupByQueryEngine;
import org.apache.hive.druid.org.apache.druid.query.groupby.GroupByQueryQueryToolChest;
import org.apache.hive.druid.org.apache.druid.query.groupby.GroupByQueryRunnerFactory;
import org.apache.hive.druid.org.apache.druid.query.groupby.GroupByQueryRunnerTestHelper;
import org.apache.hive.druid.org.apache.druid.query.groupby.ResultRow;
import org.apache.hive.druid.org.apache.druid.query.groupby.having.DimFilterHavingSpec;
import org.apache.hive.druid.org.apache.druid.query.groupby.having.DimensionSelectorHavingSpec;
import org.apache.hive.druid.org.apache.druid.query.groupby.having.EqualToHavingSpec;
import org.apache.hive.druid.org.apache.druid.query.groupby.having.GreaterThanHavingSpec;
import org.apache.hive.druid.org.apache.druid.query.groupby.having.HavingSpec;
import org.apache.hive.druid.org.apache.druid.query.groupby.having.OrHavingSpec;
import org.apache.hive.druid.org.apache.druid.query.groupby.orderby.DefaultLimitSpec;
import org.apache.hive.druid.org.apache.druid.query.groupby.orderby.LimitSpec;
import org.apache.hive.druid.org.apache.druid.query.groupby.orderby.OrderByColumnSpec;
import org.apache.hive.druid.org.apache.druid.query.groupby.strategy.GroupByStrategySelector;
import org.apache.hive.druid.org.apache.druid.query.groupby.strategy.GroupByStrategyV1;
import org.apache.hive.druid.org.apache.druid.query.groupby.strategy.GroupByStrategyV2;
import org.apache.hive.druid.org.apache.druid.query.lookup.LookupExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.lookup.LookupExtractor;
import org.apache.hive.druid.org.apache.druid.query.ordering.StringComparators;
import org.apache.hive.druid.org.apache.druid.query.search.ContainsSearchQuerySpec;
import org.apache.hive.druid.org.apache.druid.query.search.SearchQuerySpec;
import org.apache.hive.druid.org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.hive.druid.org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.hive.druid.org.apache.druid.segment.TestHelper;
import org.apache.hive.druid.org.apache.druid.segment.VirtualColumn;
import org.apache.hive.druid.org.apache.druid.segment.column.ValueType;
import org.apache.hive.druid.org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.hive.druid.org.apache.druid.testing.InitializedNullHandlingTest;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class GroupByQueryRunnerTest
extends InitializedNullHandlingTest {
    public static final ObjectMapper DEFAULT_MAPPER = TestHelper.makeSmileMapper();
    private static final DruidProcessingConfig DEFAULT_PROCESSING_CONFIG = new DruidProcessingConfig(){

        public String getFormatString() {
            return null;
        }

        public int intermediateComputeSizeBytes() {
            return 0xA00000;
        }

        public int getNumMergeBuffers() {
            return 4;
        }

        public int getNumThreads() {
            return 2;
        }
    };
    private static final Closer RESOURCE_CLOSER = Closer.create();
    private final QueryRunner<ResultRow> runner;
    private final String runnerName;
    private final GroupByQueryRunnerFactory factory;
    private final GroupByQueryConfig config;
    private final boolean vectorize;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    public static List<GroupByQueryConfig> testConfigs() {
        GroupByQueryConfig v1Config = new GroupByQueryConfig(){

            public String toString() {
                return "v1";
            }

            public String getDefaultStrategy() {
                return "v1";
            }
        };
        GroupByQueryConfig v1SingleThreadedConfig = new GroupByQueryConfig(){

            public boolean isSingleThreaded() {
                return true;
            }

            public String getDefaultStrategy() {
                return "v1";
            }

            public String toString() {
                return "v1SingleThreaded";
            }
        };
        GroupByQueryConfig v2Config = new GroupByQueryConfig(){

            public String getDefaultStrategy() {
                return "v2";
            }

            public int getBufferGrouperInitialBuckets() {
                return 4;
            }

            public String toString() {
                return "v2";
            }
        };
        GroupByQueryConfig v2SmallBufferConfig = new GroupByQueryConfig(){

            public String getDefaultStrategy() {
                return "v2";
            }

            public int getBufferGrouperMaxSize() {
                return 2;
            }

            public long getMaxOnDiskStorage() {
                return 0xA00000L;
            }

            public String toString() {
                return "v2SmallBuffer";
            }
        };
        GroupByQueryConfig v2SmallDictionaryConfig = new GroupByQueryConfig(){

            public String getDefaultStrategy() {
                return "v2";
            }

            public long getMaxMergingDictionarySize() {
                return 400L;
            }

            public long getMaxOnDiskStorage() {
                return 0xA00000L;
            }

            public String toString() {
                return "v2SmallDictionary";
            }
        };
        GroupByQueryConfig v2ParallelCombineConfig = new GroupByQueryConfig(){

            public String getDefaultStrategy() {
                return "v2";
            }

            public int getNumParallelCombineThreads() {
                return DEFAULT_PROCESSING_CONFIG.getNumThreads();
            }

            public String toString() {
                return "v2ParallelCombine";
            }
        };
        v1Config.setMaxIntermediateRows(10000);
        v1SingleThreadedConfig.setMaxIntermediateRows(10000);
        return ImmutableList.of((Object)v1Config, (Object)v1SingleThreadedConfig, (Object)v2Config, (Object)v2SmallBufferConfig, (Object)v2SmallDictionaryConfig, (Object)v2ParallelCombineConfig);
    }

    public static Pair<GroupByQueryRunnerFactory, Closer> makeQueryRunnerFactory(GroupByQueryConfig config) {
        return GroupByQueryRunnerTest.makeQueryRunnerFactory(DEFAULT_MAPPER, config, DEFAULT_PROCESSING_CONFIG);
    }

    public static Pair<GroupByQueryRunnerFactory, Closer> makeQueryRunnerFactory(ObjectMapper mapper, GroupByQueryConfig config) {
        return GroupByQueryRunnerTest.makeQueryRunnerFactory(mapper, config, DEFAULT_PROCESSING_CONFIG);
    }

    public static Pair<GroupByQueryRunnerFactory, Closer> makeQueryRunnerFactory(ObjectMapper mapper, GroupByQueryConfig config, final DruidProcessingConfig processingConfig) {
        Supplier configSupplier = Suppliers.ofInstance((Object)config);
        CloseableStupidPool<ByteBuffer> bufferPool = new CloseableStupidPool<ByteBuffer>("GroupByQueryEngine-bufferPool", new Supplier<ByteBuffer>(){

            public ByteBuffer get() {
                return ByteBuffer.allocateDirect(processingConfig.intermediateComputeSizeBytes());
            }
        });
        CloseableDefaultBlockingPool<ByteBuffer> mergeBufferPool = new CloseableDefaultBlockingPool<ByteBuffer>(new Supplier<ByteBuffer>(){

            public ByteBuffer get() {
                return ByteBuffer.allocateDirect(processingConfig.intermediateComputeSizeBytes());
            }
        }, processingConfig.getNumMergeBuffers());
        GroupByStrategySelector strategySelector = new GroupByStrategySelector(configSupplier, new GroupByStrategyV1(configSupplier, new GroupByQueryEngine(configSupplier, bufferPool), QueryRunnerTestHelper.NOOP_QUERYWATCHER, bufferPool), new GroupByStrategyV2(processingConfig, configSupplier, Suppliers.ofInstance((Object)new QueryConfig()), bufferPool, mergeBufferPool, mapper, QueryRunnerTestHelper.NOOP_QUERYWATCHER));
        GroupByQueryQueryToolChest toolChest = new GroupByQueryQueryToolChest(strategySelector, QueryRunnerTestHelper.sameThreadIntervalChunkingQueryRunnerDecorator());
        Closer closer = Closer.create();
        closer.register(bufferPool);
        closer.register(mergeBufferPool);
        return Pair.of((Object)new GroupByQueryRunnerFactory(strategySelector, toolChest), (Object)closer);
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> constructorFeeder() {
        ArrayList<Object[]> constructors = new ArrayList<Object[]>();
        for (GroupByQueryConfig config : GroupByQueryRunnerTest.testConfigs()) {
            Pair<GroupByQueryRunnerFactory, Closer> factoryAndCloser = GroupByQueryRunnerTest.makeQueryRunnerFactory(config);
            GroupByQueryRunnerFactory factory = (GroupByQueryRunnerFactory)factoryAndCloser.lhs;
            RESOURCE_CLOSER.register((Closeable)factoryAndCloser.rhs);
            for (QueryRunner runner : QueryRunnerTestHelper.makeQueryRunners(factory)) {
                UnmodifiableIterator unmodifiableIterator = ImmutableList.of((Object)false, (Object)true).iterator();
                while (unmodifiableIterator.hasNext()) {
                    boolean vectorize = (Boolean)unmodifiableIterator.next();
                    String testName = StringUtils.format((String)"config=%s, runner=%s, vectorize=%s", (Object[])new Object[]{config, runner, vectorize});
                    if (vectorize && !QueryRunnerTestHelper.isTestRunnerVectorizable(runner)) continue;
                    constructors.add(new Object[]{testName, config, factory, runner, vectorize});
                }
            }
        }
        return constructors;
    }

    @AfterClass
    public static void teardown() throws IOException {
        RESOURCE_CLOSER.close();
    }

    public GroupByQueryRunnerTest(String testName, GroupByQueryConfig config, GroupByQueryRunnerFactory factory, QueryRunner runner, boolean vectorize) {
        this.config = config;
        this.factory = factory;
        this.runner = factory.mergeRunners((ExecutorService)Execs.directExecutor(), (Iterable)ImmutableList.of((Object)runner));
        this.runnerName = runner.toString();
        this.vectorize = vectorize;
    }

    @Test
    public void testGroupBy() {
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index"), new FloatSumAggregatorFactory("idxFloat", "indexFloat"), new DoubleSumAggregatorFactory("idxDouble", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "automotive", "rows", 1L, "idx", 135L, "idxFloat", Float.valueOf(135.8851f), "idxDouble", (double)135.8851f), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "business", "rows", 1L, "idx", 118L, "idxFloat", 118.57034, "idxDouble", 118.57034), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "entertainment", "rows", 1L, "idx", 158L, "idxFloat", 158.747224, "idxDouble", 158.747224), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "health", "rows", 1L, "idx", 120L, "idxFloat", 120.134704, "idxDouble", 120.134704), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "mezzanine", "rows", 3L, "idx", 2870L, "idxFloat", Float.valueOf(2871.8867f), "idxDouble", 2871.8866900000003), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "news", "rows", 1L, "idx", 121L, "idxFloat", Float.valueOf(121.58358f), "idxDouble", 121.58358), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "premium", "rows", 3L, "idx", 2900L, "idxFloat", Float.valueOf(2900.7986f), "idxDouble", 2900.798647), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "technology", "rows", 1L, "idx", 78L, "idxFloat", Float.valueOf(78.62254f), "idxDouble", 78.622547), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "travel", "rows", 1L, "idx", 119L, "idxFloat", Float.valueOf(119.922745f), "idxDouble", 119.922742), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "automotive", "rows", 1L, "idx", 147L, "idxFloat", Float.valueOf(147.42593f), "idxDouble", 147.42593), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "business", "rows", 1L, "idx", 112L, "idxFloat", Float.valueOf(112.98703f), "idxDouble", 112.987027), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "entertainment", "rows", 1L, "idx", 166L, "idxFloat", Float.valueOf(166.01605f), "idxDouble", 166.016049), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "health", "rows", 1L, "idx", 113L, "idxFloat", Float.valueOf(113.44601f), "idxDouble", 113.446008), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "mezzanine", "rows", 3L, "idx", 2447L, "idxFloat", Float.valueOf(2448.8306f), "idxDouble", 2448.830613), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "news", "rows", 1L, "idx", 114L, "idxFloat", Float.valueOf(114.29014f), "idxDouble", 114.290141), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "premium", "rows", 3L, "idx", 2505L, "idxFloat", Float.valueOf(2506.415f), "idxDouble", 2506.415148), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "technology", "rows", 1L, "idx", 97L, "idxFloat", Float.valueOf(97.387436f), "idxDouble", 97.387433), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "travel", "rows", 1L, "idx", 126L, "idxFloat", Float.valueOf(126.41136f), "idxDouble", 126.411364));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "groupBy");
    }

    @Test
    public void testGroupByOnMissingColumn() {
        this.cannotVectorize();
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("nonexistent0", "alias0"), new ExtractionDimensionSpec("nonexistent1", "alias1", (ExtractionFn)new StringFormatExtractionFn("foo"))}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT}).setGranularity(QueryRunnerTestHelper.ALL_GRAN).build();
        List<ResultRow> expectedResults = Collections.singletonList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", null, "alias1", "foo", "rows", 26L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "missing-column");
    }

    @Test
    public void testGroupByWithStringPostAggregator() {
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setPostAggregatorSpecs((List)ImmutableList.of((Object)new ExpressionPostAggregator("post", "alias + 'x'", null, TestExprMacroTable.INSTANCE))).setGranularity(QueryRunnerTestHelper.DAY_GRAN).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("post", OrderByColumnSpec.Direction.DESCENDING)), Integer.valueOf(Integer.MAX_VALUE))).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "travel", "post", "travelx", "rows", 1L, "idx", 119L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "technology", "post", "technologyx", "rows", 1L, "idx", 78L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "premium", "post", "premiumx", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "news", "post", "newsx", "rows", 1L, "idx", 121L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "mezzanine", "post", "mezzaninex", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "health", "post", "healthx", "rows", 1L, "idx", 120L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "entertainment", "post", "entertainmentx", "rows", 1L, "idx", 158L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "business", "post", "businessx", "rows", 1L, "idx", 118L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "automotive", "post", "automotivex", "rows", 1L, "idx", 135L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "travel", "post", "travelx", "rows", 1L, "idx", 126L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "technology", "post", "technologyx", "rows", 1L, "idx", 97L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "premium", "post", "premiumx", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "news", "post", "newsx", "rows", 1L, "idx", 114L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "mezzanine", "post", "mezzaninex", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "health", "post", "healthx", "rows", 1L, "idx", 113L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "entertainment", "post", "entertainmentx", "rows", 1L, "idx", 166L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "business", "post", "businessx", "rows", 1L, "idx", 112L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "automotive", "post", "automotivex", "rows", 1L, "idx", 147L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "string-postAgg");
    }

    @Test
    public void testGroupByWithStringVirtualColumn() {
        this.cannotVectorize();
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("vc", "quality + 'x'", ValueType.STRING, TestExprMacroTable.INSTANCE)}).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("vc", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "automotivex", "rows", 1L, "idx", 135L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "businessx", "rows", 1L, "idx", 118L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "entertainmentx", "rows", 1L, "idx", 158L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "healthx", "rows", 1L, "idx", 120L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "mezzaninex", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "newsx", "rows", 1L, "idx", 121L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "premiumx", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "technologyx", "rows", 1L, "idx", 78L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "travelx", "rows", 1L, "idx", 119L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "automotivex", "rows", 1L, "idx", 147L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "businessx", "rows", 1L, "idx", 112L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "entertainmentx", "rows", 1L, "idx", 166L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "healthx", "rows", 1L, "idx", 113L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "mezzaninex", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "newsx", "rows", 1L, "idx", 114L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "premiumx", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "technologyx", "rows", 1L, "idx", 97L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "travelx", "rows", 1L, "idx", 126L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "virtual-column");
    }

    @Test
    public void testGroupByWithDurationGranularity() {
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity((Granularity)new DurationGranularity(86400L, 0L)).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "automotive", "rows", 1L, "idx", 135L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "business", "rows", 1L, "idx", 118L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "entertainment", "rows", 1L, "idx", 158L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "health", "rows", 1L, "idx", 120L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "mezzanine", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "news", "rows", 1L, "idx", 121L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "premium", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "technology", "rows", 1L, "idx", 78L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "travel", "rows", 1L, "idx", 119L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "automotive", "rows", 1L, "idx", 147L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "business", "rows", 1L, "idx", 112L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "entertainment", "rows", 1L, "idx", 166L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "health", "rows", 1L, "idx", 113L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "mezzanine", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "news", "rows", 1L, "idx", 114L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "premium", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "technology", "rows", 1L, "idx", 97L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "travel", "rows", 1L, "idx", 126L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "duration-granularity");
    }

    @Test
    public void testGroupByWithOutputNameCollisions() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("[alias] already defined");
        this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("alias", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
    }

    @Test
    public void testGroupByWithSortDimsFirst() {
        if (this.config.getDefaultStrategy().equals("v1")) {
            return;
        }
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).overrideContext((Map)ImmutableMap.of((Object)"sortByDimsFirst", (Object)true)).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "automotive", "rows", 1L, "idx", 135L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "automotive", "rows", 1L, "idx", 147L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "business", "rows", 1L, "idx", 118L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "business", "rows", 1L, "idx", 112L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "entertainment", "rows", 1L, "idx", 158L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "entertainment", "rows", 1L, "idx", 166L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "health", "rows", 1L, "idx", 120L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "health", "rows", 1L, "idx", 113L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "mezzanine", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "mezzanine", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "news", "rows", 1L, "idx", 121L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "news", "rows", 1L, "idx", 114L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "premium", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "premium", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "technology", "rows", 1L, "idx", 78L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "technology", "rows", 1L, "idx", 97L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "travel", "rows", 1L, "idx", 119L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "travel", "rows", 1L, "idx", 126L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "sort-by-dimensions-first");
    }

    @Test
    public void testGroupByWithChunkPeriod() {
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.ALL_GRAN).overrideContext((Map)ImmutableMap.of((Object)"chunkPeriod", (Object)"P1D")).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "automotive", "rows", 2L, "idx", 282L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "business", "rows", 2L, "idx", 230L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "entertainment", "rows", 2L, "idx", 324L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "health", "rows", 2L, "idx", 233L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "mezzanine", "rows", 6L, "idx", 5317L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "news", "rows", 2L, "idx", 235L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "premium", "rows", 6L, "idx", 5405L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "technology", "rows", 2L, "idx", 175L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "travel", "rows", 2L, "idx", 245L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "chunk-period");
    }

    @Test
    public void testGroupByNoAggregators() {
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "automotive"), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "business"), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "entertainment"), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "health"), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "mezzanine"), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "news"), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "premium"), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "technology"), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "travel"), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "automotive"), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "business"), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "entertainment"), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "health"), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "mezzanine"), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "news"), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "premium"), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "technology"), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "travel"));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "no-aggs");
    }

    @Test
    public void testMultiValueDimension() {
        this.cannotVectorize();
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("placementish", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.ALL_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "a", "rows", 2L, "idx", 282L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "b", "rows", 2L, "idx", 230L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "e", "rows", 2L, "idx", 324L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "h", "rows", 2L, "idx", 233L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "m", "rows", 6L, "idx", 5317L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "n", "rows", 2L, "idx", 235L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "p", "rows", 6L, "idx", 5405L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "preferred", "rows", 26L, "idx", 12446L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "t", "rows", 4L, "idx", 420L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "multi-value-dim");
    }

    @Test
    public void testTwoMultiValueDimensions() {
        this.cannotVectorize();
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimFilter((DimFilter)new SelectorDimFilter("placementish", "a", null)).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("placementish", "alias"), new DefaultDimensionSpec("placementish", "alias2")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.ALL_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "a", "alias2", "a", "rows", 2L, "idx", 282L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "a", "alias2", "preferred", "rows", 2L, "idx", 282L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "preferred", "alias2", "a", "rows", 2L, "idx", 282L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "preferred", "alias2", "preferred", "rows", 2L, "idx", 282L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "two-multi-value-dims");
    }

    @Test
    public void testMultipleDimensionsOneOfWhichIsMultiValue1() {
        this.cannotVectorize();
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("placementish", "alias"), new DefaultDimensionSpec("quality", "quality")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.ALL_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "automotive", "alias", "a", "rows", 2L, "idx", 282L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "business", "alias", "b", "rows", 2L, "idx", 230L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "entertainment", "alias", "e", "rows", 2L, "idx", 324L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "health", "alias", "h", "rows", 2L, "idx", 233L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "mezzanine", "alias", "m", "rows", 6L, "idx", 5317L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "news", "alias", "n", "rows", 2L, "idx", 235L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "premium", "alias", "p", "rows", 6L, "idx", 5405L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "automotive", "alias", "preferred", "rows", 2L, "idx", 282L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "business", "alias", "preferred", "rows", 2L, "idx", 230L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "entertainment", "alias", "preferred", "rows", 2L, "idx", 324L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "health", "alias", "preferred", "rows", 2L, "idx", 233L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "mezzanine", "alias", "preferred", "rows", 6L, "idx", 5317L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "news", "alias", "preferred", "rows", 2L, "idx", 235L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "premium", "alias", "preferred", "rows", 6L, "idx", 5405L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "technology", "alias", "preferred", "rows", 2L, "idx", 175L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "travel", "alias", "preferred", "rows", 2L, "idx", 245L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "technology", "alias", "t", "rows", 2L, "idx", 175L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "travel", "alias", "t", "rows", 2L, "idx", 245L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "one-multi-value-dim");
    }

    @Test
    public void testMultipleDimensionsOneOfWhichIsMultiValueDifferentOrder() {
        this.cannotVectorize();
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "quality"), new DefaultDimensionSpec("placementish", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.ALL_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "automotive", "alias", "a", "rows", 2L, "idx", 282L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "automotive", "alias", "preferred", "rows", 2L, "idx", 282L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "business", "alias", "b", "rows", 2L, "idx", 230L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "business", "alias", "preferred", "rows", 2L, "idx", 230L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "entertainment", "alias", "e", "rows", 2L, "idx", 324L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "entertainment", "alias", "preferred", "rows", 2L, "idx", 324L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "health", "alias", "h", "rows", 2L, "idx", 233L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "health", "alias", "preferred", "rows", 2L, "idx", 233L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "mezzanine", "alias", "m", "rows", 6L, "idx", 5317L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "mezzanine", "alias", "preferred", "rows", 6L, "idx", 5317L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "news", "alias", "n", "rows", 2L, "idx", 235L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "news", "alias", "preferred", "rows", 2L, "idx", 235L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "premium", "alias", "p", "rows", 6L, "idx", 5405L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "premium", "alias", "preferred", "rows", 6L, "idx", 5405L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "technology", "alias", "preferred", "rows", 2L, "idx", 175L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "technology", "alias", "t", "rows", 2L, "idx", 175L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "travel", "alias", "preferred", "rows", 2L, "idx", 245L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "travel", "alias", "t", "rows", 2L, "idx", 245L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "one-multi-value-dim-different-order");
    }

    @Test
    public void testGroupByMaxRowsLimitContextOverride() {
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).overrideContext((Map)ImmutableMap.of((Object)"maxResults", (Object)1)).build();
        List<ResultRow> expectedResults = null;
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(ResourceLimitExceededException.class);
        } else {
            expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "automotive", "rows", 1L, "idx", 135L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "business", "rows", 1L, "idx", 118L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "entertainment", "rows", 1L, "idx", 158L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "health", "rows", 1L, "idx", 120L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "mezzanine", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "news", "rows", 1L, "idx", 121L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "premium", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "technology", "rows", 1L, "idx", 78L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "travel", "rows", 1L, "idx", 119L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "automotive", "rows", 1L, "idx", 147L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "business", "rows", 1L, "idx", 112L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "entertainment", "rows", 1L, "idx", 166L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "health", "rows", 1L, "idx", 113L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "mezzanine", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "news", "rows", 1L, "idx", 114L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "premium", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "technology", "rows", 1L, "idx", 97L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "travel", "rows", 1L, "idx", 126L));
        }
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "override-maxResults");
    }

    @Test
    public void testGroupByTimeoutContextOverride() {
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).overrideContext((Map)ImmutableMap.of((Object)"timeout", (Object)60000)).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "automotive", "rows", 1L, "idx", 135L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "business", "rows", 1L, "idx", 118L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "entertainment", "rows", 1L, "idx", 158L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "health", "rows", 1L, "idx", 120L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "mezzanine", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "news", "rows", 1L, "idx", 121L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "premium", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "technology", "rows", 1L, "idx", 78L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "travel", "rows", 1L, "idx", 119L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "automotive", "rows", 1L, "idx", 147L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "business", "rows", 1L, "idx", 112L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "entertainment", "rows", 1L, "idx", 166L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "health", "rows", 1L, "idx", 113L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "mezzanine", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "news", "rows", 1L, "idx", 114L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "premium", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "technology", "rows", 1L, "idx", 97L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "travel", "rows", 1L, "idx", 126L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "override-timeout");
    }

    @Test
    public void testGroupByMaxOnDiskStorageContextOverride() {
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).overrideContext((Map)ImmutableMap.of((Object)"maxOnDiskStorage", (Object)0, (Object)"bufferGrouperMaxSize", (Object)1)).build();
        List<ResultRow> expectedResults = null;
        if (this.config.getDefaultStrategy().equals("v2")) {
            this.expectedException.expect(ResourceLimitExceededException.class);
            this.expectedException.expectMessage("Not enough aggregation buffer space to execute this query");
        } else {
            expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "automotive", "rows", 1L, "idx", 135L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "business", "rows", 1L, "idx", 118L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "entertainment", "rows", 1L, "idx", 158L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "health", "rows", 1L, "idx", 120L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "mezzanine", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "news", "rows", 1L, "idx", 121L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "premium", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "technology", "rows", 1L, "idx", 78L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "travel", "rows", 1L, "idx", 119L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "automotive", "rows", 1L, "idx", 147L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "business", "rows", 1L, "idx", 112L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "entertainment", "rows", 1L, "idx", 166L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "health", "rows", 1L, "idx", 113L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "mezzanine", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "news", "rows", 1L, "idx", 114L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "premium", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "technology", "rows", 1L, "idx", 97L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "travel", "rows", 1L, "idx", 126L));
        }
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "overide-maxOnDiskStorage");
    }

    @Test
    public void testNotEnoughDictionarySpaceThroughContextOverride() {
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).overrideContext((Map)ImmutableMap.of((Object)"maxOnDiskStorage", (Object)0, (Object)"maxMergingDictionarySize", (Object)1)).build();
        List<ResultRow> expectedResults = null;
        if (this.config.getDefaultStrategy().equals("v2")) {
            this.expectedException.expect(ResourceLimitExceededException.class);
            this.expectedException.expectMessage("Not enough dictionary space to execute this query");
        } else {
            expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "automotive", "rows", 1L, "idx", 135L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "business", "rows", 1L, "idx", 118L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "entertainment", "rows", 1L, "idx", 158L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "health", "rows", 1L, "idx", 120L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "mezzanine", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "news", "rows", 1L, "idx", 121L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "premium", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "technology", "rows", 1L, "idx", 78L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "travel", "rows", 1L, "idx", 119L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "automotive", "rows", 1L, "idx", 147L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "business", "rows", 1L, "idx", 112L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "entertainment", "rows", 1L, "idx", 166L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "health", "rows", 1L, "idx", 113L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "mezzanine", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "news", "rows", 1L, "idx", 114L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "premium", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "technology", "rows", 1L, "idx", 97L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "travel", "rows", 1L, "idx", 126L));
        }
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "dictionary-space");
    }

    @Test
    public void testNotEnoughDiskSpaceThroughContextOverride() {
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).overrideContext((Map)ImmutableMap.of((Object)"maxOnDiskStorage", (Object)1, (Object)"maxMergingDictionarySize", (Object)1)).build();
        List<ResultRow> expectedResults = null;
        if (this.config.getDefaultStrategy().equals("v2")) {
            this.expectedException.expect(ResourceLimitExceededException.class);
            if (this.config.getMaxOnDiskStorage() > 0L) {
                this.expectedException.expectMessage("Not enough disk space to execute this query");
            } else {
                this.expectedException.expectMessage("Not enough dictionary space to execute this query");
            }
        } else {
            expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "automotive", "rows", 1L, "idx", 135L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "business", "rows", 1L, "idx", 118L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "entertainment", "rows", 1L, "idx", 158L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "health", "rows", 1L, "idx", 120L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "mezzanine", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "news", "rows", 1L, "idx", 121L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "premium", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "technology", "rows", 1L, "idx", 78L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "travel", "rows", 1L, "idx", 119L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "automotive", "rows", 1L, "idx", 147L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "business", "rows", 1L, "idx", 112L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "entertainment", "rows", 1L, "idx", 166L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "health", "rows", 1L, "idx", 113L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "mezzanine", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "news", "rows", 1L, "idx", 114L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "premium", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "technology", "rows", 1L, "idx", 97L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "travel", "rows", 1L, "idx", 126L));
        }
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "disk-space");
    }

    @Test
    public void testSubqueryWithOuterMaxOnDiskStorageContextOverride() {
        GroupByQuery subquery = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("alias", OrderByColumnSpec.Direction.ASCENDING)), null)).overrideContext((Map)ImmutableMap.of((Object)"maxOnDiskStorage", (Object)Integer.MAX_VALUE, (Object)"bufferGrouperMaxSize", (Object)Integer.MAX_VALUE)).build();
        GroupByQuery query = this.makeQueryBuilder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new ArrayList()).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setGranularity(QueryRunnerTestHelper.ALL_GRAN).overrideContext((Map)ImmutableMap.of((Object)"maxOnDiskStorage", (Object)0, (Object)"bufferGrouperMaxSize", (Object)0)).build();
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(ISE.class);
            this.expectedException.expectMessage("Unknown column in order clause");
            GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        } else {
            this.expectedException.expect(ResourceLimitExceededException.class);
            this.expectedException.expectMessage("Not enough aggregation buffer space to execute this query");
            GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        }
    }

    @Test
    public void testGroupByWithRebucketRename() {
        this.cannotVectorize();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("automotive", "automotive0");
        map.put("business", "business0");
        map.put("entertainment", "entertainment0");
        map.put("health", "health0");
        map.put("mezzanine", "mezzanine0");
        map.put("news", "news0");
        map.put("premium", "premium0");
        map.put("technology", "technology0");
        map.put("travel", "travel0");
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new ExtractionDimensionSpec("quality", "alias", (ExtractionFn)new LookupExtractionFn((LookupExtractor)new MapLookupExtractor(map, false), false, null, Boolean.valueOf(false), Boolean.valueOf(false)))}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "automotive0", "rows", 1L, "idx", 135L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "business0", "rows", 1L, "idx", 118L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "entertainment0", "rows", 1L, "idx", 158L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "health0", "rows", 1L, "idx", 120L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "mezzanine0", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "news0", "rows", 1L, "idx", 121L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "premium0", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "technology0", "rows", 1L, "idx", 78L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "travel0", "rows", 1L, "idx", 119L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "automotive0", "rows", 1L, "idx", 147L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "business0", "rows", 1L, "idx", 112L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "entertainment0", "rows", 1L, "idx", 166L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "health0", "rows", 1L, "idx", 113L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "mezzanine0", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "news0", "rows", 1L, "idx", 114L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "premium0", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "technology0", "rows", 1L, "idx", 97L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "travel0", "rows", 1L, "idx", 126L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "rebucket-rename");
    }

    @Test
    public void testGroupByWithSimpleRenameRetainMissingNonInjective() {
        this.cannotVectorize();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("automotive", "automotive0");
        map.put("business", "business0");
        map.put("entertainment", "entertainment0");
        map.put("health", "health0");
        map.put("mezzanine", "mezzanine0");
        map.put("news", "news0");
        map.put("premium", "premium0");
        map.put("technology", "technology0");
        map.put("travel", "travel0");
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new ExtractionDimensionSpec("quality", "alias", (ExtractionFn)new LookupExtractionFn((LookupExtractor)new MapLookupExtractor(map, false), true, null, Boolean.valueOf(false), Boolean.valueOf(false)))}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "automotive0", "rows", 1L, "idx", 135L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "business0", "rows", 1L, "idx", 118L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "entertainment0", "rows", 1L, "idx", 158L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "health0", "rows", 1L, "idx", 120L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "mezzanine0", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "news0", "rows", 1L, "idx", 121L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "premium0", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "technology0", "rows", 1L, "idx", 78L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "travel0", "rows", 1L, "idx", 119L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "automotive0", "rows", 1L, "idx", 147L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "business0", "rows", 1L, "idx", 112L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "entertainment0", "rows", 1L, "idx", 166L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "health0", "rows", 1L, "idx", 113L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "mezzanine0", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "news0", "rows", 1L, "idx", 114L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "premium0", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "technology0", "rows", 1L, "idx", 97L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "travel0", "rows", 1L, "idx", 126L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "non-injective");
    }

    @Test
    public void testGroupByWithSimpleRenameRetainMissing() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("automotive", "automotive0");
        map.put("business", "business0");
        map.put("entertainment", "entertainment0");
        map.put("health", "health0");
        map.put("mezzanine", "mezzanine0");
        map.put("news", "news0");
        map.put("premium", "premium0");
        map.put("technology", "technology0");
        map.put("travel", "travel0");
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new ExtractionDimensionSpec("quality", "alias", (ExtractionFn)new LookupExtractionFn((LookupExtractor)new MapLookupExtractor(map, false), true, null, Boolean.valueOf(true), Boolean.valueOf(false)))}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "automotive0", "rows", 1L, "idx", 135L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "business0", "rows", 1L, "idx", 118L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "entertainment0", "rows", 1L, "idx", 158L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "health0", "rows", 1L, "idx", 120L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "mezzanine0", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "news0", "rows", 1L, "idx", 121L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "premium0", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "technology0", "rows", 1L, "idx", 78L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "travel0", "rows", 1L, "idx", 119L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "automotive0", "rows", 1L, "idx", 147L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "business0", "rows", 1L, "idx", 112L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "entertainment0", "rows", 1L, "idx", 166L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "health0", "rows", 1L, "idx", 113L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "mezzanine0", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "news0", "rows", 1L, "idx", 114L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "premium0", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "technology0", "rows", 1L, "idx", 97L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "travel0", "rows", 1L, "idx", 126L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "retain-missing");
    }

    @Test
    public void testGroupByWithSimpleRenameAndMissingString() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("automotive", "automotive0");
        map.put("business", "business0");
        map.put("entertainment", "entertainment0");
        map.put("health", "health0");
        map.put("mezzanine", "mezzanine0");
        map.put("news", "news0");
        map.put("premium", "premium0");
        map.put("technology", "technology0");
        map.put("travel", "travel0");
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new ExtractionDimensionSpec("quality", "alias", (ExtractionFn)new LookupExtractionFn((LookupExtractor)new MapLookupExtractor(map, false), false, "MISSING", Boolean.valueOf(true), Boolean.valueOf(false)))}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "automotive0", "rows", 1L, "idx", 135L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "business0", "rows", 1L, "idx", 118L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "entertainment0", "rows", 1L, "idx", 158L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "health0", "rows", 1L, "idx", 120L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "mezzanine0", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "news0", "rows", 1L, "idx", 121L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "premium0", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "technology0", "rows", 1L, "idx", 78L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "travel0", "rows", 1L, "idx", 119L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "automotive0", "rows", 1L, "idx", 147L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "business0", "rows", 1L, "idx", 112L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "entertainment0", "rows", 1L, "idx", 166L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "health0", "rows", 1L, "idx", 113L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "mezzanine0", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "news0", "rows", 1L, "idx", 114L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "premium0", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "technology0", "rows", 1L, "idx", 97L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "travel0", "rows", 1L, "idx", 126L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "rename-and-missing-string");
    }

    @Test
    public void testGroupByWithSimpleRename() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("automotive", "automotive0");
        map.put("business", "business0");
        map.put("entertainment", "entertainment0");
        map.put("health", "health0");
        map.put("mezzanine", "mezzanine0");
        map.put("news", "news0");
        map.put("premium", "premium0");
        map.put("technology", "technology0");
        map.put("travel", "travel0");
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new ExtractionDimensionSpec("quality", "alias", (ExtractionFn)new LookupExtractionFn((LookupExtractor)new MapLookupExtractor(map, false), false, null, Boolean.valueOf(true), Boolean.valueOf(false)))}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "automotive0", "rows", 1L, "idx", 135L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "business0", "rows", 1L, "idx", 118L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "entertainment0", "rows", 1L, "idx", 158L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "health0", "rows", 1L, "idx", 120L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "mezzanine0", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "news0", "rows", 1L, "idx", 121L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "premium0", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "technology0", "rows", 1L, "idx", 78L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "travel0", "rows", 1L, "idx", 119L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "automotive0", "rows", 1L, "idx", 147L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "business0", "rows", 1L, "idx", 112L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "entertainment0", "rows", 1L, "idx", 166L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "health0", "rows", 1L, "idx", 113L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "mezzanine0", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "news0", "rows", 1L, "idx", 114L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "premium0", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "technology0", "rows", 1L, "idx", 97L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "travel0", "rows", 1L, "idx", 126L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "simple-rename");
    }

    @Test
    public void testGroupByWithUniques() {
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.QUALITY_UNIQUES}).setGranularity(QueryRunnerTestHelper.ALL_GRAN).build();
        List<ResultRow> expectedResults = Collections.singletonList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "rows", 26L, "uniques", 9.019833517963864));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "uniques");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGroupByWithUniquesAndPostAggWithSameName() {
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new HyperUniquesAggregatorFactory("quality_uniques", "quality_uniques")}).setPostAggregatorSpecs(Collections.singletonList(new HyperUniqueFinalizingPostAggregator("quality_uniques", "quality_uniques"))).setGranularity(QueryRunnerTestHelper.ALL_GRAN).build();
        List<ResultRow> expectedResults = Collections.singletonList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "rows", 26L, "quality_uniques", 9.019833517963864));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "unique-postagg-same-name");
    }

    @Test
    public void testGroupByWithCardinality() {
        this.cannotVectorize();
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.QUALITY_CARDINALITY}).setGranularity(QueryRunnerTestHelper.ALL_GRAN).build();
        List<ResultRow> expectedResults = Collections.singletonList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "rows", 26L, "cardinality", 9.019833517963864));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "cardinality");
    }

    @Test
    public void testGroupByWithFirstLast() {
        this.cannotVectorize();
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("market", "market")}).setAggregatorSpecs(new AggregatorFactory[]{new LongFirstAggregatorFactory("first", "index"), new LongLastAggregatorFactory("last", "index")}).setGranularity(QueryRunnerTestHelper.MONTH_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-01-01", "market", "spot", "first", 100L, "last", 155L), GroupByQueryRunnerTest.makeRow(query, "2011-01-01", "market", "total_market", "first", 1000L, "last", 1127L), GroupByQueryRunnerTest.makeRow(query, "2011-01-01", "market", "upfront", "first", 800L, "last", 943L), GroupByQueryRunnerTest.makeRow(query, "2011-02-01", "market", "spot", "first", 132L, "last", 114L), GroupByQueryRunnerTest.makeRow(query, "2011-02-01", "market", "total_market", "first", 1203L, "last", 1292L), GroupByQueryRunnerTest.makeRow(query, "2011-02-01", "market", "upfront", "first", 1667L, "last", 1101L), GroupByQueryRunnerTest.makeRow(query, "2011-03-01", "market", "spot", "first", 153L, "last", 125L), GroupByQueryRunnerTest.makeRow(query, "2011-03-01", "market", "total_market", "first", 1124L, "last", 1366L), GroupByQueryRunnerTest.makeRow(query, "2011-03-01", "market", "upfront", "first", 1166L, "last", 1063L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "market", "spot", "first", 135L, "last", 120L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "market", "total_market", "first", 1314L, "last", 1029L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "market", "upfront", "first", 1447L, "last", 780L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "first-last-aggs");
    }

    @Test
    public void testGroupByWithNoResult() {
        this.cannotVectorize();
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.EMPTY_INTERVAL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("market", "market")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.INDEX_LONG_SUM, QueryRunnerTestHelper.QUALITY_CARDINALITY, new LongFirstAggregatorFactory("first", "index"), new LongLastAggregatorFactory("last", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        ImmutableList expectedResults = ImmutableList.of();
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        Assert.assertEquals((Object)expectedResults, results);
    }

    @Test
    public void testGroupByWithNullProducingDimExtractionFn() {
        this.cannotVectorize();
        RegexDimExtractionFn nullExtractionFn = new RegexDimExtractionFn("(\\w{1})", false, null){

            public byte[] getCacheKey() {
                return new byte[]{-1};
            }

            public String apply(String dimValue) {
                return "mezzanine".equals(dimValue) ? null : super.apply(dimValue);
            }
        };
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).setDimensions(new DimensionSpec[]{new ExtractionDimensionSpec("quality", "alias", (ExtractionFn)nullExtractionFn)}).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", null, "rows", 3L, "idx", 2870L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "a", "rows", 1L, "idx", 135L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "b", "rows", 1L, "idx", 118L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "e", "rows", 1L, "idx", 158L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "h", "rows", 1L, "idx", 120L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "n", "rows", 1L, "idx", 121L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "p", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "t", "rows", 2L, "idx", 197L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", null, "rows", 3L, "idx", 2447L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "a", "rows", 1L, "idx", 147L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "b", "rows", 1L, "idx", 112L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "e", "rows", 1L, "idx", 166L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "h", "rows", 1L, "idx", 113L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "n", "rows", 1L, "idx", 114L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "p", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "t", "rows", 2L, "idx", 223L));
        TestHelper.assertExpectedObjects(expectedResults, GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query), "null-dimextraction");
    }

    @Test
    @Ignore
    public void testGroupByWithEmptyStringProducingDimExtractionFn() {
        RegexDimExtractionFn emptyStringExtractionFn = new RegexDimExtractionFn("(\\w{1})", false, null){

            public byte[] getCacheKey() {
                return new byte[]{-1};
            }

            public String apply(String dimValue) {
                return "mezzanine".equals(dimValue) ? "" : super.apply(dimValue);
            }
        };
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).setDimensions(new DimensionSpec[]{new ExtractionDimensionSpec("quality", "alias", (ExtractionFn)emptyStringExtractionFn)}).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "a", "rows", 1L, "idx", 135L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "b", "rows", 1L, "idx", 118L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "e", "rows", 1L, "idx", 158L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "h", "rows", 1L, "idx", 120L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "n", "rows", 1L, "idx", 121L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "p", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "t", "rows", 2L, "idx", 197L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "a", "rows", 1L, "idx", 147L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "b", "rows", 1L, "idx", 112L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "e", "rows", 1L, "idx", 166L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "h", "rows", 1L, "idx", 113L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "n", "rows", 1L, "idx", 114L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "p", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "t", "rows", 2L, "idx", 223L));
        TestHelper.assertExpectedObjects(expectedResults, GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query), "empty-string-dimextraction");
    }

    @Test
    public void testGroupByWithTimeZone() {
        DateTimeZone tz = DateTimes.inferTzFromString((String)"America/Los_Angeles");
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setInterval("2011-03-31T00:00:00-07:00/2011-04-02T00:00:00-07:00").setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity((Granularity)new PeriodGranularity(new Period((Object)"P1D"), null, tz)).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, new DateTime((Object)"2011-03-31", tz), "alias", "automotive", "rows", 1L, "idx", 135L), GroupByQueryRunnerTest.makeRow(query, new DateTime((Object)"2011-03-31", tz), "alias", "business", "rows", 1L, "idx", 118L), GroupByQueryRunnerTest.makeRow(query, new DateTime((Object)"2011-03-31", tz), "alias", "entertainment", "rows", 1L, "idx", 158L), GroupByQueryRunnerTest.makeRow(query, new DateTime((Object)"2011-03-31", tz), "alias", "health", "rows", 1L, "idx", 120L), GroupByQueryRunnerTest.makeRow(query, new DateTime((Object)"2011-03-31", tz), "alias", "mezzanine", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTest.makeRow(query, new DateTime((Object)"2011-03-31", tz), "alias", "news", "rows", 1L, "idx", 121L), GroupByQueryRunnerTest.makeRow(query, new DateTime((Object)"2011-03-31", tz), "alias", "premium", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTest.makeRow(query, new DateTime((Object)"2011-03-31", tz), "alias", "technology", "rows", 1L, "idx", 78L), GroupByQueryRunnerTest.makeRow(query, new DateTime((Object)"2011-03-31", tz), "alias", "travel", "rows", 1L, "idx", 119L), GroupByQueryRunnerTest.makeRow(query, new DateTime((Object)"2011-04-01", tz), "alias", "automotive", "rows", 1L, "idx", 147L), GroupByQueryRunnerTest.makeRow(query, new DateTime((Object)"2011-04-01", tz), "alias", "business", "rows", 1L, "idx", 112L), GroupByQueryRunnerTest.makeRow(query, new DateTime((Object)"2011-04-01", tz), "alias", "entertainment", "rows", 1L, "idx", 166L), GroupByQueryRunnerTest.makeRow(query, new DateTime((Object)"2011-04-01", tz), "alias", "health", "rows", 1L, "idx", 113L), GroupByQueryRunnerTest.makeRow(query, new DateTime((Object)"2011-04-01", tz), "alias", "mezzanine", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTest.makeRow(query, new DateTime((Object)"2011-04-01", tz), "alias", "news", "rows", 1L, "idx", 114L), GroupByQueryRunnerTest.makeRow(query, new DateTime((Object)"2011-04-01", tz), "alias", "premium", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTest.makeRow(query, new DateTime((Object)"2011-04-01", tz), "alias", "technology", "rows", 1L, "idx", 97L), GroupByQueryRunnerTest.makeRow(query, new DateTime((Object)"2011-04-01", tz), "alias", "travel", "rows", 1L, "idx", 126L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "timezone");
    }

    @Test
    public void testMergeResults() {
        GroupByQuery.Builder builder = this.makeQueryBuilder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null));
        GroupByQuery fullQuery = builder.build();
        GroupByQuery allGranQuery = builder.copy().setGranularity(Granularities.ALL).build();
        QueryRunner mergedRunner = this.factory.getToolchest().mergeResults((QueryRunner)new QueryRunner<ResultRow>(){

            public Sequence<ResultRow> run(QueryPlus<ResultRow> queryPlus, ResponseContext responseContext) {
                QueryPlus queryPlus1 = queryPlus.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.of((String)"2011-04-02/2011-04-03"))));
                QueryPlus queryPlus2 = queryPlus.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.of((String)"2011-04-03/2011-04-04"))));
                return new MergeSequence(queryPlus.getQuery().getResultOrdering(), Sequences.simple(Arrays.asList(GroupByQueryRunnerTest.this.runner.run(queryPlus1, responseContext), GroupByQueryRunnerTest.this.runner.run(queryPlus2, responseContext))));
            }
        });
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "automotive", "rows", 2L, "idx", 269L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "business", "rows", 2L, "idx", 217L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "entertainment", "rows", 2L, "idx", 319L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "health", "rows", 2L, "idx", 216L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "mezzanine", "rows", 6L, "idx", 4420L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "news", "rows", 2L, "idx", 221L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "premium", "rows", 6L, "idx", 4416L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "technology", "rows", 2L, "idx", 177L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "travel", "rows", 2L, "idx", 243L));
        ResponseContext context = ResponseContext.createEmpty();
        TestHelper.assertExpectedObjects(expectedResults, mergedRunner.run(QueryPlus.wrap((Query)fullQuery)), "merged");
        List<ResultRow> allGranExpectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(allGranQuery, "2011-04-02", "alias", "automotive", "rows", 2L, "idx", 269L), GroupByQueryRunnerTest.makeRow(allGranQuery, "2011-04-02", "alias", "business", "rows", 2L, "idx", 217L), GroupByQueryRunnerTest.makeRow(allGranQuery, "2011-04-02", "alias", "entertainment", "rows", 2L, "idx", 319L), GroupByQueryRunnerTest.makeRow(allGranQuery, "2011-04-02", "alias", "health", "rows", 2L, "idx", 216L), GroupByQueryRunnerTest.makeRow(allGranQuery, "2011-04-02", "alias", "mezzanine", "rows", 6L, "idx", 4420L), GroupByQueryRunnerTest.makeRow(allGranQuery, "2011-04-02", "alias", "news", "rows", 2L, "idx", 221L), GroupByQueryRunnerTest.makeRow(allGranQuery, "2011-04-02", "alias", "premium", "rows", 6L, "idx", 4416L), GroupByQueryRunnerTest.makeRow(allGranQuery, "2011-04-02", "alias", "technology", "rows", 2L, "idx", 177L), GroupByQueryRunnerTest.makeRow(allGranQuery, "2011-04-02", "alias", "travel", "rows", 2L, "idx", 243L));
        TestHelper.assertExpectedObjects(allGranExpectedResults, mergedRunner.run(QueryPlus.wrap((Query)allGranQuery)), "merged");
    }

    @Test
    public void testMergeResultsWithLimit() {
        for (int limit = 1; limit < 20; ++limit) {
            this.doTestMergeResultsWithValidLimit(limit);
        }
    }

    private void doTestMergeResultsWithValidLimit(int limit) {
        GroupByQuery.Builder builder = this.makeQueryBuilder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).setLimit(limit);
        GroupByQuery fullQuery = builder.build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "automotive", "rows", 2L, "idx", 269L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "business", "rows", 2L, "idx", 217L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "entertainment", "rows", 2L, "idx", 319L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "health", "rows", 2L, "idx", 216L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "mezzanine", "rows", 6L, "idx", 4420L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "news", "rows", 2L, "idx", 221L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "premium", "rows", 6L, "idx", 4416L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "technology", "rows", 2L, "idx", 177L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "travel", "rows", 2L, "idx", 243L));
        QueryRunner mergeRunner = this.factory.getToolchest().mergeResults(this.runner);
        TestHelper.assertExpectedObjects(Iterables.limit(expectedResults, (int)limit), mergeRunner.run(QueryPlus.wrap((Query)fullQuery)), StringUtils.format((String)"limit: %d", (Object[])new Object[]{limit}));
    }

    @Test
    public void testMergeResultsAcrossMultipleDaysWithLimitAndOrderBy() {
        int limit = 14;
        GroupByQuery.Builder builder = this.makeQueryBuilder().setDataSource("testing").setInterval(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(Granularities.DAY).setLimit(14).addOrderByColumn("idx", OrderByColumnSpec.Direction.DESCENDING);
        GroupByQuery fullQuery = builder.build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "premium", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "mezzanine", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "entertainment", "rows", 1L, "idx", 158L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "automotive", "rows", 1L, "idx", 135L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "news", "rows", 1L, "idx", 121L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "health", "rows", 1L, "idx", 120L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "travel", "rows", 1L, "idx", 119L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "business", "rows", 1L, "idx", 118L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "technology", "rows", 1L, "idx", 78L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-02", "alias", "premium", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-02", "alias", "mezzanine", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-02", "alias", "entertainment", "rows", 1L, "idx", 166L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-02", "alias", "automotive", "rows", 1L, "idx", 147L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-02", "alias", "travel", "rows", 1L, "idx", 126L));
        QueryRunner mergeRunner = this.factory.getToolchest().mergeResults(this.runner);
        TestHelper.assertExpectedObjects(Iterables.limit(expectedResults, (int)14), mergeRunner.run(QueryPlus.wrap((Query)fullQuery)), StringUtils.format((String)"limit: %d", (Object[])new Object[]{14}));
    }

    @Test
    public void testMergeResultsAcrossMultipleDaysWithLimitAndOrderByUsingMathExpressions() {
        this.cannotVectorize();
        int limit = 14;
        GroupByQuery.Builder builder = this.makeQueryBuilder().setDataSource("testing").setInterval(QueryRunnerTestHelper.FIRST_TO_THIRD).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("expr", "index * 2 + indexMin / 10", ValueType.FLOAT, TestExprMacroTable.INSTANCE)}).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "expr")}).setGranularity(Granularities.DAY).setLimit(14).addOrderByColumn("idx", OrderByColumnSpec.Direction.DESCENDING);
        GroupByQuery fullQuery = builder.build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "premium", "rows", 3L, "idx", 6090L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "mezzanine", "rows", 3L, "idx", 6030L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "entertainment", "rows", 1L, "idx", 333L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "automotive", "rows", 1L, "idx", 285L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "news", "rows", 1L, "idx", 255L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "health", "rows", 1L, "idx", 252L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "travel", "rows", 1L, "idx", 251L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "business", "rows", 1L, "idx", 248L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "technology", "rows", 1L, "idx", 165L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-02", "alias", "premium", "rows", 3L, "idx", 5262L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-02", "alias", "mezzanine", "rows", 3L, "idx", 5141L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-02", "alias", "entertainment", "rows", 1L, "idx", 348L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-02", "alias", "automotive", "rows", 1L, "idx", 309L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-02", "alias", "travel", "rows", 1L, "idx", 265L));
        QueryRunner mergeRunner = this.factory.getToolchest().mergeResults(this.runner);
        TestHelper.assertExpectedObjects(Iterables.limit(expectedResults, (int)14), mergeRunner.run(QueryPlus.wrap((Query)fullQuery)), StringUtils.format((String)"limit: %d", (Object[])new Object[]{14}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMergeResultsWithNegativeLimit() {
        GroupByQuery.Builder builder = this.makeQueryBuilder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).setLimit(-1);
        builder.build();
    }

    @Test
    public void testMergeResultsWithOrderBy() {
        LimitSpec[] orderBySpecs = new LimitSpec[]{new DefaultLimitSpec(OrderByColumnSpec.ascending((String[])new String[]{"idx"}), null), new DefaultLimitSpec(OrderByColumnSpec.ascending((String[])new String[]{"rows", "idx"}), null), new DefaultLimitSpec(OrderByColumnSpec.descending((String[])new String[]{"idx"}), null), new DefaultLimitSpec(OrderByColumnSpec.descending((String[])new String[]{"rows", "idx"}), null)};
        GroupByQuery baseQuery = this.makeQueryBuilder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).build();
        List<ResultRow> allResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(baseQuery, "2011-04-01", "alias", "automotive", "rows", 2L, "idx", 269L), GroupByQueryRunnerTest.makeRow(baseQuery, "2011-04-01", "alias", "business", "rows", 2L, "idx", 217L), GroupByQueryRunnerTest.makeRow(baseQuery, "2011-04-01", "alias", "entertainment", "rows", 2L, "idx", 319L), GroupByQueryRunnerTest.makeRow(baseQuery, "2011-04-01", "alias", "health", "rows", 2L, "idx", 216L), GroupByQueryRunnerTest.makeRow(baseQuery, "2011-04-01", "alias", "mezzanine", "rows", 6L, "idx", 4420L), GroupByQueryRunnerTest.makeRow(baseQuery, "2011-04-01", "alias", "news", "rows", 2L, "idx", 221L), GroupByQueryRunnerTest.makeRow(baseQuery, "2011-04-01", "alias", "premium", "rows", 6L, "idx", 4416L), GroupByQueryRunnerTest.makeRow(baseQuery, "2011-04-01", "alias", "technology", "rows", 2L, "idx", 177L), GroupByQueryRunnerTest.makeRow(baseQuery, "2011-04-01", "alias", "travel", "rows", 2L, "idx", 243L));
        int idxPosition = baseQuery.getResultRowPositionLookup().getInt((Object)"idx");
        int rowsPosition = baseQuery.getResultRowPositionLookup().getInt((Object)"rows");
        Comparator<ResultRow> idxComparator = Comparator.comparing(row -> Float.valueOf(((Number)row.get(idxPosition)).floatValue()));
        Comparator<ResultRow> rowsComparator = Comparator.comparing(row -> Float.valueOf(((Number)row.get(rowsPosition)).floatValue()));
        Comparator rowsIdxComparator = Ordering.from(rowsComparator).thenComparing(idxComparator);
        ArrayList expectedResults = Lists.newArrayList((Object[])new List[]{Ordering.from(idxComparator).sortedCopy(allResults), Ordering.from((Comparator)rowsIdxComparator).sortedCopy(allResults), Ordering.from(idxComparator).reverse().sortedCopy(allResults), Ordering.from((Comparator)rowsIdxComparator).reverse().sortedCopy(allResults)});
        for (int i = 0; i < orderBySpecs.length; ++i) {
            this.doTestMergeResultsWithOrderBy(baseQuery, orderBySpecs[i], (List)expectedResults.get(i));
        }
    }

    private void doTestMergeResultsWithOrderBy(GroupByQuery baseQuery, LimitSpec limitSpec, List<ResultRow> expectedResults) {
        QueryRunner mergedRunner = this.factory.getToolchest().mergeResults((QueryRunner)new QueryRunner<ResultRow>(){

            public Sequence<ResultRow> run(QueryPlus<ResultRow> queryPlus, ResponseContext responseContext) {
                QueryPlus queryPlus1 = queryPlus.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.of((String)"2011-04-02/2011-04-03"))));
                QueryPlus queryPlus2 = queryPlus.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.of((String)"2011-04-03/2011-04-04"))));
                return new MergeSequence(queryPlus.getQuery().getResultOrdering(), Sequences.simple(Arrays.asList(GroupByQueryRunnerTest.this.runner.run(queryPlus1, responseContext), GroupByQueryRunnerTest.this.runner.run(queryPlus2, responseContext))));
            }
        });
        GroupByQuery query = baseQuery.withLimitSpec(limitSpec);
        TestHelper.assertExpectedObjects(expectedResults, mergedRunner.run(QueryPlus.wrap((Query)query)), "merged");
    }

    @Test
    public void testGroupByOrderLimit() {
        this.cannotVectorize();
        GroupByQuery.Builder builder = this.makeQueryBuilder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).addOrderByColumn("rows").addOrderByColumn("alias", OrderByColumnSpec.Direction.DESCENDING).setGranularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null));
        GroupByQuery query = builder.build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "travel", "rows", 2L, "idx", 243L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "technology", "rows", 2L, "idx", 177L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "news", "rows", 2L, "idx", 221L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "health", "rows", 2L, "idx", 216L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "entertainment", "rows", 2L, "idx", 319L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "business", "rows", 2L, "idx", 217L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "automotive", "rows", 2L, "idx", 269L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "premium", "rows", 6L, "idx", 4416L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "mezzanine", "rows", 6L, "idx", 4420L));
        QueryRunner mergeRunner = this.factory.getToolchest().mergeResults(this.runner);
        TestHelper.assertExpectedObjects(expectedResults, mergeRunner.run(QueryPlus.wrap((Query)query)), "no-limit");
        TestHelper.assertExpectedObjects(Iterables.limit(expectedResults, (int)5), mergeRunner.run(QueryPlus.wrap((Query)builder.setLimit(5).build())), "limited");
        List<AggregatorFactory> aggregatorSpecs = Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, new DoubleSumAggregatorFactory("idx", null, "index / 2 + indexMin", TestExprMacroTable.INSTANCE));
        builder.setLimit(Integer.MAX_VALUE).setAggregatorSpecs(aggregatorSpecs);
        expectedResults = GroupByQueryRunnerTest.makeRows(builder.build(), new String[]{"__time", "alias", "rows", "idx"}, {"2011-04-01", "travel", 2L, 365.4876403808594}, {"2011-04-01", "technology", 2L, 267.3737487792969}, {"2011-04-01", "news", 2L, 333.3147277832031}, {"2011-04-01", "health", 2L, 325.467529296875}, {"2011-04-01", "entertainment", 2L, 479.916015625}, {"2011-04-01", "business", 2L, 328.083740234375}, {"2011-04-01", "automotive", 2L, 405.5966796875}, {"2011-04-01", "premium", 6L, 6627.927734375}, {"2011-04-01", "mezzanine", 6L, 6635.47998046875});
        TestHelper.assertExpectedObjects(expectedResults, mergeRunner.run(QueryPlus.wrap((Query)builder.build())), "no-limit");
        TestHelper.assertExpectedObjects(Iterables.limit(expectedResults, (int)5), mergeRunner.run(QueryPlus.wrap((Query)builder.setLimit(5).build())), "limited");
        ExpressionVirtualColumn expressionVirtualColumn = new ExpressionVirtualColumn("expr", "index / 2 + indexMin", ValueType.FLOAT, TestExprMacroTable.INSTANCE);
        List<AggregatorFactory> aggregatorSpecs2 = Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, new DoubleSumAggregatorFactory("idx", "expr"));
        builder.setLimit(Integer.MAX_VALUE).setVirtualColumns(new VirtualColumn[]{expressionVirtualColumn}).setAggregatorSpecs(aggregatorSpecs2);
        TestHelper.assertExpectedObjects(expectedResults, mergeRunner.run(QueryPlus.wrap((Query)builder.build())), "no-limit");
        TestHelper.assertExpectedObjects(Iterables.limit(expectedResults, (int)5), mergeRunner.run(QueryPlus.wrap((Query)builder.setLimit(5).build())), "limited");
    }

    @Test
    public void testGroupByWithOrderLimit2() {
        GroupByQuery.Builder builder = this.makeQueryBuilder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).addOrderByColumn("rows", OrderByColumnSpec.Direction.DESCENDING).addOrderByColumn("alias", OrderByColumnSpec.Direction.DESCENDING).setGranularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null));
        GroupByQuery query = builder.build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "premium", "rows", 6L, "idx", 4416L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "mezzanine", "rows", 6L, "idx", 4420L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "travel", "rows", 2L, "idx", 243L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "technology", "rows", 2L, "idx", 177L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "news", "rows", 2L, "idx", 221L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "health", "rows", 2L, "idx", 216L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "entertainment", "rows", 2L, "idx", 319L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "business", "rows", 2L, "idx", 217L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "automotive", "rows", 2L, "idx", 269L));
        QueryRunner mergeRunner = this.factory.getToolchest().mergeResults(this.runner);
        TestHelper.assertExpectedObjects(expectedResults, mergeRunner.run(QueryPlus.wrap((Query)query)), "no-limit");
        TestHelper.assertExpectedObjects(Iterables.limit(expectedResults, (int)5), mergeRunner.run(QueryPlus.wrap((Query)builder.setLimit(5).build())), "limited");
    }

    @Test
    public void testGroupByWithOrderLimit3() {
        GroupByQuery.Builder builder = this.makeQueryBuilder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new DoubleSumAggregatorFactory("idx", "index")}).addOrderByColumn("idx", OrderByColumnSpec.Direction.DESCENDING).addOrderByColumn("alias", OrderByColumnSpec.Direction.DESCENDING).setGranularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null));
        GroupByQuery query = builder.build();
        List<ResultRow> expectedResults = GroupByQueryRunnerTest.makeRows(query, new String[]{"__time", "alias", "rows", "idx"}, {"2011-04-01", "mezzanine", 6L, 4423.6533203125}, {"2011-04-01", "premium", 6L, 4418.61865234375}, {"2011-04-01", "entertainment", 2L, 319.94403076171875}, {"2011-04-01", "automotive", 2L, 270.3977966308594}, {"2011-04-01", "travel", 2L, 243.65843200683594}, {"2011-04-01", "news", 2L, 222.20980834960938}, {"2011-04-01", "business", 2L, 218.7224884033203}, {"2011-04-01", "health", 2L, 216.97836303710938}, {"2011-04-01", "technology", 2L, 178.24917602539062});
        QueryRunner mergeRunner = this.factory.getToolchest().mergeResults(this.runner);
        TestHelper.assertExpectedObjects(expectedResults, mergeRunner.run(QueryPlus.wrap((Query)query)), "no-limit");
        TestHelper.assertExpectedObjects(Iterables.limit(expectedResults, (int)5), mergeRunner.run(QueryPlus.wrap((Query)builder.setLimit(5).build())), "limited");
    }

    @Test
    public void testGroupByOrderLimitNumeric() {
        GroupByQuery.Builder builder = this.makeQueryBuilder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).addOrderByColumn(new OrderByColumnSpec("rows", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)).addOrderByColumn(new OrderByColumnSpec("alias", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC)).setGranularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null));
        GroupByQuery query = builder.build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "mezzanine", "rows", 6L, "idx", 4420L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "premium", "rows", 6L, "idx", 4416L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "automotive", "rows", 2L, "idx", 269L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "business", "rows", 2L, "idx", 217L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "entertainment", "rows", 2L, "idx", 319L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "health", "rows", 2L, "idx", 216L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "news", "rows", 2L, "idx", 221L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "technology", "rows", 2L, "idx", 177L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "travel", "rows", 2L, "idx", 243L));
        QueryRunner mergeRunner = this.factory.getToolchest().mergeResults(this.runner);
        TestHelper.assertExpectedObjects(expectedResults, mergeRunner.run(QueryPlus.wrap((Query)query)), "no-limit");
        TestHelper.assertExpectedObjects(Iterables.limit(expectedResults, (int)5), mergeRunner.run(QueryPlus.wrap((Query)builder.setLimit(5).build())), "limited");
    }

    @Test
    public void testGroupByWithSameCaseOrdering() {
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setGranularity(QueryRunnerTestHelper.ALL_GRAN).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("market", "marketalias")}).setInterval(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).setLimitSpec((LimitSpec)new DefaultLimitSpec(Collections.singletonList(new OrderByColumnSpec("marketalias", OrderByColumnSpec.Direction.DESCENDING)), Integer.valueOf(3))).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT}).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "1970-01-01T00:00:00.000Z", "marketalias", "upfront", "rows", 186L), GroupByQueryRunnerTest.makeRow(query, "1970-01-01T00:00:00.000Z", "marketalias", "total_market", "rows", 186L), GroupByQueryRunnerTest.makeRow(query, "1970-01-01T00:00:00.000Z", "marketalias", "spot", "rows", 837L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "order-limit");
    }

    @Test
    public void testGroupByWithOrderLimit4() {
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setGranularity(QueryRunnerTestHelper.ALL_GRAN).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("market", "market")}).setInterval(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).setLimitSpec((LimitSpec)new DefaultLimitSpec(Collections.singletonList(new OrderByColumnSpec("market", OrderByColumnSpec.Direction.DESCENDING)), Integer.valueOf(3))).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT}).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "1970-01-01T00:00:00.000Z", "market", "upfront", "rows", 186L), GroupByQueryRunnerTest.makeRow(query, "1970-01-01T00:00:00.000Z", "market", "total_market", "rows", 186L), GroupByQueryRunnerTest.makeRow(query, "1970-01-01T00:00:00.000Z", "market", "spot", "rows", 837L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "order-limit");
    }

    @Test
    public void testGroupByWithOrderOnHyperUnique() {
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setGranularity(QueryRunnerTestHelper.ALL_GRAN).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("market", "market")}).setInterval(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).setLimitSpec((LimitSpec)new DefaultLimitSpec(Collections.singletonList(new OrderByColumnSpec("uniques", OrderByColumnSpec.Direction.DESCENDING)), Integer.valueOf(3))).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.QUALITY_UNIQUES}).setPostAggregatorSpecs(Collections.singletonList(new HyperUniqueFinalizingPostAggregator("hyperUniqueFinalizingPostAggMetric", "uniques"))).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "1970-01-01T00:00:00.000Z", "market", "spot", "uniques", 9.019833517963864, "hyperUniqueFinalizingPostAggMetric", 9.019833517963864), GroupByQueryRunnerTest.makeRow(query, "1970-01-01T00:00:00.000Z", "market", "upfront", "uniques", 2.000977198748901, "hyperUniqueFinalizingPostAggMetric", 2.000977198748901), GroupByQueryRunnerTest.makeRow(query, "1970-01-01T00:00:00.000Z", "market", "total_market", "uniques", 2.000977198748901, "hyperUniqueFinalizingPostAggMetric", 2.000977198748901));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "order-limit");
    }

    @Test
    public void testGroupByWithHavingOnHyperUnique() {
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setGranularity(QueryRunnerTestHelper.ALL_GRAN).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("market", "market")}).setInterval(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).setLimitSpec((LimitSpec)new DefaultLimitSpec(Collections.singletonList(new OrderByColumnSpec("uniques", OrderByColumnSpec.Direction.DESCENDING)), Integer.valueOf(3))).setHavingSpec((HavingSpec)new GreaterThanHavingSpec("uniques", (Number)8)).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.QUALITY_UNIQUES}).setPostAggregatorSpecs(Collections.singletonList(new HyperUniqueFinalizingPostAggregator("hyperUniqueFinalizingPostAggMetric", "uniques"))).build();
        List<ResultRow> expectedResults = Collections.singletonList(GroupByQueryRunnerTest.makeRow(query, "1970-01-01T00:00:00.000Z", "market", "spot", "uniques", 9.019833517963864, "hyperUniqueFinalizingPostAggMetric", 9.019833517963864));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "order-limit");
    }

    @Test
    public void testGroupByWithHavingOnFinalizedHyperUnique() {
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setGranularity(QueryRunnerTestHelper.ALL_GRAN).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("market", "market")}).setInterval(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).setLimitSpec((LimitSpec)new DefaultLimitSpec(Collections.singletonList(new OrderByColumnSpec("hyperUniqueFinalizingPostAggMetric", OrderByColumnSpec.Direction.DESCENDING)), Integer.valueOf(3))).setHavingSpec((HavingSpec)new GreaterThanHavingSpec("hyperUniqueFinalizingPostAggMetric", (Number)8)).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.QUALITY_UNIQUES}).setPostAggregatorSpecs(Collections.singletonList(new HyperUniqueFinalizingPostAggregator("hyperUniqueFinalizingPostAggMetric", "uniques"))).build();
        List<ResultRow> expectedResults = Collections.singletonList(GroupByQueryRunnerTest.makeRow(query, "1970-01-01T00:00:00.000Z", "market", "spot", "uniques", 9.019833517963864, "hyperUniqueFinalizingPostAggMetric", 9.019833517963864));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "order-limit");
    }

    @Test
    public void testGroupByWithLimitOnFinalizedHyperUnique() {
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setGranularity(QueryRunnerTestHelper.ALL_GRAN).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("market", "market")}).setInterval(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).setLimitSpec((LimitSpec)new DefaultLimitSpec(Collections.singletonList(new OrderByColumnSpec("hyperUniqueFinalizingPostAggMetric", OrderByColumnSpec.Direction.DESCENDING)), Integer.valueOf(3))).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.QUALITY_UNIQUES}).setPostAggregatorSpecs(Collections.singletonList(new HyperUniqueFinalizingPostAggregator("hyperUniqueFinalizingPostAggMetric", "uniques"))).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "1970-01-01T00:00:00.000Z", "market", "spot", "uniques", 9.019833517963864, "hyperUniqueFinalizingPostAggMetric", 9.019833517963864), GroupByQueryRunnerTest.makeRow(query, "1970-01-01T00:00:00.000Z", "market", "upfront", "uniques", 2.000977198748901, "hyperUniqueFinalizingPostAggMetric", 2.000977198748901), GroupByQueryRunnerTest.makeRow(query, "1970-01-01T00:00:00.000Z", "market", "total_market", "uniques", 2.000977198748901, "hyperUniqueFinalizingPostAggMetric", 2.000977198748901));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "order-limit");
    }

    @Test
    public void testGroupByWithAlphaNumericDimensionOrder() {
        this.cannotVectorize();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("automotive", "health105");
        map.put("business", "health20");
        map.put("entertainment", "travel47");
        map.put("health", "health55");
        map.put("mezzanine", "health09");
        map.put("news", "health0000");
        map.put("premium", "health999");
        map.put("technology", "travel123");
        map.put("travel", "travel555");
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new ExtractionDimensionSpec("quality", "alias", (ExtractionFn)new LookupExtractionFn((LookupExtractor)new MapLookupExtractor(map, false), false, null, Boolean.valueOf(false), Boolean.valueOf(false)))}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setLimitSpec((LimitSpec)new DefaultLimitSpec(Collections.singletonList(new OrderByColumnSpec("alias", null, StringComparators.ALPHANUMERIC)), null)).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "health0000", "rows", 1L, "idx", 121L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "health09", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "health20", "rows", 1L, "idx", 118L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "health55", "rows", 1L, "idx", 120L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "health105", "rows", 1L, "idx", 135L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "health999", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "travel47", "rows", 1L, "idx", 158L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "travel123", "rows", 1L, "idx", 78L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "travel555", "rows", 1L, "idx", 119L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "health0000", "rows", 1L, "idx", 114L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "health09", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "health20", "rows", 1L, "idx", 112L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "health55", "rows", 1L, "idx", 113L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "health105", "rows", 1L, "idx", 147L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "health999", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "travel47", "rows", 1L, "idx", 166L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "travel123", "rows", 1L, "idx", 97L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "travel555", "rows", 1L, "idx", 126L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "alphanumeric-dimension-order");
    }

    @Test
    public void testGroupByWithLookupAndLimitAndSortByDimsFirst() {
        this.cannotVectorize();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("automotive", "9");
        map.put("business", "8");
        map.put("entertainment", "7");
        map.put("health", "6");
        map.put("mezzanine", "5");
        map.put("news", "4");
        map.put("premium", "3");
        map.put("technology", "2");
        map.put("travel", "1");
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new ExtractionDimensionSpec("quality", "alias", (ExtractionFn)new LookupExtractionFn((LookupExtractor)new MapLookupExtractor(map, false), false, null, Boolean.valueOf(false), Boolean.valueOf(false)))}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setLimitSpec((LimitSpec)new DefaultLimitSpec(Collections.singletonList(new OrderByColumnSpec("alias", null, StringComparators.ALPHANUMERIC)), Integer.valueOf(11))).setGranularity(QueryRunnerTestHelper.DAY_GRAN).overrideContext((Map)ImmutableMap.of((Object)"sortByDimsFirst", (Object)true)).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "1", "rows", 1L, "idx", 119L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "1", "rows", 1L, "idx", 126L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "2", "rows", 1L, "idx", 78L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "2", "rows", 1L, "idx", 97L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "3", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "3", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "4", "rows", 1L, "idx", 121L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "4", "rows", 1L, "idx", 114L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "5", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "5", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "6", "rows", 1L, "idx", 120L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "lookup-limit");
    }

    @Ignore
    @Test
    public void testLimitPerGrouping() {
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setGranularity(QueryRunnerTestHelper.DAY_GRAN).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("market", "market")}).setInterval(QueryRunnerTestHelper.FIRST_TO_THIRD).setLimitSpec((LimitSpec)new DefaultLimitSpec(Collections.singletonList(new OrderByColumnSpec("rows", OrderByColumnSpec.Direction.DESCENDING)), Integer.valueOf(2))).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT}).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01T00:00:00.000Z", "market", "spot", "rows", 9L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02T00:00:00.000Z", "market", "spot", "rows", 9L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        Iterator resultsIter = results.iterator();
        Iterator<ResultRow> expectedResultsIter = expectedResults.iterator();
        Object next1 = resultsIter.next();
        ResultRow expectedNext1 = expectedResultsIter.next();
        Assert.assertEquals((String)"order-limit", (Object)expectedNext1, next1);
        Object next2 = resultsIter.next();
        ResultRow expectedNext2 = expectedResultsIter.next();
        Assert.assertNotEquals((String)"order-limit", (Object)expectedNext2, next2);
    }

    @Test
    public void testPostAggMergedHavingSpec() {
        GroupByQuery.Builder builder = this.makeQueryBuilder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("index", "index")}).setPostAggregatorSpecs((List)ImmutableList.of((Object)QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT)).setGranularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).setHavingSpec((HavingSpec)new OrHavingSpec((List)ImmutableList.of((Object)new GreaterThanHavingSpec("addRowsIndexConstant", (Number)1000L))));
        GroupByQuery fullQuery = builder.build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "mezzanine", "rows", 6L, "index", 4420L, "addRowsIndexConstant", 4427.0), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "premium", "rows", 6L, "index", 4416L, "addRowsIndexConstant", 4423.0));
        QueryRunner mergedRunner = this.factory.getToolchest().mergeResults((QueryRunner)new QueryRunner<ResultRow>(){

            public Sequence<ResultRow> run(QueryPlus<ResultRow> queryPlus, ResponseContext responseContext) {
                QueryPlus queryPlus1 = queryPlus.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.of((String)"2011-04-02/2011-04-03"))));
                QueryPlus queryPlus2 = queryPlus.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.of((String)"2011-04-03/2011-04-04"))));
                return new MergeSequence(queryPlus.getQuery().getResultOrdering(), Sequences.simple(Arrays.asList(GroupByQueryRunnerTest.this.runner.run(queryPlus1, responseContext), GroupByQueryRunnerTest.this.runner.run(queryPlus2, responseContext))));
            }
        });
        TestHelper.assertExpectedObjects(expectedResults, mergedRunner.run(QueryPlus.wrap((Query)fullQuery)), "merged");
    }

    @Test
    public void testGroupByWithOrderLimitHavingSpec() {
        GroupByQuery.Builder builder = this.makeQueryBuilder().setDataSource("testing").setInterval("2011-01-25/2011-01-28").setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new DoubleSumAggregatorFactory("index", "index")}).setGranularity(Granularities.ALL).setHavingSpec((HavingSpec)new GreaterThanHavingSpec("index", (Number)310L)).setLimitSpec((LimitSpec)new DefaultLimitSpec(Collections.singletonList(new OrderByColumnSpec("index", OrderByColumnSpec.Direction.ASCENDING)), Integer.valueOf(5)));
        GroupByQuery fullQuery = builder.build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(fullQuery, "2011-01-25", "alias", "business", "rows", 3L, "index", 312.38165283203125), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-01-25", "alias", "news", "rows", 3L, "index", 312.7834167480469), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-01-25", "alias", "technology", "rows", 3L, "index", 324.6412353515625), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-01-25", "alias", "travel", "rows", 3L, "index", 393.36322021484375), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-01-25", "alias", "health", "rows", 3L, "index", 511.2996826171875));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, fullQuery);
        TestHelper.assertExpectedObjects(expectedResults, results, "order-limit-havingspec");
    }

    @Test
    public void testPostAggHavingSpec() {
        GroupByQuery.Builder builder = this.makeQueryBuilder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("index", "index")}).setPostAggregatorSpecs((List)ImmutableList.of((Object)QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT)).setGranularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).setHavingSpec((HavingSpec)new OrHavingSpec((List)ImmutableList.of((Object)new GreaterThanHavingSpec("addRowsIndexConstant", (Number)1000L))));
        GroupByQuery fullQuery = builder.build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "mezzanine", "rows", 6L, "index", 4420L, "addRowsIndexConstant", 4427.0), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "premium", "rows", 6L, "index", 4416L, "addRowsIndexConstant", 4423.0));
        TestHelper.assertExpectedObjects(expectedResults, GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, fullQuery), "postagg-havingspec");
    }

    @Test
    public void testHavingSpec() {
        GroupByQuery.Builder builder = this.makeQueryBuilder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).setHavingSpec((HavingSpec)new OrHavingSpec((List)ImmutableList.of((Object)new GreaterThanHavingSpec("rows", (Number)2L), (Object)new EqualToHavingSpec("idx", (Number)217L))));
        GroupByQuery fullQuery = builder.build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "business", "rows", 2L, "idx", 217L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "mezzanine", "rows", 6L, "idx", 4420L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "premium", "rows", 6L, "idx", 4416L));
        TestHelper.assertExpectedObjects(expectedResults, GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, fullQuery), "havingspec");
    }

    @Test
    public void testDimFilterHavingSpec() {
        DimFilterHavingSpec havingSpec = new DimFilterHavingSpec((DimFilter)new AndDimFilter((List)ImmutableList.of((Object)new OrDimFilter((List)ImmutableList.of((Object)new BoundDimFilter("rows", "2", null, Boolean.valueOf(true), Boolean.valueOf(false), null, null, StringComparators.NUMERIC), (Object)new SelectorDimFilter("idx", "217", null))), (Object)new SelectorDimFilter("__time", String.valueOf(DateTimes.of((String)"2011-04-01").getMillis()), null))), null);
        GroupByQuery.Builder builder = this.makeQueryBuilder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).setHavingSpec((HavingSpec)havingSpec);
        GroupByQuery fullQuery = builder.build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "business", "rows", 2L, "idx", 217L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "mezzanine", "rows", 6L, "idx", 4420L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "premium", "rows", 6L, "idx", 4416L));
        TestHelper.assertExpectedObjects(expectedResults, GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, fullQuery), "dimfilter-havingspec");
    }

    @Test
    public void testDimFilterHavingSpecWithExtractionFns() {
        String extractionJsFn = "function(str) { return 'super-' + str; }";
        JavaScriptExtractionFn extractionFn = new JavaScriptExtractionFn(extractionJsFn, false, JavaScriptConfig.getEnabledInstance());
        String extractionJsFn2 = "function(num) { return num + 10; }";
        JavaScriptExtractionFn extractionFn2 = new JavaScriptExtractionFn(extractionJsFn2, false, JavaScriptConfig.getEnabledInstance());
        DimFilterHavingSpec havingSpec = new DimFilterHavingSpec((DimFilter)new OrDimFilter((List)ImmutableList.of((Object)new BoundDimFilter("rows", "12", null, Boolean.valueOf(true), Boolean.valueOf(false), null, (ExtractionFn)extractionFn2, StringComparators.NUMERIC), (Object)new SelectorDimFilter("idx", "super-217", (ExtractionFn)extractionFn))), null);
        GroupByQuery.Builder builder = this.makeQueryBuilder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).setHavingSpec((HavingSpec)havingSpec);
        GroupByQuery fullQuery = builder.build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "business", "rows", 2L, "idx", 217L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "mezzanine", "rows", 6L, "idx", 4420L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "premium", "rows", 6L, "idx", 4416L));
        TestHelper.assertExpectedObjects(expectedResults, GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, fullQuery), "extractionfn-havingspec");
    }

    @Test
    public void testMergedHavingSpec() {
        GroupByQuery.Builder builder = this.makeQueryBuilder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).setHavingSpec((HavingSpec)new OrHavingSpec((List)ImmutableList.of((Object)new GreaterThanHavingSpec("rows", (Number)2L), (Object)new EqualToHavingSpec("idx", (Number)217L))));
        GroupByQuery fullQuery = builder.build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "business", "rows", 2L, "idx", 217L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "mezzanine", "rows", 6L, "idx", 4420L), GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "premium", "rows", 6L, "idx", 4416L));
        QueryRunner mergedRunner = this.factory.getToolchest().mergeResults((QueryRunner)new QueryRunner<ResultRow>(){

            public Sequence<ResultRow> run(QueryPlus<ResultRow> queryPlus, ResponseContext responseContext) {
                QueryPlus queryPlus1 = queryPlus.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.of((String)"2011-04-02/2011-04-03"))));
                QueryPlus queryPlus2 = queryPlus.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.of((String)"2011-04-03/2011-04-04"))));
                return new MergeSequence(queryPlus.getQuery().getResultOrdering(), Sequences.simple(Arrays.asList(GroupByQueryRunnerTest.this.runner.run(queryPlus1, responseContext), GroupByQueryRunnerTest.this.runner.run(queryPlus2, responseContext))));
            }
        });
        TestHelper.assertExpectedObjects(expectedResults, mergedRunner.run(QueryPlus.wrap((Query)fullQuery)), "merged");
    }

    @Test
    public void testMergedPostAggHavingSpec() {
        GroupByQuery.Builder builder = this.makeQueryBuilder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setPostAggregatorSpecs(Collections.singletonList(new ArithmeticPostAggregator("rows_times_10", "*", Arrays.asList(new FieldAccessPostAggregator("rows", "rows"), new ConstantPostAggregator("const", (Number)10L))))).setGranularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).setHavingSpec((HavingSpec)new OrHavingSpec((List)ImmutableList.of((Object)new GreaterThanHavingSpec("rows_times_10", (Number)20L), (Object)new EqualToHavingSpec("idx", (Number)217L))));
        GroupByQuery query = builder.build();
        GroupByQuery expressionQuery = query.withPostAggregatorSpecs(Collections.singletonList(new ExpressionPostAggregator("rows_times_10", "rows * 10.0", null, TestExprMacroTable.INSTANCE)));
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "business", "rows", 2L, "idx", 217L, "rows_times_10", 20.0), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "mezzanine", "rows", 6L, "idx", 4420L, "rows_times_10", 60.0), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "premium", "rows", 6L, "idx", 4416L, "rows_times_10", 60.0));
        QueryRunner mergedRunner = this.factory.getToolchest().mergeResults((QueryRunner)new QueryRunner<ResultRow>(){

            public Sequence<ResultRow> run(QueryPlus<ResultRow> queryPlus, ResponseContext responseContext) {
                QueryPlus queryPlus1 = queryPlus.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.of((String)"2011-04-02/2011-04-03"))));
                QueryPlus queryPlus2 = queryPlus.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.of((String)"2011-04-03/2011-04-04"))));
                return new MergeSequence(queryPlus.getQuery().getResultOrdering(), Sequences.simple(Arrays.asList(GroupByQueryRunnerTest.this.runner.run(queryPlus1, responseContext), GroupByQueryRunnerTest.this.runner.run(queryPlus2, responseContext))));
            }
        });
        ResponseContext context = ResponseContext.createEmpty();
        TestHelper.assertExpectedObjects(expectedResults, this.factory.getToolchest().postMergeQueryDecoration(this.factory.getToolchest().mergeResults(this.factory.getToolchest().preMergeQueryDecoration(mergedRunner))).run(QueryPlus.wrap((Query)query)), "merged");
        TestHelper.assertExpectedObjects(expectedResults, this.factory.getToolchest().postMergeQueryDecoration(this.factory.getToolchest().mergeResults(this.factory.getToolchest().preMergeQueryDecoration(mergedRunner))).run(QueryPlus.wrap((Query)expressionQuery)), "merged");
    }

    @Test
    public void testCustomAggregatorHavingSpec() {
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new TestBigDecimalSumAggregatorFactory("idxDouble", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).setHavingSpec((HavingSpec)new OrHavingSpec((List)ImmutableList.of((Object)new EqualToHavingSpec("rows", (Number)3L), (Object)new GreaterThanHavingSpec("idxDouble", (Number)135.0)))).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "automotive", "rows", 1L, "idxDouble", 135.885094), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "entertainment", "rows", 1L, "idxDouble", 158.747224), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "mezzanine", "rows", 3L, "idxDouble", 2871.8866900000003), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "premium", "rows", 3L, "idxDouble", 2900.798647), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "automotive", "rows", 1L, "idxDouble", 147.425935), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "entertainment", "rows", 1L, "idxDouble", 166.016049), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "mezzanine", "rows", 3L, "idxDouble", 2448.830613), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "premium", "rows", 3L, "idxDouble", 2506.415148));
        TestHelper.assertExpectedObjects(expectedResults, GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query), "custom-havingspec");
    }

    @Test
    public void testGroupByWithRegEx() {
        GroupByQuery.Builder builder = this.makeQueryBuilder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimFilter((DimFilter)new RegexDimFilter("quality", "auto.*", null)).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "quality")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT}).setGranularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null));
        GroupByQuery query = builder.build();
        List<ResultRow> expectedResults = Collections.singletonList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "automotive", "rows", 2L));
        QueryRunner mergeRunner = this.factory.getToolchest().mergeResults(this.runner);
        TestHelper.assertExpectedObjects(expectedResults, mergeRunner.run(QueryPlus.wrap((Query)query)), "no-limit");
    }

    @Test
    public void testGroupByWithNonexistentDimension() {
        GroupByQuery.Builder builder = this.makeQueryBuilder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").addDimension("billy").addDimension("quality").setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT}).setGranularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null));
        GroupByQuery query = builder.build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "billy", null, "quality", "automotive", "rows", 2L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "billy", null, "quality", "business", "rows", 2L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "billy", null, "quality", "entertainment", "rows", 2L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "billy", null, "quality", "health", "rows", 2L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "billy", null, "quality", "mezzanine", "rows", 6L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "billy", null, "quality", "news", "rows", 2L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "billy", null, "quality", "premium", "rows", 6L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "billy", null, "quality", "technology", "rows", 2L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "billy", null, "quality", "travel", "rows", 2L));
        QueryRunner mergeRunner = this.factory.getToolchest().mergeResults(this.runner);
        TestHelper.assertExpectedObjects(expectedResults, mergeRunner.run(QueryPlus.wrap((Query)query)), "no-limit");
    }

    @Test
    public void testIdenticalSubquery() {
        GroupByQuery subquery = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setDimFilter((DimFilter)new JavaScriptDimFilter("quality", "function(dim){ return true; }", null, JavaScriptConfig.getEnabledInstance())).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index"), new LongSumAggregatorFactory("indexMaxPlusTen", "indexMaxPlusTen")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        GroupByQuery query = this.makeQueryBuilder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("alias", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("rows", "rows"), new LongSumAggregatorFactory("idx", "idx")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "automotive", "rows", 1L, "idx", 135L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "business", "rows", 1L, "idx", 118L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "entertainment", "rows", 1L, "idx", 158L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "health", "rows", 1L, "idx", 120L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "mezzanine", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "news", "rows", 1L, "idx", 121L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "premium", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "technology", "rows", 1L, "idx", 78L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "travel", "rows", 1L, "idx", 119L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "automotive", "rows", 1L, "idx", 147L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "business", "rows", 1L, "idx", 112L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "entertainment", "rows", 1L, "idx", 166L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "health", "rows", 1L, "idx", 113L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "mezzanine", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "news", "rows", 1L, "idx", 114L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "premium", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "technology", "rows", 1L, "idx", 97L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "travel", "rows", 1L, "idx", 126L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "sub-query");
    }

    @Test
    public void testSubqueryWithMultipleIntervalsInOuterQuery() {
        GroupByQuery subquery = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setDimFilter((DimFilter)new JavaScriptDimFilter("quality", "function(dim){ return true; }", null, JavaScriptConfig.getEnabledInstance())).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index"), new LongSumAggregatorFactory("indexMaxPlusTen", "indexMaxPlusTen")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        GroupByQuery query = this.makeQueryBuilder().setDataSource((Query)subquery).setQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2011-04-01T00:00:00.000Z/2011-04-01T23:58:00.000Z"), (Object)Intervals.of((String)"2011-04-02T00:00:00.000Z/2011-04-03T00:00:00.000Z")))).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("alias", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("rows", "rows"), new LongSumAggregatorFactory("idx", "idx")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "automotive", "rows", 1L, "idx", 135L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "business", "rows", 1L, "idx", 118L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "entertainment", "rows", 1L, "idx", 158L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "health", "rows", 1L, "idx", 120L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "mezzanine", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "news", "rows", 1L, "idx", 121L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "premium", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "technology", "rows", 1L, "idx", 78L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "travel", "rows", 1L, "idx", 119L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "automotive", "rows", 1L, "idx", 147L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "business", "rows", 1L, "idx", 112L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "entertainment", "rows", 1L, "idx", 166L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "health", "rows", 1L, "idx", 113L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "mezzanine", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "news", "rows", 1L, "idx", 114L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "premium", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "technology", "rows", 1L, "idx", 97L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "travel", "rows", 1L, "idx", 126L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "subquery-multiple-intervals");
    }

    @Test
    public void testSubqueryWithMultipleIntervalsInOuterQueryAndChunkPeriod() {
        GroupByQuery subquery = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setDimFilter((DimFilter)new JavaScriptDimFilter("quality", "function(dim){ return true; }", null, JavaScriptConfig.getEnabledInstance())).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index"), new LongSumAggregatorFactory("indexMaxPlusTen", "indexMaxPlusTen")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).overrideContext((Map)ImmutableMap.of((Object)"chunkPeriod", (Object)"P1D")).build();
        GroupByQuery query = this.makeQueryBuilder().setDataSource((Query)subquery).setQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2011-04-01T00:00:00.000Z/2011-04-01T23:58:00.000Z"), (Object)Intervals.of((String)"2011-04-02T00:00:00.000Z/2011-04-03T00:00:00.000Z")))).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("alias", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("rows", "rows"), new LongSumAggregatorFactory("idx", "idx")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "automotive", "rows", 1L, "idx", 135L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "business", "rows", 1L, "idx", 118L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "entertainment", "rows", 1L, "idx", 158L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "health", "rows", 1L, "idx", 120L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "mezzanine", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "news", "rows", 1L, "idx", 121L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "premium", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "technology", "rows", 1L, "idx", 78L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "travel", "rows", 1L, "idx", 119L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "automotive", "rows", 1L, "idx", 147L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "business", "rows", 1L, "idx", 112L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "entertainment", "rows", 1L, "idx", 166L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "health", "rows", 1L, "idx", 113L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "mezzanine", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "news", "rows", 1L, "idx", 114L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "premium", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "technology", "rows", 1L, "idx", 97L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "travel", "rows", 1L, "idx", 126L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "subquery-multiple-intervals");
    }

    @Test
    public void testSubqueryWithExtractionFnInOuterQuery() {
        GroupByQuery subquery = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setDimFilter((DimFilter)new JavaScriptDimFilter("quality", "function(dim){ return true; }", null, JavaScriptConfig.getEnabledInstance())).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index"), new LongSumAggregatorFactory("indexMaxPlusTen", "indexMaxPlusTen")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        GroupByQuery query = this.makeQueryBuilder().setDataSource((Query)subquery).setQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2011-04-01T00:00:00.000Z/2011-04-03T00:00:00.000Z")))).setDimensions(new DimensionSpec[]{new ExtractionDimensionSpec("alias", "alias", (ExtractionFn)new RegexDimExtractionFn("(a).*", Boolean.valueOf(true), "a"))}).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("rows", "rows"), new LongSumAggregatorFactory("idx", "idx")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "a", "rows", 13L, "idx", 6619L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "a", "rows", 13L, "idx", 5827L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "subquery-extractionfn");
    }

    @Test
    public void testDifferentGroupingSubquery() {
        this.cannotVectorize();
        GroupByQuery subquery = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index"), new LongSumAggregatorFactory("indexMaxPlusTen", "indexMaxPlusTen")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        GroupByQuery query = this.makeQueryBuilder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new DoubleMaxAggregatorFactory("idx", "idx"), new DoubleMaxAggregatorFactory("indexMaxPlusTen", "indexMaxPlusTen")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        List<ResultRow> expectedResults = GroupByQueryRunnerTest.makeRows(query, new String[]{"__time", "rows", "idx", "indexMaxPlusTen"}, {"2011-04-01", 9L, 2900.0, 2930.0}, {"2011-04-02", 9L, 2505.0, 2535.0});
        TestHelper.assertExpectedObjects(expectedResults, GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query), "subquery");
        subquery = this.makeQueryBuilder(subquery).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("expr", "-index + 100", ValueType.FLOAT, TestExprMacroTable.INSTANCE)}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "expr"), new LongSumAggregatorFactory("indexMaxPlusTen", "indexMaxPlusTen")}).build();
        query = (GroupByQuery)query.withDataSource((DataSource)new QueryDataSource((Query)subquery));
        expectedResults = GroupByQueryRunnerTest.makeRows(query, new String[]{"__time", "rows", "idx", "indexMaxPlusTen"}, {"2011-04-01", 9L, 21.0, 2930.0}, {"2011-04-02", 9L, 2.0, 2535.0});
        TestHelper.assertExpectedObjects(expectedResults, GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query), "subquery");
    }

    @Test
    public void testDifferentGroupingSubqueryMultipleAggregatorsOnSameField() {
        GroupByQuery subquery = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setPostAggregatorSpecs(Collections.singletonList(new ArithmeticPostAggregator("post_agg", "+", (List)Lists.newArrayList((Object[])new PostAggregator[]{new FieldAccessPostAggregator("idx", "idx"), new FieldAccessPostAggregator("idx", "idx")})))).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        GroupByQuery query = this.makeQueryBuilder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setAggregatorSpecs(new AggregatorFactory[]{new DoubleMaxAggregatorFactory("idx1", "idx"), new DoubleMaxAggregatorFactory("idx2", "idx"), new DoubleMaxAggregatorFactory("idx3", "post_agg"), new DoubleMaxAggregatorFactory("idx4", "post_agg")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "idx1", 2900.0, "idx2", 2900.0, "idx3", 5800.0, "idx4", 5800.0), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "idx1", 2505.0, "idx2", 2505.0, "idx3", 5010.0, "idx4", 5010.0));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "subquery-multiple-aggs");
    }

    @Test
    public void testDifferentGroupingSubqueryWithFilter() {
        GroupByQuery subquery = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "quality")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        GroupByQuery query = this.makeQueryBuilder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setAggregatorSpecs(new AggregatorFactory[]{new DoubleMaxAggregatorFactory("idx", "idx")}).setDimFilter((DimFilter)new OrDimFilter((List)Lists.newArrayList((Object[])new DimFilter[]{new SelectorDimFilter("quality", "automotive", null), new SelectorDimFilter("quality", "premium", null), new SelectorDimFilter("quality", "mezzanine", null), new SelectorDimFilter("quality", "business", null), new SelectorDimFilter("quality", "entertainment", null), new SelectorDimFilter("quality", "health", null), new SelectorDimFilter("quality", "news", null), new SelectorDimFilter("quality", "technology", null), new SelectorDimFilter("quality", "travel", null)}))).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "idx", 2900.0), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "idx", 2505.0));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "subquery-filter");
    }

    @Test
    public void testDifferentIntervalSubquery() {
        GroupByQuery subquery = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        GroupByQuery query = this.makeQueryBuilder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.SECOND_ONLY).setAggregatorSpecs(new AggregatorFactory[]{new DoubleMaxAggregatorFactory("idx", "idx")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        List<ResultRow> expectedResults = Collections.singletonList(GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "idx", 2505.0));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "subquery-different-intervals");
    }

    @Test
    public void testGroupByTimeExtractionNamedUnderUnderTime() {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("'__time' cannot be used as an output name for dimensions, aggregators, or post-aggregators.");
        this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("market", "market"), new ExtractionDimensionSpec("__time", "__time", (ExtractionFn)new TimeFormatExtractionFn("EEEE", null, null, null, false))}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.INDEX_DOUBLE_SUM}).setPostAggregatorSpecs(Collections.singletonList(QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT)).setGranularity(QueryRunnerTestHelper.ALL_GRAN).setDimFilter((DimFilter)new OrDimFilter(Arrays.asList(new SelectorDimFilter("market", "spot", null), new SelectorDimFilter("market", "upfront", null)))).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of(), Integer.valueOf(1))).build();
    }

    @Test
    public void testGroupByWithUnderUnderTimeAsDimensionNameWithHavingAndLimit() {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("'__time' cannot be used as an output name for dimensions, aggregators, or post-aggregators.");
        this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "__time")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).setHavingSpec((HavingSpec)new OrHavingSpec((List)ImmutableList.of((Object)new DimensionSelectorHavingSpec("__time", "automotive", null), (Object)new DimensionSelectorHavingSpec("__time", "business", null)))).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("__time", OrderByColumnSpec.Direction.DESCENDING)), null)).build();
    }

    @Test
    public void testEmptySubquery() {
        GroupByQuery subquery = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.EMPTY_INTERVAL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        GroupByQuery query = this.makeQueryBuilder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setAggregatorSpecs(new AggregatorFactory[]{new DoubleMaxAggregatorFactory("idx", "idx")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        Assert.assertFalse((boolean)results.iterator().hasNext());
    }

    @Test
    public void testSubqueryWithPostAggregators() {
        GroupByQuery subquery = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setDimFilter((DimFilter)new JavaScriptDimFilter("quality", "function(dim){ return true; }", null, JavaScriptConfig.getEnabledInstance())).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx_subagg", "index")}).setPostAggregatorSpecs(Collections.singletonList(new ArithmeticPostAggregator("idx_subpostagg", "+", Arrays.asList(new FieldAccessPostAggregator("the_idx_subagg", "idx_subagg"), new ConstantPostAggregator("thousand", (Number)1000))))).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        GroupByQuery query = this.makeQueryBuilder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("alias", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("rows", "rows"), new LongSumAggregatorFactory("idx", "idx_subpostagg")}).setPostAggregatorSpecs(Collections.singletonList(new ArithmeticPostAggregator("idx_post", "+", Arrays.asList(new FieldAccessPostAggregator("the_idx_agg", "idx"), new ConstantPostAggregator("ten_thousand", (Number)10000))))).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "automotive", "rows", 1L, "idx_post", 11135.0, "idx", 1135L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "business", "rows", 1L, "idx_post", 11118.0, "idx", 1118L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "entertainment", "rows", 1L, "idx_post", 11158.0, "idx", 1158L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "health", "rows", 1L, "idx_post", 11120.0, "idx", 1120L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "mezzanine", "rows", 3L, "idx_post", 13870.0, "idx", 3870L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "news", "rows", 1L, "idx_post", 11121.0, "idx", 1121L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "premium", "rows", 3L, "idx_post", 13900.0, "idx", 3900L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "technology", "rows", 1L, "idx_post", 11078.0, "idx", 1078L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "travel", "rows", 1L, "idx_post", 11119.0, "idx", 1119L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "automotive", "rows", 1L, "idx_post", 11147.0, "idx", 1147L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "business", "rows", 1L, "idx_post", 11112.0, "idx", 1112L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "entertainment", "rows", 1L, "idx_post", 11166.0, "idx", 1166L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "health", "rows", 1L, "idx_post", 11113.0, "idx", 1113L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "mezzanine", "rows", 3L, "idx_post", 13447.0, "idx", 3447L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "news", "rows", 1L, "idx_post", 11114.0, "idx", 1114L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "premium", "rows", 3L, "idx_post", 13505.0, "idx", 3505L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "technology", "rows", 1L, "idx_post", 11097.0, "idx", 1097L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "travel", "rows", 1L, "idx_post", 11126.0, "idx", 1126L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "subquery-postaggs");
    }

    @Test
    public void testSubqueryWithPostAggregatorsAndHaving() {
        GroupByQuery subquery = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx_subagg", "index")}).setPostAggregatorSpecs(Collections.singletonList(new ArithmeticPostAggregator("idx_subpostagg", "+", Arrays.asList(new FieldAccessPostAggregator("the_idx_subagg", "idx_subagg"), new ConstantPostAggregator("thousand", (Number)1000))))).setHavingSpec(new HavingSpec(){
            private GroupByQuery query;

            public void setQuery(GroupByQuery query) {
                this.query = query;
            }

            public byte[] getCacheKey() {
                return new byte[0];
            }

            public boolean eval(ResultRow row) {
                String field = "idx_subpostagg";
                int p = this.query.getResultRowPositionLookup().getInt((Object)"idx_subpostagg");
                return Rows.objectToNumber((String)"idx_subpostagg", (Object)row.get(p)).floatValue() < 3800.0f;
            }
        }).addOrderByColumn("alias").setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        GroupByQuery query = this.makeQueryBuilder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("alias", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("rows", "rows"), new LongSumAggregatorFactory("idx", "idx_subpostagg")}).setPostAggregatorSpecs(Collections.singletonList(new ArithmeticPostAggregator("idx_post", "+", Arrays.asList(new FieldAccessPostAggregator("the_idx_agg", "idx"), new ConstantPostAggregator("ten_thousand", (Number)10000))))).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "automotive", "rows", 1L, "idx_post", 11135.0, "idx", 1135L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "business", "rows", 1L, "idx_post", 11118.0, "idx", 1118L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "entertainment", "rows", 1L, "idx_post", 11158.0, "idx", 1158L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "health", "rows", 1L, "idx_post", 11120.0, "idx", 1120L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "news", "rows", 1L, "idx_post", 11121.0, "idx", 1121L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "technology", "rows", 1L, "idx_post", 11078.0, "idx", 1078L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "travel", "rows", 1L, "idx_post", 11119.0, "idx", 1119L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "automotive", "rows", 1L, "idx_post", 11147.0, "idx", 1147L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "business", "rows", 1L, "idx_post", 11112.0, "idx", 1112L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "entertainment", "rows", 1L, "idx_post", 11166.0, "idx", 1166L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "health", "rows", 1L, "idx_post", 11113.0, "idx", 1113L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "mezzanine", "rows", 3L, "idx_post", 13447.0, "idx", 3447L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "news", "rows", 1L, "idx_post", 11114.0, "idx", 1114L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "premium", "rows", 3L, "idx_post", 13505.0, "idx", 3505L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "technology", "rows", 1L, "idx_post", 11097.0, "idx", 1097L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "travel", "rows", 1L, "idx_post", 11126.0, "idx", 1126L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "subquery-postaggs");
    }

    @Test
    public void testSubqueryWithMultiColumnAggregators() {
        this.cannotVectorize();
        GroupByQuery subquery = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setDimFilter((DimFilter)new JavaScriptDimFilter("market", "function(dim){ return true; }", null, JavaScriptConfig.getEnabledInstance())).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new DoubleSumAggregatorFactory("idx_subagg", "index"), new JavaScriptAggregatorFactory("js_agg", Arrays.asList("index", "market"), "function(current, index, dim){return current + index + dim.length;}", "function(){return 0;}", "function(a,b){return a + b;}", JavaScriptConfig.getEnabledInstance())}).setPostAggregatorSpecs(Collections.singletonList(new ArithmeticPostAggregator("idx_subpostagg", "+", Arrays.asList(new FieldAccessPostAggregator("the_idx_subagg", "idx_subagg"), new ConstantPostAggregator("thousand", (Number)1000))))).setHavingSpec(new HavingSpec(){
            private GroupByQuery query;

            public byte[] getCacheKey() {
                return new byte[0];
            }

            public void setQuery(GroupByQuery query) {
                this.query = query;
            }

            public boolean eval(ResultRow row) {
                String field = "idx_subpostagg";
                int p = this.query.getResultRowPositionLookup().getInt((Object)"idx_subpostagg");
                return Rows.objectToNumber((String)"idx_subpostagg", (Object)row.get(p)).floatValue() < 3800.0f;
            }
        }).addOrderByColumn("alias").setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        GroupByQuery query = this.makeQueryBuilder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("alias", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("rows", "rows"), new LongSumAggregatorFactory("idx", "idx_subpostagg"), new DoubleSumAggregatorFactory("js_outer_agg", "js_agg")}).setPostAggregatorSpecs(Collections.singletonList(new ArithmeticPostAggregator("idx_post", "+", Arrays.asList(new FieldAccessPostAggregator("the_idx_agg", "idx"), new ConstantPostAggregator("ten_thousand", (Number)10000))))).setLimitSpec((LimitSpec)new DefaultLimitSpec(Collections.singletonList(new OrderByColumnSpec("alias", OrderByColumnSpec.Direction.DESCENDING)), Integer.valueOf(5))).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "travel", "rows", 1L, "idx_post", 11119.0, "idx", 1119L, "js_outer_agg", 123.92274475097656), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "technology", "rows", 1L, "idx_post", 11078.0, "idx", 1078L, "js_outer_agg", 82.62254333496094), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "news", "rows", 1L, "idx_post", 11121.0, "idx", 1121L, "js_outer_agg", 125.58358001708984), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "health", "rows", 1L, "idx_post", 11120.0, "idx", 1120L, "js_outer_agg", 124.13470458984375), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "entertainment", "rows", 1L, "idx_post", 11158.0, "idx", 1158L, "js_outer_agg", 162.74722290039062));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "subquery-multi-aggs");
    }

    @Test
    public void testSubqueryWithOuterFilterAggregator() {
        GroupByQuery subquery = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("market", "market"), new DefaultDimensionSpec("quality", "quality")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("index", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        SelectorDimFilter filter = new SelectorDimFilter("market", "spot", null);
        GroupByQuery query = this.makeQueryBuilder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).setDimensions(Collections.emptyList()).setAggregatorSpecs(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)QueryRunnerTestHelper.ROWS_COUNT, (DimFilter)filter)}).setGranularity(QueryRunnerTestHelper.ALL_GRAN).build();
        List<ResultRow> expectedResults = Collections.singletonList(GroupByQueryRunnerTest.makeRow(query, "1970-01-01", "rows", 837L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "subquery-filter-agg");
    }

    @Test
    public void testSubqueryWithOuterTimeFilter() {
        GroupByQuery subquery = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("market", "market"), new DefaultDimensionSpec("quality", "quality")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("index", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        SelectorDimFilter fridayFilter = new SelectorDimFilter("__time", "Friday", (ExtractionFn)new TimeFormatExtractionFn("EEEE", null, null, null, false));
        InDimFilter firstDaysFilter = new InDimFilter("__time", (Collection)ImmutableList.of((Object)"1", (Object)"2", (Object)"3"), (ExtractionFn)new TimeFormatExtractionFn("d", null, null, null, false));
        GroupByQuery query = this.makeQueryBuilder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).setDimensions(Collections.emptyList()).setDimFilter((DimFilter)firstDaysFilter).setAggregatorSpecs(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)QueryRunnerTestHelper.ROWS_COUNT, (DimFilter)fridayFilter)}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-02-01", "rows", 0L), GroupByQueryRunnerTest.makeRow(query, "2011-02-02", "rows", 0L), GroupByQueryRunnerTest.makeRow(query, "2011-02-03", "rows", 0L), GroupByQueryRunnerTest.makeRow(query, "2011-03-01", "rows", 0L), GroupByQueryRunnerTest.makeRow(query, "2011-03-02", "rows", 0L), GroupByQueryRunnerTest.makeRow(query, "2011-03-03", "rows", 0L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "rows", 13L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "rows", 0L), GroupByQueryRunnerTest.makeRow(query, "2011-04-03", "rows", 0L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "subquery-time-filter");
    }

    @Test
    public void testSubqueryWithContextTimeout() {
        GroupByQuery subquery = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        GroupByQuery query = this.makeQueryBuilder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new ArrayList()).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setGranularity(QueryRunnerTestHelper.ALL_GRAN).overrideContext((Map)ImmutableMap.of((Object)"timeout", (Object)10000)).build();
        List<ResultRow> expectedResults = Collections.singletonList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "count", 18L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "subquery-timeout");
    }

    @Test
    public void testSubqueryWithOuterVirtualColumns() {
        GroupByQuery subquery = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        GroupByQuery query = this.makeQueryBuilder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("expr", "1", ValueType.FLOAT, TestExprMacroTable.INSTANCE)}).setDimensions(new ArrayList()).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("count", "expr")}).setGranularity(QueryRunnerTestHelper.ALL_GRAN).build();
        List<ResultRow> expectedResults = Collections.singletonList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "count", 18L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "subquery-virtual");
    }

    @Test
    public void testSubqueryWithOuterCardinalityAggregator() {
        GroupByQuery subquery = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("market", "market"), new DefaultDimensionSpec("quality", "quality")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("index", "index")}).setGranularity(QueryRunnerTestHelper.ALL_GRAN).build();
        GroupByQuery query = this.makeQueryBuilder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).setDimensions(Collections.emptyList()).setAggregatorSpecs(new AggregatorFactory[]{new CardinalityAggregatorFactory("car", (List)ImmutableList.of((Object)new DefaultDimensionSpec("quality", "quality")), false)}).setGranularity(QueryRunnerTestHelper.ALL_GRAN).build();
        List<ResultRow> expectedResults = Collections.singletonList(GroupByQueryRunnerTest.makeRow(query, "1970-01-01", "car", 9.019833517963864));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "subquery-cardinality");
    }

    @Test
    public void testSubqueryWithOuterCountAggregator() {
        GroupByQuery subquery = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("alias", OrderByColumnSpec.Direction.ASCENDING)), null)).build();
        GroupByQuery query = this.makeQueryBuilder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new ArrayList()).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setGranularity(QueryRunnerTestHelper.ALL_GRAN).build();
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(ISE.class);
            this.expectedException.expectMessage("Unknown column in order clause");
            GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        } else {
            List<ResultRow> expectedResults = Collections.singletonList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "count", 18L));
            Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
            TestHelper.assertExpectedObjects(expectedResults, results, "subquery-count-agg");
        }
    }

    @Test
    public void testSubqueryWithOuterDimJavascriptAggregators() {
        GroupByQuery subquery = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("market", "market"), new DefaultDimensionSpec("quality", "quality")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("index", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        GroupByQuery query = this.makeQueryBuilder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "quality")}).setAggregatorSpecs(new AggregatorFactory[]{new JavaScriptAggregatorFactory("js_agg", Arrays.asList("index", "market"), "function(current, index, dim){return current + index + dim.length;}", "function(){return 0;}", "function(a,b){return a + b;}", JavaScriptConfig.getEnabledInstance())}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "automotive", "js_agg", 139.0), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "business", "js_agg", 122.0), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "entertainment", "js_agg", 162.0), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "health", "js_agg", 124.0), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "mezzanine", "js_agg", 2893.0), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "news", "js_agg", 125.0), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "premium", "js_agg", 2923.0), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "technology", "js_agg", 82.0), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "travel", "js_agg", 123.0), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "quality", "automotive", "js_agg", 151.0), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "quality", "business", "js_agg", 116.0), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "quality", "entertainment", "js_agg", 170.0), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "quality", "health", "js_agg", 117.0), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "quality", "mezzanine", "js_agg", 2470.0), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "quality", "news", "js_agg", 118.0), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "quality", "premium", "js_agg", 2528.0), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "quality", "technology", "js_agg", 101.0), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "quality", "travel", "js_agg", 130.0));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "subquery-javascript");
    }

    @Test
    public void testSubqueryWithOuterJavascriptAggregators() {
        GroupByQuery subquery = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("market", "market"), new DefaultDimensionSpec("quality", "quality")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("index", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        GroupByQuery query = this.makeQueryBuilder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "quality")}).setAggregatorSpecs(new AggregatorFactory[]{new JavaScriptAggregatorFactory("js_agg", Arrays.asList("index", "rows"), "function(current, index, rows){return current + index + rows;}", "function(){return 0;}", "function(a,b){return a + b;}", JavaScriptConfig.getEnabledInstance())}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "automotive", "js_agg", 136.0), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "business", "js_agg", 119.0), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "entertainment", "js_agg", 159.0), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "health", "js_agg", 121.0), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "mezzanine", "js_agg", 2873.0), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "news", "js_agg", 122.0), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "premium", "js_agg", 2903.0), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "technology", "js_agg", 79.0), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "quality", "travel", "js_agg", 120.0), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "quality", "automotive", "js_agg", 148.0), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "quality", "business", "js_agg", 113.0), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "quality", "entertainment", "js_agg", 167.0), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "quality", "health", "js_agg", 114.0), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "quality", "mezzanine", "js_agg", 2450.0), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "quality", "news", "js_agg", 115.0), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "quality", "premium", "js_agg", 2508.0), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "quality", "technology", "js_agg", 98.0), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "quality", "travel", "js_agg", 127.0));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "subquery-javascript");
    }

    @Test
    public void testSubqueryWithHyperUniques() {
        GroupByQuery subquery = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index"), new HyperUniquesAggregatorFactory("quality_uniques", "quality_uniques")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        GroupByQuery query = this.makeQueryBuilder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("alias", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("rows", "rows"), new LongSumAggregatorFactory("idx", "idx"), new HyperUniquesAggregatorFactory("uniq", "quality_uniques")}).setGranularity(QueryRunnerTestHelper.ALL_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "automotive", "rows", 2L, "idx", 282L, "uniq", 1.0002442201269182), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "business", "rows", 2L, "idx", 230L, "uniq", 1.0002442201269182), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "entertainment", "rows", 2L, "idx", 324L, "uniq", 1.0002442201269182), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "health", "rows", 2L, "idx", 233L, "uniq", 1.0002442201269182), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "mezzanine", "rows", 6L, "idx", 5317L, "uniq", 1.0002442201269182), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "news", "rows", 2L, "idx", 235L, "uniq", 1.0002442201269182), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "premium", "rows", 6L, "idx", 5405L, "uniq", 1.0002442201269182), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "technology", "rows", 2L, "idx", 175L, "uniq", 1.0002442201269182), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "travel", "rows", 2L, "idx", 245L, "uniq", 1.0002442201269182));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "subquery-hyperunique");
    }

    @Test
    public void testSubqueryWithHyperUniquesPostAggregator() {
        GroupByQuery subquery = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new ArrayList()).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index"), new HyperUniquesAggregatorFactory("quality_uniques_inner", "quality_uniques")}).setPostAggregatorSpecs(Collections.singletonList(new FieldAccessPostAggregator("quality_uniques_inner_post", "quality_uniques_inner"))).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        GroupByQuery query = this.makeQueryBuilder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new ArrayList()).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("rows", "rows"), new LongSumAggregatorFactory("idx", "idx"), new HyperUniquesAggregatorFactory("quality_uniques_outer", "quality_uniques_inner_post")}).setPostAggregatorSpecs(Collections.singletonList(new HyperUniqueFinalizingPostAggregator("quality_uniques_outer_post", "quality_uniques_outer"))).setGranularity(QueryRunnerTestHelper.ALL_GRAN).build();
        List<ResultRow> expectedResults = Collections.singletonList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "rows", 26L, "idx", 12446L, "quality_uniques_outer", 9.019833517963864, "quality_uniques_outer_post", 9.019833517963864));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "subquery-hyperunique");
    }

    @Test
    public void testSubqueryWithFirstLast() {
        this.cannotVectorize();
        GroupByQuery subquery = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("market", "market")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongFirstAggregatorFactory("innerfirst", "index"), new LongLastAggregatorFactory("innerlast", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).overrideContext((Map)ImmutableMap.of((Object)"finalize", (Object)true)).build();
        GroupByQuery query = this.makeQueryBuilder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).setDimensions(Collections.emptyList()).setAggregatorSpecs(new AggregatorFactory[]{new LongFirstAggregatorFactory("first", "innerfirst"), new LongLastAggregatorFactory("last", "innerlast")}).setGranularity(QueryRunnerTestHelper.MONTH_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-01-01", "first", 100L, "last", 943L), GroupByQueryRunnerTest.makeRow(query, "2011-02-01", "first", 132L, "last", 1101L), GroupByQueryRunnerTest.makeRow(query, "2011-03-01", "first", 153L, "last", 1063L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "first", 135L, "last", 780L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "subquery-firstlast");
    }

    @Test
    public void testGroupByWithSubtotalsSpecOfDimensionsPrefixes() {
        this.cannotVectorize();
        if (!this.config.getDefaultStrategy().equals("v2")) {
            return;
        }
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("alias", "quality", ValueType.STRING, TestExprMacroTable.INSTANCE)}).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("market", "market2"), new DefaultDimensionSpec("alias", "alias2")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.DAY_GRAN).setSubtotalsSpec((List)ImmutableList.of((Object)ImmutableList.of((Object)"market2"), (Object)ImmutableList.of())).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01T00:00:00.000Z", "market2", "spot", "rows", 9L, "idx", 1102L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01T00:00:00.000Z", "market2", "total_market", "rows", 2L, "idx", 2836L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01T00:00:00.000Z", "market2", "upfront", "rows", 2L, "idx", 2681L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02T00:00:00.000Z", "market2", "spot", "rows", 9L, "idx", 1120L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02T00:00:00.000Z", "market2", "total_market", "rows", 2L, "idx", 2514L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02T00:00:00.000Z", "market2", "upfront", "rows", 2L, "idx", 2193L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01T00:00:00.000Z", "rows", 13L, "idx", 6619L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02T00:00:00.000Z", "rows", 13L, "idx", 5827L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "subtotal");
    }

    @Test
    public void testGroupByWithSubtotalsSpecGeneral() {
        this.cannotVectorize();
        if (!this.config.getDefaultStrategy().equals("v2")) {
            return;
        }
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("alias", "quality", ValueType.STRING, TestExprMacroTable.INSTANCE)}).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "quality2"), new DefaultDimensionSpec("market", "market2"), new DefaultDimensionSpec("alias", "alias2")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index"))).setPostAggregatorSpecs(Collections.singletonList(new FieldAccessPostAggregator("idxPostAgg", "idx"))).setGranularity(QueryRunnerTestHelper.DAY_GRAN).setSubtotalsSpec((List)ImmutableList.of((Object)ImmutableList.of((Object)"alias2"), (Object)ImmutableList.of((Object)"market2"), (Object)ImmutableList.of())).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias2", "automotive", "rows", 1L, "idx", 135L, "idxPostAgg", 135L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias2", "business", "rows", 1L, "idx", 118L, "idxPostAgg", 118L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias2", "entertainment", "rows", 1L, "idx", 158L, "idxPostAgg", 158L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias2", "health", "rows", 1L, "idx", 120L, "idxPostAgg", 120L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias2", "mezzanine", "rows", 3L, "idx", 2870L, "idxPostAgg", 2870L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias2", "news", "rows", 1L, "idx", 121L, "idxPostAgg", 121L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias2", "premium", "rows", 3L, "idx", 2900L, "idxPostAgg", 2900L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias2", "technology", "rows", 1L, "idx", 78L, "idxPostAgg", 78L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias2", "travel", "rows", 1L, "idx", 119L, "idxPostAgg", 119L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias2", "automotive", "rows", 1L, "idx", 147L, "idxPostAgg", 147L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias2", "business", "rows", 1L, "idx", 112L, "idxPostAgg", 112L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias2", "entertainment", "rows", 1L, "idx", 166L, "idxPostAgg", 166L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias2", "health", "rows", 1L, "idx", 113L, "idxPostAgg", 113L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias2", "mezzanine", "rows", 3L, "idx", 2447L, "idxPostAgg", 2447L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias2", "news", "rows", 1L, "idx", 114L, "idxPostAgg", 114L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias2", "premium", "rows", 3L, "idx", 2505L, "idxPostAgg", 2505L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias2", "technology", "rows", 1L, "idx", 97L, "idxPostAgg", 97L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias2", "travel", "rows", 1L, "idx", 126L, "idxPostAgg", 126L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01T00:00:00.000Z", "market2", "spot", "rows", 9L, "idx", 1102L, "idxPostAgg", 1102L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01T00:00:00.000Z", "market2", "total_market", "rows", 2L, "idx", 2836L, "idxPostAgg", 2836L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01T00:00:00.000Z", "market2", "upfront", "rows", 2L, "idx", 2681L, "idxPostAgg", 2681L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02T00:00:00.000Z", "market2", "spot", "rows", 9L, "idx", 1120L, "idxPostAgg", 1120L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02T00:00:00.000Z", "market2", "total_market", "rows", 2L, "idx", 2514L, "idxPostAgg", 2514L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02T00:00:00.000Z", "market2", "upfront", "rows", 2L, "idx", 2193L, "idxPostAgg", 2193L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01T00:00:00.000Z", "rows", 13L, "idx", 6619L, "idxPostAgg", 6619L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02T00:00:00.000Z", "rows", 13L, "idx", 5827L, "idxPostAgg", 5827L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "subtotal");
    }

    @Test
    public void testGroupByWithSubtotalsSpecWithRenamedDimensionAndFilter() {
        if (!this.config.getDefaultStrategy().equals("v2")) {
            return;
        }
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("alias", "quality", ValueType.STRING, TestExprMacroTable.INSTANCE)}).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "quality"), new DefaultDimensionSpec("market", "market"), new DefaultDimensionSpec("alias", "alias_renamed")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index"), new FloatSumAggregatorFactory("idxFloat", "indexFloat"), new DoubleSumAggregatorFactory("idxDouble", "index"))).setDimFilter((DimFilter)new SelectorDimFilter("alias", "automotive", null)).setGranularity(QueryRunnerTestHelper.DAY_GRAN).setSubtotalsSpec((List)ImmutableList.of((Object)ImmutableList.of((Object)"alias_renamed"), (Object)ImmutableList.of())).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias_renamed", "automotive", "rows", 1L, "idx", 135L, "idxFloat", Float.valueOf(135.8851f), "idxDouble", (double)135.8851f), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias_renamed", "automotive", "rows", 1L, "idx", 147L, "idxFloat", Float.valueOf(147.42593f), "idxDouble", 147.42593), GroupByQueryRunnerTest.makeRow(query, "2011-04-01T00:00:00.000Z", "rows", 1L, "idx", 135L, "idxFloat", Float.valueOf(135.8851f), "idxDouble", (double)135.8851f), GroupByQueryRunnerTest.makeRow(query, "2011-04-02T00:00:00.000Z", "rows", 1L, "idx", 147L, "idxFloat", Float.valueOf(147.42593f), "idxDouble", 147.42593));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "subtotal");
    }

    @Test
    public void testGroupByWithSubtotalsSpecWithLongDimensionColumn() {
        if (!this.config.getDefaultStrategy().equals("v2")) {
            return;
        }
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("qualityLong", "ql", ValueType.LONG), new DefaultDimensionSpec("market", "market2")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.DAY_GRAN).setSubtotalsSpec((List)ImmutableList.of((Object)ImmutableList.of((Object)"ql"), (Object)ImmutableList.of((Object)"market2"), (Object)ImmutableList.of())).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01T00:00:00.000Z", "ql", 1000L, "rows", 1L, "idx", 135L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01T00:00:00.000Z", "ql", 1100L, "rows", 1L, "idx", 118L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01T00:00:00.000Z", "ql", 1200L, "rows", 1L, "idx", 158L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01T00:00:00.000Z", "ql", 1300L, "rows", 1L, "idx", 120L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01T00:00:00.000Z", "ql", 1400L, "rows", 3L, "idx", 2870L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01T00:00:00.000Z", "ql", 1500L, "rows", 1L, "idx", 121L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01T00:00:00.000Z", "ql", 1600L, "rows", 3L, "idx", 2900L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01T00:00:00.000Z", "ql", 1700L, "rows", 1L, "idx", 78L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01T00:00:00.000Z", "ql", 1800L, "rows", 1L, "idx", 119L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02T00:00:00.000Z", "ql", 1000L, "rows", 1L, "idx", 147L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02T00:00:00.000Z", "ql", 1100L, "rows", 1L, "idx", 112L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02T00:00:00.000Z", "ql", 1200L, "rows", 1L, "idx", 166L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02T00:00:00.000Z", "ql", 1300L, "rows", 1L, "idx", 113L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02T00:00:00.000Z", "ql", 1400L, "rows", 3L, "idx", 2447L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02T00:00:00.000Z", "ql", 1500L, "rows", 1L, "idx", 114L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02T00:00:00.000Z", "ql", 1600L, "rows", 3L, "idx", 2505L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02T00:00:00.000Z", "ql", 1700L, "rows", 1L, "idx", 97L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02T00:00:00.000Z", "ql", 1800L, "rows", 1L, "idx", 126L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01T00:00:00.000Z", "market2", "spot", "rows", 9L, "idx", 1102L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01T00:00:00.000Z", "market2", "total_market", "rows", 2L, "idx", 2836L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01T00:00:00.000Z", "market2", "upfront", "rows", 2L, "idx", 2681L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02T00:00:00.000Z", "market2", "spot", "rows", 9L, "idx", 1120L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02T00:00:00.000Z", "market2", "total_market", "rows", 2L, "idx", 2514L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02T00:00:00.000Z", "market2", "upfront", "rows", 2L, "idx", 2193L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01T00:00:00.000Z", "rows", 13L, "idx", 6619L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02T00:00:00.000Z", "rows", 13L, "idx", 5827L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "subtotal-long-dim");
    }

    @Test
    public void testGroupByWithSubtotalsSpecWithOrderLimit() {
        if (!this.config.getDefaultStrategy().equals("v2")) {
            return;
        }
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias"), new DefaultDimensionSpec("market", "market")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.DAY_GRAN).setSubtotalsSpec((List)ImmutableList.of((Object)ImmutableList.of((Object)"alias"), (Object)ImmutableList.of((Object)"market"), (Object)ImmutableList.of())).addOrderByColumn("idx").addOrderByColumn("alias").addOrderByColumn("market").setLimit(1).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "technology", "rows", 1L, "idx", 78L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01T00:00:00.000Z", "market", "spot", "rows", 9L, "idx", 1102L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01T00:00:00.000Z", "rows", 13L, "idx", 6619L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "subtotal-order-limit");
    }

    @Test
    public void testGroupByWithTimeColumn() {
        this.cannotVectorize();
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.JS_COUNT_IF_TIME_GREATER_THAN, QueryRunnerTestHelper.TIME_LONG_SUM}).setGranularity(QueryRunnerTestHelper.ALL_GRAN).build();
        List<ResultRow> expectedResults = Collections.singletonList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "rows", 26L, "ntimestamps", 13.0, "sumtime", 33843139200000L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "time");
    }

    @Test
    public void testGroupByTimeExtraction() {
        this.cannotVectorize();
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("market", "market"), new ExtractionDimensionSpec("__time", "dayOfWeek", (ExtractionFn)new TimeFormatExtractionFn("EEEE", null, null, null, false))}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.INDEX_DOUBLE_SUM}).setPostAggregatorSpecs(Collections.singletonList(QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT)).setGranularity(QueryRunnerTestHelper.ALL_GRAN).setDimFilter((DimFilter)new OrDimFilter(Arrays.asList(new SelectorDimFilter("market", "spot", null), new SelectorDimFilter("market", "upfront", null)))).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "1970-01-01", "dayOfWeek", "Friday", "market", "spot", "index", 13219.574157714844, "rows", 117L, "addRowsIndexConstant", 13337.574157714844), GroupByQueryRunnerTest.makeRow(query, "1970-01-01", "dayOfWeek", "Monday", "market", "spot", "index", 13557.738830566406, "rows", 117L, "addRowsIndexConstant", 13675.738830566406), GroupByQueryRunnerTest.makeRow(query, "1970-01-01", "dayOfWeek", "Saturday", "market", "spot", "index", 13493.751281738281, "rows", 117L, "addRowsIndexConstant", 13611.751281738281), GroupByQueryRunnerTest.makeRow(query, "1970-01-01", "dayOfWeek", "Sunday", "market", "spot", "index", 13585.541015625, "rows", 117L, "addRowsIndexConstant", 13703.541015625), GroupByQueryRunnerTest.makeRow(query, "1970-01-01", "dayOfWeek", "Thursday", "market", "spot", "index", 14279.127197265625, "rows", 126L, "addRowsIndexConstant", 14406.127197265625), GroupByQueryRunnerTest.makeRow(query, "1970-01-01", "dayOfWeek", "Tuesday", "market", "spot", "index", 13199.471435546875, "rows", 117L, "addRowsIndexConstant", 13317.471435546875), GroupByQueryRunnerTest.makeRow(query, "1970-01-01", "dayOfWeek", "Wednesday", "market", "spot", "index", 14271.368591308594, "rows", 126L, "addRowsIndexConstant", 14398.368591308594), GroupByQueryRunnerTest.makeRow(query, "1970-01-01", "dayOfWeek", "Friday", "market", "upfront", "index", 27297.8623046875, "rows", 26L, "addRowsIndexConstant", 27324.8623046875), GroupByQueryRunnerTest.makeRow(query, "1970-01-01", "dayOfWeek", "Monday", "market", "upfront", "index", 27619.58447265625, "rows", 26L, "addRowsIndexConstant", 27646.58447265625), GroupByQueryRunnerTest.makeRow(query, "1970-01-01", "dayOfWeek", "Saturday", "market", "upfront", "index", 27820.83154296875, "rows", 26L, "addRowsIndexConstant", 27847.83154296875), GroupByQueryRunnerTest.makeRow(query, "1970-01-01", "dayOfWeek", "Sunday", "market", "upfront", "index", 24791.223876953125, "rows", 26L, "addRowsIndexConstant", 24818.223876953125), GroupByQueryRunnerTest.makeRow(query, "1970-01-01", "dayOfWeek", "Thursday", "market", "upfront", "index", 28562.748901367188, "rows", 28L, "addRowsIndexConstant", 28591.748901367188), GroupByQueryRunnerTest.makeRow(query, "1970-01-01", "dayOfWeek", "Tuesday", "market", "upfront", "index", 26968.280639648438, "rows", 26L, "addRowsIndexConstant", 26995.280639648438), GroupByQueryRunnerTest.makeRow(query, "1970-01-01", "dayOfWeek", "Wednesday", "market", "upfront", "index", 28985.5751953125, "rows", 28L, "addRowsIndexConstant", 29014.5751953125));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "time-extraction");
    }

    @Test
    public void testGroupByTimeExtractionWithNulls() {
        this.cannotVectorize();
        DimExtractionFn nullWednesdays = new DimExtractionFn(){

            public String apply(String dimValue) {
                if ("Wednesday".equals(dimValue)) {
                    return null;
                }
                return dimValue;
            }

            public byte[] getCacheKey() {
                throw new UnsupportedOperationException();
            }

            public boolean preservesOrdering() {
                return false;
            }

            public ExtractionFn.ExtractionType getExtractionType() {
                return ExtractionFn.ExtractionType.MANY_TO_ONE;
            }
        };
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("market", "market"), new ExtractionDimensionSpec("__time", "dayOfWeek", (ExtractionFn)new CascadeExtractionFn(new ExtractionFn[]{new TimeFormatExtractionFn("EEEE", null, null, null, false), nullWednesdays}))}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.INDEX_DOUBLE_SUM}).setPostAggregatorSpecs(Collections.singletonList(QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT)).setGranularity(QueryRunnerTestHelper.ALL_GRAN).setDimFilter((DimFilter)new OrDimFilter(Arrays.asList(new SelectorDimFilter("market", "spot", null), new SelectorDimFilter("market", "upfront", null)))).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "1970-01-01", "dayOfWeek", null, "market", "spot", "index", 14271.368591308594, "rows", 126L, "addRowsIndexConstant", 14398.368591308594), GroupByQueryRunnerTest.makeRow(query, "1970-01-01", "dayOfWeek", "Friday", "market", "spot", "index", 13219.574157714844, "rows", 117L, "addRowsIndexConstant", 13337.574157714844), GroupByQueryRunnerTest.makeRow(query, "1970-01-01", "dayOfWeek", "Monday", "market", "spot", "index", 13557.738830566406, "rows", 117L, "addRowsIndexConstant", 13675.738830566406), GroupByQueryRunnerTest.makeRow(query, "1970-01-01", "dayOfWeek", "Saturday", "market", "spot", "index", 13493.751281738281, "rows", 117L, "addRowsIndexConstant", 13611.751281738281), GroupByQueryRunnerTest.makeRow(query, "1970-01-01", "dayOfWeek", "Sunday", "market", "spot", "index", 13585.541015625, "rows", 117L, "addRowsIndexConstant", 13703.541015625), GroupByQueryRunnerTest.makeRow(query, "1970-01-01", "dayOfWeek", "Thursday", "market", "spot", "index", 14279.127197265625, "rows", 126L, "addRowsIndexConstant", 14406.127197265625), GroupByQueryRunnerTest.makeRow(query, "1970-01-01", "dayOfWeek", "Tuesday", "market", "spot", "index", 13199.471435546875, "rows", 117L, "addRowsIndexConstant", 13317.471435546875), GroupByQueryRunnerTest.makeRow(query, "1970-01-01", "dayOfWeek", null, "market", "upfront", "index", 28985.5751953125, "rows", 28L, "addRowsIndexConstant", 29014.5751953125), GroupByQueryRunnerTest.makeRow(query, "1970-01-01", "dayOfWeek", "Friday", "market", "upfront", "index", 27297.8623046875, "rows", 26L, "addRowsIndexConstant", 27324.8623046875), GroupByQueryRunnerTest.makeRow(query, "1970-01-01", "dayOfWeek", "Monday", "market", "upfront", "index", 27619.58447265625, "rows", 26L, "addRowsIndexConstant", 27646.58447265625), GroupByQueryRunnerTest.makeRow(query, "1970-01-01", "dayOfWeek", "Saturday", "market", "upfront", "index", 27820.83154296875, "rows", 26L, "addRowsIndexConstant", 27847.83154296875), GroupByQueryRunnerTest.makeRow(query, "1970-01-01", "dayOfWeek", "Sunday", "market", "upfront", "index", 24791.223876953125, "rows", 26L, "addRowsIndexConstant", 24818.223876953125), GroupByQueryRunnerTest.makeRow(query, "1970-01-01", "dayOfWeek", "Thursday", "market", "upfront", "index", 28562.748901367188, "rows", 28L, "addRowsIndexConstant", 28591.748901367188), GroupByQueryRunnerTest.makeRow(query, "1970-01-01", "dayOfWeek", "Tuesday", "market", "upfront", "index", 26968.280639648438, "rows", 26L, "addRowsIndexConstant", 26995.280639648438));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "time-extraction");
    }

    @Test
    public void testBySegmentResults() {
        GroupByQuery.Builder builder = this.makeQueryBuilder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).setDimFilter((DimFilter)new SelectorDimFilter("quality", "mezzanine", null)).setContext((Map)ImmutableMap.of((Object)"bySegment", (Object)true));
        GroupByQuery fullQuery = builder.build();
        int segmentCount = 32;
        Result singleSegmentResult = new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new BySegmentResultValueClass(Collections.singletonList(GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "mezzanine", "rows", 6L, "idx", 4420L)), QueryRunnerTestHelper.SEGMENT_ID.toString(), Intervals.of((String)"2011-04-02T00:00:00.000Z/2011-04-04T00:00:00.000Z")));
        ArrayList<Result> bySegmentResults = new ArrayList<Result>();
        for (int i = 0; i < segmentCount; ++i) {
            bySegmentResults.add(singleSegmentResult);
        }
        QueryToolChest toolChest = this.factory.getToolchest();
        ArrayList<QueryRunner> singleSegmentRunners = new ArrayList<QueryRunner>();
        for (int i = 0; i < segmentCount; ++i) {
            singleSegmentRunners.add(toolChest.preMergeQueryDecoration(this.runner));
        }
        ExecutorService exec = Executors.newCachedThreadPool();
        QueryRunner theRunner = toolChest.postMergeQueryDecoration((QueryRunner)new FinalizeResultsQueryRunner(toolChest.mergeResults(this.factory.mergeRunners(Executors.newCachedThreadPool(), singleSegmentRunners)), toolChest));
        TestHelper.assertExpectedObjects(bySegmentResults, theRunner.run(QueryPlus.wrap((Query)fullQuery)), "bySegment");
        exec.shutdownNow();
    }

    @Test
    public void testBySegmentResultsUnOptimizedDimextraction() {
        GroupByQuery.Builder builder = this.makeQueryBuilder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions(new DimensionSpec[]{new ExtractionDimensionSpec("quality", "alias", (ExtractionFn)new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)ImmutableMap.of((Object)"mezzanine", (Object)"mezzanine0"), false), false, null, Boolean.valueOf(false), Boolean.valueOf(false)))}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).setDimFilter((DimFilter)new SelectorDimFilter("quality", "mezzanine", null)).setContext((Map)ImmutableMap.of((Object)"bySegment", (Object)true));
        GroupByQuery fullQuery = builder.build();
        int segmentCount = 32;
        Result singleSegmentResult = new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new BySegmentResultValueClass(Collections.singletonList(GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "mezzanine0", "rows", 6L, "idx", 4420L)), QueryRunnerTestHelper.SEGMENT_ID.toString(), Intervals.of((String)"2011-04-02T00:00:00.000Z/2011-04-04T00:00:00.000Z")));
        ArrayList<Result> bySegmentResults = new ArrayList<Result>();
        for (int i = 0; i < segmentCount; ++i) {
            bySegmentResults.add(singleSegmentResult);
        }
        QueryToolChest toolChest = this.factory.getToolchest();
        ArrayList<QueryRunner> singleSegmentRunners = new ArrayList<QueryRunner>();
        for (int i = 0; i < segmentCount; ++i) {
            singleSegmentRunners.add(toolChest.preMergeQueryDecoration(this.runner));
        }
        ExecutorService exec = Executors.newCachedThreadPool();
        QueryRunner theRunner = toolChest.postMergeQueryDecoration((QueryRunner)new FinalizeResultsQueryRunner(toolChest.mergeResults(this.factory.mergeRunners(Executors.newCachedThreadPool(), singleSegmentRunners)), toolChest));
        TestHelper.assertExpectedObjects(bySegmentResults, theRunner.run(QueryPlus.wrap((Query)fullQuery)), "bySegment");
        exec.shutdownNow();
    }

    @Test
    public void testBySegmentResultsOptimizedDimextraction() {
        GroupByQuery.Builder builder = this.makeQueryBuilder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions(new DimensionSpec[]{new ExtractionDimensionSpec("quality", "alias", (ExtractionFn)new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)ImmutableMap.of((Object)"mezzanine", (Object)"mezzanine0"), false), false, null, Boolean.valueOf(true), Boolean.valueOf(false)))}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).setDimFilter((DimFilter)new SelectorDimFilter("quality", "mezzanine", null)).overrideContext((Map)ImmutableMap.of((Object)"bySegment", (Object)true));
        GroupByQuery fullQuery = builder.build();
        int segmentCount = 32;
        Result singleSegmentResult = new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new BySegmentResultValueClass(Collections.singletonList(GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "mezzanine0", "rows", 6L, "idx", 4420L)), QueryRunnerTestHelper.SEGMENT_ID.toString(), Intervals.of((String)"2011-04-02T00:00:00.000Z/2011-04-04T00:00:00.000Z")));
        ArrayList<Result> bySegmentResults = new ArrayList<Result>();
        for (int i = 0; i < segmentCount; ++i) {
            bySegmentResults.add(singleSegmentResult);
        }
        QueryToolChest toolChest = this.factory.getToolchest();
        ArrayList<QueryRunner> singleSegmentRunners = new ArrayList<QueryRunner>();
        for (int i = 0; i < segmentCount; ++i) {
            singleSegmentRunners.add(toolChest.preMergeQueryDecoration(this.runner));
        }
        ExecutorService exec = Executors.newCachedThreadPool();
        QueryRunner theRunner = toolChest.postMergeQueryDecoration((QueryRunner)new FinalizeResultsQueryRunner(toolChest.mergeResults(this.factory.mergeRunners(Executors.newCachedThreadPool(), singleSegmentRunners)), toolChest));
        TestHelper.assertExpectedObjects(bySegmentResults, theRunner.run(QueryPlus.wrap((Query)fullQuery)), "bySegment-dim-extraction");
        exec.shutdownNow();
    }

    @Test
    public void testGroupByWithExtractionDimFilter() {
        HashMap<String, String> extractionMap = new HashMap<String, String>();
        extractionMap.put("automotive", "automotiveAndBusinessAndNewsAndMezzanine");
        extractionMap.put("business", "automotiveAndBusinessAndNewsAndMezzanine");
        extractionMap.put("mezzanine", "automotiveAndBusinessAndNewsAndMezzanine");
        extractionMap.put("news", "automotiveAndBusinessAndNewsAndMezzanine");
        MapLookupExtractor mapLookupExtractor = new MapLookupExtractor(extractionMap, false);
        LookupExtractionFn lookupExtractionFn = new LookupExtractionFn((LookupExtractor)mapLookupExtractor, false, null, Boolean.valueOf(true), Boolean.valueOf(false));
        ArrayList dimFilters = Lists.newArrayList((Object[])new DimFilter[]{new ExtractionDimFilter("quality", "automotiveAndBusinessAndNewsAndMezzanine", (ExtractionFn)lookupExtractionFn, null), new SelectorDimFilter("quality", "entertainment", null), new SelectorDimFilter("quality", "health", null), new SelectorDimFilter("quality", "premium", null), new SelectorDimFilter("quality", "technology", null), new SelectorDimFilter("quality", "travel", null)});
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).setDimFilter((DimFilter)new OrDimFilter((List)dimFilters)).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "automotive", "rows", 1L, "idx", 135L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "business", "rows", 1L, "idx", 118L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "entertainment", "rows", 1L, "idx", 158L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "health", "rows", 1L, "idx", 120L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "mezzanine", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "news", "rows", 1L, "idx", 121L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "premium", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "technology", "rows", 1L, "idx", 78L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "travel", "rows", 1L, "idx", 119L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "automotive", "rows", 1L, "idx", 147L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "business", "rows", 1L, "idx", 112L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "entertainment", "rows", 1L, "idx", 166L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "health", "rows", 1L, "idx", 113L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "mezzanine", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "news", "rows", 1L, "idx", 114L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "premium", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "technology", "rows", 1L, "idx", 97L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "travel", "rows", 1L, "idx", 126L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "dim-extraction");
    }

    @Test
    public void testGroupByWithExtractionDimFilterCaseMappingValueIsNullOrEmpty() {
        HashMap<String, String> extractionMap = new HashMap<String, String>();
        extractionMap.put("automotive", "automotive0");
        extractionMap.put("business", "business0");
        extractionMap.put("entertainment", "entertainment0");
        extractionMap.put("health", "health0");
        extractionMap.put("mezzanine", null);
        extractionMap.put("news", "");
        extractionMap.put("premium", "premium0");
        extractionMap.put("technology", "technology0");
        extractionMap.put("travel", "travel0");
        MapLookupExtractor mapLookupExtractor = new MapLookupExtractor(extractionMap, false);
        LookupExtractionFn lookupExtractionFn = new LookupExtractionFn((LookupExtractor)mapLookupExtractor, false, null, Boolean.valueOf(true), Boolean.valueOf(false));
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).setDimFilter((DimFilter)new ExtractionDimFilter("quality", "", (ExtractionFn)lookupExtractionFn, null)).build();
        List<ResultRow> expectedResults = NullHandling.replaceWithDefault() ? Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "mezzanine", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "news", "rows", 1L, "idx", 121L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "mezzanine", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "news", "rows", 1L, "idx", 114L)) : Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "news", "rows", 1L, "idx", 121L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "news", "rows", 1L, "idx", 114L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "dim-extraction");
    }

    @Test
    public void testGroupByWithExtractionDimFilterWhenSearchValueNotInTheMap() {
        HashMap extractionMap = new HashMap();
        MapLookupExtractor mapLookupExtractor = new MapLookupExtractor(extractionMap, false);
        LookupExtractionFn lookupExtractionFn = new LookupExtractionFn((LookupExtractor)mapLookupExtractor, false, null, Boolean.valueOf(true), Boolean.valueOf(false));
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).setDimFilter((DimFilter)new ExtractionDimFilter("quality", "NOT_THERE", (ExtractionFn)lookupExtractionFn, null)).build();
        List expectedResults = Collections.emptyList();
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "dim-extraction");
    }

    @Test
    public void testGroupByWithExtractionDimFilterKeyisNull() {
        LookupExtractionFn lookupExtractionFn;
        HashMap<String, String> extractionMap = new HashMap<String, String>();
        MapLookupExtractor mapLookupExtractor = new MapLookupExtractor(extractionMap, false);
        if (NullHandling.replaceWithDefault()) {
            lookupExtractionFn = new LookupExtractionFn((LookupExtractor)mapLookupExtractor, false, null, Boolean.valueOf(true), Boolean.valueOf(false));
            extractionMap.put("", "REPLACED_VALUE");
        } else {
            lookupExtractionFn = new LookupExtractionFn((LookupExtractor)mapLookupExtractor, false, "REPLACED_VALUE", Boolean.valueOf(true), Boolean.valueOf(false));
            extractionMap.put("", "NOT_USED");
        }
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("null_column", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).setDimFilter((DimFilter)new ExtractionDimFilter("null_column", "REPLACED_VALUE", (ExtractionFn)lookupExtractionFn, null)).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", null, "rows", 13L, "idx", 6619L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", null, "rows", 13L, "idx", 5827L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "dim-extraction");
    }

    @Test
    public void testGroupByWithAggregatorFilterAndExtractionFunction() {
        HashMap<String, String> extractionMap = new HashMap<String, String>();
        extractionMap.put("automotive", "automotive0");
        extractionMap.put("business", "business0");
        extractionMap.put("entertainment", "entertainment0");
        extractionMap.put("health", "health0");
        extractionMap.put("mezzanine", "mezzanineANDnews");
        extractionMap.put("news", "mezzanineANDnews");
        extractionMap.put("premium", "premium0");
        extractionMap.put("technology", "technology0");
        extractionMap.put("travel", "travel0");
        MapLookupExtractor mapLookupExtractor = new MapLookupExtractor(extractionMap, false);
        LookupExtractionFn lookupExtractionFn = new LookupExtractionFn((LookupExtractor)mapLookupExtractor, false, "missing", Boolean.valueOf(true), Boolean.valueOf(false));
        ExtractionDimFilter filter = new ExtractionDimFilter("quality", "mezzanineANDnews", (ExtractionFn)lookupExtractionFn, null);
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)QueryRunnerTestHelper.ROWS_COUNT, (DimFilter)filter), new FilteredAggregatorFactory((AggregatorFactory)new LongSumAggregatorFactory("idx", "index"), (DimFilter)filter)}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "automotive", "rows", 0L, "idx", NullHandling.defaultLongValue()), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "business", "rows", 0L, "idx", NullHandling.defaultLongValue()), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "entertainment", "rows", 0L, "idx", NullHandling.defaultLongValue()), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "health", "rows", 0L, "idx", NullHandling.defaultLongValue()), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "mezzanine", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "news", "rows", 1L, "idx", 121L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "premium", "rows", 0L, "idx", NullHandling.defaultLongValue()), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "technology", "rows", 0L, "idx", NullHandling.defaultLongValue()), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "travel", "rows", 0L, "idx", NullHandling.defaultLongValue()), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "automotive", "rows", 0L, "idx", NullHandling.defaultLongValue()), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "business", "rows", 0L, "idx", NullHandling.defaultLongValue()), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "entertainment", "rows", 0L, "idx", NullHandling.defaultLongValue()), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "health", "rows", 0L, "idx", NullHandling.defaultLongValue()), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "mezzanine", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "news", "rows", 1L, "idx", 114L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "premium", "rows", 0L, "idx", NullHandling.defaultLongValue()), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "technology", "rows", 0L, "idx", NullHandling.defaultLongValue()), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "travel", "rows", 0L, "idx", NullHandling.defaultLongValue()));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "agg-filter");
    }

    @Test
    public void testGroupByWithExtractionDimFilterOptimazitionManyToOne() {
        HashMap<String, String> extractionMap = new HashMap<String, String>();
        extractionMap.put("mezzanine", "newsANDmezzanine");
        extractionMap.put("news", "newsANDmezzanine");
        MapLookupExtractor mapLookupExtractor = new MapLookupExtractor(extractionMap, false);
        LookupExtractionFn lookupExtractionFn = new LookupExtractionFn((LookupExtractor)mapLookupExtractor, false, null, Boolean.valueOf(true), Boolean.valueOf(true));
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).setDimFilter((DimFilter)new ExtractionDimFilter("quality", "newsANDmezzanine", (ExtractionFn)lookupExtractionFn, null)).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "mezzanine", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "news", "rows", 1L, "idx", 121L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "mezzanine", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "news", "rows", 1L, "idx", 114L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "extraction-dim-filter");
    }

    @Test
    public void testGroupByWithExtractionDimFilterNullDims() {
        LookupExtractionFn lookupExtractionFn;
        HashMap<String, String> extractionMap = new HashMap<String, String>();
        extractionMap.put("", "EMPTY");
        MapLookupExtractor mapLookupExtractor = new MapLookupExtractor(extractionMap, false);
        if (NullHandling.replaceWithDefault()) {
            extractionMap.put("", "EMPTY");
            lookupExtractionFn = new LookupExtractionFn((LookupExtractor)mapLookupExtractor, false, null, Boolean.valueOf(true), Boolean.valueOf(true));
        } else {
            extractionMap.put("", "SHOULD_NOT_BE_USED");
            lookupExtractionFn = new LookupExtractionFn((LookupExtractor)mapLookupExtractor, false, "EMPTY", Boolean.valueOf(true), Boolean.valueOf(true));
        }
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("null_column", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).setDimFilter((DimFilter)new ExtractionDimFilter("null_column", "EMPTY", (ExtractionFn)lookupExtractionFn, null)).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", null, "rows", 13L, "idx", 6619L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", null, "rows", 13L, "idx", 5827L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "extraction-dim-filter");
    }

    @Test
    public void testBySegmentResultsWithAllFiltersWithExtractionFns() {
        String extractionJsFn = "function(str) { return 'super-' + str; }";
        String jsFn = "function(x) { return(x === 'super-mezzanine') }";
        JavaScriptExtractionFn extractionFn = new JavaScriptExtractionFn(extractionJsFn, false, JavaScriptConfig.getEnabledInstance());
        ArrayList<Object> superFilterList = new ArrayList<Object>();
        superFilterList.add(new SelectorDimFilter("quality", "super-mezzanine", (ExtractionFn)extractionFn));
        superFilterList.add(new InDimFilter("quality", Arrays.asList("not-super-mezzanine", "FOOBAR", "super-mezzanine"), (ExtractionFn)extractionFn));
        superFilterList.add(new BoundDimFilter("quality", "super-mezzanine", "super-mezzanine", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), (ExtractionFn)extractionFn, StringComparators.ALPHANUMERIC));
        superFilterList.add(new RegexDimFilter("quality", "super-mezzanine", (ExtractionFn)extractionFn));
        superFilterList.add(new SearchQueryDimFilter("quality", (SearchQuerySpec)new ContainsSearchQuerySpec("super-mezzanine", true), (ExtractionFn)extractionFn));
        superFilterList.add(new JavaScriptDimFilter("quality", jsFn, (ExtractionFn)extractionFn, JavaScriptConfig.getEnabledInstance()));
        AndDimFilter superFilter = new AndDimFilter(superFilterList);
        GroupByQuery.Builder builder = this.makeQueryBuilder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).setDimFilter((DimFilter)superFilter).overrideContext((Map)ImmutableMap.of((Object)"bySegment", (Object)true));
        GroupByQuery fullQuery = builder.build();
        int segmentCount = 32;
        Result singleSegmentResult = new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new BySegmentResultValueClass(Collections.singletonList(GroupByQueryRunnerTest.makeRow(fullQuery, "2011-04-01", "alias", "mezzanine", "rows", 6L, "idx", 4420L)), QueryRunnerTestHelper.SEGMENT_ID.toString(), Intervals.of((String)"2011-04-02T00:00:00.000Z/2011-04-04T00:00:00.000Z")));
        ArrayList<Result> bySegmentResults = new ArrayList<Result>();
        for (int i = 0; i < segmentCount; ++i) {
            bySegmentResults.add(singleSegmentResult);
        }
        QueryToolChest toolChest = this.factory.getToolchest();
        ArrayList<QueryRunner> singleSegmentRunners = new ArrayList<QueryRunner>();
        for (int i = 0; i < segmentCount; ++i) {
            singleSegmentRunners.add(toolChest.preMergeQueryDecoration(this.runner));
        }
        ExecutorService exec = Executors.newCachedThreadPool();
        QueryRunner theRunner = toolChest.postMergeQueryDecoration((QueryRunner)new FinalizeResultsQueryRunner(toolChest.mergeResults(this.factory.mergeRunners(Executors.newCachedThreadPool(), singleSegmentRunners)), toolChest));
        TestHelper.assertExpectedObjects(bySegmentResults, theRunner.run(QueryPlus.wrap((Query)fullQuery)), "bySegment-filter");
        exec.shutdownNow();
    }

    @Test
    public void testGroupByWithAllFiltersOnNullDimsWithExtractionFns() {
        HashMap<String, String> extractionMap = new HashMap<String, String>();
        extractionMap.put("", "EMPTY");
        extractionMap.put(null, "EMPTY");
        MapLookupExtractor mapLookupExtractor = new MapLookupExtractor(extractionMap, false);
        LookupExtractionFn extractionFn = new LookupExtractionFn((LookupExtractor)mapLookupExtractor, false, "EMPTY", Boolean.valueOf(true), Boolean.valueOf(true));
        String jsFn = "function(x) { return(x === 'EMPTY') }";
        ArrayList<Object> superFilterList = new ArrayList<Object>();
        superFilterList.add(new SelectorDimFilter("null_column", "EMPTY", (ExtractionFn)extractionFn));
        superFilterList.add(new InDimFilter("null_column", Arrays.asList("NOT-EMPTY", "FOOBAR", "EMPTY"), (ExtractionFn)extractionFn));
        superFilterList.add(new BoundDimFilter("null_column", "EMPTY", "EMPTY", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), (ExtractionFn)extractionFn, StringComparators.ALPHANUMERIC));
        superFilterList.add(new RegexDimFilter("null_column", "EMPTY", (ExtractionFn)extractionFn));
        superFilterList.add(new SearchQueryDimFilter("null_column", (SearchQuerySpec)new ContainsSearchQuerySpec("EMPTY", true), (ExtractionFn)extractionFn));
        superFilterList.add(new JavaScriptDimFilter("null_column", jsFn, (ExtractionFn)extractionFn, JavaScriptConfig.getEnabledInstance()));
        AndDimFilter superFilter = new AndDimFilter(superFilterList);
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("null_column", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).setDimFilter((DimFilter)superFilter).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", null, "rows", 13L, "idx", 6619L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", null, "rows", 13L, "idx", 5827L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "extraction");
    }

    @Test
    public void testGroupByCardinalityAggWithExtractionFn() {
        this.cannotVectorize();
        String helloJsFn = "function(str) { return 'hello' }";
        JavaScriptExtractionFn helloFn = new JavaScriptExtractionFn(helloJsFn, false, JavaScriptConfig.getEnabledInstance());
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("market", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new CardinalityAggregatorFactory("numVals", (List)ImmutableList.of((Object)new ExtractionDimensionSpec("quality", "quality", (ExtractionFn)helloFn)), false)}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "spot", "rows", 9L, "numVals", 1.0002442201269182), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "total_market", "rows", 2L, "numVals", 1.0002442201269182), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "upfront", "rows", 2L, "numVals", 1.0002442201269182), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "spot", "rows", 9L, "numVals", 1.0002442201269182), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "total_market", "rows", 2L, "numVals", 1.0002442201269182), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "upfront", "rows", 2L, "numVals", 1.0002442201269182));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "cardinality-agg");
    }

    @Test
    public void testGroupByCardinalityAggOnFloat() {
        this.cannotVectorize();
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("market", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new CardinalityAggregatorFactory("numVals", (List)ImmutableList.of((Object)new DefaultDimensionSpec("index", "index")), false)}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "spot", "rows", 9L, "numVals", 8.015665809687173), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "total_market", "rows", 2L, "numVals", 2.000977198748901), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "upfront", "rows", 2L, "numVals", 2.000977198748901), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "spot", "rows", 9L, "numVals", 9.019833517963864), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "total_market", "rows", 2L, "numVals", 2.000977198748901), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "upfront", "rows", 2L, "numVals", 2.000977198748901));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "cardinality-agg");
    }

    @Test
    public void testGroupByLongColumn() {
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(UnsupportedOperationException.class);
            this.expectedException.expectMessage("GroupBy v1 only supports dimensions with an outputType of STRING.");
        }
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("qualityLong", "ql_alias", ValueType.LONG)}).setDimFilter((DimFilter)new SelectorDimFilter("quality", "entertainment", null)).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).addOrderByColumn(new OrderByColumnSpec("ql_alias", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC)).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        Assert.assertEquals((Object)Functions.identity(), (Object)query.getLimitSpec().build(query));
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "ql_alias", 1200L, "rows", 1L, "idx", 158L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "ql_alias", 1200L, "rows", 1L, "idx", 166L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "long");
    }

    @Test
    public void testGroupByLongColumnDescending() {
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(UnsupportedOperationException.class);
            this.expectedException.expectMessage("GroupBy v1 only supports dimensions with an outputType of STRING.");
        }
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("qualityLong", "ql_alias", ValueType.LONG)}).setDimFilter((DimFilter)new InDimFilter("quality", Arrays.asList("entertainment", "technology"), null)).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).addOrderByColumn(new OrderByColumnSpec("ql_alias", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)).setGranularity(QueryRunnerTestHelper.ALL_GRAN).build();
        Assert.assertNotEquals((Object)Functions.identity(), (Object)query.getLimitSpec().build(query));
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "ql_alias", 1700L, "rows", 2L, "idx", 175L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "ql_alias", 1200L, "rows", 2L, "idx", 324L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "long");
    }

    @Test
    public void testGroupByLongColumnWithExFn() {
        this.cannotVectorize();
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(UnsupportedOperationException.class);
            this.expectedException.expectMessage("GroupBy v1 does not support dimension selectors with unknown cardinality.");
        }
        String jsFn = "function(str) { return 'super-' + str; }";
        JavaScriptExtractionFn jsExtractionFn = new JavaScriptExtractionFn(jsFn, false, JavaScriptConfig.getEnabledInstance());
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new ExtractionDimensionSpec("qualityLong", "ql_alias", (ExtractionFn)jsExtractionFn)}).setDimFilter((DimFilter)new SelectorDimFilter("quality", "entertainment", null)).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "ql_alias", "super-1200", "rows", 1L, "idx", 158L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "ql_alias", "super-1200", "rows", 1L, "idx", 166L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "long-extraction");
    }

    @Test
    public void testGroupByLongTimeColumn() {
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(UnsupportedOperationException.class);
            this.expectedException.expectMessage("GroupBy v1 only supports dimensions with an outputType of STRING.");
        }
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("__time", "time_alias", ValueType.LONG)}).setDimFilter((DimFilter)new SelectorDimFilter("quality", "entertainment", null)).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "time_alias", 1301616000000L, "rows", 1L, "idx", 158L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "time_alias", 1301702400000L, "rows", 1L, "idx", 166L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "long");
    }

    @Test
    public void testGroupByLongTimeColumnWithExFn() {
        this.cannotVectorize();
        String jsFn = "function(str) { return 'super-' + str; }";
        JavaScriptExtractionFn jsExtractionFn = new JavaScriptExtractionFn(jsFn, false, JavaScriptConfig.getEnabledInstance());
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new ExtractionDimensionSpec("__time", "time_alias", (ExtractionFn)jsExtractionFn)}).setDimFilter((DimFilter)new SelectorDimFilter("quality", "entertainment", null)).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "time_alias", "super-1301616000000", "rows", 1L, "idx", 158L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "time_alias", "super-1301702400000", "rows", 1L, "idx", 166L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "long-extraction");
    }

    @Test
    public void testGroupByFloatColumn() {
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(UnsupportedOperationException.class);
            this.expectedException.expectMessage("GroupBy v1 only supports dimensions with an outputType of STRING.");
        }
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("index", "index_alias", ValueType.FLOAT)}).setDimFilter((DimFilter)new SelectorDimFilter("quality", "entertainment", null)).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).addOrderByColumn(new OrderByColumnSpec("index_alias", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC)).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        Assert.assertEquals((Object)Functions.identity(), (Object)query.getLimitSpec().build(query));
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "index_alias", Float.valueOf(158.74722f), "rows", 1L, "idx", 158L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "index_alias", Float.valueOf(166.01605f), "rows", 1L, "idx", 166L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "float");
    }

    @Test
    public void testGroupByFloatColumnDescending() {
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(UnsupportedOperationException.class);
            this.expectedException.expectMessage("GroupBy v1 only supports dimensions with an outputType of STRING.");
        }
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("qualityFloat", "qf_alias", ValueType.FLOAT)}).setDimFilter((DimFilter)new InDimFilter("quality", Arrays.asList("entertainment", "technology"), null)).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).addOrderByColumn(new OrderByColumnSpec("qf_alias", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)).setGranularity(QueryRunnerTestHelper.ALL_GRAN).build();
        Assert.assertNotEquals((Object)Functions.identity(), (Object)query.getLimitSpec().build(query));
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "qf_alias", Float.valueOf(17000.0f), "rows", 2L, "idx", 175L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "qf_alias", Float.valueOf(12000.0f), "rows", 2L, "idx", 324L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "float");
    }

    @Test
    public void testGroupByDoubleColumnDescending() {
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(UnsupportedOperationException.class);
            this.expectedException.expectMessage("GroupBy v1 only supports dimensions with an outputType of STRING.");
        }
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("qualityDouble", "alias", ValueType.DOUBLE)}).setDimFilter((DimFilter)new InDimFilter("quality", Arrays.asList("entertainment", "technology"), null)).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).addOrderByColumn(new OrderByColumnSpec("alias", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)).setGranularity(QueryRunnerTestHelper.ALL_GRAN).build();
        Assert.assertNotEquals((Object)Functions.identity(), (Object)query.getLimitSpec().build(query));
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", 17000.0, "rows", 2L, "idx", 175L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", 12000.0, "rows", 2L, "idx", 324L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "double");
    }

    @Test
    public void testGroupByFloatColumnWithExFn() {
        this.cannotVectorize();
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(UnsupportedOperationException.class);
            this.expectedException.expectMessage("GroupBy v1 does not support dimension selectors with unknown cardinality.");
        }
        String jsFn = "function(str) { return 'super-' + str; }";
        JavaScriptExtractionFn jsExtractionFn = new JavaScriptExtractionFn(jsFn, false, JavaScriptConfig.getEnabledInstance());
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new ExtractionDimensionSpec("index", "index_alias", (ExtractionFn)jsExtractionFn)}).setDimFilter((DimFilter)new SelectorDimFilter("quality", "entertainment", null)).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "index_alias", "super-158.747224", "rows", 1L, "idx", 158L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "index_alias", "super-166.016049", "rows", 1L, "idx", 166L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "float");
    }

    @Test
    public void testGroupByWithHavingSpecOnLongAndFloat() {
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(UnsupportedOperationException.class);
            this.expectedException.expectMessage("GroupBy v1 only supports dimensions with an outputType of STRING.");
        }
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("market", "alias"), new DefaultDimensionSpec("qualityLong", "ql_alias", ValueType.LONG), new DefaultDimensionSpec("__time", "time_alias", ValueType.LONG), new DefaultDimensionSpec("index", "index_alias", ValueType.FLOAT)}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT}).setHavingSpec((HavingSpec)new DimFilterHavingSpec((DimFilter)new AndDimFilter((List)Lists.newArrayList((Object[])new DimFilter[]{new SelectorDimFilter("ql_alias", "1400", null), new SelectorDimFilter("time_alias", "1301616000000", null), new BoundDimFilter("index_alias", "1310.0", "1320.0", Boolean.valueOf(true), Boolean.valueOf(true), null, null, StringComparators.NUMERIC)})), null)).setGranularity(QueryRunnerTestHelper.ALL_GRAN).build();
        List<ResultRow> expectedResults = Collections.singletonList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "total_market", "time_alias", 1301616000000L, "index_alias", 1314.8397, "ql_alias", 1400L, "rows", 1L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "havingspec-long-float");
    }

    @Test
    public void testGroupByLongAndFloatOutputAsString() {
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(UnsupportedOperationException.class);
            this.expectedException.expectMessage("GroupBy v1 does not support dimension selectors with unknown cardinality.");
        }
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("qualityLong", "ql_alias"), new DefaultDimensionSpec("qualityFloat", "qf_alias")}).setDimFilter((DimFilter)new SelectorDimFilter("quality", "entertainment", null)).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "ql_alias", "1200", "qf_alias", "12000.0", "rows", 1L, "idx", 158L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "ql_alias", "1200", "qf_alias", "12000.0", "rows", 1L, "idx", 166L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "long-float");
    }

    @Test
    public void testGroupByNumericStringsAsNumeric() {
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(UnsupportedOperationException.class);
            this.expectedException.expectMessage("GroupBy v1 does not support dimension selectors with unknown cardinality.");
        }
        GroupByQuery subquery = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("qualityLong", "ql_alias"), new DefaultDimensionSpec("qualityFloat", "qf_alias"), new DefaultDimensionSpec("__time", "time_alias")}).setDimFilter((DimFilter)new SelectorDimFilter("quality", "entertainment", null)).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        GroupByQuery outerQuery = this.makeQueryBuilder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("time_alias", "time_alias2", ValueType.LONG), new DefaultDimensionSpec("ql_alias", "ql_alias_long", ValueType.LONG), new DefaultDimensionSpec("qf_alias", "qf_alias_float", ValueType.FLOAT), new DefaultDimensionSpec("ql_alias", "ql_alias_float", ValueType.FLOAT)}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setGranularity(QueryRunnerTestHelper.ALL_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(outerQuery, "2011-04-01", "time_alias2", 1301616000000L, "ql_alias_long", 1200L, "qf_alias_float", 12000.0, "ql_alias_float", 1200.0, "count", 1L), GroupByQueryRunnerTest.makeRow(outerQuery, "2011-04-01", "time_alias2", 1301702400000L, "ql_alias_long", 1200L, "qf_alias_float", 12000.0, "ql_alias_float", 1200.0, "count", 1L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, outerQuery);
        TestHelper.assertExpectedObjects(expectedResults, results, "numeric-string");
    }

    @Test
    public void testGroupByNumericStringsAsNumericWithDecoration() {
        this.cannotVectorize();
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(UnsupportedOperationException.class);
            this.expectedException.expectMessage("GroupBy v1 only supports dimensions with an outputType of STRING.");
        }
        RegexFilteredDimensionSpec regexSpec = new RegexFilteredDimensionSpec((DimensionSpec)new DefaultDimensionSpec("qualityNumericString", "ql", ValueType.LONG), "170000");
        ListFilteredDimensionSpec listFilteredSpec = new ListFilteredDimensionSpec((DimensionSpec)new DefaultDimensionSpec("qualityNumericString", "qf", ValueType.FLOAT), (Set)Sets.newHashSet((Object[])new String[]{"170000"}), Boolean.valueOf(true));
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{regexSpec, listFilteredSpec}).setDimFilter((DimFilter)new InDimFilter("quality", Arrays.asList("entertainment", "technology"), null)).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setGranularity(QueryRunnerTestHelper.ALL_GRAN).addOrderByColumn("ql").build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "ql", NullHandling.defaultLongValue(), "qf", NullHandling.defaultDoubleValue(), "count", 2L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "ql", 170000L, "qf", 170000.0, "count", 2L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "numeric-string");
    }

    @Test
    public void testGroupByDecorationOnNumerics() {
        this.cannotVectorize();
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(UnsupportedOperationException.class);
            this.expectedException.expectMessage("GroupBy v1 only supports dimensions with an outputType of STRING.");
        }
        RegexFilteredDimensionSpec regexSpec = new RegexFilteredDimensionSpec((DimensionSpec)new DefaultDimensionSpec("qualityLong", "ql", ValueType.LONG), "1700");
        ListFilteredDimensionSpec listFilteredSpec = new ListFilteredDimensionSpec((DimensionSpec)new DefaultDimensionSpec("qualityFloat", "qf", ValueType.FLOAT), (Set)Sets.newHashSet((Object[])new String[]{"17000.0"}), Boolean.valueOf(true));
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{regexSpec, listFilteredSpec}).setDimFilter((DimFilter)new InDimFilter("quality", Arrays.asList("entertainment", "technology"), null)).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setGranularity(QueryRunnerTestHelper.ALL_GRAN).build();
        List<ResultRow> expectedResults = NullHandling.replaceWithDefault() ? Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "ql", 0L, "qf", 0.0, "count", 2L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "ql", 1700L, "qf", 17000.0, "count", 2L)) : Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "ql", null, "qf", null, "count", 2L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "ql", 1700L, "qf", 17000.0, "count", 2L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "numeric");
    }

    @Test
    public void testGroupByNestedWithInnerQueryNumerics() {
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(UnsupportedOperationException.class);
            this.expectedException.expectMessage("GroupBy v1 only supports dimensions with an outputType of STRING.");
        }
        GroupByQuery subquery = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias"), new DefaultDimensionSpec("qualityLong", "ql_alias", ValueType.LONG), new DefaultDimensionSpec("qualityFloat", "qf_alias", ValueType.FLOAT)}).setDimFilter((DimFilter)new InDimFilter("quality", Collections.singletonList("entertainment"), null)).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        GroupByQuery outerQuery = this.makeQueryBuilder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("ql_alias", "quallong", ValueType.LONG), new DefaultDimensionSpec("qf_alias", "qualfloat", ValueType.FLOAT)}).setDimFilter((DimFilter)new AndDimFilter((List)Lists.newArrayList((Object[])new DimFilter[]{new SelectorDimFilter("ql_alias", "1200", null), new BoundDimFilter("qf_alias", "11095.0", "12005.0", Boolean.valueOf(true), Boolean.valueOf(true), null, null, StringComparators.NUMERIC)}))).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("ql_alias_sum", "ql_alias"), new DoubleSumAggregatorFactory("qf_alias_sum", "qf_alias")}).setGranularity(QueryRunnerTestHelper.ALL_GRAN).build();
        List<ResultRow> expectedResults = Collections.singletonList(GroupByQueryRunnerTest.makeRow(outerQuery, "2011-04-01", "quallong", 1200L, "qualfloat", 12000.0, "ql_alias_sum", 2400L, "qf_alias_sum", 24000.0));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, outerQuery);
        TestHelper.assertExpectedObjects(expectedResults, results, "numerics");
    }

    @Test
    public void testGroupByNestedWithInnerQueryNumericsWithLongTime() {
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(UnsupportedOperationException.class);
            this.expectedException.expectMessage("GroupBy v1 only supports dimensions with an outputType of STRING.");
        }
        GroupByQuery subQuery = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("market", "alias"), new DefaultDimensionSpec("__time", "time_alias", ValueType.LONG), new DefaultDimensionSpec("index", "index_alias", ValueType.FLOAT)}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT}).setGranularity(QueryRunnerTestHelper.ALL_GRAN).build();
        GroupByQuery outerQuery = this.makeQueryBuilder().setDataSource((Query)subQuery).setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("alias", "market"), new DefaultDimensionSpec("time_alias", "time_alias2", ValueType.LONG)}).setAggregatorSpecs(new AggregatorFactory[]{new LongMaxAggregatorFactory("time_alias_max", "time_alias"), new DoubleMaxAggregatorFactory("index_alias_max", "index_alias")}).setGranularity(QueryRunnerTestHelper.ALL_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(outerQuery, "2011-04-01", "market", "spot", "time_alias2", 1301616000000L, "time_alias_max", 1301616000000L, "index_alias_max", 158.74722290039062), GroupByQueryRunnerTest.makeRow(outerQuery, "2011-04-01", "market", "spot", "time_alias2", 1301702400000L, "time_alias_max", 1301702400000L, "index_alias_max", 166.01605224609375), GroupByQueryRunnerTest.makeRow(outerQuery, "2011-04-01", "market", "total_market", "time_alias2", 1301616000000L, "time_alias_max", 1301616000000L, "index_alias_max", 1522.043701171875), GroupByQueryRunnerTest.makeRow(outerQuery, "2011-04-01", "market", "total_market", "time_alias2", 1301702400000L, "time_alias_max", 1301702400000L, "index_alias_max", 1321.375), GroupByQueryRunnerTest.makeRow(outerQuery, "2011-04-01", "market", "upfront", "time_alias2", 1301616000000L, "time_alias_max", 1301616000000L, "index_alias_max", 1447.3411865234375), GroupByQueryRunnerTest.makeRow(outerQuery, "2011-04-01", "market", "upfront", "time_alias2", 1301702400000L, "time_alias_max", 1301702400000L, "index_alias_max", 1144.3424072265625));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, outerQuery);
        TestHelper.assertExpectedObjects(expectedResults, results, "numerics");
    }

    @Test
    public void testGroupByStringOutputAsLong() {
        this.cannotVectorize();
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(UnsupportedOperationException.class);
            this.expectedException.expectMessage("GroupBy v1 only supports dimensions with an outputType of STRING.");
        }
        StrlenExtractionFn strlenFn = StrlenExtractionFn.instance();
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new ExtractionDimensionSpec("quality", "alias", ValueType.LONG, (ExtractionFn)strlenFn)}).setDimFilter((DimFilter)new SelectorDimFilter("quality", "entertainment", null)).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", 13L, "rows", 1L, "idx", 158L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", 13L, "rows", 1L, "idx", 166L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "string-long");
    }

    @Test
    public void testGroupByWithAggsOnNumericDimensions() {
        this.cannotVectorize();
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setDimFilter((DimFilter)new SelectorDimFilter("quality", "technology", null)).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("qlLong", "qualityLong"), new DoubleSumAggregatorFactory("qlFloat", "qualityLong"), new JavaScriptAggregatorFactory("qlJs", (List)ImmutableList.of((Object)"qualityLong"), "function(a,b) { return a + b; }", "function() { return 0; }", "function(a,b) { return a + b }", JavaScriptConfig.getEnabledInstance()), new DoubleSumAggregatorFactory("qfFloat", "qualityFloat"), new LongSumAggregatorFactory("qfLong", "qualityFloat"), new JavaScriptAggregatorFactory("qfJs", (List)ImmutableList.of((Object)"qualityFloat"), "function(a,b) { return a + b; }", "function() { return 0; }", "function(a,b) { return a + b }", JavaScriptConfig.getEnabledInstance())}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "technology", "rows", 1L, "qlLong", 1700L, "qlFloat", 1700.0, "qlJs", 1700.0, "qfFloat", 17000.0, "qfLong", 17000L, "qfJs", 17000.0), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "technology", "rows", 1L, "qlLong", 1700L, "qlFloat", 1700.0, "qlJs", 1700.0, "qfFloat", 17000.0, "qfLong", 17000L, "qfJs", 17000.0));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "numeric-dims");
    }

    @Test
    public void testGroupByNestedOuterExtractionFnOnFloatInner() {
        this.cannotVectorize();
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(UnsupportedOperationException.class);
            this.expectedException.expectMessage("GroupBy v1 only supports dimensions with an outputType of STRING.");
        }
        String jsFn = "function(obj) { return obj; }";
        JavaScriptExtractionFn jsExtractionFn = new JavaScriptExtractionFn(jsFn, false, JavaScriptConfig.getEnabledInstance());
        GroupByQuery subquery = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias"), new ExtractionDimensionSpec("qualityFloat", "qf_inner", ValueType.FLOAT, (ExtractionFn)jsExtractionFn)}).setDimFilter((DimFilter)new SelectorDimFilter("quality", "technology", null)).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        GroupByQuery outerQuery = this.makeQueryBuilder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("alias", "alias"), new ExtractionDimensionSpec("qf_inner", "qf_outer", ValueType.FLOAT, (ExtractionFn)jsExtractionFn)}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT}).setGranularity(QueryRunnerTestHelper.ALL_GRAN).build();
        List<ResultRow> expectedResults = Collections.singletonList(GroupByQueryRunnerTest.makeRow(outerQuery, "2011-04-01", "alias", "technology", "qf_outer", Float.valueOf(17000.0f), "rows", 2L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, outerQuery);
        TestHelper.assertExpectedObjects(expectedResults, results, "extraction-fn");
    }

    @Test
    public void testGroupByNestedDoubleTimeExtractionFnWithLongOutputTypes() {
        this.cannotVectorize();
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(UnsupportedOperationException.class);
            this.expectedException.expectMessage("GroupBy v1 only supports dimensions with an outputType of STRING.");
        }
        GroupByQuery subquery = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias"), new ExtractionDimensionSpec("__time", "time_day", ValueType.LONG, (ExtractionFn)new TimeFormatExtractionFn(null, null, null, Granularities.DAY, true))}).setDimFilter((DimFilter)new SelectorDimFilter("quality", "technology", null)).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        GroupByQuery outerQuery = this.makeQueryBuilder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("alias", "alias"), new ExtractionDimensionSpec("time_day", "time_week", ValueType.LONG, (ExtractionFn)new TimeFormatExtractionFn(null, null, null, Granularities.WEEK, true))}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT}).setGranularity(QueryRunnerTestHelper.ALL_GRAN).build();
        List<ResultRow> expectedResults = Collections.singletonList(GroupByQueryRunnerTest.makeRow(outerQuery, "2011-04-01", "alias", "technology", "time_week", 1301270400000L, "rows", 2L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, outerQuery);
        TestHelper.assertExpectedObjects(expectedResults, results, "extraction-fn");
    }

    @Test
    public void testGroupByLimitPushDown() {
        if (!this.config.getDefaultStrategy().equals("v2")) {
            return;
        }
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setGranularity(QueryRunnerTestHelper.ALL_GRAN).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("market", "marketalias")}).setInterval(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).setLimitSpec((LimitSpec)new DefaultLimitSpec(Collections.singletonList(new OrderByColumnSpec("marketalias", OrderByColumnSpec.Direction.DESCENDING)), Integer.valueOf(2))).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT}).overrideContext((Map)ImmutableMap.of((Object)"forceLimitPushDown", (Object)true)).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "1970-01-01T00:00:00.000Z", "marketalias", "upfront", "rows", 186L), GroupByQueryRunnerTest.makeRow(query, "1970-01-01T00:00:00.000Z", "marketalias", "total_market", "rows", 186L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "order-limit");
    }

    @Test
    public void testGroupByLimitPushDownWithLongDimensionNotInLimitSpec() {
        this.cannotVectorize();
        if (!this.config.getDefaultStrategy().equals("v2")) {
            return;
        }
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setGranularity(QueryRunnerTestHelper.ALL_GRAN).setDimensions(new DimensionSpec[]{new ExtractionDimensionSpec("quality", "qualityLen", ValueType.LONG, (ExtractionFn)StrlenExtractionFn.instance())}).setInterval(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).setLimitSpec((LimitSpec)new DefaultLimitSpec(Collections.EMPTY_LIST, Integer.valueOf(6))).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT}).overrideContext((Map)ImmutableMap.of((Object)"forceLimitPushDown", (Object)true)).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "1970-01-01T00:00:00.000Z", "qualityLen", 4L, "rows", 93L), GroupByQueryRunnerTest.makeRow(query, "1970-01-01T00:00:00.000Z", "qualityLen", 6L, "rows", 186L), GroupByQueryRunnerTest.makeRow(query, "1970-01-01T00:00:00.000Z", "qualityLen", 7L, "rows", 279L), GroupByQueryRunnerTest.makeRow(query, "1970-01-01T00:00:00.000Z", "qualityLen", 8L, "rows", 93L), GroupByQueryRunnerTest.makeRow(query, "1970-01-01T00:00:00.000Z", "qualityLen", 9L, "rows", 279L), GroupByQueryRunnerTest.makeRow(query, "1970-01-01T00:00:00.000Z", "qualityLen", 10L, "rows", 186L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "order-limit");
    }

    @Test
    public void testMergeResultsWithLimitPushDown() {
        if (!this.config.getDefaultStrategy().equals("v2")) {
            return;
        }
        GroupByQuery.Builder builder = this.makeQueryBuilder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setLimitSpec((LimitSpec)new DefaultLimitSpec(Collections.singletonList(new OrderByColumnSpec("alias", OrderByColumnSpec.Direction.DESCENDING)), Integer.valueOf(5))).overrideContext((Map)ImmutableMap.of((Object)"forceLimitPushDown", (Object)true)).setGranularity(Granularities.ALL);
        GroupByQuery allGranQuery = builder.build();
        QueryRunner mergedRunner = this.factory.getToolchest().mergeResults((QueryRunner)new QueryRunner<ResultRow>(){

            public Sequence<ResultRow> run(QueryPlus<ResultRow> queryPlus, ResponseContext responseContext) {
                QueryPlus queryPlus1 = queryPlus.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.of((String)"2011-04-02/2011-04-03"))));
                QueryPlus queryPlus2 = queryPlus.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.of((String)"2011-04-03/2011-04-04"))));
                return GroupByQueryRunnerTest.this.factory.getToolchest().mergeResults((queryPlus3, responseContext1) -> new MergeSequence(queryPlus3.getQuery().getResultOrdering(), Sequences.simple(Arrays.asList(GroupByQueryRunnerTest.this.runner.run(queryPlus1, responseContext1), GroupByQueryRunnerTest.this.runner.run(queryPlus2, responseContext1))))).run(queryPlus, responseContext);
            }
        });
        HashMap context = new HashMap();
        List<ResultRow> allGranExpectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(allGranQuery, "2011-04-02", "alias", "travel", "rows", 2L, "idx", 243L), GroupByQueryRunnerTest.makeRow(allGranQuery, "2011-04-02", "alias", "technology", "rows", 2L, "idx", 177L), GroupByQueryRunnerTest.makeRow(allGranQuery, "2011-04-02", "alias", "premium", "rows", 6L, "idx", 4416L), GroupByQueryRunnerTest.makeRow(allGranQuery, "2011-04-02", "alias", "news", "rows", 2L, "idx", 221L), GroupByQueryRunnerTest.makeRow(allGranQuery, "2011-04-02", "alias", "mezzanine", "rows", 6L, "idx", 4420L));
        TestHelper.assertExpectedObjects(allGranExpectedResults, mergedRunner.run(QueryPlus.wrap((Query)allGranQuery)), "merged");
    }

    @Test
    public void testMergeResultsWithLimitPushDownSortByAgg() {
        if (!this.config.getDefaultStrategy().equals("v2")) {
            return;
        }
        GroupByQuery.Builder builder = this.makeQueryBuilder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setLimitSpec((LimitSpec)new DefaultLimitSpec(Collections.singletonList(new OrderByColumnSpec("idx", OrderByColumnSpec.Direction.DESCENDING)), Integer.valueOf(5))).overrideContext((Map)ImmutableMap.of((Object)"forceLimitPushDown", (Object)true)).setGranularity(Granularities.ALL);
        GroupByQuery allGranQuery = builder.build();
        QueryRunner mergedRunner = this.factory.getToolchest().mergeResults((QueryRunner)new QueryRunner<ResultRow>(){

            public Sequence<ResultRow> run(QueryPlus<ResultRow> queryPlus, ResponseContext responseContext) {
                QueryPlus queryPlus1 = queryPlus.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.of((String)"2011-04-02/2011-04-03"))));
                QueryPlus queryPlus2 = queryPlus.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.of((String)"2011-04-03/2011-04-04"))));
                return GroupByQueryRunnerTest.this.factory.getToolchest().mergeResults((queryPlus3, responseContext1) -> new MergeSequence(queryPlus3.getQuery().getResultOrdering(), Sequences.simple(Arrays.asList(GroupByQueryRunnerTest.this.runner.run(queryPlus1, responseContext1), GroupByQueryRunnerTest.this.runner.run(queryPlus2, responseContext1))))).run(queryPlus, responseContext);
            }
        });
        List<ResultRow> allGranExpectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(allGranQuery, "2011-04-02", "alias", "mezzanine", "rows", 6L, "idx", 4420L), GroupByQueryRunnerTest.makeRow(allGranQuery, "2011-04-02", "alias", "premium", "rows", 6L, "idx", 4416L), GroupByQueryRunnerTest.makeRow(allGranQuery, "2011-04-02", "alias", "entertainment", "rows", 2L, "idx", 319L), GroupByQueryRunnerTest.makeRow(allGranQuery, "2011-04-02", "alias", "automotive", "rows", 2L, "idx", 269L), GroupByQueryRunnerTest.makeRow(allGranQuery, "2011-04-02", "alias", "travel", "rows", 2L, "idx", 243L));
        List results = mergedRunner.run(QueryPlus.wrap((Query)allGranQuery)).toList();
        TestHelper.assertExpectedObjects(allGranExpectedResults, results, "merged");
    }

    @Test
    public void testMergeResultsWithLimitPushDownSortByDimDim() {
        if (!this.config.getDefaultStrategy().equals("v2")) {
            return;
        }
        GroupByQuery.Builder builder = this.makeQueryBuilder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias"), new DefaultDimensionSpec("market", "market")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)Lists.newArrayList((Object[])new OrderByColumnSpec[]{new OrderByColumnSpec("alias", OrderByColumnSpec.Direction.DESCENDING), new OrderByColumnSpec("market", OrderByColumnSpec.Direction.DESCENDING)}), Integer.valueOf(5))).overrideContext((Map)ImmutableMap.of((Object)"forceLimitPushDown", (Object)true)).setGranularity(Granularities.ALL);
        GroupByQuery allGranQuery = builder.build();
        QueryRunner mergedRunner = this.factory.getToolchest().mergeResults((QueryRunner)new QueryRunner<ResultRow>(){

            public Sequence<ResultRow> run(QueryPlus<ResultRow> queryPlus, ResponseContext responseContext) {
                QueryPlus queryPlus1 = queryPlus.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.of((String)"2011-04-02/2011-04-03"))));
                QueryPlus queryPlus2 = queryPlus.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.of((String)"2011-04-03/2011-04-04"))));
                return GroupByQueryRunnerTest.this.factory.getToolchest().mergeResults((queryPlus3, responseContext1) -> new MergeSequence(queryPlus3.getQuery().getResultOrdering(), Sequences.simple(Arrays.asList(GroupByQueryRunnerTest.this.runner.run(queryPlus1, responseContext1), GroupByQueryRunnerTest.this.runner.run(queryPlus2, responseContext1))))).run(queryPlus, responseContext);
            }
        });
        List<ResultRow> allGranExpectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(allGranQuery, "2011-04-02", "alias", "travel", "market", "spot", "rows", 2L, "idx", 243L), GroupByQueryRunnerTest.makeRow(allGranQuery, "2011-04-02", "alias", "technology", "market", "spot", "rows", 2L, "idx", 177L), GroupByQueryRunnerTest.makeRow(allGranQuery, "2011-04-02", "alias", "premium", "market", "upfront", "rows", 2L, "idx", 1817L), GroupByQueryRunnerTest.makeRow(allGranQuery, "2011-04-02", "alias", "premium", "market", "total_market", "rows", 2L, "idx", 2342L), GroupByQueryRunnerTest.makeRow(allGranQuery, "2011-04-02", "alias", "premium", "market", "spot", "rows", 2L, "idx", 257L));
        List results = mergedRunner.run(QueryPlus.wrap((Query)allGranQuery)).toList();
        TestHelper.assertExpectedObjects(allGranExpectedResults, results, "merged");
    }

    @Test
    public void testMergeResultsWithLimitPushDownSortByDimAggDim() {
        if (!this.config.getDefaultStrategy().equals("v2")) {
            return;
        }
        GroupByQuery.Builder builder = this.makeQueryBuilder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias"), new DefaultDimensionSpec("market", "market")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)Lists.newArrayList((Object[])new OrderByColumnSpec[]{new OrderByColumnSpec("alias", OrderByColumnSpec.Direction.DESCENDING), new OrderByColumnSpec("idx", OrderByColumnSpec.Direction.DESCENDING), new OrderByColumnSpec("market", OrderByColumnSpec.Direction.DESCENDING)}), Integer.valueOf(5))).overrideContext((Map)ImmutableMap.of((Object)"forceLimitPushDown", (Object)true)).setGranularity(Granularities.ALL);
        GroupByQuery allGranQuery = builder.build();
        QueryRunner mergedRunner = this.factory.getToolchest().mergeResults((QueryRunner)new QueryRunner<ResultRow>(){

            public Sequence<ResultRow> run(QueryPlus<ResultRow> queryPlus, ResponseContext responseContext) {
                QueryPlus queryPlus1 = queryPlus.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.of((String)"2011-04-02/2011-04-03"))));
                QueryPlus queryPlus2 = queryPlus.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.of((String)"2011-04-03/2011-04-04"))));
                return GroupByQueryRunnerTest.this.factory.getToolchest().mergeResults((queryPlus3, responseContext1) -> new MergeSequence(queryPlus3.getQuery().getResultOrdering(), Sequences.simple(Arrays.asList(GroupByQueryRunnerTest.this.runner.run(queryPlus1, responseContext1), GroupByQueryRunnerTest.this.runner.run(queryPlus2, responseContext1))))).run(queryPlus, responseContext);
            }
        });
        List<ResultRow> allGranExpectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(allGranQuery, "2011-04-02", "alias", "travel", "market", "spot", "rows", 2L, "idx", 243L), GroupByQueryRunnerTest.makeRow(allGranQuery, "2011-04-02", "alias", "technology", "market", "spot", "rows", 2L, "idx", 177L), GroupByQueryRunnerTest.makeRow(allGranQuery, "2011-04-02", "alias", "premium", "market", "total_market", "rows", 2L, "idx", 2342L), GroupByQueryRunnerTest.makeRow(allGranQuery, "2011-04-02", "alias", "premium", "market", "upfront", "rows", 2L, "idx", 1817L), GroupByQueryRunnerTest.makeRow(allGranQuery, "2011-04-02", "alias", "premium", "market", "spot", "rows", 2L, "idx", 257L));
        List results = mergedRunner.run(QueryPlus.wrap((Query)allGranQuery)).toList();
        TestHelper.assertExpectedObjects(allGranExpectedResults, results, "merged");
    }

    @Test
    public void testGroupByLimitPushDownPostAggNotSupported() {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.expectedException.expectMessage("Limit push down when sorting by a post aggregator is not supported.");
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setGranularity(QueryRunnerTestHelper.ALL_GRAN).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("market", "marketalias")}).setInterval(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).setLimitSpec((LimitSpec)new DefaultLimitSpec(Collections.singletonList(new OrderByColumnSpec("constant", OrderByColumnSpec.Direction.DESCENDING)), Integer.valueOf(2))).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT}).setPostAggregatorSpecs(Collections.singletonList(new ConstantPostAggregator("constant", (Number)1))).overrideContext((Map)ImmutableMap.of((Object)"forceLimitPushDown", (Object)true)).build();
        GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
    }

    @Test
    public void testEmptySubqueryWithLimitPushDown() {
        GroupByQuery subquery = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.EMPTY_INTERVAL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setLimitSpec((LimitSpec)new DefaultLimitSpec(Collections.singletonList(new OrderByColumnSpec("alias", OrderByColumnSpec.Direction.DESCENDING)), Integer.valueOf(5))).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        GroupByQuery query = this.makeQueryBuilder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setAggregatorSpecs(new AggregatorFactory[]{new DoubleMaxAggregatorFactory("idx", "idx")}).setLimitSpec((LimitSpec)new DefaultLimitSpec(null, Integer.valueOf(5))).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        Assert.assertFalse((boolean)results.iterator().hasNext());
    }

    @Test
    public void testSubqueryWithMultipleIntervalsInOuterQueryWithLimitPushDown() {
        GroupByQuery subquery = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setDimFilter((DimFilter)new JavaScriptDimFilter("quality", "function(dim){ return true; }", null, JavaScriptConfig.getEnabledInstance())).setLimitSpec((LimitSpec)new DefaultLimitSpec(Collections.singletonList(new OrderByColumnSpec("alias", OrderByColumnSpec.Direction.DESCENDING)), Integer.valueOf(12))).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index"), new LongSumAggregatorFactory("indexMaxPlusTen", "indexMaxPlusTen")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        GroupByQuery query = this.makeQueryBuilder().setDataSource((Query)subquery).setQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2011-04-01T00:00:00.000Z/2011-04-01T23:58:00.000Z"), (Object)Intervals.of((String)"2011-04-02T00:00:00.000Z/2011-04-03T00:00:00.000Z")))).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("alias", "alias")}).setLimitSpec((LimitSpec)new DefaultLimitSpec(Collections.singletonList(new OrderByColumnSpec("alias", OrderByColumnSpec.Direction.DESCENDING)), Integer.valueOf(15))).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("rows", "rows"), new LongSumAggregatorFactory("idx", "idx")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "travel", "rows", 1L, "idx", 119L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "technology", "rows", 1L, "idx", 78L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "premium", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "news", "rows", 1L, "idx", 121L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "mezzanine", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "health", "rows", 1L, "idx", 120L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "entertainment", "rows", 1L, "idx", 158L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "business", "rows", 1L, "idx", 118L), GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "automotive", "rows", 1L, "idx", 135L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "travel", "rows", 1L, "idx", 126L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "technology", "rows", 1L, "idx", 97L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "premium", "rows", 3L, "idx", 2505L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "limit-pushdown");
    }

    @Test
    public void testRejectForceLimitPushDownWithHaving() {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("Cannot force limit push down when a having spec is present.");
        this.makeQueryBuilder().setDataSource("testing").setGranularity(QueryRunnerTestHelper.ALL_GRAN).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("market", "marketalias")}).setInterval(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).setLimitSpec((LimitSpec)new DefaultLimitSpec(Collections.singletonList(new OrderByColumnSpec("marketalias", OrderByColumnSpec.Direction.DESCENDING)), Integer.valueOf(2))).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT}).overrideContext((Map)ImmutableMap.of((Object)"forceLimitPushDown", (Object)true)).setHavingSpec((HavingSpec)new GreaterThanHavingSpec("rows", (Number)10)).build();
    }

    @Test
    public void testTypeConversionWithMergingChainedExecutionRunner() {
        this.cannotVectorize();
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(UnsupportedOperationException.class);
            this.expectedException.expectMessage("GroupBy v1 only supports dimensions with an outputType of STRING.");
        }
        GroupByQuery query = this.makeQueryBuilder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias"), new ExtractionDimensionSpec("quality", "qualityLen", ValueType.LONG, (ExtractionFn)StrlenExtractionFn.instance())}).setDimFilter((DimFilter)new SelectorDimFilter("quality", "technology", null)).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "technology", "qualityLen", 10L, "rows", 2L, "idx", 156L), GroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "technology", "qualityLen", 10L, "rows", 2L, "idx", 194L));
        ChainedExecutionQueryRunner ceqr = new ChainedExecutionQueryRunner((ExecutorService)Execs.directExecutor(), (query1, future) -> {}, (Iterable)ImmutableList.of(this.runner, this.runner));
        QueryRunner mergingRunner = this.factory.mergeRunners((ExecutorService)Execs.directExecutor(), (Iterable)ImmutableList.of((Object)ceqr));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, mergingRunner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "type-conversion");
    }

    private static ResultRow makeRow(GroupByQuery query, String timestamp, Object ... vals) {
        return GroupByQueryRunnerTestHelper.createExpectedRow(query, timestamp, vals);
    }

    private static ResultRow makeRow(GroupByQuery query, DateTime timestamp, Object ... vals) {
        return GroupByQueryRunnerTestHelper.createExpectedRow(query, timestamp, vals);
    }

    private static List<ResultRow> makeRows(GroupByQuery query, String[] columnNames, Object[] ... values) {
        return GroupByQueryRunnerTestHelper.createExpectedRows(query, columnNames, values);
    }

    private GroupByQuery.Builder makeQueryBuilder() {
        return GroupByQuery.builder().overrideContext(this.makeContext());
    }

    private GroupByQuery.Builder makeQueryBuilder(GroupByQuery query) {
        return new GroupByQuery.Builder(query).overrideContext(this.makeContext());
    }

    private Map<String, Object> makeContext() {
        return ImmutableMap.builder().put((Object)"vectorize", (Object)(this.vectorize ? "force" : "false")).put((Object)"vectorSize", (Object)16).build();
    }

    private void cannotVectorize() {
        if (this.vectorize && this.config.getDefaultStrategy().equals("v2")) {
            this.expectedException.expect(RuntimeException.class);
            this.expectedException.expectMessage("Cannot vectorize!");
        }
    }
}

