/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.groupby;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.org.apache.druid.collections.SerializablePair;
import org.apache.hive.druid.org.apache.druid.data.input.Row;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.query.CacheStrategy;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.FloatSumAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.SerializablePairLongString;
import org.apache.hive.druid.org.apache.druid.query.aggregation.last.DoubleLastAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.last.FloatLastAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.last.LongLastAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.last.StringLastAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.post.ConstantPostAggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.post.ExpressionPostAggregator;
import org.apache.hive.druid.org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.hive.druid.org.apache.druid.query.filter.AndDimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.BoundDimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.DimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.OrDimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.hive.druid.org.apache.druid.query.groupby.GroupByQuery;
import org.apache.hive.druid.org.apache.druid.query.groupby.GroupByQueryQueryToolChest;
import org.apache.hive.druid.org.apache.druid.query.groupby.ResultRow;
import org.apache.hive.druid.org.apache.druid.query.groupby.having.AndHavingSpec;
import org.apache.hive.druid.org.apache.druid.query.groupby.having.DimFilterHavingSpec;
import org.apache.hive.druid.org.apache.druid.query.groupby.having.EqualToHavingSpec;
import org.apache.hive.druid.org.apache.druid.query.groupby.having.GreaterThanHavingSpec;
import org.apache.hive.druid.org.apache.druid.query.groupby.having.HavingSpec;
import org.apache.hive.druid.org.apache.druid.query.groupby.having.LessThanHavingSpec;
import org.apache.hive.druid.org.apache.druid.query.groupby.having.NotHavingSpec;
import org.apache.hive.druid.org.apache.druid.query.groupby.having.OrHavingSpec;
import org.apache.hive.druid.org.apache.druid.query.groupby.orderby.DefaultLimitSpec;
import org.apache.hive.druid.org.apache.druid.query.groupby.orderby.LimitSpec;
import org.apache.hive.druid.org.apache.druid.query.groupby.orderby.OrderByColumnSpec;
import org.apache.hive.druid.org.apache.druid.query.ordering.StringComparators;
import org.apache.hive.druid.org.apache.druid.segment.TestHelper;
import org.apache.hive.druid.org.apache.druid.segment.VirtualColumn;
import org.apache.hive.druid.org.apache.druid.segment.column.ValueType;
import org.apache.hive.druid.org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.junit.Assert;
import org.junit.Test;

public class GroupByQueryQueryToolChestTest {
    @Test
    public void testResultLevelCacheKeyWithPostAggregate() {
        GroupByQuery query1 = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setPostAggregatorSpecs((List)ImmutableList.of((Object)new ExpressionPostAggregator("post", "alias + 'x'", null, TestExprMacroTable.INSTANCE))).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        GroupByQuery query2 = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setPostAggregatorSpecs((List)ImmutableList.of((Object)new ExpressionPostAggregator("post", "alias - 'x'", null, TestExprMacroTable.INSTANCE))).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        CacheStrategy strategy1 = new GroupByQueryQueryToolChest(null, QueryRunnerTestHelper.sameThreadIntervalChunkingQueryRunnerDecorator()).getCacheStrategy(query1);
        CacheStrategy strategy2 = new GroupByQueryQueryToolChest(null, QueryRunnerTestHelper.sameThreadIntervalChunkingQueryRunnerDecorator()).getCacheStrategy(query2);
        Assert.assertTrue((boolean)Arrays.equals(strategy1.computeCacheKey((Query)query1), strategy2.computeCacheKey((Query)query2)));
        Assert.assertFalse((boolean)Arrays.equals(strategy1.computeResultLevelCacheKey((Query)query1), strategy2.computeResultLevelCacheKey((Query)query2)));
    }

    @Test
    public void testResultLevelCacheKeyWithLimitSpec() {
        GroupByQuery query1 = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setPostAggregatorSpecs((List)ImmutableList.of((Object)new ExpressionPostAggregator("post", "alias + 'x'", null, TestExprMacroTable.INSTANCE))).setGranularity(QueryRunnerTestHelper.DAY_GRAN).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("post", OrderByColumnSpec.Direction.DESCENDING)), Integer.valueOf(Integer.MAX_VALUE))).build();
        GroupByQuery query2 = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setPostAggregatorSpecs((List)ImmutableList.of((Object)new ExpressionPostAggregator("post", "alias - 'x'", null, TestExprMacroTable.INSTANCE))).setGranularity(QueryRunnerTestHelper.DAY_GRAN).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("post", OrderByColumnSpec.Direction.DESCENDING)), Integer.valueOf(Integer.MAX_VALUE))).build();
        CacheStrategy strategy1 = new GroupByQueryQueryToolChest(null, QueryRunnerTestHelper.sameThreadIntervalChunkingQueryRunnerDecorator()).getCacheStrategy(query1);
        CacheStrategy strategy2 = new GroupByQueryQueryToolChest(null, QueryRunnerTestHelper.sameThreadIntervalChunkingQueryRunnerDecorator()).getCacheStrategy(query2);
        Assert.assertTrue((boolean)Arrays.equals(strategy1.computeCacheKey((Query)query1), strategy2.computeCacheKey((Query)query2)));
        Assert.assertFalse((boolean)Arrays.equals(strategy1.computeResultLevelCacheKey((Query)query1), strategy2.computeResultLevelCacheKey((Query)query2)));
    }

    @Test
    public void testResultLevelCacheKeyWithHavingSpec() {
        GroupByQuery query1 = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setPostAggregatorSpecs((List)ImmutableList.of((Object)new ExpressionPostAggregator("post", "alias + 'x'", null, TestExprMacroTable.INSTANCE))).setGranularity(QueryRunnerTestHelper.DAY_GRAN).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("post", OrderByColumnSpec.Direction.DESCENDING)), Integer.valueOf(Integer.MAX_VALUE))).setHavingSpec((HavingSpec)new GreaterThanHavingSpec("uniques", (Number)8)).build();
        GroupByQuery query2 = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setPostAggregatorSpecs((List)ImmutableList.of((Object)new ExpressionPostAggregator("post", "alias + 'x'", null, TestExprMacroTable.INSTANCE))).setGranularity(QueryRunnerTestHelper.DAY_GRAN).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("post", OrderByColumnSpec.Direction.DESCENDING)), Integer.valueOf(Integer.MAX_VALUE))).setHavingSpec((HavingSpec)new GreaterThanHavingSpec("uniques", (Number)10)).build();
        CacheStrategy strategy1 = new GroupByQueryQueryToolChest(null, QueryRunnerTestHelper.sameThreadIntervalChunkingQueryRunnerDecorator()).getCacheStrategy(query1);
        CacheStrategy strategy2 = new GroupByQueryQueryToolChest(null, QueryRunnerTestHelper.sameThreadIntervalChunkingQueryRunnerDecorator()).getCacheStrategy(query2);
        Assert.assertTrue((boolean)Arrays.equals(strategy1.computeCacheKey((Query)query1), strategy2.computeCacheKey((Query)query2)));
        Assert.assertFalse((boolean)Arrays.equals(strategy1.computeResultLevelCacheKey((Query)query1), strategy2.computeResultLevelCacheKey((Query)query2)));
    }

    @Test
    public void testResultLevelCacheKeyWithAndHavingSpec() {
        List<HavingSpec> havings = Arrays.asList(new GreaterThanHavingSpec("agg", (Number)1.3), new OrHavingSpec(Arrays.asList(new LessThanHavingSpec("lessAgg", (Number)1L), new NotHavingSpec((HavingSpec)new EqualToHavingSpec("equalAgg", (Number)2.0)))));
        AndHavingSpec andHavingSpec = new AndHavingSpec(havings);
        List<HavingSpec> havings2 = Arrays.asList(new GreaterThanHavingSpec("agg", (Number)13.0), new OrHavingSpec(Arrays.asList(new LessThanHavingSpec("lessAgg", (Number)1L), new NotHavingSpec((HavingSpec)new EqualToHavingSpec("equalAgg", (Number)22.0)))));
        AndHavingSpec andHavingSpec2 = new AndHavingSpec(havings2);
        GroupByQuery query1 = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setPostAggregatorSpecs((List)ImmutableList.of((Object)new ExpressionPostAggregator("post", "alias + 'x'", null, TestExprMacroTable.INSTANCE))).setGranularity(QueryRunnerTestHelper.DAY_GRAN).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("post", OrderByColumnSpec.Direction.DESCENDING)), Integer.valueOf(Integer.MAX_VALUE))).setHavingSpec((HavingSpec)andHavingSpec).build();
        GroupByQuery query2 = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setPostAggregatorSpecs((List)ImmutableList.of((Object)new ExpressionPostAggregator("post", "alias + 'x'", null, TestExprMacroTable.INSTANCE))).setGranularity(QueryRunnerTestHelper.DAY_GRAN).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("post", OrderByColumnSpec.Direction.DESCENDING)), Integer.valueOf(Integer.MAX_VALUE))).setHavingSpec((HavingSpec)andHavingSpec2).build();
        CacheStrategy strategy1 = new GroupByQueryQueryToolChest(null, QueryRunnerTestHelper.sameThreadIntervalChunkingQueryRunnerDecorator()).getCacheStrategy(query1);
        CacheStrategy strategy2 = new GroupByQueryQueryToolChest(null, QueryRunnerTestHelper.sameThreadIntervalChunkingQueryRunnerDecorator()).getCacheStrategy(query2);
        Assert.assertTrue((boolean)Arrays.equals(strategy1.computeCacheKey((Query)query1), strategy2.computeCacheKey((Query)query2)));
        Assert.assertFalse((boolean)Arrays.equals(strategy1.computeResultLevelCacheKey((Query)query1), strategy2.computeResultLevelCacheKey((Query)query2)));
    }

    @Test
    public void testResultLevelCacheKeyWithHavingDimFilterHavingSpec() {
        DimFilterHavingSpec havingSpec1 = new DimFilterHavingSpec((DimFilter)new AndDimFilter((List)ImmutableList.of((Object)new OrDimFilter((List)ImmutableList.of((Object)new BoundDimFilter("rows", "2", null, Boolean.valueOf(true), Boolean.valueOf(false), null, null, StringComparators.NUMERIC), (Object)new SelectorDimFilter("idx", "217", null))), (Object)new SelectorDimFilter("__time", String.valueOf(DateTimes.of((String)"2011-04-01").getMillis()), null))), null);
        DimFilterHavingSpec havingSpec2 = new DimFilterHavingSpec((DimFilter)new AndDimFilter((List)ImmutableList.of((Object)new OrDimFilter((List)ImmutableList.of((Object)new BoundDimFilter("rows", "2", null, Boolean.valueOf(true), Boolean.valueOf(false), null, null, StringComparators.NUMERIC), (Object)new SelectorDimFilter("idx", "317", null))), (Object)new SelectorDimFilter("__time", String.valueOf(DateTimes.of((String)"2011-04-01").getMillis()), null))), null);
        GroupByQuery query1 = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setPostAggregatorSpecs((List)ImmutableList.of((Object)new ExpressionPostAggregator("post", "alias + 'x'", null, TestExprMacroTable.INSTANCE))).setGranularity(QueryRunnerTestHelper.DAY_GRAN).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("post", OrderByColumnSpec.Direction.DESCENDING)), Integer.valueOf(Integer.MAX_VALUE))).setHavingSpec((HavingSpec)havingSpec1).build();
        GroupByQuery query2 = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setPostAggregatorSpecs((List)ImmutableList.of((Object)new ExpressionPostAggregator("post", "alias + 'x'", null, TestExprMacroTable.INSTANCE))).setGranularity(QueryRunnerTestHelper.DAY_GRAN).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("post", OrderByColumnSpec.Direction.DESCENDING)), Integer.valueOf(Integer.MAX_VALUE))).setHavingSpec((HavingSpec)havingSpec2).build();
        CacheStrategy strategy1 = new GroupByQueryQueryToolChest(null, QueryRunnerTestHelper.sameThreadIntervalChunkingQueryRunnerDecorator()).getCacheStrategy(query1);
        CacheStrategy strategy2 = new GroupByQueryQueryToolChest(null, QueryRunnerTestHelper.sameThreadIntervalChunkingQueryRunnerDecorator()).getCacheStrategy(query2);
        Assert.assertTrue((boolean)Arrays.equals(strategy1.computeCacheKey((Query)query1), strategy2.computeCacheKey((Query)query2)));
        Assert.assertFalse((boolean)Arrays.equals(strategy1.computeResultLevelCacheKey((Query)query1), strategy2.computeResultLevelCacheKey((Query)query2)));
    }

    @Test
    public void testResultLevelCacheKeyWithSubTotalsSpec() {
        GroupByQuery query1 = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias"), new DefaultDimensionSpec("market", "market")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index"), new FloatSumAggregatorFactory("idxFloat", "indexFloat"), new DoubleSumAggregatorFactory("idxDouble", "index"))).setGranularity(QueryRunnerTestHelper.DAY_GRAN).setSubtotalsSpec((List)ImmutableList.of((Object)ImmutableList.of((Object)"alias"), (Object)ImmutableList.of((Object)"market"), (Object)ImmutableList.of())).build();
        GroupByQuery query2 = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias"), new DefaultDimensionSpec("market", "market")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index"), new FloatSumAggregatorFactory("idxFloat", "indexFloat"), new DoubleSumAggregatorFactory("idxDouble", "index"))).setGranularity(QueryRunnerTestHelper.DAY_GRAN).setSubtotalsSpec((List)ImmutableList.of((Object)ImmutableList.of((Object)"alias"), (Object)ImmutableList.of())).build();
        CacheStrategy strategy1 = new GroupByQueryQueryToolChest(null, QueryRunnerTestHelper.sameThreadIntervalChunkingQueryRunnerDecorator()).getCacheStrategy(query1);
        CacheStrategy strategy2 = new GroupByQueryQueryToolChest(null, QueryRunnerTestHelper.sameThreadIntervalChunkingQueryRunnerDecorator()).getCacheStrategy(query2);
        Assert.assertTrue((boolean)Arrays.equals(strategy1.computeCacheKey((Query)query1), strategy2.computeCacheKey((Query)query2)));
        Assert.assertFalse((boolean)Arrays.equals(strategy1.computeResultLevelCacheKey((Query)query1), strategy2.computeResultLevelCacheKey((Query)query2)));
    }

    @Test
    public void testCacheStrategy() throws Exception {
        this.doTestCacheStrategy(ValueType.STRING, "val1");
        this.doTestCacheStrategy(ValueType.FLOAT, Float.valueOf(2.1f));
        this.doTestCacheStrategy(ValueType.DOUBLE, 2.1);
        this.doTestCacheStrategy(ValueType.LONG, 2L);
    }

    @Test
    public void testMultiColumnCacheStrategy() throws Exception {
        GroupByQuery query1 = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions((List)ImmutableList.of((Object)new DefaultDimensionSpec("test", "test", ValueType.STRING), (Object)new DefaultDimensionSpec("v0", "v0", ValueType.STRING))).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "concat('foo', test)", ValueType.STRING, TestExprMacroTable.INSTANCE)}).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, this.getComplexAggregatorFactoryForValueType(ValueType.STRING))).setPostAggregatorSpecs((List)ImmutableList.of((Object)new ConstantPostAggregator("post", (Number)10))).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        CacheStrategy strategy = new GroupByQueryQueryToolChest(null, null).getCacheStrategy(query1);
        ResultRow result1 = ResultRow.of((Object[])new Object[]{123L, "val1", "fooval1", 1, this.getIntermediateComplexValue(ValueType.STRING, "val1")});
        Object preparedValue = strategy.prepareForSegmentLevelCache().apply((Object)result1);
        ObjectMapper objectMapper = TestHelper.makeJsonMapper();
        Object fromCacheValue = objectMapper.readValue(objectMapper.writeValueAsBytes(preparedValue), strategy.getCacheObjectClazz());
        ResultRow fromCacheResult = (ResultRow)strategy.pullFromSegmentLevelCache().apply(fromCacheValue);
        Assert.assertEquals((Object)result1, (Object)fromCacheResult);
    }

    @Test
    public void testResultSerde() throws Exception {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(Collections.singletonList(DefaultDimensionSpec.of((String)"test"))).setAggregatorSpecs(Collections.singletonList(QueryRunnerTestHelper.ROWS_COUNT)).setPostAggregatorSpecs(Collections.singletonList(new ConstantPostAggregator("post", (Number)10))).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        GroupByQueryQueryToolChest toolChest = new GroupByQueryQueryToolChest(null, QueryRunnerTestHelper.sameThreadIntervalChunkingQueryRunnerDecorator());
        ObjectMapper objectMapper = TestHelper.makeJsonMapper();
        ObjectMapper arraysObjectMapper = toolChest.decorateObjectMapper(objectMapper, query.withOverriddenContext((Map)ImmutableMap.of((Object)"resultAsArray", (Object)true)));
        ObjectMapper mapsObjectMapper = toolChest.decorateObjectMapper(objectMapper, query.withOverriddenContext((Map)ImmutableMap.of((Object)"resultAsArray", (Object)false)));
        Object[] rowObjects = new Object[]{DateTimes.of((String)"2000").getMillis(), "foo", 100, 10};
        ResultRow resultRow = ResultRow.of((Object[])rowObjects);
        Assert.assertEquals((Object)resultRow, (Object)arraysObjectMapper.readValue(StringUtils.format((String)"[%s, \"foo\", 100, 10]", (Object[])new Object[]{DateTimes.of((String)"2000").getMillis()}), ResultRow.class));
        Assert.assertEquals((Object)resultRow, (Object)arraysObjectMapper.readValue(StringUtils.format((String)"{\"version\":\"v1\",\"timestamp\":\"%s\",\"event\":  {\"test\":\"foo\", \"rows\":100, \"post\":10}}", (Object[])new Object[]{DateTimes.of((String)"2000")}), ResultRow.class));
        Assert.assertArrayEquals((Object[])rowObjects, (Object[])((Object[])objectMapper.readValue(arraysObjectMapper.writeValueAsBytes((Object)resultRow), Object[].class)));
        Assert.assertEquals((Object)resultRow.toMapBasedRow(query), (Object)objectMapper.readValue(mapsObjectMapper.writeValueAsBytes((Object)resultRow), Row.class));
        Assert.assertEquals((String)"arrays read arrays", (Object)resultRow, (Object)arraysObjectMapper.readValue(arraysObjectMapper.writeValueAsBytes((Object)resultRow), ResultRow.class));
        Assert.assertEquals((String)"arrays read maps", (Object)resultRow, (Object)arraysObjectMapper.readValue(mapsObjectMapper.writeValueAsBytes((Object)resultRow), ResultRow.class));
        Assert.assertEquals((String)"maps read arrays", (Object)resultRow, (Object)mapsObjectMapper.readValue(arraysObjectMapper.writeValueAsBytes((Object)resultRow), ResultRow.class));
        Assert.assertEquals((String)"maps read maps", (Object)resultRow, (Object)mapsObjectMapper.readValue(mapsObjectMapper.writeValueAsBytes((Object)resultRow), ResultRow.class));
    }

    private AggregatorFactory getComplexAggregatorFactoryForValueType(ValueType valueType) {
        switch (valueType) {
            case LONG: {
                return new LongLastAggregatorFactory("complexMetric", "test");
            }
            case DOUBLE: {
                return new DoubleLastAggregatorFactory("complexMetric", "test");
            }
            case FLOAT: {
                return new FloatLastAggregatorFactory("complexMetric", "test");
            }
            case STRING: {
                return new StringLastAggregatorFactory("complexMetric", "test", null);
            }
        }
        throw new IllegalArgumentException("bad valueType: " + valueType);
    }

    private SerializablePair getIntermediateComplexValue(ValueType valueType, Object dimValue) {
        switch (valueType) {
            case LONG: 
            case DOUBLE: 
            case FLOAT: {
                return new SerializablePair((Object)123L, dimValue);
            }
            case STRING: {
                return new SerializablePairLongString(Long.valueOf(123L), (String)dimValue);
            }
        }
        throw new IllegalArgumentException("bad valueType: " + valueType);
    }

    private void doTestCacheStrategy(ValueType valueType, Object dimValue) throws IOException {
        GroupByQuery query1 = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(Collections.singletonList(new DefaultDimensionSpec("test", "test", valueType))).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, this.getComplexAggregatorFactoryForValueType(valueType))).setPostAggregatorSpecs((List)ImmutableList.of((Object)new ConstantPostAggregator("post", (Number)10))).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        CacheStrategy strategy = new GroupByQueryQueryToolChest(null, null).getCacheStrategy(query1);
        ResultRow result1 = ResultRow.of((Object[])new Object[]{123L, dimValue, 1, this.getIntermediateComplexValue(valueType, dimValue)});
        Object preparedValue = strategy.prepareForSegmentLevelCache().apply((Object)result1);
        ObjectMapper objectMapper = TestHelper.makeJsonMapper();
        Object fromCacheValue = objectMapper.readValue(objectMapper.writeValueAsBytes(preparedValue), strategy.getCacheObjectClazz());
        ResultRow fromCacheResult = (ResultRow)strategy.pullFromSegmentLevelCache().apply(fromCacheValue);
        Assert.assertEquals((Object)result1, (Object)fromCacheResult);
        ResultRow result2 = ResultRow.of((Object[])new Object[]{123L, dimValue, 1, dimValue, 10});
        ResultRow typeAdjustedResult2 = valueType == ValueType.FLOAT ? ResultRow.of((Object[])new Object[]{123L, dimValue, 1, 2.1, 10}) : (valueType == ValueType.LONG ? ResultRow.of((Object[])new Object[]{123L, dimValue, 1, 2, 10}) : result2);
        Object preparedResultCacheValue = strategy.prepareForCache(true).apply((Object)result2);
        Object fromResultCacheValue = objectMapper.readValue(objectMapper.writeValueAsBytes(preparedResultCacheValue), strategy.getCacheObjectClazz());
        ResultRow fromResultCacheResult = (ResultRow)strategy.pullFromCache(true).apply(fromResultCacheValue);
        Assert.assertEquals((Object)typeAdjustedResult2, (Object)fromResultCacheResult);
    }
}

