/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.groupby;

import java.util.Collections;
import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.core.Emitter;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.org.apache.druid.query.CachingEmitter;
import org.apache.hive.druid.org.apache.druid.query.DefaultQueryMetricsTest;
import org.apache.hive.druid.org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.dimension.ExtractionDimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.extraction.MapLookupExtractor;
import org.apache.hive.druid.org.apache.druid.query.filter.DimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.hive.druid.org.apache.druid.query.groupby.DefaultGroupByQueryMetrics;
import org.apache.hive.druid.org.apache.druid.query.groupby.GroupByQuery;
import org.apache.hive.druid.org.apache.druid.query.lookup.LookupExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.lookup.LookupExtractor;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.Test;

public class DefaultGroupByQueryMetricsTest {
    @Test
    public void testDefaultGroupByQueryMetricsQuery() {
        CachingEmitter cachingEmitter = new CachingEmitter();
        ServiceEmitter serviceEmitter = new ServiceEmitter("", "", (Emitter)cachingEmitter);
        DefaultGroupByQueryMetrics queryMetrics = new DefaultGroupByQueryMetrics();
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions(new DimensionSpec[]{new ExtractionDimensionSpec("quality", "alias", (ExtractionFn)new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)ImmutableMap.of((Object)"mezzanine", (Object)"mezzanine0"), false), false, null, Boolean.valueOf(true), Boolean.valueOf(false)))}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).setDimFilter((DimFilter)new SelectorDimFilter("quality", "mezzanine", null)).setContext((Map)ImmutableMap.of((Object)"bySegment", (Object)true));
        GroupByQuery query = builder.build();
        queryMetrics.query(query);
        queryMetrics.reportQueryTime(0L).emit(serviceEmitter);
        Map actualEvent = cachingEmitter.getLastEmittedEvent().toMap();
        Assert.assertEquals((long)15L, (long)actualEvent.size());
        Assert.assertTrue((boolean)actualEvent.containsKey("feed"));
        Assert.assertTrue((boolean)actualEvent.containsKey("timestamp"));
        Assert.assertEquals((Object)"", actualEvent.get("host"));
        Assert.assertEquals((Object)"", actualEvent.get("service"));
        Assert.assertEquals((Object)"testing", actualEvent.get("dataSource"));
        Assert.assertEquals((Object)query.getType(), actualEvent.get("type"));
        Interval expectedInterval = Intervals.of((String)"2011-04-02/2011-04-04");
        Assert.assertEquals(Collections.singletonList(expectedInterval.toString()), actualEvent.get("interval"));
        Assert.assertEquals((Object)"true", actualEvent.get("hasFilters"));
        Assert.assertEquals((Object)expectedInterval.toDuration().toString(), actualEvent.get("duration"));
        Assert.assertEquals((Object)"", actualEvent.get("id"));
        Assert.assertEquals((Object)"1", actualEvent.get("numDimensions"));
        Assert.assertEquals((Object)"2", actualEvent.get("numMetrics"));
        Assert.assertEquals((Object)"0", actualEvent.get("numComplexMetrics"));
        Assert.assertEquals((Object)"query/time", actualEvent.get("metric"));
        Assert.assertEquals((Object)0L, actualEvent.get("value"));
    }

    @Test
    public void testDefaultGroupByQueryMetricsMetricNamesAndUnits() {
        CachingEmitter cachingEmitter = new CachingEmitter();
        ServiceEmitter serviceEmitter = new ServiceEmitter("", "", (Emitter)cachingEmitter);
        DefaultGroupByQueryMetrics queryMetrics = new DefaultGroupByQueryMetrics();
        DefaultQueryMetricsTest.testQueryMetricsDefaultMetricNamesAndUnits(cachingEmitter, serviceEmitter, queryMetrics);
    }
}

