/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.filter.vector;

import org.apache.hive.druid.org.apache.druid.query.filter.vector.ReadableVectorMatch;
import org.apache.hive.druid.org.apache.druid.query.filter.vector.VectorMatch;
import org.junit.Assert;
import org.junit.Test;

public class VectorMatchTest {
    private static final int VECTOR_SIZE = 10;

    @Test
    public void testRemoveAll() {
        VectorMatchTest.assertMatchEquals(VectorMatch.allFalse(), (ReadableVectorMatch)VectorMatchTest.copy(VectorMatch.allTrue((int)10)).removeAll(VectorMatch.allTrue((int)10)));
        VectorMatchTest.assertMatchEquals(VectorMatch.allTrue((int)10), (ReadableVectorMatch)VectorMatchTest.copy(VectorMatch.allTrue((int)10)).removeAll(VectorMatch.allFalse()));
        VectorMatchTest.assertMatchEquals((ReadableVectorMatch)VectorMatchTest.createMatch(new int[]{3, 6, 7, 8, 10}), (ReadableVectorMatch)VectorMatchTest.createMatch(new int[]{3, 5, 6, 7, 8, 10}).removeAll((ReadableVectorMatch)VectorMatchTest.createMatch(new int[]{4, 5, 9})));
        VectorMatchTest.assertMatchEquals((ReadableVectorMatch)VectorMatchTest.createMatch(new int[]{3, 6, 7, 8, 10}), (ReadableVectorMatch)VectorMatchTest.createMatch(new int[]{3, 5, 6, 7, 8, 10}).removeAll((ReadableVectorMatch)VectorMatchTest.createMatch(new int[]{2, 5, 9})));
        VectorMatchTest.assertMatchEquals((ReadableVectorMatch)VectorMatchTest.createMatch(new int[]{6, 7, 8, 10}), (ReadableVectorMatch)VectorMatchTest.createMatch(new int[]{3, 5, 6, 7, 8, 10}).removeAll((ReadableVectorMatch)VectorMatchTest.createMatch(new int[]{3, 5, 9})));
        VectorMatchTest.assertMatchEquals((ReadableVectorMatch)VectorMatchTest.createMatch(new int[]{6, 7, 8}), (ReadableVectorMatch)VectorMatchTest.createMatch(new int[]{3, 5, 6, 7, 8, 10}).removeAll((ReadableVectorMatch)VectorMatchTest.createMatch(new int[]{3, 5, 10})));
    }

    @Test
    public void testAddAll() {
        VectorMatch scratch = VectorMatch.wrap((int[])new int[10]);
        VectorMatchTest.assertMatchEquals(VectorMatch.allTrue((int)10), (ReadableVectorMatch)VectorMatchTest.copy(VectorMatch.allTrue((int)10)).addAll(VectorMatch.allTrue((int)10), scratch));
        VectorMatchTest.assertMatchEquals(VectorMatch.allTrue((int)10), (ReadableVectorMatch)VectorMatchTest.createMatch(new int[0]).addAll(VectorMatch.allTrue((int)10), scratch));
        VectorMatchTest.assertMatchEquals((ReadableVectorMatch)VectorMatchTest.createMatch(new int[]{3, 4, 5, 6, 7, 8, 9, 10}), (ReadableVectorMatch)VectorMatchTest.createMatch(new int[]{3, 5, 6, 7, 8, 10}).addAll((ReadableVectorMatch)VectorMatchTest.createMatch(new int[]{4, 5, 9}), scratch));
        VectorMatchTest.assertMatchEquals((ReadableVectorMatch)VectorMatchTest.createMatch(new int[]{3, 4, 5, 6, 7, 8, 10}), (ReadableVectorMatch)VectorMatchTest.createMatch(new int[]{3, 5, 6, 7, 8}).addAll((ReadableVectorMatch)VectorMatchTest.createMatch(new int[]{4, 5, 10}), scratch));
        VectorMatchTest.assertMatchEquals((ReadableVectorMatch)VectorMatchTest.createMatch(new int[]{2, 3, 5, 6, 7, 8, 9, 10}), (ReadableVectorMatch)VectorMatchTest.createMatch(new int[]{3, 5, 6, 7, 8, 10}).addAll((ReadableVectorMatch)VectorMatchTest.createMatch(new int[]{2, 5, 9}), scratch));
        VectorMatchTest.assertMatchEquals((ReadableVectorMatch)VectorMatchTest.createMatch(new int[]{3, 5, 6, 7, 8, 9, 10}), (ReadableVectorMatch)VectorMatchTest.createMatch(new int[]{3, 5, 6, 7, 8, 10}).addAll((ReadableVectorMatch)VectorMatchTest.createMatch(new int[]{3, 5, 9}), scratch));
        VectorMatchTest.assertMatchEquals((ReadableVectorMatch)VectorMatchTest.createMatch(new int[]{3, 5, 6, 7, 8, 10}), (ReadableVectorMatch)VectorMatchTest.createMatch(new int[]{3, 5, 6, 7, 8, 10}).addAll((ReadableVectorMatch)VectorMatchTest.createMatch(new int[]{3, 5, 10}), scratch));
    }

    private static void assertMatchEquals(ReadableVectorMatch expected, ReadableVectorMatch actual) {
        Assert.assertEquals((Object)expected.toString(), (Object)actual.toString());
    }

    private static VectorMatch copy(ReadableVectorMatch match) {
        int[] selection = match.getSelection();
        int[] newSelection = new int[selection.length];
        System.arraycopy(selection, 0, newSelection, 0, selection.length);
        return VectorMatch.wrap((int[])newSelection).setSelectionSize(match.getSelectionSize());
    }

    private static VectorMatch createMatch(int[] selection) {
        VectorMatch match = VectorMatch.wrap((int[])new int[10]);
        System.arraycopy(selection, 0, match.getSelection(), 0, selection.length);
        match.setSelectionSize(selection.length);
        return match;
    }
}

