/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.filter;

import com.google.inject.Injector;
import com.google.inject.Key;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.org.apache.druid.guice.GuiceInjectors;
import org.apache.hive.druid.org.apache.druid.guice.annotations.Json;
import org.apache.hive.druid.org.apache.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.extraction.RegexDimExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.filter.DimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.InDimFilter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InDimFilterSerDesrTest {
    private static ObjectMapper mapper;
    private final String serializedFilter = "{\"type\":\"in\",\"dimension\":\"dimTest\",\"values\":[\"bad\",\"good\"],\"extractionFn\":null}";

    @Before
    public void setUp() {
        Injector defaultInjector = GuiceInjectors.makeStartupInjector();
        mapper = (ObjectMapper)defaultInjector.getInstance(Key.get(ObjectMapper.class, Json.class));
    }

    @Test
    public void testDeserialization() throws IOException {
        InDimFilter actualInDimFilter = (InDimFilter)mapper.readerFor(DimFilter.class).readValue("{\"type\":\"in\",\"dimension\":\"dimTest\",\"values\":[\"bad\",\"good\"],\"extractionFn\":null}");
        InDimFilter expectedInDimFilter = new InDimFilter("dimTest", Arrays.asList("good", "bad"), null);
        Assert.assertEquals((Object)expectedInDimFilter, (Object)actualInDimFilter);
    }

    @Test
    public void testSerialization() throws IOException {
        InDimFilter dimInFilter = new InDimFilter("dimTest", Arrays.asList("good", "bad"), null);
        String actualSerializedFilter = mapper.writeValueAsString((Object)dimInFilter);
        Assert.assertEquals((Object)"{\"type\":\"in\",\"dimension\":\"dimTest\",\"values\":[\"bad\",\"good\"],\"extractionFn\":null}", (Object)actualSerializedFilter);
    }

    @Test
    public void testGetCacheKey() {
        InDimFilter inDimFilter_1 = new InDimFilter("dimTest", Arrays.asList("good", "bad"), null);
        InDimFilter inDimFilter_2 = new InDimFilter("dimTest", Collections.singletonList("good,bad"), null);
        Assert.assertNotEquals((Object)inDimFilter_1.getCacheKey(), (Object)inDimFilter_2.getCacheKey());
        RegexDimExtractionFn regexFn = new RegexDimExtractionFn(".*", Boolean.valueOf(false), null);
        InDimFilter inDimFilter_3 = new InDimFilter("dimTest", Arrays.asList("good", "bad"), (ExtractionFn)regexFn);
        InDimFilter inDimFilter_4 = new InDimFilter("dimTest", Collections.singletonList("good,bad"), (ExtractionFn)regexFn);
        Assert.assertNotEquals((Object)inDimFilter_3.getCacheKey(), (Object)inDimFilter_4.getCacheKey());
    }

    @Test
    public void testGetCacheKeyNullValue() throws IOException {
        InDimFilter inDimFilter = (InDimFilter)mapper.readValue("{\"type\":\"in\",\"dimension\":\"dimTest\",\"values\":[null]}", InDimFilter.class);
        Assert.assertNotNull((Object)inDimFilter.getCacheKey());
    }
}

