/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.extraction;

import java.util.Arrays;
import org.apache.hive.druid.org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.hive.druid.org.apache.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.extraction.TimeFormatExtractionFn;
import org.joda.time.DateTimeZone;
import org.junit.Assert;
import org.junit.Test;

public class TimeFormatExtractionFnTest {
    private static final long[] TIMESTAMPS = new long[]{DateTimes.of((String)"2015-01-01T23:00:00Z").getMillis(), DateTimes.of((String)"2015-01-02T23:00:00Z").getMillis(), DateTimes.of((String)"2015-03-03T23:00:00Z").getMillis(), DateTimes.of((String)"2015-03-04T23:00:00Z").getMillis(), DateTimes.of((String)"2015-05-02T23:00:00Z").getMillis(), DateTimes.of((String)"2015-12-21T23:00:00Z").getMillis()};

    @Test
    public void testDayOfWeekExtraction() throws Exception {
        TimeFormatExtractionFn fn = new TimeFormatExtractionFn("EEEE", null, null, null, false);
        Assert.assertEquals((Object)"Thursday", (Object)fn.apply(TIMESTAMPS[0]));
        Assert.assertEquals((Object)"Friday", (Object)fn.apply(TIMESTAMPS[1]));
        Assert.assertEquals((Object)"Tuesday", (Object)fn.apply(TIMESTAMPS[2]));
        Assert.assertEquals((Object)"Wednesday", (Object)fn.apply(TIMESTAMPS[3]));
        Assert.assertEquals((Object)"Saturday", (Object)fn.apply(TIMESTAMPS[4]));
        Assert.assertEquals((Object)"Monday", (Object)fn.apply(TIMESTAMPS[5]));
        this.testSerde(fn, "EEEE", null, null, Granularities.NONE);
    }

    @Test
    public void testLocalizedExtraction() throws Exception {
        TimeFormatExtractionFn fn = new TimeFormatExtractionFn("EEEE", null, "is", null, false);
        Assert.assertEquals((Object)"fimmtudagur", (Object)fn.apply(TIMESTAMPS[0]));
        Assert.assertEquals((Object)"f\u00f6studagur", (Object)fn.apply(TIMESTAMPS[1]));
        Assert.assertEquals((Object)"\u00feri\u00f0judagur", (Object)fn.apply(TIMESTAMPS[2]));
        Assert.assertEquals((Object)"mi\u00f0vikudagur", (Object)fn.apply(TIMESTAMPS[3]));
        Assert.assertEquals((Object)"laugardagur", (Object)fn.apply(TIMESTAMPS[4]));
        Assert.assertEquals((Object)"m\u00e1nudagur", (Object)fn.apply(TIMESTAMPS[5]));
        this.testSerde(fn, "EEEE", null, "is", Granularities.NONE);
    }

    @Test
    public void testGranularExtractionWithNullPattern() throws Exception {
        TimeFormatExtractionFn fn = new TimeFormatExtractionFn(null, null, null, Granularities.DAY, false);
        Assert.assertEquals((Object)"2015-01-01T00:00:00.000Z", (Object)fn.apply(TIMESTAMPS[0]));
        Assert.assertEquals((Object)"2015-01-02T00:00:00.000Z", (Object)fn.apply(TIMESTAMPS[1]));
        Assert.assertEquals((Object)"2015-03-03T00:00:00.000Z", (Object)fn.apply(TIMESTAMPS[2]));
        Assert.assertEquals((Object)"2015-03-04T00:00:00.000Z", (Object)fn.apply(TIMESTAMPS[3]));
        Assert.assertEquals((Object)"2015-05-02T00:00:00.000Z", (Object)fn.apply(TIMESTAMPS[4]));
        Assert.assertEquals((Object)"2015-12-21T00:00:00.000Z", (Object)fn.apply(TIMESTAMPS[5]));
        this.testSerde(fn, null, null, null, Granularities.DAY);
    }

    @Test
    public void testTimeZoneExtraction() throws Exception {
        TimeFormatExtractionFn fn = new TimeFormatExtractionFn("'In Berlin ist es schon 'EEEE", DateTimes.inferTzFromString((String)"Europe/Berlin"), "de", null, false);
        Assert.assertEquals((Object)"In Berlin ist es schon Freitag", (Object)fn.apply(TIMESTAMPS[0]));
        Assert.assertEquals((Object)"In Berlin ist es schon Samstag", (Object)fn.apply(TIMESTAMPS[1]));
        Assert.assertEquals((Object)"In Berlin ist es schon Mittwoch", (Object)fn.apply(TIMESTAMPS[2]));
        Assert.assertEquals((Object)"In Berlin ist es schon Donnerstag", (Object)fn.apply(TIMESTAMPS[3]));
        Assert.assertEquals((Object)"In Berlin ist es schon Sonntag", (Object)fn.apply(TIMESTAMPS[4]));
        Assert.assertEquals((Object)"In Berlin ist es schon Dienstag", (Object)fn.apply(TIMESTAMPS[5]));
        this.testSerde(fn, "'In Berlin ist es schon 'EEEE", DateTimes.inferTzFromString((String)"Europe/Berlin"), "de", Granularities.NONE);
    }

    public void testSerde(TimeFormatExtractionFn fn, String format, DateTimeZone tz, String locale, Granularity granularity) throws Exception {
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        String json = objectMapper.writeValueAsString((Object)fn);
        TimeFormatExtractionFn deserialized = (TimeFormatExtractionFn)objectMapper.readValue(json, TimeFormatExtractionFn.class);
        Assert.assertEquals((Object)format, (Object)deserialized.getFormat());
        Assert.assertEquals((Object)tz, (Object)deserialized.getTimeZone());
        Assert.assertEquals((Object)locale, (Object)deserialized.getLocale());
        Assert.assertEquals((Object)granularity, (Object)deserialized.getGranularity());
        Assert.assertEquals((Object)fn, (Object)deserialized);
    }

    @Test
    public void testSerdeFromJson() throws Exception {
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        String json = "{ \"type\" : \"timeFormat\", \"format\" : \"HH\" }";
        TimeFormatExtractionFn extractionFn = (TimeFormatExtractionFn)objectMapper.readValue("{ \"type\" : \"timeFormat\", \"format\" : \"HH\" }", ExtractionFn.class);
        Assert.assertEquals((Object)"HH", (Object)extractionFn.getFormat());
        Assert.assertEquals(null, (Object)extractionFn.getLocale());
        Assert.assertEquals(null, (Object)extractionFn.getTimeZone());
        Assert.assertEquals((Object)extractionFn, (Object)objectMapper.readValue(objectMapper.writeValueAsBytes((Object)extractionFn), ExtractionFn.class));
    }

    @Test
    public void testCacheKey() {
        TimeFormatExtractionFn fn = new TimeFormatExtractionFn("'In Berlin ist es schon 'EEEE", DateTimes.inferTzFromString((String)"Europe/Berlin"), "de", null, false);
        TimeFormatExtractionFn fn2 = new TimeFormatExtractionFn("'In Berlin ist es schon 'EEEE", DateTimes.inferTzFromString((String)"Europe/Berlin"), "de", null, true);
        TimeFormatExtractionFn fn3 = new TimeFormatExtractionFn("'In Berlin ist es schon 'EEEE", DateTimes.inferTzFromString((String)"Europe/Berlin"), "de", null, true);
        TimeFormatExtractionFn fn4 = new TimeFormatExtractionFn(null, null, null, null, false);
        Assert.assertFalse((boolean)Arrays.equals(fn.getCacheKey(), fn2.getCacheKey()));
        Assert.assertFalse((boolean)Arrays.equals(fn.getCacheKey(), fn4.getCacheKey()));
        Assert.assertTrue((boolean)Arrays.equals(fn2.getCacheKey(), fn3.getCacheKey()));
    }
}

