/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.extraction;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.hive.druid.org.apache.druid.common.config.NullHandling;
import org.apache.hive.druid.org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.org.apache.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.extraction.TimeDimExtractionFn;
import org.junit.Assert;
import org.junit.Test;

public class TimeDimExtractionFnTest {
    private static final String[] DIMS = new String[]{"01/01/2012", "01/02/2012", "03/03/2012", "03/04/2012", "05/05/2012", "12/21/2012"};

    @Test
    public void testEmptyNullAndUnparseableExtraction() {
        for (boolean joda : Arrays.asList(true, false)) {
            TimeDimExtractionFn extractionFn = new TimeDimExtractionFn("MM/dd/yyyy", "MM/yyyy", joda);
            Assert.assertNull((Object)extractionFn.apply(null));
            if (NullHandling.replaceWithDefault()) {
                Assert.assertNull((Object)extractionFn.apply(""));
            } else {
                Assert.assertEquals((Object)"", (Object)extractionFn.apply(""));
            }
            Assert.assertEquals((Object)"foo", (Object)extractionFn.apply("foo"));
        }
    }

    @Test
    public void testMonthExtraction() {
        HashSet<String> months = new HashSet<String>();
        TimeDimExtractionFn extractionFn = new TimeDimExtractionFn("MM/dd/yyyy", "MM/yyyy", false);
        for (String dim : DIMS) {
            months.add(extractionFn.apply(dim));
        }
        Assert.assertEquals((long)months.size(), (long)4L);
        Assert.assertTrue((boolean)months.contains("01/2012"));
        Assert.assertTrue((boolean)months.contains("03/2012"));
        Assert.assertTrue((boolean)months.contains("05/2012"));
        Assert.assertTrue((boolean)months.contains("12/2012"));
    }

    @Test
    public void testMonthExtractionJoda() {
        HashSet<String> months = new HashSet<String>();
        TimeDimExtractionFn extractionFn = new TimeDimExtractionFn("MM/dd/yyyy", "MM/yyyy", true);
        for (String dim : DIMS) {
            months.add(extractionFn.apply(dim));
        }
        Assert.assertEquals((long)months.size(), (long)4L);
        Assert.assertTrue((boolean)months.contains("01/2012"));
        Assert.assertTrue((boolean)months.contains("03/2012"));
        Assert.assertTrue((boolean)months.contains("05/2012"));
        Assert.assertTrue((boolean)months.contains("12/2012"));
    }

    @Test
    public void testQuarterExtraction() {
        HashSet<String> quarters = new HashSet<String>();
        TimeDimExtractionFn extractionFn = new TimeDimExtractionFn("MM/dd/yyyy", "QQQ/yyyy", false);
        for (String dim : DIMS) {
            quarters.add(extractionFn.apply(dim));
        }
        Assert.assertEquals((long)quarters.size(), (long)3L);
        Assert.assertTrue((boolean)quarters.contains("Q1/2012"));
        Assert.assertTrue((boolean)quarters.contains("Q2/2012"));
        Assert.assertTrue((boolean)quarters.contains("Q4/2012"));
    }

    @Test
    public void testWeeks() {
        TimeDimExtractionFn weekFn = new TimeDimExtractionFn("yyyy-MM-dd", "YYYY-ww", false);
        Assert.assertEquals((Object)"2016-01", (Object)weekFn.apply("2015-12-31"));
        Assert.assertEquals((Object)"2016-01", (Object)weekFn.apply("2016-01-01"));
        Assert.assertEquals((Object)"2017-01", (Object)weekFn.apply("2017-01-01"));
        Assert.assertEquals((Object)"2018-01", (Object)weekFn.apply("2017-12-31"));
        Assert.assertEquals((Object)"2018-01", (Object)weekFn.apply("2018-01-01"));
    }

    @Test
    public void testWeeksJoda() {
        TimeDimExtractionFn weekFn = new TimeDimExtractionFn("yyyy-MM-dd", "xxxx-ww", true);
        Assert.assertEquals((Object)"2015-53", (Object)weekFn.apply("2015-12-31"));
        Assert.assertEquals((Object)"2015-53", (Object)weekFn.apply("2016-01-01"));
        Assert.assertEquals((Object)"2016-52", (Object)weekFn.apply("2017-01-01"));
        Assert.assertEquals((Object)"2017-52", (Object)weekFn.apply("2017-12-31"));
        Assert.assertEquals((Object)"2018-01", (Object)weekFn.apply("2018-01-01"));
    }

    @Test
    public void testSerde() throws Exception {
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        String json = "{ \"type\" : \"time\", \"timeFormat\" : \"MM/dd/yyyy\", \"resultFormat\" : \"yyyy-MM-dd\", \"joda\" : true }";
        TimeDimExtractionFn extractionFn = (TimeDimExtractionFn)objectMapper.readValue("{ \"type\" : \"time\", \"timeFormat\" : \"MM/dd/yyyy\", \"resultFormat\" : \"yyyy-MM-dd\", \"joda\" : true }", ExtractionFn.class);
        Assert.assertEquals((Object)"MM/dd/yyyy", (Object)extractionFn.getTimeFormat());
        Assert.assertEquals((Object)"yyyy-MM-dd", (Object)extractionFn.getResultFormat());
        Assert.assertEquals((Object)extractionFn, (Object)objectMapper.readValue(objectMapper.writeValueAsBytes((Object)extractionFn), ExtractionFn.class));
    }
}

