/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.extraction;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.org.apache.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.extraction.SearchQuerySpecDimExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.search.FragmentSearchQuerySpec;
import org.apache.hive.druid.org.apache.druid.query.search.SearchQuerySpec;
import org.junit.Assert;
import org.junit.Test;

public class SearchQuerySpecDimExtractionFnTest {
    private static final String[] TEST_STRINGS = new String[]{"Kyoto", "Calgary", "Tokyo", "Stockholm", "Toyokawa", "Pretoria", "Yorktown", "Ontario"};

    @Test
    public void testExtraction() {
        FragmentSearchQuerySpec spec = new FragmentSearchQuerySpec(Arrays.asList("tO", "yO"));
        SearchQuerySpecDimExtractionFn extractionFn = new SearchQuerySpecDimExtractionFn((SearchQuerySpec)spec);
        ImmutableList expected = ImmutableList.of((Object)"Kyoto", (Object)"Tokyo", (Object)"Toyokawa", (Object)"Yorktown");
        ArrayList<String> extracted = new ArrayList<String>();
        for (String str : TEST_STRINGS) {
            String res = extractionFn.apply(str);
            if (res == null) continue;
            extracted.add(res);
        }
        Assert.assertEquals((Object)expected, extracted);
    }

    @Test
    public void testCaseSensitiveExtraction() {
        FragmentSearchQuerySpec spec = new FragmentSearchQuerySpec(Arrays.asList("to", "yo"), true);
        SearchQuerySpecDimExtractionFn extractionFn = new SearchQuerySpecDimExtractionFn((SearchQuerySpec)spec);
        ImmutableList expected = ImmutableList.of((Object)"Kyoto");
        ArrayList<String> extracted = new ArrayList<String>();
        for (String str : TEST_STRINGS) {
            String res = extractionFn.apply(str);
            if (res == null) continue;
            extracted.add(res);
        }
        Assert.assertEquals((Object)expected, extracted);
    }

    @Test
    public void testCaseSensitiveExtraction2() {
        FragmentSearchQuerySpec spec = new FragmentSearchQuerySpec(Arrays.asList("To", "yo"), true);
        SearchQuerySpecDimExtractionFn extractionFn = new SearchQuerySpecDimExtractionFn((SearchQuerySpec)spec);
        ImmutableList expected = ImmutableList.of((Object)"Tokyo", (Object)"Toyokawa");
        ArrayList<String> extracted = new ArrayList<String>();
        for (String str : TEST_STRINGS) {
            String res = extractionFn.apply(str);
            if (res == null) continue;
            extracted.add(res);
        }
        Assert.assertEquals((Object)expected, extracted);
    }

    @Test
    public void testSerde() throws Exception {
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        FragmentSearchQuerySpec spec = new FragmentSearchQuerySpec(Arrays.asList("to", "yo"), true);
        SearchQuerySpecDimExtractionFn extractionFn = new SearchQuerySpecDimExtractionFn((SearchQuerySpec)spec);
        ExtractionFn extractionFn2 = (ExtractionFn)objectMapper.readValue(objectMapper.writeValueAsBytes((Object)extractionFn), ExtractionFn.class);
        FragmentSearchQuerySpec spec2 = (FragmentSearchQuerySpec)((SearchQuerySpecDimExtractionFn)extractionFn2).getSearchQuerySpec();
        Assert.assertEquals((Object)extractionFn, (Object)extractionFn2);
        Assert.assertEquals((Object)true, (Object)spec2.isCaseSensitive());
        Assert.assertEquals((Object)ImmutableList.of((Object)"to", (Object)"yo"), (Object)spec2.getValues());
    }
}

