/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.extraction;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.hive.druid.org.apache.druid.common.config.NullHandling;
import org.apache.hive.druid.org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.org.apache.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.extraction.MatchingDimExtractionFn;
import org.junit.Assert;
import org.junit.Test;

public class MatchingDimExtractionFnTest {
    private static final String[] TEST_STRINGS = new String[]{"Quito", "Calgary", "Tokyo", "Stockholm", "Vancouver", "Pretoria", "Wellington", null, "Ontario"};

    @Test
    public void testExtraction() {
        String regex = ".*[Tt][Oo].*";
        MatchingDimExtractionFn extractionFn = new MatchingDimExtractionFn(regex);
        List<String> expected = Arrays.asList("Quito", "Tokyo", "Stockholm", "Pretoria", "Wellington");
        HashSet<String> extracted = new HashSet<String>();
        for (String str : TEST_STRINGS) {
            String res = extractionFn.apply(str);
            if (res == null) continue;
            extracted.add(res);
        }
        Assert.assertEquals((long)5L, (long)extracted.size());
        for (String str : extracted) {
            Assert.assertTrue((boolean)expected.contains(str));
        }
    }

    @Test
    public void testNullExtraction() {
        String regex = "^$";
        MatchingDimExtractionFn extractionFn = new MatchingDimExtractionFn(regex);
        Assert.assertNull((Object)extractionFn.apply(null));
        Assert.assertNull((Object)extractionFn.apply((String)null));
        Assert.assertEquals((Object)(NullHandling.replaceWithDefault() ? null : ""), (Object)extractionFn.apply(""));
    }

    @Test
    public void testSerde() throws Exception {
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        String json = "{ \"type\" : \"partial\", \"expr\" : \".(...)?\" }";
        MatchingDimExtractionFn extractionFn = (MatchingDimExtractionFn)objectMapper.readValue("{ \"type\" : \"partial\", \"expr\" : \".(...)?\" }", ExtractionFn.class);
        Assert.assertEquals((Object)".(...)?", (Object)extractionFn.getExpr());
        Assert.assertEquals((Object)extractionFn, (Object)objectMapper.readValue(objectMapper.writeValueAsBytes((Object)extractionFn), ExtractionFn.class));
    }
}

