/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.extraction;

import com.google.inject.Injector;
import com.google.inject.Key;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.guice.GuiceInjectors;
import org.apache.hive.druid.org.apache.druid.guice.annotations.Json;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.query.extraction.DimExtractionFn;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class MapLookupExtractionFnSerDeTest {
    private static ObjectMapper mapper;
    private static final Map<String, String> RENAMES;

    @BeforeClass
    public static void setup() {
        Injector defaultInjector = GuiceInjectors.makeStartupInjector();
        mapper = (ObjectMapper)defaultInjector.getInstance(Key.get(ObjectMapper.class, Json.class));
    }

    @Test
    public void testDeserialization() throws IOException {
        DimExtractionFn fn = (DimExtractionFn)mapper.readerFor(DimExtractionFn.class).readValue(StringUtils.format((String)"{\"type\":\"lookup\",\"lookup\":{\"type\":\"map\", \"map\":%s}}", (Object[])new Object[]{mapper.writeValueAsString(RENAMES)}));
        for (String key : RENAMES.keySet()) {
            Assert.assertEquals((Object)RENAMES.get(key), (Object)fn.apply(key));
        }
        String crazyString = UUID.randomUUID().toString();
        Assert.assertEquals(null, (Object)fn.apply(crazyString));
        Assert.assertEquals((Object)crazyString, (Object)((DimExtractionFn)mapper.readerFor(DimExtractionFn.class).readValue(StringUtils.format((String)"{\"type\":\"lookup\",\"lookup\":{\"type\":\"map\", \"map\":%s}, \"retainMissingValue\":true}", (Object[])new Object[]{mapper.writeValueAsString(RENAMES)}))).apply(crazyString));
    }

    static {
        RENAMES = ImmutableMap.of((Object)"foo", (Object)"bar", (Object)"bar", (Object)"baz");
    }
}

