/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.dimension;

import java.util.Arrays;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.dimension.PrefixFilteredDimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.dimension.TestDimensionSelector;
import org.apache.hive.druid.org.apache.druid.segment.DimensionSelector;
import org.apache.hive.druid.org.apache.druid.segment.TestHelper;
import org.apache.hive.druid.org.apache.druid.segment.data.IndexedInts;
import org.junit.Assert;
import org.junit.Test;

public class PrefixFilteredDimensionSpecTest {
    @Test
    public void testSerde() throws Exception {
        ObjectMapper mapper = TestHelper.makeJsonMapper();
        String jsonStr = "{\n  \"type\": \"prefixFiltered\",\n  \"delegate\": {\n    \"type\": \"default\",\n    \"dimension\": \"foo\",\n    \"outputName\": \"bar\"\n  },\n  \"prefix\": \"xxx\"\n}";
        PrefixFilteredDimensionSpec actual = (PrefixFilteredDimensionSpec)mapper.readValue(mapper.writeValueAsString(mapper.readValue(jsonStr, DimensionSpec.class)), DimensionSpec.class);
        PrefixFilteredDimensionSpec expected = new PrefixFilteredDimensionSpec((DimensionSpec)new DefaultDimensionSpec("foo", "bar"), "xxx");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testGetCacheKey() {
        PrefixFilteredDimensionSpec spec1 = new PrefixFilteredDimensionSpec((DimensionSpec)new DefaultDimensionSpec("foo", "bar"), "xxx");
        PrefixFilteredDimensionSpec spec2 = new PrefixFilteredDimensionSpec((DimensionSpec)new DefaultDimensionSpec("foo", "bar"), "xyz");
        Assert.assertFalse((boolean)Arrays.equals(spec1.getCacheKey(), spec2.getCacheKey()));
    }

    @Test
    public void testDecorator() {
        PrefixFilteredDimensionSpec spec = new PrefixFilteredDimensionSpec((DimensionSpec)new DefaultDimensionSpec("foo", "far"), "c");
        DimensionSelector selector = spec.decorate((DimensionSelector)TestDimensionSelector.INSTANCE);
        Assert.assertEquals((long)1L, (long)selector.getValueCardinality());
        IndexedInts row = selector.getRow();
        Assert.assertEquals((long)1L, (long)row.size());
        Assert.assertEquals((long)0L, (long)row.get(0));
        Assert.assertEquals((Object)"c", (Object)selector.lookupName(0));
        Assert.assertEquals((long)0L, (long)selector.idLookup().lookupId("c"));
    }
}

