/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.dimension;

import java.util.Arrays;
import java.util.Set;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.dimension.ListFilteredDimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.dimension.TestDimensionSelector;
import org.apache.hive.druid.org.apache.druid.segment.DimensionSelector;
import org.apache.hive.druid.org.apache.druid.segment.TestHelper;
import org.apache.hive.druid.org.apache.druid.segment.data.IndexedInts;
import org.junit.Assert;
import org.junit.Test;

public class ListFilteredDimensionSpecTest {
    @Test
    public void testSerde() throws Exception {
        ObjectMapper mapper = TestHelper.makeJsonMapper();
        String jsonStr = "{\n  \"type\": \"listFiltered\",\n  \"delegate\": {\n    \"type\": \"default\",\n    \"dimension\": \"foo\",\n    \"outputName\": \"bar\"\n  },\n  \"values\": [\"xxx\"]\n}";
        ListFilteredDimensionSpec actual = (ListFilteredDimensionSpec)mapper.readValue(mapper.writeValueAsString(mapper.readValue(jsonStr, DimensionSpec.class)), DimensionSpec.class);
        ListFilteredDimensionSpec expected = new ListFilteredDimensionSpec((DimensionSpec)new DefaultDimensionSpec("foo", "bar"), (Set)ImmutableSet.of((Object)"xxx"), Boolean.valueOf(true));
        Assert.assertEquals((Object)expected, (Object)actual);
        jsonStr = "{\n  \"type\": \"listFiltered\",\n  \"delegate\": {\n    \"type\": \"default\",\n    \"dimension\": \"foo\",\n    \"outputName\": \"bar\"\n  },\n  \"values\": [\"xxx\"],\n  \"isWhitelist\": false\n}";
        actual = (ListFilteredDimensionSpec)mapper.readValue(mapper.writeValueAsString(mapper.readValue(jsonStr, DimensionSpec.class)), DimensionSpec.class);
        expected = new ListFilteredDimensionSpec((DimensionSpec)new DefaultDimensionSpec("foo", "bar"), (Set)ImmutableSet.of((Object)"xxx"), Boolean.valueOf(false));
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testGetCacheKey() {
        ListFilteredDimensionSpec spec1 = new ListFilteredDimensionSpec((DimensionSpec)new DefaultDimensionSpec("foo", "bar"), (Set)ImmutableSet.of((Object)"xxx"), null);
        ListFilteredDimensionSpec spec2 = new ListFilteredDimensionSpec((DimensionSpec)new DefaultDimensionSpec("foo", "bar"), (Set)ImmutableSet.of((Object)"xyz"), null);
        Assert.assertFalse((boolean)Arrays.equals(spec1.getCacheKey(), spec2.getCacheKey()));
        ListFilteredDimensionSpec spec3 = new ListFilteredDimensionSpec((DimensionSpec)new DefaultDimensionSpec("foo", "bar"), (Set)ImmutableSet.of((Object)"xxx"), Boolean.valueOf(false));
        Assert.assertFalse((boolean)Arrays.equals(spec1.getCacheKey(), spec3.getCacheKey()));
    }

    @Test
    public void testDecoratorWithWhitelist() {
        ListFilteredDimensionSpec spec = new ListFilteredDimensionSpec((DimensionSpec)new DefaultDimensionSpec("foo", "bar"), (Set)ImmutableSet.of((Object)"c", (Object)"g"), Boolean.valueOf(true));
        DimensionSelector selector = spec.decorate((DimensionSelector)TestDimensionSelector.INSTANCE);
        Assert.assertEquals((long)2L, (long)selector.getValueCardinality());
        IndexedInts row = selector.getRow();
        Assert.assertEquals((long)2L, (long)row.size());
        Assert.assertEquals((long)0L, (long)row.get(0));
        Assert.assertEquals((long)1L, (long)row.get(1));
        Assert.assertEquals((Object)"c", (Object)selector.lookupName(0));
        Assert.assertEquals((Object)"g", (Object)selector.lookupName(1));
        Assert.assertEquals((long)0L, (long)selector.idLookup().lookupId("c"));
        Assert.assertEquals((long)1L, (long)selector.idLookup().lookupId("g"));
    }

    @Test
    public void testDecoratorWithBlacklist() {
        ListFilteredDimensionSpec spec = new ListFilteredDimensionSpec((DimensionSpec)new DefaultDimensionSpec("foo", "bar"), (Set)ImmutableSet.of((Object)"c", (Object)"g"), Boolean.valueOf(false));
        DimensionSelector selector = spec.decorate((DimensionSelector)TestDimensionSelector.INSTANCE);
        Assert.assertEquals((long)24L, (long)selector.getValueCardinality());
        IndexedInts row = selector.getRow();
        Assert.assertEquals((long)1L, (long)row.size());
        Assert.assertEquals((long)3L, (long)row.get(0));
        Assert.assertEquals((Object)"a", (Object)selector.lookupName(0));
        Assert.assertEquals((Object)"z", (Object)selector.lookupName(23));
        Assert.assertEquals((long)0L, (long)selector.idLookup().lookupId("a"));
        Assert.assertEquals((long)23L, (long)selector.idLookup().lookupId("z"));
    }

    @Test
    public void testDecoratorWithBlacklistUsingNonPresentValues() {
        ListFilteredDimensionSpec spec = new ListFilteredDimensionSpec((DimensionSpec)new DefaultDimensionSpec("foo", "bar"), (Set)ImmutableSet.of((Object)"c", (Object)"gx"), Boolean.valueOf(false));
        DimensionSelector selector = spec.decorate((DimensionSelector)TestDimensionSelector.INSTANCE);
        Assert.assertEquals((long)25L, (long)selector.getValueCardinality());
        IndexedInts row = selector.getRow();
        Assert.assertEquals((long)2L, (long)row.size());
        Assert.assertEquals((long)3L, (long)row.get(0));
        Assert.assertEquals((long)5L, (long)row.get(1));
        Assert.assertEquals((Object)"e", (Object)selector.lookupName(row.get(0)));
        Assert.assertEquals((Object)"g", (Object)selector.lookupName(row.get(1)));
        Assert.assertEquals((Object)"a", (Object)selector.lookupName(0));
        Assert.assertEquals((Object)"z", (Object)selector.lookupName(24));
        Assert.assertEquals((long)0L, (long)selector.idLookup().lookupId("a"));
        Assert.assertEquals((long)24L, (long)selector.idLookup().lookupId("z"));
    }
}

