/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.datasourcemetadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.data.input.MapBasedInputRow;
import org.apache.hive.druid.org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.hive.druid.org.apache.druid.query.DefaultGenericQueryMetricsFactory;
import org.apache.hive.druid.org.apache.druid.query.Druids;
import org.apache.hive.druid.org.apache.druid.query.GenericQueryMetricsFactory;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.QueryPlus;
import org.apache.hive.druid.org.apache.druid.query.QueryRunner;
import org.apache.hive.druid.org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.org.apache.druid.query.Result;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.context.ConcurrentResponseContext;
import org.apache.hive.druid.org.apache.druid.query.context.ResponseContext;
import org.apache.hive.druid.org.apache.druid.query.datasourcemetadata.DataSourceMetadataQuery;
import org.apache.hive.druid.org.apache.druid.query.datasourcemetadata.DataSourceMetadataQueryRunnerFactory;
import org.apache.hive.druid.org.apache.druid.query.datasourcemetadata.DataSourceMetadataResultValue;
import org.apache.hive.druid.org.apache.druid.query.datasourcemetadata.DataSourceQueryQueryToolChest;
import org.apache.hive.druid.org.apache.druid.segment.IncrementalIndexSegment;
import org.apache.hive.druid.org.apache.druid.segment.Segment;
import org.apache.hive.druid.org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.org.apache.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.hive.druid.org.apache.druid.timeline.LogicalSegment;
import org.apache.hive.druid.org.apache.druid.timeline.SegmentId;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class DataSourceMetadataQueryTest {
    private static final ObjectMapper JSON_MAPPER = new DefaultObjectMapper();

    @Test
    public void testQuerySerialization() throws IOException {
        DataSourceMetadataQuery query = Druids.newDataSourceMetadataQueryBuilder().dataSource("testing").build();
        String json = JSON_MAPPER.writeValueAsString((Object)query);
        Query serdeQuery = (Query)JSON_MAPPER.readValue(json, Query.class);
        Assert.assertEquals((Object)query, (Object)serdeQuery);
    }

    @Test
    public void testContextSerde() throws Exception {
        DataSourceMetadataQuery query = Druids.newDataSourceMetadataQueryBuilder().dataSource("foo").intervals("2013/2014").context((Map)ImmutableMap.of((Object)"priority", (Object)1, (Object)"useCache", (Object)true, (Object)"populateCache", (Object)"true", (Object)"finalize", (Object)true)).build();
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        Query serdeQuery = (Query)mapper.readValue(mapper.writeValueAsBytes(mapper.readValue(mapper.writeValueAsString((Object)query), Query.class)), Query.class);
        Assert.assertEquals((Object)1, (Object)serdeQuery.getContextValue("priority"));
        Assert.assertEquals((Object)true, (Object)serdeQuery.getContextValue("useCache"));
        Assert.assertEquals((Object)"true", (Object)serdeQuery.getContextValue("populateCache"));
        Assert.assertEquals((Object)true, (Object)serdeQuery.getContextValue("finalize"));
        Assert.assertEquals((Object)true, (Object)serdeQuery.getContextBoolean("useCache", false));
        Assert.assertEquals((Object)true, (Object)serdeQuery.getContextBoolean("populateCache", false));
        Assert.assertEquals((Object)true, (Object)serdeQuery.getContextBoolean("finalize", false));
    }

    @Test
    public void testMaxIngestedEventTime() throws Exception {
        OnheapIncrementalIndex rtIndex = new IncrementalIndex.Builder().setSimpleTestingIndexSchema(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setMaxRowCount(1000).buildOnheap();
        QueryRunner runner = QueryRunnerTestHelper.makeQueryRunner(new DataSourceMetadataQueryRunnerFactory(new DataSourceQueryQueryToolChest(DefaultGenericQueryMetricsFactory.instance()), QueryRunnerTestHelper.NOOP_QUERYWATCHER), (Segment)new IncrementalIndexSegment((IncrementalIndex)rtIndex, SegmentId.dummy((String)"test")), null);
        DateTime timestamp = DateTimes.nowUtc();
        rtIndex.add((InputRow)new MapBasedInputRow(timestamp.getMillis(), (List)ImmutableList.of((Object)"dim1"), (Map)ImmutableMap.of((Object)"dim1", (Object)"x")));
        DataSourceMetadataQuery dataSourceMetadataQuery = Druids.newDataSourceMetadataQueryBuilder().dataSource("testing").build();
        ConcurrentResponseContext context = ConcurrentResponseContext.createEmpty();
        context.put((ResponseContext.BaseKey)ResponseContext.Key.MISSING_SEGMENTS, new ArrayList());
        List results = runner.run(QueryPlus.wrap((Query)dataSourceMetadataQuery), (ResponseContext)context).toList();
        DataSourceMetadataResultValue val = (DataSourceMetadataResultValue)((Result)results.iterator().next()).getValue();
        DateTime maxIngestedEventTime = val.getMaxIngestedEventTime();
        Assert.assertEquals((Object)timestamp, (Object)maxIngestedEventTime);
    }

    @Test
    public void testFilterSegments() {
        GenericQueryMetricsFactory queryMetricsFactory = DefaultGenericQueryMetricsFactory.instance();
        DataSourceQueryQueryToolChest toolChest = new DataSourceQueryQueryToolChest(queryMetricsFactory);
        List segments = toolChest.filterSegments(null, Arrays.asList(new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2012-01-01/P1D");
            }

            public Interval getTrueInterval() {
                return this.getInterval();
            }
        }, new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2012-01-01T01/PT1H");
            }

            public Interval getTrueInterval() {
                return this.getInterval();
            }
        }, new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2013-01-01/P1D");
            }

            public Interval getTrueInterval() {
                return this.getInterval();
            }
        }, new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2013-01-01T01/PT1H");
            }

            public Interval getTrueInterval() {
                return this.getInterval();
            }
        }, new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2013-01-01T02/PT1H");
            }

            public Interval getTrueInterval() {
                return this.getInterval();
            }
        }));
        Assert.assertEquals((long)segments.size(), (long)2L);
        List<LogicalSegment> expected = Arrays.asList(new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2013-01-01/P1D");
            }

            public Interval getTrueInterval() {
                return this.getInterval();
            }
        }, new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2013-01-01T02/PT1H");
            }

            public Interval getTrueInterval() {
                return this.getInterval();
            }
        });
        for (int i = 0; i < segments.size(); ++i) {
            Assert.assertEquals((Object)expected.get(i).getInterval(), (Object)((LogicalSegment)segments.get(i)).getInterval());
        }
    }

    @Test
    public void testFilterOverlappingSegments() {
        GenericQueryMetricsFactory queryMetricsFactory = DefaultGenericQueryMetricsFactory.instance();
        DataSourceQueryQueryToolChest toolChest = new DataSourceQueryQueryToolChest(queryMetricsFactory);
        List segments = toolChest.filterSegments(null, (List)ImmutableList.of((Object)new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2015/2016-08-01");
            }

            public Interval getTrueInterval() {
                return Intervals.of((String)"2015/2016-08-01");
            }
        }, (Object)new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2016-08-01/2017");
            }

            public Interval getTrueInterval() {
                return Intervals.of((String)"2016-08-01/2017");
            }
        }, (Object)new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2017/2017-08-01");
            }

            public Interval getTrueInterval() {
                return Intervals.of((String)"2017/2018");
            }
        }, (Object)new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2017-08-01/2017-08-02");
            }

            public Interval getTrueInterval() {
                return Intervals.of((String)"2017-08-01/2017-08-02");
            }
        }, (Object)new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2017-08-02/2018");
            }

            public Interval getTrueInterval() {
                return Intervals.of((String)"2017/2018");
            }
        }));
        ImmutableList expected = ImmutableList.of((Object)new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2017/2017-08-01");
            }

            public Interval getTrueInterval() {
                return Intervals.of((String)"2017/2018");
            }
        }, (Object)new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2017-08-01/2017-08-02");
            }

            public Interval getTrueInterval() {
                return Intervals.of((String)"2017-08-01/2017-08-02");
            }
        }, (Object)new LogicalSegment(){

            public Interval getInterval() {
                return Intervals.of((String)"2017-08-02/2018");
            }

            public Interval getTrueInterval() {
                return Intervals.of((String)"2017/2018");
            }
        });
        Assert.assertEquals((long)expected.size(), (long)segments.size());
        for (int i = 0; i < expected.size(); ++i) {
            Assert.assertEquals((Object)((LogicalSegment)expected.get(i)).getInterval(), (Object)((LogicalSegment)segments.get(i)).getInterval());
            Assert.assertEquals((Object)((LogicalSegment)expected.get(i)).getTrueInterval(), (Object)((LogicalSegment)segments.get(i)).getTrueInterval());
        }
    }

    @Test
    public void testResultSerialization() {
        DataSourceMetadataResultValue resultValue = new DataSourceMetadataResultValue(DateTimes.of((String)"2000-01-01T00Z"));
        Map resultValueMap = (Map)new DefaultObjectMapper().convertValue((Object)resultValue, JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        Assert.assertEquals((Object)ImmutableMap.of((Object)"maxIngestedEventTime", (Object)"2000-01-01T00:00:00.000Z"), (Object)resultValueMap);
    }

    @Test
    public void testResultDeserialization() {
        ImmutableMap resultValueMap = ImmutableMap.of((Object)"maxIngestedEventTime", (Object)"2000-01-01T00:00:00.000Z");
        DataSourceMetadataResultValue resultValue = (DataSourceMetadataResultValue)new DefaultObjectMapper().convertValue((Object)resultValueMap, DataSourceMetadataResultValue.class);
        Assert.assertEquals((Object)DateTimes.of((String)"2000"), (Object)resultValue.getMaxIngestedEventTime());
    }
}

