/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.context;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.query.SegmentDescriptor;
import org.apache.hive.druid.org.apache.druid.query.context.ResponseContext;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class ResponseContextTest {
    private final ResponseContext.BaseKey nonregisteredKey = new ResponseContext.BaseKey(){

        public String getName() {
            return "non-registered-key";
        }

        public BiFunction<Object, Object, Object> getMergeFunction() {
            return (a, b) -> a;
        }
    };

    @Test(expected=IllegalStateException.class)
    public void putISETest() {
        ResponseContext.createEmpty().put(this.nonregisteredKey, new Object());
    }

    @Test(expected=IllegalStateException.class)
    public void addISETest() {
        ResponseContext.createEmpty().add(this.nonregisteredKey, new Object());
    }

    @Test(expected=IllegalArgumentException.class)
    public void registerKeyIAETest() {
        ResponseContext.Key.registerKey((ResponseContext.BaseKey)ResponseContext.Key.NUM_SCANNED_ROWS);
    }

    @Test
    public void mergeValueTest() {
        ResponseContext ctx = ResponseContext.createEmpty();
        ctx.add((ResponseContext.BaseKey)ResponseContext.Key.ETAG, (Object)"dummy-etag");
        Assert.assertEquals((Object)"dummy-etag", (Object)ctx.get((ResponseContext.BaseKey)ResponseContext.Key.ETAG));
        ctx.add((ResponseContext.BaseKey)ResponseContext.Key.ETAG, (Object)"new-dummy-etag");
        Assert.assertEquals((Object)"new-dummy-etag", (Object)ctx.get((ResponseContext.BaseKey)ResponseContext.Key.ETAG));
        Interval interval01 = Intervals.of((String)"2019-01-01/P1D");
        ctx.add((ResponseContext.BaseKey)ResponseContext.Key.UNCOVERED_INTERVALS, Collections.singletonList(interval01));
        Assert.assertArrayEquals((Object[])Collections.singletonList(interval01).toArray(), (Object[])((List)ctx.get((ResponseContext.BaseKey)ResponseContext.Key.UNCOVERED_INTERVALS)).toArray());
        Interval interval12 = Intervals.of((String)"2019-01-02/P1D");
        Interval interval23 = Intervals.of((String)"2019-01-03/P1D");
        ctx.add((ResponseContext.BaseKey)ResponseContext.Key.UNCOVERED_INTERVALS, Arrays.asList(interval12, interval23));
        Assert.assertArrayEquals((Object[])Arrays.asList(interval01, interval12, interval23).toArray(), (Object[])((List)ctx.get((ResponseContext.BaseKey)ResponseContext.Key.UNCOVERED_INTERVALS)).toArray());
        SegmentDescriptor sd01 = new SegmentDescriptor(interval01, "01", 0);
        ctx.add((ResponseContext.BaseKey)ResponseContext.Key.MISSING_SEGMENTS, Collections.singletonList(sd01));
        Assert.assertArrayEquals((Object[])Collections.singletonList(sd01).toArray(), (Object[])((List)ctx.get((ResponseContext.BaseKey)ResponseContext.Key.MISSING_SEGMENTS)).toArray());
        SegmentDescriptor sd12 = new SegmentDescriptor(interval12, "12", 1);
        SegmentDescriptor sd23 = new SegmentDescriptor(interval23, "23", 2);
        ctx.add((ResponseContext.BaseKey)ResponseContext.Key.MISSING_SEGMENTS, Arrays.asList(sd12, sd23));
        Assert.assertArrayEquals((Object[])Arrays.asList(sd01, sd12, sd23).toArray(), (Object[])((List)ctx.get((ResponseContext.BaseKey)ResponseContext.Key.MISSING_SEGMENTS)).toArray());
        ctx.add((ResponseContext.BaseKey)ResponseContext.Key.NUM_SCANNED_ROWS, (Object)0L);
        Assert.assertEquals((Object)0L, (Object)ctx.get((ResponseContext.BaseKey)ResponseContext.Key.NUM_SCANNED_ROWS));
        ctx.add((ResponseContext.BaseKey)ResponseContext.Key.NUM_SCANNED_ROWS, (Object)1L);
        Assert.assertEquals((Object)1L, (Object)ctx.get((ResponseContext.BaseKey)ResponseContext.Key.NUM_SCANNED_ROWS));
        ctx.add((ResponseContext.BaseKey)ResponseContext.Key.NUM_SCANNED_ROWS, (Object)3L);
        Assert.assertEquals((Object)4L, (Object)ctx.get((ResponseContext.BaseKey)ResponseContext.Key.NUM_SCANNED_ROWS));
        ctx.add((ResponseContext.BaseKey)ResponseContext.Key.UNCOVERED_INTERVALS_OVERFLOWED, (Object)false);
        Assert.assertEquals((Object)false, (Object)ctx.get((ResponseContext.BaseKey)ResponseContext.Key.UNCOVERED_INTERVALS_OVERFLOWED));
        ctx.add((ResponseContext.BaseKey)ResponseContext.Key.UNCOVERED_INTERVALS_OVERFLOWED, (Object)true);
        Assert.assertEquals((Object)true, (Object)ctx.get((ResponseContext.BaseKey)ResponseContext.Key.UNCOVERED_INTERVALS_OVERFLOWED));
        ctx.add((ResponseContext.BaseKey)ResponseContext.Key.UNCOVERED_INTERVALS_OVERFLOWED, (Object)false);
        Assert.assertEquals((Object)true, (Object)ctx.get((ResponseContext.BaseKey)ResponseContext.Key.UNCOVERED_INTERVALS_OVERFLOWED));
    }

    @Test
    public void mergeResponseContextTest() {
        ResponseContext ctx1 = ResponseContext.createEmpty();
        ctx1.put((ResponseContext.BaseKey)ResponseContext.Key.ETAG, (Object)"dummy-etag-1");
        Interval interval01 = Intervals.of((String)"2019-01-01/P1D");
        ctx1.put((ResponseContext.BaseKey)ResponseContext.Key.UNCOVERED_INTERVALS, Collections.singletonList(interval01));
        ctx1.put((ResponseContext.BaseKey)ResponseContext.Key.NUM_SCANNED_ROWS, (Object)1L);
        ResponseContext ctx2 = ResponseContext.createEmpty();
        ctx2.put((ResponseContext.BaseKey)ResponseContext.Key.ETAG, (Object)"dummy-etag-2");
        Interval interval12 = Intervals.of((String)"2019-01-02/P1D");
        ctx2.put((ResponseContext.BaseKey)ResponseContext.Key.UNCOVERED_INTERVALS, Collections.singletonList(interval12));
        SegmentDescriptor sd01 = new SegmentDescriptor(interval01, "01", 0);
        ctx2.put((ResponseContext.BaseKey)ResponseContext.Key.MISSING_SEGMENTS, Collections.singletonList(sd01));
        ctx2.put((ResponseContext.BaseKey)ResponseContext.Key.NUM_SCANNED_ROWS, (Object)2L);
        ctx1.merge(ctx2);
        Assert.assertEquals((Object)"dummy-etag-2", (Object)ctx1.get((ResponseContext.BaseKey)ResponseContext.Key.ETAG));
        Assert.assertEquals((Object)3L, (Object)ctx1.get((ResponseContext.BaseKey)ResponseContext.Key.NUM_SCANNED_ROWS));
        Assert.assertArrayEquals((Object[])Arrays.asList(interval01, interval12).toArray(), (Object[])((List)ctx1.get((ResponseContext.BaseKey)ResponseContext.Key.UNCOVERED_INTERVALS)).toArray());
        Assert.assertArrayEquals((Object[])Collections.singletonList(sd01).toArray(), (Object[])((List)ctx1.get((ResponseContext.BaseKey)ResponseContext.Key.MISSING_SEGMENTS)).toArray());
    }

    @Test(expected=IllegalStateException.class)
    public void mergeISETest() {
        ResponseContext ctx = new ResponseContext(){

            protected Map<ResponseContext.BaseKey, Object> getDelegate() {
                return ImmutableMap.of((Object)ResponseContextTest.this.nonregisteredKey, (Object)"non-registered-key");
            }
        };
        ResponseContext.createEmpty().merge(ctx);
    }

    @Test
    public void serializeWithCorrectnessTest() throws JsonProcessingException {
        ResponseContext ctx1 = ResponseContext.createEmpty();
        ctx1.add((ResponseContext.BaseKey)ResponseContext.Key.ETAG, (Object)"string-value");
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        Assert.assertEquals((Object)mapper.writeValueAsString((Object)ImmutableMap.of((Object)"ETag", (Object)"string-value")), (Object)ctx1.serializeWith((ObjectMapper)mapper, Integer.MAX_VALUE).getTruncatedResult());
        ResponseContext ctx2 = ResponseContext.createEmpty();
        ctx2.add((ResponseContext.BaseKey)ResponseContext.Key.NUM_SCANNED_ROWS, (Object)100);
        Assert.assertEquals((Object)mapper.writeValueAsString((Object)ImmutableMap.of((Object)"count", (Object)100)), (Object)ctx2.serializeWith((ObjectMapper)mapper, Integer.MAX_VALUE).getTruncatedResult());
    }

    @Test
    public void serializeWithTruncateValueTest() throws IOException {
        ResponseContext ctx = ResponseContext.createEmpty();
        ctx.put((ResponseContext.BaseKey)ResponseContext.Key.NUM_SCANNED_ROWS, (Object)100);
        ctx.put((ResponseContext.BaseKey)ResponseContext.Key.ETAG, (Object)"long-string-that-is-supposed-to-be-removed-from-result");
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        String fullString = objectMapper.writeValueAsString((Object)ctx.getDelegate());
        ResponseContext.SerializationResult res1 = ctx.serializeWith((ObjectMapper)objectMapper, Integer.MAX_VALUE);
        Assert.assertEquals((Object)fullString, (Object)res1.getTruncatedResult());
        ResponseContext ctxCopy = ResponseContext.createEmpty();
        ctxCopy.merge(ctx);
        ResponseContext.SerializationResult res2 = ctx.serializeWith((ObjectMapper)objectMapper, 30);
        ctxCopy.remove((ResponseContext.BaseKey)ResponseContext.Key.ETAG);
        ctxCopy.put((ResponseContext.BaseKey)ResponseContext.Key.TRUNCATED, (Object)true);
        Assert.assertEquals((Object)ctxCopy.getDelegate(), (Object)ResponseContext.deserialize((String)res2.getTruncatedResult(), (ObjectMapper)objectMapper).getDelegate());
    }

    @Test
    public void serializeWithTruncateArrayTest() throws IOException {
        ResponseContext ctx = ResponseContext.createEmpty();
        ctx.put((ResponseContext.BaseKey)ResponseContext.Key.NUM_SCANNED_ROWS, (Object)100);
        ctx.put((ResponseContext.BaseKey)ResponseContext.Key.UNCOVERED_INTERVALS, Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9));
        ctx.put((ResponseContext.BaseKey)ResponseContext.Key.MISSING_SEGMENTS, Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9));
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        String fullString = objectMapper.writeValueAsString((Object)ctx.getDelegate());
        ResponseContext.SerializationResult res1 = ctx.serializeWith((ObjectMapper)objectMapper, Integer.MAX_VALUE);
        Assert.assertEquals((Object)fullString, (Object)res1.getTruncatedResult());
        ResponseContext ctxCopy = ResponseContext.createEmpty();
        ctxCopy.merge(ctx);
        ResponseContext.SerializationResult res2 = ctx.serializeWith((ObjectMapper)objectMapper, 70);
        ctxCopy.put((ResponseContext.BaseKey)ResponseContext.Key.UNCOVERED_INTERVALS, Arrays.asList(0, 1, 2, 3, 4));
        ctxCopy.remove((ResponseContext.BaseKey)ResponseContext.Key.MISSING_SEGMENTS);
        ctxCopy.put((ResponseContext.BaseKey)ResponseContext.Key.TRUNCATED, (Object)true);
        Assert.assertEquals((Object)ctxCopy.getDelegate(), (Object)ResponseContext.deserialize((String)res2.getTruncatedResult(), (ObjectMapper)objectMapper).getDelegate());
    }

    @Test
    public void deserializeTest() throws IOException {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        ResponseContext ctx = ResponseContext.deserialize((String)mapper.writeValueAsString((Object)ImmutableMap.of((Object)"ETag", (Object)"string-value", (Object)"count", (Object)100L, (Object)"cpuConsumed", (Object)100000L)), (ObjectMapper)mapper);
        Assert.assertEquals((Object)"string-value", (Object)ctx.get((ResponseContext.BaseKey)ResponseContext.Key.ETAG));
        Assert.assertEquals((Object)100, (Object)ctx.get((ResponseContext.BaseKey)ResponseContext.Key.NUM_SCANNED_ROWS));
        Assert.assertEquals((Object)100000, (Object)ctx.get((ResponseContext.BaseKey)ResponseContext.Key.CPU_CONSUMED_NANOS));
        ctx.add((ResponseContext.BaseKey)ResponseContext.Key.NUM_SCANNED_ROWS, (Object)10L);
        Assert.assertEquals((Object)110L, (Object)ctx.get((ResponseContext.BaseKey)ResponseContext.Key.NUM_SCANNED_ROWS));
        ctx.add((ResponseContext.BaseKey)ResponseContext.Key.CPU_CONSUMED_NANOS, (Object)100);
        Assert.assertEquals((Object)100100L, (Object)ctx.get((ResponseContext.BaseKey)ResponseContext.Key.CPU_CONSUMED_NANOS));
    }

    @Test(expected=IllegalStateException.class)
    public void deserializeISETest() throws IOException {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        ResponseContext.deserialize((String)mapper.writeValueAsString((Object)ImmutableMap.of((Object)"ETag_unexpected", (Object)"string-value")), (ObjectMapper)mapper);
    }

    @Test
    public void extensionEnumIntegrityTest() {
        Assert.assertEquals((Object)((Object)ExtensionResponseContextKey.EXTENSION_KEY_1), (Object)ResponseContext.Key.keyOf((String)ExtensionResponseContextKey.EXTENSION_KEY_1.getName()));
        Assert.assertEquals((Object)((Object)ExtensionResponseContextKey.EXTENSION_KEY_2), (Object)ResponseContext.Key.keyOf((String)ExtensionResponseContextKey.EXTENSION_KEY_2.getName()));
        for (ExtensionResponseContextKey key : ExtensionResponseContextKey.values()) {
            Assert.assertTrue((boolean)ResponseContext.Key.getAllRegisteredKeys().contains((Object)key));
        }
    }

    @Test
    public void extensionEnumMergeTest() {
        ResponseContext ctx = ResponseContext.createEmpty();
        ctx.add((ResponseContext.BaseKey)ResponseContext.Key.ETAG, (Object)"etag");
        ctx.add((ResponseContext.BaseKey)ExtensionResponseContextKey.EXTENSION_KEY_1, (Object)"string-value");
        ctx.add((ResponseContext.BaseKey)ExtensionResponseContextKey.EXTENSION_KEY_2, (Object)2L);
        ResponseContext ctxFinal = ResponseContext.createEmpty();
        ctxFinal.add((ResponseContext.BaseKey)ResponseContext.Key.ETAG, (Object)"old-etag");
        ctxFinal.add((ResponseContext.BaseKey)ExtensionResponseContextKey.EXTENSION_KEY_1, (Object)"old-string-value");
        ctxFinal.add((ResponseContext.BaseKey)ExtensionResponseContextKey.EXTENSION_KEY_2, (Object)1L);
        ctxFinal.merge(ctx);
        Assert.assertEquals((Object)"etag", (Object)ctxFinal.get((ResponseContext.BaseKey)ResponseContext.Key.ETAG));
        Assert.assertEquals((Object)"string-value", (Object)ctxFinal.get((ResponseContext.BaseKey)ExtensionResponseContextKey.EXTENSION_KEY_1));
        Assert.assertEquals((Object)3L, (Object)ctxFinal.get((ResponseContext.BaseKey)ExtensionResponseContextKey.EXTENSION_KEY_2));
    }

    static enum ExtensionResponseContextKey implements ResponseContext.BaseKey
    {
        EXTENSION_KEY_1("extension_key_1"),
        EXTENSION_KEY_2("extension_key_2", (oldValue, newValue) -> (Long)oldValue + (Long)newValue);

        private final String name;
        private final BiFunction<Object, Object, Object> mergeFunction;

        private ExtensionResponseContextKey(String name) {
            this.name = name;
            this.mergeFunction = (oldValue, newValue) -> newValue;
        }

        private ExtensionResponseContextKey(String name, BiFunction<Object, Object, Object> mergeFunction) {
            this.name = name;
            this.mergeFunction = mergeFunction;
        }

        public String getName() {
            return this.name;
        }

        public BiFunction<Object, Object, Object> getMergeFunction() {
            return this.mergeFunction;
        }

        static {
            for (ExtensionResponseContextKey key : ExtensionResponseContextKey.values()) {
                ResponseContext.Key.registerKey((ResponseContext.BaseKey)key);
            }
        }
    }
}

