/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.aggregation.post;

import java.util.HashMap;
import java.util.List;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.org.apache.druid.js.JavaScriptConfig;
import org.apache.hive.druid.org.apache.druid.query.aggregation.post.JavaScriptPostAggregator;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class JavaScriptPostAggregatorTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testCompute() {
        HashMap<String, Double> metricValues = new HashMap<String, Double>();
        metricValues.put("delta", -10.0);
        metricValues.put("total", 100.0);
        String absPercentFunction = "function(delta, total) { return 100 * Math.abs(delta) / total; }";
        JavaScriptPostAggregator javaScriptPostAggregator = new JavaScriptPostAggregator("absPercent", (List)Lists.newArrayList((Object[])new String[]{"delta", "total"}), absPercentFunction, JavaScriptConfig.getEnabledInstance());
        Assert.assertEquals((Object)10.0, (Object)javaScriptPostAggregator.compute(metricValues));
    }

    @Test
    public void testComputeJavaScriptNotAllowed() {
        String absPercentFunction = "function(delta, total) { return 100 * Math.abs(delta) / total; }";
        JavaScriptPostAggregator aggregator = new JavaScriptPostAggregator("absPercent", (List)Lists.newArrayList((Object[])new String[]{"delta", "total"}), absPercentFunction, new JavaScriptConfig(false));
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("JavaScript is disabled");
        aggregator.compute(new HashMap());
    }
}

