/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.aggregation.mean;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.base.Suppliers;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.org.apache.druid.data.input.MapBasedInputRow;
import org.apache.hive.druid.org.apache.druid.data.input.impl.InputRowParser;
import org.apache.hive.druid.org.apache.druid.data.input.impl.NoopInputRowParser;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregationTestHelper;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.segment.QueryableIndex;
import org.apache.hive.druid.org.apache.druid.segment.TestIndex;
import org.apache.hive.druid.org.apache.druid.segment.incremental.IncrementalIndex;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class SimpleTestIndex {
    public static final int NUM_ROWS = 10;
    public static final String SINGLE_VALUE_DOUBLE_AS_STRING_DIM = "singleValueDoubleAsStringDim";
    public static final String MULTI_VALUE_DOUBLE_AS_STRING_DIM = "multiValueDoubleAsStringDim";
    public static final String DOUBLE_COL = "doubleCol";
    public static final List<String> DIMENSIONS = ImmutableList.of((Object)"singleValueDoubleAsStringDim", (Object)"multiValueDoubleAsStringDim");
    private static Supplier<IncrementalIndex> realtimeIndex = Suppliers.memoize(() -> SimpleTestIndex.makeRealtimeIndex());
    private static Supplier<QueryableIndex> mmappedIndex = Suppliers.memoize(() -> TestIndex.persistRealtimeAndLoadMMapped((IncrementalIndex)realtimeIndex.get()));

    public static IncrementalIndex getIncrementalTestIndex() {
        return (IncrementalIndex)realtimeIndex.get();
    }

    public static QueryableIndex getMMappedTestIndex() {
        return (QueryableIndex)mmappedIndex.get();
    }

    private static IncrementalIndex makeRealtimeIndex() {
        try {
            ArrayList inputRows = Lists.newArrayListWithExpectedSize((int)10);
            for (int i = 1; i <= 10; ++i) {
                double doubleVal = (double)i + 0.7;
                String stringVal = String.valueOf(doubleVal);
                inputRows.add(new MapBasedInputRow(DateTime.now((DateTimeZone)DateTimeZone.UTC), DIMENSIONS, (Map)ImmutableMap.of((Object)DOUBLE_COL, (Object)doubleVal, (Object)SINGLE_VALUE_DOUBLE_AS_STRING_DIM, (Object)stringVal, (Object)MULTI_VALUE_DOUBLE_AS_STRING_DIM, (Object)Lists.newArrayList((Object[])new String[]{stringVal, null, stringVal}))));
            }
            return AggregationTestHelper.createIncrementalIndex(inputRows.iterator(), (InputRowParser)new NoopInputRowParser(null), new AggregatorFactory[]{new CountAggregatorFactory("count"), new DoubleSumAggregatorFactory(DOUBLE_COL, DOUBLE_COL)}, 0L, Granularities.NONE, false, 100, false);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

