/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.aggregation.mean;

import java.util.Collections;
import java.util.List;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.org.apache.druid.data.input.MapBasedRow;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.org.apache.druid.query.Druids;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.Result;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregationTestHelper;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.mean.DoubleMeanAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.mean.SimpleTestIndex;
import org.apache.hive.druid.org.apache.druid.query.groupby.GroupByQuery;
import org.apache.hive.druid.org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.hive.druid.org.apache.druid.query.groupby.ResultRow;
import org.apache.hive.druid.org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.hive.druid.org.apache.druid.query.timeseries.TimeseriesResultValue;
import org.apache.hive.druid.org.apache.druid.segment.IncrementalIndexSegment;
import org.apache.hive.druid.org.apache.druid.segment.QueryableIndexSegment;
import org.apache.hive.druid.org.apache.druid.segment.Segment;
import org.apache.hive.druid.org.apache.druid.timeline.SegmentId;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class DoubleMeanAggregationTest {
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();
    private final AggregationTestHelper groupByQueryTestHelper = AggregationTestHelper.createGroupByQueryAggregationTestHelper(Collections.EMPTY_LIST, new GroupByQueryConfig(), this.tempFolder);
    private final AggregationTestHelper timeseriesQueryTestHelper = AggregationTestHelper.createTimeseriesQueryAggregationTestHelper(Collections.EMPTY_LIST, this.tempFolder);
    private final List<Segment> segments = ImmutableList.of((Object)new IncrementalIndexSegment(SimpleTestIndex.getIncrementalTestIndex(), SegmentId.dummy((String)"test1")), (Object)new QueryableIndexSegment(SimpleTestIndex.getMMappedTestIndex(), SegmentId.dummy((String)"test2")));

    @Test
    public void testBufferAggretatorUsingGroupByQuery() throws Exception {
        GroupByQuery query = new GroupByQuery.Builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval("1970/2050").setAggregatorSpecs(new AggregatorFactory[]{new DoubleMeanAggregatorFactory("meanOnDouble", "doubleCol"), new DoubleMeanAggregatorFactory("meanOnString", "singleValueDoubleAsStringDim"), new DoubleMeanAggregatorFactory("meanOnMultiValue", "multiValueDoubleAsStringDim")}).build();
        ObjectMapper jsonMapper = this.groupByQueryTestHelper.getObjectMapper();
        query = (GroupByQuery)jsonMapper.readValue(jsonMapper.writeValueAsString((Object)query), Query.class);
        Sequence<ResultRow> seq = this.groupByQueryTestHelper.runQueryOnSegmentsObjs(this.segments, (Query)query);
        MapBasedRow result = ((ResultRow)Iterables.getOnlyElement((Iterable)seq.toList())).toMapBasedRow(query);
        Assert.assertEquals((double)6.2, (double)result.getMetric("meanOnDouble").doubleValue(), (double)1.0E-4);
        Assert.assertEquals((double)6.2, (double)result.getMetric("meanOnString").doubleValue(), (double)1.0E-4);
        Assert.assertEquals((double)4.1333, (double)result.getMetric("meanOnMultiValue").doubleValue(), (double)1.0E-4);
    }

    @Test
    public void testVectorAggretatorUsingGroupByQueryOnDoubleColumn() throws Exception {
        GroupByQuery query = new GroupByQuery.Builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval("1970/2050").setAggregatorSpecs(new AggregatorFactory[]{new DoubleMeanAggregatorFactory("meanOnDouble", "doubleCol")}).setContext(Collections.singletonMap("vectorize", true)).build();
        ObjectMapper jsonMapper = this.groupByQueryTestHelper.getObjectMapper();
        query = (GroupByQuery)jsonMapper.readValue(jsonMapper.writeValueAsString((Object)query), Query.class);
        Sequence<ResultRow> seq = this.groupByQueryTestHelper.runQueryOnSegmentsObjs(this.segments, (Query)query);
        MapBasedRow result = ((ResultRow)Iterables.getOnlyElement((Iterable)seq.toList())).toMapBasedRow(query);
        Assert.assertEquals((double)6.2, (double)result.getMetric("meanOnDouble").doubleValue(), (double)1.0E-4);
    }

    @Test
    public void testAggretatorUsingTimeseriesQuery() throws Exception {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("test").granularity(Granularities.ALL).intervals("1970/2050").aggregators(new AggregatorFactory[]{new DoubleMeanAggregatorFactory("meanOnDouble", "doubleCol"), new DoubleMeanAggregatorFactory("meanOnString", "singleValueDoubleAsStringDim"), new DoubleMeanAggregatorFactory("meanOnMultiValue", "multiValueDoubleAsStringDim")}).build();
        ObjectMapper jsonMapper = this.timeseriesQueryTestHelper.getObjectMapper();
        query = (TimeseriesQuery)jsonMapper.readValue(jsonMapper.writeValueAsString((Object)query), Query.class);
        Sequence<ResultRow> seq = this.timeseriesQueryTestHelper.runQueryOnSegmentsObjs(this.segments, (Query)query);
        TimeseriesResultValue result = (TimeseriesResultValue)((Result)Iterables.getOnlyElement((Iterable)seq.toList())).getValue();
        Assert.assertEquals((double)6.2, (double)result.getDoubleMetric("meanOnDouble"), (double)1.0E-4);
        Assert.assertEquals((double)6.2, (double)result.getDoubleMetric("meanOnString"), (double)1.0E-4);
        Assert.assertEquals((double)4.1333, (double)result.getDoubleMetric("meanOnMultiValue"), (double)1.0E-4);
    }
}

