/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.aggregation.last;

import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.hive.druid.org.apache.druid.collections.SerializablePair;
import org.apache.hive.druid.org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.org.apache.druid.java.util.common.Pair;
import org.apache.hive.druid.org.apache.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.TestDoubleColumnSelectorImpl;
import org.apache.hive.druid.org.apache.druid.query.aggregation.TestLongColumnSelector;
import org.apache.hive.druid.org.apache.druid.query.aggregation.TestObjectColumnSelector;
import org.apache.hive.druid.org.apache.druid.query.aggregation.last.DoubleLastAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.org.apache.druid.testing.InitializedNullHandlingTest;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DoubleLastAggregationTest
extends InitializedNullHandlingTest {
    private DoubleLastAggregatorFactory doubleLastAggFactory;
    private DoubleLastAggregatorFactory combiningAggFactory;
    private ColumnSelectorFactory colSelectorFactory;
    private TestLongColumnSelector timeSelector;
    private TestDoubleColumnSelectorImpl valueSelector;
    private TestObjectColumnSelector objectSelector;
    private double[] doubles = new double[]{1.1897, 0.001, 86.23, 166.228};
    private long[] times = new long[]{8224L, 6879L, 2436L, 7888L};
    private SerializablePair[] pairs = new SerializablePair[]{new SerializablePair((Object)52782L, (Object)134.3), new SerializablePair((Object)65492L, (Object)1232.212), new SerializablePair((Object)69134L, (Object)18.1233), new SerializablePair((Object)11111L, (Object)233.5232)};

    @Before
    public void setup() {
        this.doubleLastAggFactory = new DoubleLastAggregatorFactory("billy", "nilly");
        this.combiningAggFactory = (DoubleLastAggregatorFactory)this.doubleLastAggFactory.getCombiningFactory();
        this.timeSelector = new TestLongColumnSelector(this.times);
        this.valueSelector = new TestDoubleColumnSelectorImpl(this.doubles);
        this.objectSelector = new TestObjectColumnSelector<SerializablePair>(this.pairs);
        this.colSelectorFactory = (ColumnSelectorFactory)EasyMock.createMock(ColumnSelectorFactory.class);
        EasyMock.expect((Object)this.colSelectorFactory.makeColumnValueSelector("__time")).andReturn((Object)this.timeSelector);
        EasyMock.expect((Object)this.colSelectorFactory.makeColumnValueSelector("nilly")).andReturn((Object)this.valueSelector);
        EasyMock.expect((Object)this.colSelectorFactory.makeColumnValueSelector("billy")).andReturn((Object)this.objectSelector);
        EasyMock.replay((Object[])new Object[]{this.colSelectorFactory});
    }

    @Test
    public void testDoubleLastAggregator() {
        Aggregator agg = this.doubleLastAggFactory.factorize(this.colSelectorFactory);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        Pair result = (Pair)agg.get();
        Assert.assertEquals((long)this.times[0], (long)((Long)result.lhs));
        Assert.assertEquals((double)this.doubles[0], (double)((Double)result.rhs), (double)1.0E-4);
        Assert.assertEquals((long)((long)this.doubles[0]), (long)agg.getLong());
        Assert.assertEquals((double)this.doubles[0], (double)agg.getDouble(), (double)1.0E-4);
    }

    @Test
    public void testDoubleLastBufferAggregator() {
        BufferAggregator agg = this.doubleLastAggFactory.factorizeBuffered(this.colSelectorFactory);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[this.doubleLastAggFactory.getMaxIntermediateSizeWithNulls()]);
        agg.init(buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        Pair result = (Pair)agg.get(buffer, 0);
        Assert.assertEquals((long)this.times[0], (long)((Long)result.lhs));
        Assert.assertEquals((double)this.doubles[0], (double)((Double)result.rhs), (double)1.0E-4);
        Assert.assertEquals((long)((long)this.doubles[0]), (long)agg.getLong(buffer, 0));
        Assert.assertEquals((double)this.doubles[0], (double)agg.getDouble(buffer, 0), (double)1.0E-4);
    }

    @Test
    public void testCombine() {
        SerializablePair pair1 = new SerializablePair((Object)1467225000L, (Object)3.621);
        SerializablePair pair2 = new SerializablePair((Object)1467240000L, (Object)785.4);
        Assert.assertEquals((Object)pair2, (Object)this.doubleLastAggFactory.combine((Object)pair1, (Object)pair2));
    }

    @Test
    public void testComparatorWithNulls() {
        SerializablePair pair1 = new SerializablePair((Object)1467225000L, (Object)3.621);
        SerializablePair pair2 = new SerializablePair((Object)1467240000L, null);
        Comparator comparator = this.doubleLastAggFactory.getComparator();
        Assert.assertEquals((long)1L, (long)comparator.compare(pair1, pair2));
        Assert.assertEquals((long)0L, (long)comparator.compare(pair1, pair1));
        Assert.assertEquals((long)0L, (long)comparator.compare(pair2, pair2));
        Assert.assertEquals((long)-1L, (long)comparator.compare(pair2, pair1));
    }

    @Test
    public void testDoubleLastCombiningAggregator() {
        Aggregator agg = this.combiningAggFactory.factorize(this.colSelectorFactory);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        Pair result = (Pair)agg.get();
        SerializablePair expected = this.pairs[2];
        Assert.assertEquals((Object)expected.lhs, (Object)result.lhs);
        Assert.assertEquals((double)((Double)expected.rhs), (double)((Double)result.rhs), (double)1.0E-4);
        Assert.assertEquals((long)((Double)expected.rhs).longValue(), (long)agg.getLong());
        Assert.assertEquals((double)((Double)expected.rhs), (double)agg.getDouble(), (double)1.0E-4);
    }

    @Test
    public void testDoubleLastCombiningBufferAggregator() {
        BufferAggregator agg = this.combiningAggFactory.factorizeBuffered(this.colSelectorFactory);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[this.doubleLastAggFactory.getMaxIntermediateSizeWithNulls()]);
        agg.init(buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        Pair result = (Pair)agg.get(buffer, 0);
        SerializablePair expected = this.pairs[2];
        Assert.assertEquals((Object)expected.lhs, (Object)result.lhs);
        Assert.assertEquals((double)((Double)expected.rhs), (double)((Double)result.rhs), (double)1.0E-4);
        Assert.assertEquals((long)((Double)expected.rhs).longValue(), (long)agg.getLong(buffer, 0));
        Assert.assertEquals((double)((Double)expected.rhs), (double)agg.getDouble(buffer, 0), (double)1.0E-4);
    }

    @Test
    public void testSerde() throws Exception {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        String doubleSpecJson = "{\"type\":\"doubleLast\",\"name\":\"billy\",\"fieldName\":\"nilly\"}";
        Assert.assertEquals((Object)this.doubleLastAggFactory, (Object)mapper.readValue(doubleSpecJson, AggregatorFactory.class));
    }

    private void aggregate(Aggregator agg) {
        agg.aggregate();
        this.timeSelector.increment();
        this.valueSelector.increment();
        this.objectSelector.increment();
    }

    private void aggregate(BufferAggregator agg, ByteBuffer buff, int position) {
        agg.aggregate(buff, position);
        this.timeSelector.increment();
        this.valueSelector.increment();
        this.objectSelector.increment();
    }
}

