/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.aggregation.hyperloglog;

import java.util.Comparator;
import java.util.Random;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.hash.HashFunction;
import org.apache.hive.druid.com.google.common.hash.Hashing;
import org.apache.hive.druid.org.apache.druid.hll.HyperLogLogCollector;
import org.apache.hive.druid.org.apache.druid.hll.VersionZeroHyperLogLogCollector;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.segment.TestHelper;
import org.junit.Assert;
import org.junit.Test;

public class HyperUniquesAggregatorFactoryTest {
    static final HyperUniquesAggregatorFactory AGGREGATOR_FACTORY = new HyperUniquesAggregatorFactory("hyperUnique", "uniques");
    static final String V0_BASE64 = "AAYbEyQwFyQVASMCVFEQQgEQIxIhM4ISAQMhUkICEDFDIBMhMgFQFAFAMjAAEhEREyVAEiUBAhIjISATMCECMiERIRIiVRFRAyIAEgFCQSMEJAITATAAEAMQgCEBEjQiAyUTAyEQASJyAGURAAISAwISATETQhAREBYDIVIlFTASAzJgERIgRCcmUyAwNAMyEJMjIhQXQhEWECABQDETATEREjIRAgEyIiMxMBQiAkBBMDYAMEQQACMzMhIkMTQSkYIRABIBADMBAhIEISAENkEBQDAxETMAIEEwEzQiQSEVQSFBBAQDICIiAVIAMTAQIQYBIRABADMDEzEAQSMkEiAYFBAQI0AmECEyQSARRTIVMhEkMiKAMCUBxUghAkIBI3EmMAQiACEAJDJCAAADOzESEDBCRjMgEUQQETQwEWIhA6MlAiAAZDI1AgEIIDUyFDIHMQEEAwIRBRABBStCZCQhAgJSMQIiQEEURTBmM1MxACIAETGhMgQnBRICNiIREyIUNAEAAkABAwQSEBJBIhIhIRERAiIRACUhEUAVMkQGEVMjECYjACBwEQQSIRIgAAEyExQUFSEAIBJCIDIDYTAgMiNBIUADUiETADMoFEADETMCIwUEQkIAESMSIzIABDERIXEhIiACQgUSEgJiQCAUARIRAREDQiEUAkQgAgQiIEAzIxRCARIgBAAVAzMAECEwE0Qh8gAAASEhEiAiMhUxcRImIVABATYyUBAwIoE1QhRDIiYBIBEBEiQSQyERAAADMAARAEACFYUwQSQBIRIgURITARFSEzEHEBACOTMREBIAMjIgEhU0cxEQIRIhIi1wEgMRUBEgMQIRAnAVASURMHQBAiEyBSAAEBQTAWQ5EQA0IUMSISAUEiASIjIhMhMFJBBSEjEAECEwACASEQFBAjARITEQIgYTEKEAeAAiMkEyARowARFBAicRISIBIxAQAgEBARMCIRQgMSIVIAkjMxIAIEMyADASMgFRIjEyKjEjBBIEQCUAARYBEQMxMCIBACNCACRCMlEzUUAAUDM1MhAjEgAxAAISAVFQECAhQAMBMhEzEgASNxAhFRIxECMRJBQAERAToBgQMhJSRQFAEhAwMiIhMQAwAgQiBQJiIGMQQhEiQxR1MiAjIAIEEiAkARECEzQlMjECIRATBgIhEBQAIQAEATEjBCMwAgMBMhAhIyFBIxQAARI1AAEABCIDFBIRUzMBIgAgEiARQCASMQQDQCFBAQAUJwMUElAyIAIRBSIRITICEAIxMAEUBEYTcBMBEEIxMREwIRIDAGIAEgYxBAEANCAhBAI2UhIiIgIRABIEVRAwNEIQERQgEFMhFCQSIAEhQDMTEQMiAjJyEQ==";
    private final HashFunction fn = Hashing.murmur3_128();

    @Test
    public void testDeserializeV0() {
        Object v0 = AGGREGATOR_FACTORY.deserialize((Object)V0_BASE64);
        Assert.assertEquals((String)"deserialized value is VersionZeroHyperLogLogCollector", VersionZeroHyperLogLogCollector.class, v0.getClass());
    }

    @Test
    public void testCompare1() {
        HyperLogLogCollector collector1 = HyperLogLogCollector.makeLatestCollector();
        HyperLogLogCollector collector2 = HyperLogLogCollector.makeLatestCollector();
        collector1.add(this.fn.hashLong(0L).asBytes());
        HyperUniquesAggregatorFactory factory = new HyperUniquesAggregatorFactory("foo", "bar");
        Comparator comparator = factory.getComparator();
        for (int i = 1; i < 100; i += 2) {
            collector1.add(this.fn.hashLong((long)i).asBytes());
            collector2.add(this.fn.hashLong((long)(i + 1)).asBytes());
            Assert.assertEquals((long)1L, (long)comparator.compare(collector1, collector2));
            Assert.assertEquals((long)1L, (long)Double.compare(collector1.estimateCardinality(), collector2.estimateCardinality()));
        }
    }

    @Test
    public void testCompare2() {
        int l;
        int k;
        HyperLogLogCollector collector2;
        int j;
        HyperLogLogCollector collector1;
        int i;
        Random rand = new Random(0L);
        HyperUniquesAggregatorFactory factory = new HyperUniquesAggregatorFactory("foo", "bar");
        Comparator comparator = factory.getComparator();
        for (i = 1; i < 1000; ++i) {
            collector1 = HyperLogLogCollector.makeLatestCollector();
            j = rand.nextInt(50);
            for (int l2 = 0; l2 < j; ++l2) {
                collector1.add(this.fn.hashLong(rand.nextLong()).asBytes());
            }
            collector2 = HyperLogLogCollector.makeLatestCollector();
            k = j + 1 + rand.nextInt(5);
            for (l = 0; l < k; ++l) {
                collector2.add(this.fn.hashLong(rand.nextLong()).asBytes());
            }
            Assert.assertEquals((long)Double.compare(collector1.estimateCardinality(), collector2.estimateCardinality()), (long)comparator.compare(collector1, collector2));
        }
        for (i = 1; i < 100; ++i) {
            collector1 = HyperLogLogCollector.makeLatestCollector();
            j = rand.nextInt(500);
            for (int l3 = 0; l3 < j; ++l3) {
                collector1.add(this.fn.hashLong(rand.nextLong()).asBytes());
            }
            collector2 = HyperLogLogCollector.makeLatestCollector();
            k = j + 2 + rand.nextInt(5);
            for (l = 0; l < k; ++l) {
                collector2.add(this.fn.hashLong(rand.nextLong()).asBytes());
            }
            Assert.assertEquals((long)Double.compare(collector1.estimateCardinality(), collector2.estimateCardinality()), (long)comparator.compare(collector1, collector2));
        }
        for (i = 1; i < 10; ++i) {
            collector1 = HyperLogLogCollector.makeLatestCollector();
            j = rand.nextInt(100000);
            for (int l4 = 0; l4 < j; ++l4) {
                collector1.add(this.fn.hashLong(rand.nextLong()).asBytes());
            }
            collector2 = HyperLogLogCollector.makeLatestCollector();
            k = j + 20000 + rand.nextInt(100000);
            for (l = 0; l < k; ++l) {
                collector2.add(this.fn.hashLong(rand.nextLong()).asBytes());
            }
            Assert.assertEquals((long)Double.compare(collector1.estimateCardinality(), collector2.estimateCardinality()), (long)comparator.compare(collector1, collector2));
        }
    }

    @Test
    public void testCompareToShouldBehaveConsistentlyWithEstimatedCardinalitiesEvenInToughCases() {
        Random rand = new Random(0L);
        HyperUniquesAggregatorFactory factory = new HyperUniquesAggregatorFactory("foo", "bar");
        Comparator comparator = factory.getComparator();
        for (int i = 0; i < 1000; ++i) {
            HyperLogLogCollector leftCollector = HyperLogLogCollector.makeLatestCollector();
            int j = rand.nextInt(9000) + 5000;
            for (int l = 0; l < j; ++l) {
                leftCollector.add(this.fn.hashLong(rand.nextLong()).asBytes());
            }
            HyperLogLogCollector rightCollector = HyperLogLogCollector.makeLatestCollector();
            int k = rand.nextInt(9000) + 5000;
            for (int l = 0; l < k; ++l) {
                rightCollector.add(this.fn.hashLong(rand.nextLong()).asBytes());
            }
            int orderedByCardinality = Double.compare(leftCollector.estimateCardinality(), rightCollector.estimateCardinality());
            int orderedByComparator = comparator.compare(leftCollector, rightCollector);
            Assert.assertEquals((String)StringUtils.format((String)"orderedByComparator=%d, orderedByCardinality=%d,\nLeft={cardinality=%f, hll=%s},\nRight={cardinality=%f, hll=%s},\n", (Object[])new Object[]{orderedByComparator, orderedByCardinality, leftCollector.estimateCardinality(), leftCollector, rightCollector.estimateCardinality(), rightCollector}), (long)orderedByCardinality, (long)orderedByComparator);
        }
    }

    @Test
    public void testSerde() throws Exception {
        HyperUniquesAggregatorFactory factory = new HyperUniquesAggregatorFactory("foo", "bar", true, true);
        ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
        AggregatorFactory factory2 = (AggregatorFactory)jsonMapper.readValue(jsonMapper.writeValueAsString((Object)factory), AggregatorFactory.class);
        Assert.assertEquals((Object)factory, (Object)factory2);
    }
}

