/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.aggregation.hyperloglog;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.hive.druid.org.apache.druid.jackson.AggregatorsModule;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregationTestHelper;
import org.apache.hive.druid.org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.hive.druid.org.apache.druid.query.groupby.GroupByQueryRunnerTest;
import org.apache.hive.druid.org.apache.druid.query.groupby.ResultRow;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class HyperUniquesAggregationTest {
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();
    private final GroupByQueryConfig config;

    public HyperUniquesAggregationTest(GroupByQueryConfig config) {
        this.config = config;
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<?> constructorFeeder() {
        ArrayList<Object[]> constructors = new ArrayList<Object[]>();
        for (GroupByQueryConfig config : GroupByQueryRunnerTest.testConfigs()) {
            constructors.add(new Object[]{config});
        }
        return constructors;
    }

    @Test
    public void testIngestAndQuery() throws Exception {
        try (AggregationTestHelper helper = AggregationTestHelper.createGroupByQueryAggregationTestHelper(Collections.singletonList(new AggregatorsModule()), this.config, this.tempFolder);){
            String metricSpec = "[{\"type\": \"hyperUnique\",\"name\": \"index_hll\",\"fieldName\": \"market\"}]";
            String parseSpec = "{\"type\" : \"string\",\"parseSpec\" : {    \"format\" : \"tsv\",    \"timestampSpec\" : {        \"column\" : \"timestamp\",        \"format\" : \"auto\"},    \"dimensionsSpec\" : {        \"dimensions\": [],        \"dimensionExclusions\" : [],        \"spatialDimensions\" : []    },    \"columns\": [\"timestamp\", \"market\", \"quality\", \"placement\", \"placementish\", \"index\"]  }}";
            String query = "{\"queryType\": \"groupBy\",\"dataSource\": \"test_datasource\",\"granularity\": \"ALL\",\"dimensions\": [],\"aggregations\": [  { \"type\": \"hyperUnique\", \"name\": \"index_hll\", \"fieldName\": \"index_hll\" }],\"postAggregations\": [  { \"type\": \"hyperUniqueCardinality\", \"name\": \"index_unique_count\", \"fieldName\": \"index_hll\" }],\"intervals\": [ \"1970/2050\" ]}";
            Sequence<ResultRow> seq = helper.createIndexAndRunQueryOnSegment(new File(this.getClass().getClassLoader().getResource("druid.sample.tsv").getFile()), parseSpec, metricSpec, 0L, Granularities.NONE, 50000, query);
            ResultRow resultRow = (ResultRow)seq.toList().get(0);
            Assert.assertEquals((String)"index_hll", (double)3.0, (double)((Number)resultRow.get(0)).floatValue(), (double)0.1);
            Assert.assertEquals((String)"index_unique_count", (double)3.0, (double)((Number)resultRow.get(1)).floatValue(), (double)0.1);
        }
    }

    @Test
    public void testIngestAndQueryPrecomputedHll() throws Exception {
        try (AggregationTestHelper helper = AggregationTestHelper.createGroupByQueryAggregationTestHelper(Collections.singletonList(new AggregatorsModule()), this.config, this.tempFolder);){
            String metricSpec = "[{\"type\": \"hyperUnique\",\"name\": \"index_hll\",\"fieldName\": \"preComputedHll\",\"isInputHyperUnique\": true}]";
            String parseSpec = "{\"type\" : \"string\",\"parseSpec\" : {    \"format\" : \"tsv\",    \"timestampSpec\" : {        \"column\" : \"timestamp\",        \"format\" : \"auto\"},    \"dimensionsSpec\" : {        \"dimensions\": [],        \"dimensionExclusions\" : [],        \"spatialDimensions\" : []    },    \"columns\": [\"timestamp\", \"market\", \"preComputedHll\"]  }}";
            String query = "{\"queryType\": \"groupBy\",\"dataSource\": \"test_datasource\",\"granularity\": \"ALL\",\"dimensions\": [],\"aggregations\": [  { \"type\": \"hyperUnique\", \"name\": \"index_hll\", \"fieldName\": \"index_hll\" }],\"postAggregations\": [  { \"type\": \"hyperUniqueCardinality\", \"name\": \"index_unique_count\", \"fieldName\": \"index_hll\" }],\"intervals\": [ \"1970/2050\" ]}";
            Sequence<ResultRow> seq = helper.createIndexAndRunQueryOnSegment(new File(this.getClass().getClassLoader().getResource("druid.hll.sample.tsv").getFile()), parseSpec, metricSpec, 0L, Granularities.DAY, 50000, query);
            ResultRow resultRow = (ResultRow)seq.toList().get(0);
            Assert.assertEquals((String)"index_hll", (double)4.0, (double)((Number)resultRow.get(0)).floatValue(), (double)0.1);
            Assert.assertEquals((String)"index_unique_count", (double)4.0, (double)((Number)resultRow.get(1)).floatValue(), (double)0.1);
        }
    }
}

