/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.aggregation.first;

import java.nio.ByteBuffer;
import org.apache.hive.druid.org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.SerializablePairLongString;
import org.apache.hive.druid.org.apache.druid.query.aggregation.TestLongColumnSelector;
import org.apache.hive.druid.org.apache.druid.query.aggregation.TestObjectColumnSelector;
import org.apache.hive.druid.org.apache.druid.query.aggregation.first.StringFirstAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.first.StringFirstBufferAggregator;
import org.apache.hive.druid.org.apache.druid.segment.BaseLongColumnValueSelector;
import org.junit.Assert;
import org.junit.Test;

public class StringFirstBufferAggregatorTest {
    private void aggregateBuffer(TestLongColumnSelector timeSelector, TestObjectColumnSelector valueSelector, BufferAggregator agg, ByteBuffer buf, int position) {
        agg.aggregate(buf, position);
        timeSelector.increment();
        valueSelector.increment();
    }

    @Test
    public void testBufferAggregate() {
        long[] timestamps = new long[]{1526724600L, 1526724700L, 1526724800L, 1526725900L, 1526725000L};
        String[] strings = new String[]{"AAAA", "BBBB", "CCCC", "DDDD", "EEEE"};
        Integer maxStringBytes = 1024;
        TestLongColumnSelector longColumnSelector = new TestLongColumnSelector(timestamps);
        TestObjectColumnSelector<String> objectColumnSelector = new TestObjectColumnSelector<String>(strings);
        StringFirstAggregatorFactory factory = new StringFirstAggregatorFactory("billy", "billy", maxStringBytes);
        StringFirstBufferAggregator agg = new StringFirstBufferAggregator((BaseLongColumnValueSelector)longColumnSelector, objectColumnSelector, maxStringBytes.intValue(), false);
        ByteBuffer buf = ByteBuffer.allocate(factory.getMaxIntermediateSize());
        int position = 0;
        agg.init(buf, position);
        for (int i = 0; i < timestamps.length; ++i) {
            this.aggregateBuffer(longColumnSelector, objectColumnSelector, (BufferAggregator)agg, buf, position);
        }
        SerializablePairLongString sp = (SerializablePairLongString)agg.get(buf, position);
        Assert.assertEquals((String)"expected last string value", (Object)strings[0], (Object)sp.rhs);
        Assert.assertEquals((String)"last string timestamp is the biggest", (Object)new Long(timestamps[0]), (Object)new Long((Long)sp.lhs));
    }

    @Test
    public void testBufferAggregateWithFoldCheck() {
        long[] timestamps = new long[]{1526724600L, 1526724700L, 1526724800L, 1526725900L, 1526725000L};
        String[] strings = new String[]{"AAAA", "BBBB", "CCCC", "DDDD", "EEEE"};
        Integer maxStringBytes = 1024;
        TestLongColumnSelector longColumnSelector = new TestLongColumnSelector(timestamps);
        TestObjectColumnSelector<String> objectColumnSelector = new TestObjectColumnSelector<String>(strings);
        StringFirstAggregatorFactory factory = new StringFirstAggregatorFactory("billy", "billy", maxStringBytes);
        StringFirstBufferAggregator agg = new StringFirstBufferAggregator((BaseLongColumnValueSelector)longColumnSelector, objectColumnSelector, maxStringBytes.intValue(), true);
        ByteBuffer buf = ByteBuffer.allocate(factory.getMaxIntermediateSize());
        int position = 0;
        agg.init(buf, position);
        for (int i = 0; i < timestamps.length; ++i) {
            this.aggregateBuffer(longColumnSelector, objectColumnSelector, (BufferAggregator)agg, buf, position);
        }
        SerializablePairLongString sp = (SerializablePairLongString)agg.get(buf, position);
        Assert.assertEquals((String)"expected last string value", (Object)strings[0], (Object)sp.rhs);
        Assert.assertEquals((String)"last string timestamp is the biggest", (Object)new Long(timestamps[0]), (Object)new Long((Long)sp.lhs));
    }

    @Test
    public void testNullBufferAggregate() {
        long[] timestamps = new long[]{2222L, 1111L, 3333L, 4444L, 5555L};
        String[] strings = new String[]{null, "AAAA", "BBBB", "DDDD", "EEEE"};
        Integer maxStringBytes = 1024;
        TestLongColumnSelector longColumnSelector = new TestLongColumnSelector(timestamps);
        TestObjectColumnSelector<String> objectColumnSelector = new TestObjectColumnSelector<String>(strings);
        StringFirstAggregatorFactory factory = new StringFirstAggregatorFactory("billy", "billy", maxStringBytes);
        StringFirstBufferAggregator agg = new StringFirstBufferAggregator((BaseLongColumnValueSelector)longColumnSelector, objectColumnSelector, maxStringBytes.intValue(), false);
        ByteBuffer buf = ByteBuffer.allocate(factory.getMaxIntermediateSize());
        int position = 0;
        agg.init(buf, position);
        for (int i = 0; i < timestamps.length; ++i) {
            this.aggregateBuffer(longColumnSelector, objectColumnSelector, (BufferAggregator)agg, buf, position);
        }
        SerializablePairLongString sp = (SerializablePairLongString)agg.get(buf, position);
        Assert.assertEquals((String)"expected last string value", (Object)strings[1], (Object)sp.rhs);
        Assert.assertEquals((String)"last string timestamp is the biggest", (Object)new Long(timestamps[1]), (Object)new Long((Long)sp.lhs));
    }

    @Test
    public void testNoStringValue() {
        long[] timestamps = new long[]{1526724000L, 1526724600L};
        Double[] doubles = new Double[]{null, 2.0};
        Integer maxStringBytes = 1024;
        TestLongColumnSelector longColumnSelector = new TestLongColumnSelector(timestamps);
        TestObjectColumnSelector<Double> objectColumnSelector = new TestObjectColumnSelector<Double>(doubles);
        StringFirstAggregatorFactory factory = new StringFirstAggregatorFactory("billy", "billy", maxStringBytes);
        StringFirstBufferAggregator agg = new StringFirstBufferAggregator((BaseLongColumnValueSelector)longColumnSelector, objectColumnSelector, maxStringBytes.intValue(), false);
        ByteBuffer buf = ByteBuffer.allocate(factory.getMaxIntermediateSize());
        int position = 0;
        agg.init(buf, position);
        for (int i = 0; i < timestamps.length; ++i) {
            this.aggregateBuffer(longColumnSelector, objectColumnSelector, (BufferAggregator)agg, buf, position);
        }
        SerializablePairLongString sp = (SerializablePairLongString)agg.get(buf, position);
        Assert.assertEquals((long)1526724000L, (long)((Long)sp.lhs));
        Assert.assertEquals(null, (Object)sp.rhs);
    }
}

