/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.aggregation.first;

import java.nio.ByteBuffer;
import org.apache.hive.druid.org.apache.druid.java.util.common.Pair;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.hive.druid.org.apache.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.SerializablePairLongString;
import org.apache.hive.druid.org.apache.druid.query.aggregation.TestLongColumnSelector;
import org.apache.hive.druid.org.apache.druid.query.aggregation.TestObjectColumnSelector;
import org.apache.hive.druid.org.apache.druid.query.aggregation.first.StringFirstAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.hive.druid.org.apache.druid.segment.column.ValueType;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StringFirstAggregationTest {
    private final Integer MAX_STRING_SIZE = 1024;
    private AggregatorFactory stringFirstAggFactory;
    private AggregatorFactory combiningAggFactory;
    private ColumnSelectorFactory colSelectorFactory;
    private TestLongColumnSelector timeSelector;
    private TestObjectColumnSelector<String> valueSelector;
    private TestObjectColumnSelector objectSelector;
    private String[] strings = new String[]{"1111", "2222", "3333", null, "4444"};
    private long[] times = new long[]{8224L, 6879L, 2436L, 3546L, 7888L};
    private SerializablePairLongString[] pairs = new SerializablePairLongString[]{new SerializablePairLongString(Long.valueOf(52782L), "AAAA"), new SerializablePairLongString(Long.valueOf(65492L), "BBBB"), new SerializablePairLongString(Long.valueOf(69134L), "CCCC"), new SerializablePairLongString(Long.valueOf(11111L), "DDDD"), new SerializablePairLongString(Long.valueOf(51223L), null)};

    @Before
    public void setup() {
        this.stringFirstAggFactory = new StringFirstAggregatorFactory("billy", "nilly", this.MAX_STRING_SIZE);
        this.combiningAggFactory = this.stringFirstAggFactory.getCombiningFactory();
        this.timeSelector = new TestLongColumnSelector(this.times);
        this.valueSelector = new TestObjectColumnSelector<String>(this.strings);
        this.objectSelector = new TestObjectColumnSelector<SerializablePairLongString>(this.pairs);
        this.colSelectorFactory = (ColumnSelectorFactory)EasyMock.createMock(ColumnSelectorFactory.class);
        EasyMock.expect((Object)this.colSelectorFactory.makeColumnValueSelector("__time")).andReturn((Object)this.timeSelector);
        EasyMock.expect((Object)this.colSelectorFactory.makeColumnValueSelector("nilly")).andReturn(this.valueSelector);
        EasyMock.expect((Object)this.colSelectorFactory.makeColumnValueSelector("billy")).andReturn((Object)this.objectSelector);
        EasyMock.expect((Object)this.colSelectorFactory.getColumnCapabilities("nilly")).andReturn((Object)new ColumnCapabilitiesImpl().setType(ValueType.STRING));
        EasyMock.expect((Object)this.colSelectorFactory.getColumnCapabilities("billy")).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.colSelectorFactory});
    }

    @Test
    public void testStringFirstAggregator() {
        Aggregator agg = this.stringFirstAggFactory.factorize(this.colSelectorFactory);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        Pair result = (Pair)agg.get();
        Assert.assertEquals((Object)this.strings[2], (Object)result.rhs);
    }

    @Test
    public void testStringFirstBufferAggregator() {
        BufferAggregator agg = this.stringFirstAggFactory.factorizeBuffered(this.colSelectorFactory);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[this.stringFirstAggFactory.getMaxIntermediateSize()]);
        agg.init(buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        Pair result = (Pair)agg.get(buffer, 0);
        Assert.assertEquals((Object)this.strings[2], (Object)result.rhs);
    }

    @Test
    public void testCombine() {
        SerializablePairLongString pair1 = new SerializablePairLongString(Long.valueOf(1467225000L), "AAAA");
        SerializablePairLongString pair2 = new SerializablePairLongString(Long.valueOf(1467240000L), "BBBB");
        Assert.assertEquals((Object)pair2, (Object)this.stringFirstAggFactory.combine((Object)pair1, (Object)pair2));
    }

    @Test
    public void testStringFirstCombiningAggregator() {
        Aggregator agg = this.combiningAggFactory.factorize(this.colSelectorFactory);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        Pair result = (Pair)agg.get();
        SerializablePairLongString expected = this.pairs[3];
        Assert.assertEquals((Object)expected.lhs, (Object)result.lhs);
        Assert.assertEquals((Object)expected.rhs, (Object)result.rhs);
    }

    @Test
    public void testStringFirstCombiningBufferAggregator() {
        BufferAggregator agg = this.combiningAggFactory.factorizeBuffered(this.colSelectorFactory);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[this.stringFirstAggFactory.getMaxIntermediateSize()]);
        agg.init(buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        Pair result = (Pair)agg.get(buffer, 0);
        SerializablePairLongString expected = this.pairs[3];
        Assert.assertEquals((Object)expected.lhs, (Object)result.lhs);
        Assert.assertEquals((Object)expected.rhs, (Object)result.rhs);
    }

    @Test
    public void testStringFirstAggregateCombiner() {
        String[] strings = new String[]{"AAAA", "BBBB", "CCCC", "DDDD", "EEEE"};
        TestObjectColumnSelector<String> columnSelector = new TestObjectColumnSelector<String>(strings);
        AggregateCombiner stringFirstAggregateCombiner = this.combiningAggFactory.makeAggregateCombiner();
        stringFirstAggregateCombiner.reset(columnSelector);
        Assert.assertEquals((Object)strings[0], (Object)stringFirstAggregateCombiner.getObject());
        columnSelector.increment();
        stringFirstAggregateCombiner.fold(columnSelector);
        Assert.assertEquals((Object)strings[0], (Object)stringFirstAggregateCombiner.getObject());
        stringFirstAggregateCombiner.reset(columnSelector);
        Assert.assertEquals((Object)strings[1], (Object)stringFirstAggregateCombiner.getObject());
    }

    private void aggregate(Aggregator agg) {
        agg.aggregate();
        this.timeSelector.increment();
        this.valueSelector.increment();
        this.objectSelector.increment();
    }

    private void aggregate(BufferAggregator agg, ByteBuffer buff, int position) {
        agg.aggregate(buff, position);
        this.timeSelector.increment();
        this.valueSelector.increment();
        this.objectSelector.increment();
    }
}

