/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.Assert;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.org.apache.druid.query.DataSource;
import org.apache.hive.druid.org.apache.druid.query.Druids;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.QueryPlus;
import org.apache.hive.druid.org.apache.druid.query.QueryRunner;
import org.apache.hive.druid.org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.org.apache.druid.query.TableDataSource;
import org.apache.hive.druid.org.apache.druid.query.UnionDataSource;
import org.apache.hive.druid.org.apache.druid.query.UnionQueryRunner;
import org.apache.hive.druid.org.apache.druid.query.context.ResponseContext;
import org.apache.hive.druid.org.apache.druid.query.timeseries.TimeseriesQuery;
import org.junit.Test;

public class UnionQueryRunnerTest {
    @Test
    public void testUnionQueryRunner() {
        final AtomicBoolean ds1 = new AtomicBoolean(false);
        final AtomicBoolean ds2 = new AtomicBoolean(false);
        QueryRunner baseRunner = new QueryRunner(){

            public Sequence run(QueryPlus queryPlus, ResponseContext responseContext) {
                Assert.assertTrue((boolean)(queryPlus.getQuery().getDataSource() instanceof TableDataSource));
                String dsName = (String)Iterables.getOnlyElement((Iterable)queryPlus.getQuery().getDataSource().getNames());
                if ("ds1".equals(dsName)) {
                    ds1.compareAndSet(false, true);
                    return Sequences.simple(Arrays.asList(1, 2, 3));
                }
                if ("ds2".equals(dsName)) {
                    ds2.compareAndSet(false, true);
                    return Sequences.simple(Arrays.asList(4, 5, 6));
                }
                throw new AssertionError((Object)"Unexpected DataSource");
            }
        };
        UnionQueryRunner runner = new UnionQueryRunner(baseRunner);
        TimeseriesQuery q = Druids.newTimeseriesQueryBuilder().dataSource((DataSource)new UnionDataSource(Arrays.asList(new TableDataSource("ds1"), new TableDataSource("ds2")))).intervals("2014-01-01T00:00:00Z/2015-01-01T00:00:00Z").aggregators(QueryRunnerTestHelper.COMMON_DOUBLE_AGGREGATORS).build();
        ResponseContext responseContext = ResponseContext.createEmpty();
        Sequence result = runner.run(QueryPlus.wrap((Query)q), responseContext);
        List res = result.toList();
        Assert.assertEquals(Arrays.asList(1, 2, 3, 4, 5, 6), (Object)res);
        Assert.assertEquals((boolean)true, (boolean)ds1.get());
        Assert.assertEquals((boolean)true, (boolean)ds2.get());
    }
}

